/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.mcode;

import com.mathworks.widgets.text.matlab.AbstractTokenManager;
import com.mathworks.widgets.text.matlab.MatlabTokenManager;
import com.mathworks.widgets.text.mcode.MTokenContext;
import com.mathworks.widgets.text.mcode.MTokenUtils;
import java.util.Map;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;

public final class MTokenManager
extends AbstractTokenManager {
    private static final MTokenManager INSTANCE = new MTokenManager();
    private static final TokenID[] BRACKET_SKIP_TOKENS = new TokenID[]{MTokenContext.LINE_COMMENT, MTokenContext.BLKCOM, MTokenContext.BLKEND, MTokenContext.BLKSTART, MTokenContext.CPAD, MTokenContext.PRAGMA, MTokenContext.STRING_LITERAL, MTokenContext.DUAL, MTokenContext.INCOMPLETE_STRING_LITERAL};

    public static MatlabTokenManager getInstance() {
        return INSTANCE;
    }

    private MTokenManager() {
    }

    @Override
    public TokenID getTokenID(int n) {
        return MTokenContext.getTokenID(n);
    }

    @Override
    public TokenContextPath getTokenContextPath() {
        return MTokenContext.contextPath;
    }

    @Override
    public boolean isImplicitEOL(int n) {
        return n == 103 || n == 101 || n == 102;
    }

    @Override
    public boolean isStatementBlockStart(TokenID tokenID) {
        int n = tokenID.getNumericID();
        return n == 7 || n == 13 || n == 3 || n == 6 || n == 5 || n == 4 || n == 1 || n == 25 || n == 28 || n == 32 || n == 33 || n == 34 || n == 35 || n == 31 || n == 30;
    }

    @Override
    public boolean isStatementBlockEnd(TokenID tokenID) {
        return MTokenManager.tokenIDEquals((TokenID)MTokenContext.END, tokenID);
    }

    @Override
    public boolean isMidStatementStart(TokenID tokenID) {
        int n = tokenID.getNumericID();
        return n == 9 || n == 10 || n == 20 || n == 23 || n == 22;
    }

    @Override
    public boolean isFunctionWithoutEnd(TokenID tokenID, BaseDocument baseDocument) {
        return MTokenManager.tokenIDEquals((TokenID)MTokenContext.FUNCTION, tokenID) && !MTokenUtils.isNewStyle(baseDocument);
    }

    @Override
    public boolean isCommentToken(TokenID tokenID) {
        return MTokenManager.tokenIDEquals((TokenID)MTokenContext.LINE_COMMENT, tokenID) || MTokenManager.tokenIDEquals((TokenID)MTokenContext.CPAD, tokenID) || MTokenManager.tokenIDEquals((TokenID)MTokenContext.BLKCOM, tokenID) || MTokenManager.tokenIDEquals((TokenID)MTokenContext.BLKSTART, tokenID) || MTokenManager.tokenIDEquals((TokenID)MTokenContext.BLKEND, tokenID) || MTokenManager.tokenIDEquals((TokenID)MTokenContext.PRAGMA, tokenID);
    }

    @Override
    public boolean isBlockCommentToken(TokenID tokenID) {
        return MTokenManager.tokenIDEquals((TokenID)MTokenContext.BLKCOM, tokenID);
    }

    @Override
    public boolean isCodepadToken(TokenID tokenID) {
        return MTokenManager.tokenIDEquals((TokenID)MTokenContext.CPAD, tokenID);
    }

    @Override
    public boolean isBlockCommentStartOrEnd(TokenID tokenID) {
        return MTokenManager.tokenIDEquals((TokenID)MTokenContext.BLKEND, tokenID) || MTokenManager.tokenIDEquals((TokenID)MTokenContext.BLKSTART, tokenID);
    }

    @Override
    public boolean canModifyWhitespace(TokenID tokenID) {
        switch (tokenID.getNumericID()) {
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 106: 
            case 108: 
            case 109: 
            case 116: {
                return true;
            }
        }
        return false;
    }

    @Override
    public TokenItem findStatementStartForMid(TokenItem tokenItem, Map<TokenItem, TokenItem> map) {
        TokenItem tokenItem2 = null;
        switch (tokenItem.getTokenID().getNumericID()) {
            case 9: 
            case 10: {
                tokenItem2 = this.findIf(tokenItem, map);
                break;
            }
            case 20: {
                tokenItem2 = this.findTry(tokenItem, map);
                break;
            }
            case 22: 
            case 23: {
                tokenItem2 = this.findSwitch(tokenItem, map);
            }
        }
        return tokenItem2;
    }

    @Override
    public boolean isSwitchToken(TokenID tokenID) {
        return MTokenManager.tokenIDEquals(tokenID, (TokenID)MTokenContext.SWITCH);
    }

    @Override
    public boolean isEndToken(TokenID tokenID) {
        return MTokenManager.tokenIDEquals(tokenID, (TokenID)MTokenContext.END);
    }

    @Override
    public boolean isFunctionToken(TokenID tokenID) {
        return MTokenManager.tokenIDEquals(tokenID, (TokenID)MTokenContext.FUNCTION);
    }

    @Override
    public boolean isBadCharacterToken(TokenID tokenID) {
        return MTokenManager.tokenIDEquals(tokenID, (TokenID)MTokenContext.BADCHAR);
    }

    @Override
    public TokenItem findFunction(TokenItem tokenItem, Map<TokenItem, TokenItem> map) {
        return this.findTokenFromAcceptableSet(tokenItem, 1, new TokenID[]{MTokenContext.FUNCTION, MTokenContext.NESTED}, map);
    }

    @Override
    public TokenID getWhitespaceToken() {
        return MTokenContext.WHITESPACE;
    }

    @Override
    public TokenID[] getBracketSkipTokens() {
        return BRACKET_SKIP_TOKENS;
    }

    @Override
    public TokenID getIdentifierToken() {
        return MTokenContext.IDENTIFIER;
    }

    private TokenItem findIf(TokenItem tokenItem, Map<TokenItem, TokenItem> map) {
        return this.findTokenFromAcceptableSet(tokenItem, 3, new TokenID[]{MTokenContext.ELSE, MTokenContext.ELSEIF}, map);
    }

    private TokenItem findTry(TokenItem tokenItem, Map<TokenItem, TokenItem> map) {
        return this.findTokenFromAcceptableSet(tokenItem, 5, new TokenID[]{MTokenContext.CATCH}, map);
    }

    private TokenItem findSwitch(TokenItem tokenItem, Map<TokenItem, TokenItem> map) {
        return this.findTokenFromAcceptableSet(tokenItem, 4, new TokenID[]{MTokenContext.CASE, MTokenContext.OTHERWISE}, map);
    }

    private static boolean tokenIDEquals(TokenID tokenID, TokenID tokenID2) {
        return tokenID.getNumericID() == tokenID2.getNumericID();
    }
}

