/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.fold;

import com.mathworks.widgets.StateMRUFiles;
import com.mathworks.widgets.text.STPInterface;
import com.mathworks.widgets.text.fold.FoldState;
import com.mathworks.widgets.text.fold.FoldStateManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldHierarchyEvent;
import org.netbeans.api.editor.fold.FoldHierarchyListener;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FoldStateManagerImpl
implements FoldStateManager {
    private static FoldStateManager sFoldStateManager = new FoldStateManagerImpl();
    private Map<String, List<FoldState>> fUniqueKeyToFoldState = new HashMap<String, List<FoldState>>();
    private HierarchyUpdateListener fHierarchyListener = new HierarchyUpdateListener();

    private FoldStateManagerImpl() {
    }

    public static FoldStateManager getInstance() {
        return sFoldStateManager;
    }

    @Override
    public void loadState(String string, Node node) {
        assert (string != null && node != null);
        List<FoldState> list = FoldStateManagerImpl.createFoldStates(node);
        this.fUniqueKeyToFoldState.put(string, list);
    }

    private static List<FoldState> createFoldStates(Node node) {
        ArrayList<FoldState> arrayList = new ArrayList<FoldState>();
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                NamedNodeMap namedNodeMap = node2.getAttributes();
                Node node3 = namedNodeMap != null ? namedNodeMap.getNamedItem("name") : null;
                String string = node3 != null ? node3.getNodeValue() : null;
                NodeList nodeList2 = node2.getChildNodes();
                if (nodeList2 == null || string == null) continue;
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Node node4 = nodeList2.item(j);
                    if (node4.getNodeType() != 1 || !node4.getNodeName().equals("Fold")) continue;
                    FoldState foldState = new FoldState();
                    foldState.setTypeName(string);
                    NamedNodeMap namedNodeMap2 = node4.getAttributes();
                    String string2 = namedNodeMap2.getNamedItem("startOffset").getNodeValue();
                    int n = Integer.parseInt(string2);
                    string2 = namedNodeMap2.getNamedItem("endOffset").getNodeValue();
                    int n2 = Integer.parseInt(string2);
                    foldState.setStartOffset(n);
                    foldState.setEndOffset(n2);
                    String string3 = namedNodeMap2.getNamedItem("state").getNodeValue();
                    foldState.setCollapsed(string3.equals("collapsed"));
                    arrayList.add(foldState);
                }
            }
        }
        return arrayList;
    }

    @Override
    public List<FoldState> getFoldStates(FoldHierarchy foldHierarchy) {
        String string;
        List<FoldState> list = null;
        if (foldHierarchy != null && foldHierarchy.getComponent() != null && (string = FoldStateManagerImpl.getUniqueKeyFromHierarchy(foldHierarchy)) != null) {
            list = this.fUniqueKeyToFoldState.get(string);
            foldHierarchy.addFoldHierarchyListener((FoldHierarchyListener)this.fHierarchyListener);
        }
        return list;
    }

    @Override
    public void cleanup(STPInterface sTPInterface) {
        assert (sTPInterface != null && sTPInterface.getUniqueKey() != null);
        FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)sTPInterface.getActiveTextComponent());
        if (foldHierarchy != null) {
            foldHierarchy.removeFoldHierarchyListener((FoldHierarchyListener)this.fHierarchyListener);
        }
        this.fUniqueKeyToFoldState.remove(sTPInterface.getUniqueKey());
    }

    @Override
    public void clearState(String string) {
        assert (string != null);
        this.fUniqueKeyToFoldState.remove(string);
    }

    @Override
    public void updateState(STPInterface sTPInterface) {
    }

    @Override
    public Node saveState(STPInterface sTPInterface, Node node) {
        assert (sTPInterface != null && node != null);
        JTextComponent jTextComponent = sTPInterface.getActiveTextComponent();
        if (jTextComponent != null) {
            FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)jTextComponent);
            this.applyFoldStateChanges(node, foldHierarchy);
        }
        return node;
    }

    private Node applyFoldStateChanges(Node node, FoldHierarchy foldHierarchy) {
        if (foldHierarchy != null && node != null) {
            Document document = node.getOwnerDocument();
            Fold fold = foldHierarchy.getRootFold();
            List list = FoldUtilities.findRecursive((Fold)fold);
            if (list != null) {
                for (Fold fold2 : list) {
                    if (!fold2.isCollapsed()) continue;
                    String string = fold2.getType().toString();
                    Node node2 = FoldStateManagerImpl.getOrCreateFoldTypeNode(string, node);
                    Element element = document.createElement("Fold");
                    element.setAttribute("startOffset", String.valueOf(fold2.getStartOffset()));
                    element.setAttribute("endOffset", String.valueOf(fold2.getEndOffset()));
                    element.setAttribute("state", "collapsed");
                    node2.appendChild(element);
                }
            }
        }
        return node;
    }

    private static String getUniqueKeyFromHierarchy(FoldHierarchy foldHierarchy) {
        String string = null;
        if (foldHierarchy != null && foldHierarchy.getComponent() != null && foldHierarchy.getComponent() instanceof STPInterface) {
            STPInterface sTPInterface = (STPInterface)((Object)foldHierarchy.getComponent());
            string = sTPInterface.getUniqueKey();
        }
        return string;
    }

    private static Node getOrCreateFoldTypeNode(String string, Node node) {
        Node node2 = null;
        if (string != null && node != null) {
            Element element;
            NodeList nodeList = node.getChildNodes();
            if (nodeList != null) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element element2 = element = nodeList.item(i).getNodeType() == 1 ? nodeList.item(i).getAttributes() : null;
                    if (element == null || !element.getNamedItem("name").getNodeValue().equals(string)) continue;
                    node2 = nodeList.item(i);
                    break;
                }
            }
            if (node2 == null) {
                Document document = node.getOwnerDocument();
                element = document.createElement("FoldType");
                element.setAttribute("name", string);
                node2 = element;
                node.appendChild(node2);
            }
        }
        return node2;
    }

    private static class HierarchyUpdateListener
    implements FoldHierarchyListener {
        private HierarchyUpdateListener() {
        }

        public void foldHierarchyChanged(FoldHierarchyEvent foldHierarchyEvent) {
            STPInterface sTPInterface;
            String string;
            FoldHierarchy foldHierarchy;
            if (foldHierarchyEvent != null && foldHierarchyEvent.getAddedFoldCount() == 0 && foldHierarchyEvent.getRemovedFoldCount() == 0 && (foldHierarchy = (FoldHierarchy)foldHierarchyEvent.getSource()).getComponent() instanceof STPInterface && (string = (sTPInterface = (STPInterface)((Object)foldHierarchy.getComponent())).getUniqueKey()) != null) {
                StateMRUFiles.getInstance().updateFileAsMRU(string);
            }
        }
    }
}

