/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text;

import com.mathworks.widgets.STPPrefsManager;
import com.mathworks.widgets.SyntaxTextPane;
import com.mathworks.widgets.text.EditorPreferences;
import com.mathworks.widgets.text.IndentingStyle;
import com.mathworks.widgets.text.mcode.MLanguage;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.StringUtils;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;

public class STPTestUtilities {
    private static final boolean DEBUG = false;

    private STPTestUtilities() {
    }

    public static void setMIndentMode(IndentingStyle indentingStyle) throws Exception {
        STPTestUtilities.setPrefValue("indenting-type", indentingStyle.getInternalName());
        EditorPreferences.setIndentingStyle(MLanguage.INSTANCE, indentingStyle);
    }

    public static void setTabExpandsToSpaces(boolean bl) throws Exception {
        STPTestUtilities.setPrefValue("expand-tabs", bl);
        EditorPreferences.setTabChangedToSpaces(bl);
    }

    private static void setPrefValue(String string, Object object) throws Exception {
        Method[] methodArray;
        for (Method method : methodArray = STPPrefsManager.class.getDeclaredMethods()) {
            if (!method.getName().equals("setPrefValue") || method.getParameterTypes().length != 2) continue;
            method.setAccessible(true);
            method.invoke((Object)STPPrefsManager.getInstance(), string, object);
            return;
        }
        assert (false) : "Didn't find private setPrefValue(String, Object) method";
    }

    public static void deleteAll(SyntaxTextPane syntaxTextPane) throws BadLocationException {
        syntaxTextPane.delete(0, syntaxTextPane.getLength());
        syntaxTextPane.setUndoCleanMarker();
    }

    public static void typeLetter(String string, SyntaxTextPane syntaxTextPane) {
        assert (string.length() == 1) : "Use typeWord for multiple letters";
        BaseAction baseAction = (BaseAction)((BaseKit)syntaxTextPane.getEditorKit()).getActionByName("default-typed");
        baseAction.actionPerformed(new ActionEvent(syntaxTextPane, 0, string), (JTextComponent)syntaxTextPane);
    }

    public static void typeWord(String string, SyntaxTextPane syntaxTextPane) {
        char[] cArray = string.toCharArray();
        for (int i = 0; i != cArray.length; ++i) {
            String string2 = String.valueOf(cArray[i]);
            if (string2.equals("\t")) {
                STPTestUtilities.typeTab(syntaxTextPane);
                continue;
            }
            if (string2.equals("\n")) {
                STPTestUtilities.typeNewline(syntaxTextPane);
                continue;
            }
            STPTestUtilities.typeLetter(string2, syntaxTextPane);
        }
    }

    public static void typeTab(SyntaxTextPane syntaxTextPane) {
        BaseAction baseAction = (BaseAction)((BaseKit)syntaxTextPane.getEditorKit()).getActionByName("insert-tab");
        baseAction.actionPerformed(new ActionEvent(syntaxTextPane, 0, "\t"), (JTextComponent)syntaxTextPane);
    }

    public static void typeShiftTab(SyntaxTextPane syntaxTextPane) {
        BaseAction baseAction = (BaseAction)((BaseKit)syntaxTextPane.getEditorKit()).getActionByName("shift-tab-pressed");
        baseAction.actionPerformed(new ActionEvent(syntaxTextPane, 0, "\t"), (JTextComponent)syntaxTextPane);
    }

    public static void typeNewline(SyntaxTextPane syntaxTextPane) {
        BaseAction baseAction = (BaseAction)((BaseKit)syntaxTextPane.getEditorKit()).getActionByName("insert-break");
        baseAction.actionPerformed(new ActionEvent(syntaxTextPane, 0, ""), (JTextComponent)syntaxTextPane);
    }

    public static void typeShiftNewline(SyntaxTextPane syntaxTextPane) {
        BaseAction baseAction = (BaseAction)((BaseKit)syntaxTextPane.getEditorKit()).getActionByName("shift-insert-break");
        baseAction.actionPerformed(new ActionEvent(syntaxTextPane, 0, ""), (JTextComponent)syntaxTextPane);
    }

    public static void selectLine(SyntaxTextPane syntaxTextPane) throws BadLocationException {
        int n = syntaxTextPane.getCaret().getDot();
        syntaxTextPane.getCaret().moveDot(syntaxTextPane.getLineEnd(syntaxTextPane.getLineFromPos(n)));
    }

    public static void undo(SyntaxTextPane syntaxTextPane) {
        syntaxTextPane.getUndoAction().actionPerformed(new ActionEvent(syntaxTextPane, 0, ""));
    }

    public static void redo(SyntaxTextPane syntaxTextPane) {
        syntaxTextPane.getRedoAction().actionPerformed(new ActionEvent(syntaxTextPane, 0, ""));
    }

    public static void cut(SyntaxTextPane syntaxTextPane) {
        syntaxTextPane.getCutAction().actionPerformed(new ActionEvent(syntaxTextPane, 0, ""));
    }

    public static void copy(SyntaxTextPane syntaxTextPane) {
        syntaxTextPane.getCopyAction().actionPerformed(new ActionEvent(syntaxTextPane, 0, ""));
    }

    public static void paste(SyntaxTextPane syntaxTextPane) {
        syntaxTextPane.getPasteAction().actionPerformed(new ActionEvent(syntaxTextPane, 0, ""));
    }

    public static void deleteNext(SyntaxTextPane syntaxTextPane) {
        BaseAction baseAction = (BaseAction)((BaseKit)syntaxTextPane.getEditorKit()).getActionByName("delete-next");
        baseAction.actionPerformed(new ActionEvent(syntaxTextPane, 0, ""), (JTextComponent)syntaxTextPane);
    }

    public static void deletePrevious(SyntaxTextPane syntaxTextPane) {
        BaseAction baseAction = (BaseAction)((BaseKit)syntaxTextPane.getEditorKit()).getActionByName("delete-previous");
        baseAction.actionPerformed(new ActionEvent(syntaxTextPane, 0, ""), (JTextComponent)syntaxTextPane);
    }

    public static void comment(SyntaxTextPane syntaxTextPane) {
        BaseAction baseAction = (BaseAction)((BaseKit)syntaxTextPane.getEditorKit()).getActionByName("comment");
        baseAction.actionPerformed(new ActionEvent(syntaxTextPane, 0, ""), (JTextComponent)syntaxTextPane);
    }

    public static void uncomment(SyntaxTextPane syntaxTextPane) {
        BaseAction baseAction = (BaseAction)((BaseKit)syntaxTextPane.getEditorKit()).getActionByName("uncomment");
        baseAction.actionPerformed(new ActionEvent(syntaxTextPane, 0, ""), (JTextComponent)syntaxTextPane);
    }

    public static void indent(SyntaxTextPane syntaxTextPane) {
        BaseAction baseAction = (BaseAction)((BaseKit)syntaxTextPane.getEditorKit()).getActionByName("shift-line-right");
        baseAction.actionPerformed(new ActionEvent(syntaxTextPane, 0, ""), (JTextComponent)syntaxTextPane);
    }

    public static void unindent(SyntaxTextPane syntaxTextPane) {
        BaseAction baseAction = (BaseAction)((BaseKit)syntaxTextPane.getEditorKit()).getActionByName("shift-line-left");
        baseAction.actionPerformed(new ActionEvent(syntaxTextPane, 0, ""), (JTextComponent)syntaxTextPane);
    }

    public static String getShiftString(BaseDocument baseDocument) {
        return StringUtils.repeat((String)" ", (int)baseDocument.getShiftWidth());
    }
}

