/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text;

import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.InvalidMarkException;
import org.netbeans.editor.Mark;
import org.netbeans.editor.MarkFactory;
import org.netbeans.editor.Utilities;

public class MarkPair {
    private final MarkFactory.DrawMark fStart;
    private final MarkFactory.DrawMark fEnd;
    private final String fLayerName;
    private final BaseDocument fDoc;

    public MarkPair(String string, EditorUI editorUI, BaseDocument baseDocument) throws InvalidMarkException, BadLocationException {
        if (string == null) {
            throw new IllegalArgumentException("'layerName' cannot be null");
        }
        if (editorUI == null) {
            throw new IllegalArgumentException("'ui' cannot be null");
        }
        if (baseDocument == null) {
            throw new IllegalArgumentException("'doc' cannot be null");
        }
        this.fDoc = baseDocument;
        this.fLayerName = string;
        this.fStart = new MarkFactory.DrawMark(this.fLayerName, editorUI);
        this.fEnd = new MarkFactory.DrawMark(this.fLayerName, editorUI);
        this.fStart.setActivateLayer(true);
        Utilities.insertMark((BaseDocument)baseDocument, (Mark)this.fStart, (int)0);
        Utilities.insertMark((BaseDocument)baseDocument, (Mark)this.fEnd, (int)0);
    }

    public void setEndMarkActive() {
        this.fEnd.setActivateLayer(true);
    }

    public String getLayerName() {
        return this.fLayerName;
    }

    private boolean isEndMarkActive() {
        return this.fEnd.getActivateLayer();
    }

    public int getStartOffset() throws InvalidMarkException {
        return this.fStart.getOffset();
    }

    public int getEndOffset() throws InvalidMarkException {
        return this.fEnd.getOffset();
    }

    public void remove() {
        this.removeSafely((Mark)this.fStart);
        this.removeSafely((Mark)this.fEnd);
    }

    public void move(int n, int n2) throws InvalidMarkException, BadLocationException {
        Utilities.moveMark((BaseDocument)this.fDoc, (Mark)this.fStart, (int)n);
        Utilities.moveMark((BaseDocument)this.fDoc, (Mark)this.fEnd, (int)n2);
    }

    public void repaint(EditorUI editorUI) throws InvalidMarkException, BadLocationException {
        if (this.fStart.isValid() && this.fEnd.isValid()) {
            editorUI.repaintBlock(this.fStart.getOffset(), this.fEnd.getOffset());
        }
    }

    public void repaint(EditorUI editorUI, Rectangle rectangle) throws InvalidMarkException, BadLocationException {
        if (rectangle == null) {
            this.repaint(editorUI);
        } else if (this.fStart.isValid() && this.fEnd.isValid()) {
            Rectangle rectangle2;
            Rectangle rectangle3;
            Rectangle rectangle4 = (Rectangle)rectangle.clone();
            rectangle4 = this.convertToComponent(editorUI, rectangle4);
            Rectangle rectangle5 = editorUI.getComponent().modelToView(this.fStart.getOffset());
            Rectangle rectangle6 = rectangle5.union(rectangle3 = editorUI.getComponent().modelToView(this.fEnd.getOffset()));
            if (rectangle6.intersects(rectangle2 = editorUI.getComponent().getVisibleRect())) {
                Rectangle rectangle7 = rectangle6.intersection(rectangle2);
                if (rectangle7.intersects(rectangle4)) {
                    Rectangle[] rectangleArray = SwingUtilities.computeDifference(rectangle7, rectangle4);
                    if (rectangleArray.length > 0) {
                        RepaintManager.currentManager(editorUI.getComponent()).paintDirtyRegions();
                        for (int i = 0; i != rectangleArray.length; ++i) {
                            editorUI.getComponent().repaint(rectangleArray[i]);
                        }
                    }
                } else {
                    editorUI.getComponent().repaint(rectangle7);
                }
            }
        }
    }

    private Rectangle convertToComponent(EditorUI editorUI, Rectangle rectangle) {
        Point point = rectangle.getLocation();
        SwingUtilities.convertPointFromScreen(point, editorUI.getComponent());
        rectangle.setLocation(point);
        return rectangle;
    }

    public void moveAndRepaint(EditorUI editorUI, int n, int n2) throws InvalidMarkException, BadLocationException {
        this.move(n, n2);
        this.repaint(editorUI);
    }

    private void removeSafely(Mark mark) {
        block3: {
            try {
                if (mark.isValid()) {
                    mark.remove();
                }
            }
            catch (InvalidMarkException invalidMarkException) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block3;
                invalidMarkException.printStackTrace();
            }
        }
    }
}

