/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text;

import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Utilities;

public class MWEditorUIUtils {
    private MWEditorUIUtils() {
    }

    public static int convertLineNbrToY(int n, EditorUI editorUI) throws BadLocationException {
        int n2 = -1;
        if (n >= 0 && editorUI != null && editorUI.getComponent() != null) {
            Element element;
            Element element2;
            JTextComponent jTextComponent = editorUI.getComponent();
            BaseTextUI baseTextUI = (BaseTextUI)jTextComponent.getUI();
            Rectangle rectangle = baseTextUI.modelToView(jTextComponent, (element2 = (element = baseTextUI.getRootView(jTextComponent).getElement()).getElement(n)).getStartOffset());
            n2 = rectangle != null ? rectangle.y : -1;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int convertYToLineNbr(int n, EditorUI editorUI) throws BadLocationException {
        int n2 = -1;
        if (editorUI != null && editorUI.getComponent() != null) {
            int n3;
            BaseTextUI baseTextUI = (BaseTextUI)editorUI.getComponent().getUI();
            int n4 = baseTextUI.getPosFromY(n);
            BaseDocument baseDocument = (BaseDocument)editorUI.getComponent().getDocument();
            baseDocument.readLock();
            try {
                n2 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n4);
                n3 = Utilities.getRowCount((BaseDocument)baseDocument);
            }
            finally {
                baseDocument.readUnlock();
            }
            n2 = n2 >= n3 ? -1 : n2;
        }
        return n2;
    }

    public static View getRootView(JTextComponent jTextComponent) {
        View view = null;
        if (jTextComponent != null) {
            view = Utilities.getDocumentView((JTextComponent)jTextComponent);
        }
        return view;
    }

    public static int getViewIndexFromY(int n, EditorUI editorUI) throws BadLocationException {
        int n2 = -1;
        if (editorUI != null && editorUI.getComponent() != null) {
            JTextComponent jTextComponent = editorUI.getComponent();
            BaseTextUI baseTextUI = (BaseTextUI)editorUI.getComponent().getUI();
            int n3 = baseTextUI.getPosFromY(n);
            n2 = MWEditorUIUtils.getRootView(jTextComponent).getViewIndex(n3, Position.Bias.Forward);
        }
        return n2;
    }

    public static int getRowEndWithEOLFromPoint(Point point, JTextComponent jTextComponent) throws BadLocationException {
        int n = -1;
        assert (jTextComponent != null) : "component cannot be null";
        if (jTextComponent.getUI() != null) {
            assert (jTextComponent.getUI() instanceof BaseTextUI) : "component must have UI class inheriting from BaseTextUI";
            BaseTextUI baseTextUI = (BaseTextUI)jTextComponent.getUI();
            int n2 = baseTextUI.viewToModel(jTextComponent, point);
            n = Utilities.getRowEnd((JTextComponent)jTextComponent, (int)n2);
            if (n + 1 < jTextComponent.getDocument().getLength()) {
                n = Utilities.getRowStart((JTextComponent)jTextComponent, (int)(n + 1));
            }
        }
        return n;
    }

    public static int getRowStartFromPoint(Point point, JTextComponent jTextComponent) throws BadLocationException {
        int n = -1;
        assert (jTextComponent != null) : "component cannot be null";
        if (jTextComponent.getUI() != null) {
            assert (jTextComponent.getUI() instanceof BaseTextUI) : "component must have UI class inheriting from BaseTextUI";
            BaseTextUI baseTextUI = (BaseTextUI)jTextComponent.getUI();
            int n2 = baseTextUI.viewToModel(jTextComponent, point);
            n = Utilities.getRowStart((JTextComponent)jTextComponent, (int)n2);
        }
        return n;
    }
}

