/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.spreadsheet.data;

public class ValueSummary {
    private final long[] fLengths;
    private final boolean fIsSigned;
    private boolean fIsReal = true;
    private boolean fIsSparse = false;
    private boolean fIsGlobal = false;
    private final String fClazz;
    private String fSpecialEmpty;
    private static final String INITIAL_STRING = "<";
    private static final String TERMINAL_STRING = ">";

    ValueSummary(String string, long[] lArray) {
        this(string, lArray, true);
    }

    ValueSummary(String string, long[] lArray, boolean bl) {
        this(string, lArray, bl, true, null);
    }

    ValueSummary(String string, long[] lArray, String string2) {
        this(string, lArray, true, true, string2);
    }

    ValueSummary(String string, long[] lArray, boolean bl, boolean bl2, String string2) {
        ValueSummary.checkLengths(lArray);
        this.fLengths = lArray;
        this.fIsSigned = bl2;
        this.fIsReal = bl;
        this.fClazz = string;
        this.fSpecialEmpty = string2;
    }

    public boolean isSparse() {
        return this.fIsSparse;
    }

    public void setIsSparse(boolean bl) {
        this.fIsSparse = bl;
    }

    public boolean isGlobal() {
        return this.fIsGlobal;
    }

    public void setIsGlobal(boolean bl) {
        this.fIsGlobal = bl;
    }

    public void setIsReal(boolean bl) {
        this.fIsReal = bl;
    }

    public final boolean isReal() {
        return this.fIsReal;
    }

    public final boolean isSigned() {
        return this.fIsSigned;
    }

    public final long[] getLengths() {
        return this.fLengths;
    }

    public final String toString() {
        return this.toString(true);
    }

    public final String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        long[] lArray = this.getLengths();
        boolean bl2 = false;
        if (bl) {
            for (int i = 0; i < lArray.length; ++i) {
                if (lArray[i] != 0L) continue;
                bl2 = true;
                break;
            }
        }
        if (bl2 && this.fSpecialEmpty != null) {
            stringBuffer.append(this.fSpecialEmpty);
        } else {
            stringBuffer.append(INITIAL_STRING);
            if (lArray.length > 3) {
                stringBuffer.append(lArray.length);
                stringBuffer.append("-D");
            } else {
                stringBuffer.append(lArray[0]);
                stringBuffer.append('x');
                stringBuffer.append(lArray[1]);
                if (lArray.length > 2) {
                    stringBuffer.append('x');
                    stringBuffer.append(lArray[2]);
                }
            }
            if (this.fIsGlobal) {
                stringBuffer.append(" global");
            }
            if (this.fIsSparse) {
                stringBuffer.append(" sparse");
            }
            if (!this.fIsReal) {
                stringBuffer.append(" complex");
            }
            stringBuffer.append(' ').append(this.fClazz);
            stringBuffer.append(TERMINAL_STRING);
        }
        return stringBuffer.toString();
    }

    public final String getMatlabClass() {
        return this.fClazz;
    }

    private static void checkLengths(long[] lArray) {
        if (lArray == null || lArray.length < 2) {
            throw new IllegalArgumentException("Length must be an array with two or more arguments.");
        }
    }
}

