/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.spreadsheet.data;

import com.mathworks.widgets.spreadsheet.data.ComplexIntegralScalar;
import com.mathworks.widgets.spreadsheet.format.FormatUtils;

public final class ComplexScalarShort
extends ComplexIntegralScalar {
    private final short fR;
    private final short fI;
    private static final int UNSIGNED_SHORT_MAX = 65536;
    private static final ComplexScalarShort ZERO_REAL_SIGNED = new ComplexScalarShort(0, true);
    private static final ComplexScalarShort ONE_REAL_SIGNED = new ComplexScalarShort(1, true);
    private static final ComplexScalarShort ZERO_COMPLEX_SIGNED = new ComplexScalarShort(0, 0, true);
    private static final ComplexScalarShort ONE_COMPLEX_SIGNED = new ComplexScalarShort(1, 0, true);
    private static final ComplexScalarShort I_COMPLEX_SIGNED = new ComplexScalarShort(0, 1, true);
    private static final ComplexScalarShort ZERO_REAL_UNSIGNED = new ComplexScalarShort(0, false);
    private static final ComplexScalarShort ONE_REAL_UNSIGNED = new ComplexScalarShort(1, false);
    private static final ComplexScalarShort ZERO_COMPLEX_UNSIGNED = new ComplexScalarShort(0, 0, false);
    private static final ComplexScalarShort ONE_COMPLEX_UNSIGNED = new ComplexScalarShort(1, 0, false);
    private static final ComplexScalarShort I_COMPLEX_UNSIGNED = new ComplexScalarShort(0, 1, false);

    public static ComplexScalarShort valueOf(short s) {
        return ComplexScalarShort.valueOf(s, true);
    }

    public static ComplexScalarShort valueOf(short s, boolean bl) {
        if (s == 0) {
            return bl ? ZERO_REAL_SIGNED : ZERO_REAL_UNSIGNED;
        }
        if (s == 1) {
            return bl ? ONE_REAL_SIGNED : ONE_REAL_UNSIGNED;
        }
        return new ComplexScalarShort(s, bl);
    }

    public static ComplexScalarShort valueOf(short s, short s2) {
        return ComplexScalarShort.valueOf(s, s2, true);
    }

    public static ComplexScalarShort valueOf(short s, short s2, boolean bl) {
        if (s == 0) {
            if (s2 == 1) {
                return bl ? I_COMPLEX_SIGNED : I_COMPLEX_UNSIGNED;
            }
            if (s2 == 0) {
                return bl ? ZERO_COMPLEX_SIGNED : ZERO_COMPLEX_UNSIGNED;
            }
        }
        if (s == 1 && s2 == 0) {
            return bl ? ONE_COMPLEX_SIGNED : ONE_COMPLEX_UNSIGNED;
        }
        return new ComplexScalarShort(s, s2, bl);
    }

    private ComplexScalarShort(short s, boolean bl) {
        super(true, bl);
        this.fR = s;
        this.fI = 0;
    }

    private ComplexScalarShort(short s, short s2, boolean bl) {
        super(false, bl);
        this.fR = s;
        this.fI = s2;
    }

    @Override
    public long longValueReal() {
        return this.fR;
    }

    @Override
    public long longValueImaginary() {
        return this.fI;
    }

    @Override
    public double doubleValueReal() {
        return this.fR;
    }

    @Override
    public double doubleValueImaginary() {
        return this.fI;
    }

    @Override
    public String formatAsIntegral() {
        short s = this.shortValueReal();
        Number number = this.isSigned() || s > -1 ? (Number)s : (Number)(s + 65536);
        if (this.isReal()) {
            return FormatUtils.formatAsIntegral(number);
        }
        short s2 = this.shortValueImaginary();
        Number number2 = this.isSigned() || s2 > -1 ? (Number)s2 : (Number)(s2 + 65536);
        return FormatUtils.formatAsIntegral(number, number2);
    }
}

