/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.spreadsheet.color;

import com.mathworks.widgets.spreadsheet.color.ColorArrayTableModel;
import com.mathworks.widgets.spreadsheet.color.ColorTableModel;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CompositeColorArrayTableModel
implements ColorArrayTableModel {
    private List<ColorTableModel> fColorTableLists = new ArrayList<ColorTableModel>();
    private ChangeListener fLocalChangeListener;
    private List<ChangeListener> fChangeListeners = new ArrayList<ChangeListener>();
    public static final Color[] NO_COLORS = new Color[0];

    public CompositeColorArrayTableModel() {
        this.fLocalChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                CompositeColorArrayTableModel.this.fireChangeEvent();
            }
        };
    }

    public void addColorTableModel(ColorTableModel colorTableModel) {
        this.fColorTableLists.add(colorTableModel);
        colorTableModel.addColorTableModelListener(this.fLocalChangeListener);
        this.fireChangeEvent();
    }

    public void removeColorTableModel(ColorTableModel colorTableModel) {
        colorTableModel.removeColorTableModelListener(this.fLocalChangeListener);
        this.fColorTableLists.remove(colorTableModel);
        this.fireChangeEvent();
    }

    @Override
    public void addColorArrayTableModelListener(ChangeListener changeListener) {
        this.fChangeListeners.add(changeListener);
    }

    @Override
    public void removeColorArrayTableModelListener(ChangeListener changeListener) {
        this.fChangeListeners.remove(changeListener);
    }

    @Override
    public Color[] getColorsAt(int n, int n2) {
        if (this.fColorTableLists.isEmpty()) {
            return NO_COLORS;
        }
        Color[] colorArray = new Color[this.fColorTableLists.size()];
        for (int i = 0; i < colorArray.length; ++i) {
            colorArray[i] = this.fColorTableLists.get(i).getColorAt(n, n2);
        }
        return colorArray;
    }

    public void clearModels() {
        this.fColorTableLists.clear();
        this.fireChangeEvent();
    }

    private void fireChangeEvent() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.fChangeListeners) {
            changeListener.stateChanged(changeEvent);
        }
    }
}

