/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.spreadsheet;

import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.api.UndoabilityChangeListener;
import com.mathworks.mwswing.undo.MUndoManager;
import com.mathworks.widgets.action.AbstractRedoAction;
import com.mathworks.widgets.action.AbstractUndoAction;
import com.mathworks.widgets.spreadsheet.IUndoManagerProvider;
import java.awt.event.ActionEvent;

public class UndoActionFactory {
    private UndoActionFactory() {
    }

    public static MJAbstractAction getUndoAction(IUndoManagerProvider iUndoManagerProvider) {
        if (iUndoManagerProvider != null) {
            return UndoActionFactory.getUndoAction(iUndoManagerProvider.getUndoManager());
        }
        return UndoActionFactory.getUndoAction((MUndoManager)null);
    }

    public static MJAbstractAction getRedoAction(IUndoManagerProvider iUndoManagerProvider) {
        if (iUndoManagerProvider != null) {
            return UndoActionFactory.getRedoAction(iUndoManagerProvider.getUndoManager());
        }
        return UndoActionFactory.getRedoAction((MUndoManager)null);
    }

    public static MJAbstractAction getUndoAction(MUndoManager mUndoManager) {
        if (mUndoManager != null) {
            return new ManagedUndoAction(mUndoManager);
        }
        return new UnmanagedUndoAction();
    }

    public static MJAbstractAction getRedoAction(MUndoManager mUndoManager) {
        if (mUndoManager != null) {
            return new ManagedRedoAction(mUndoManager);
        }
        return new UnmanagedRedoAction();
    }

    private static class UnmanagedRedoAction
    extends AbstractRedoAction {
        UnmanagedRedoAction() {
            super.setEnabled(false);
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    private static class ManagedRedoAction
    extends AbstractRedoAction {
        private MUndoManager lManager;
        private boolean lExternalEnablingFlag;

        ManagedRedoAction(MUndoManager mUndoManager) {
            this.lManager = mUndoManager;
            this.setEnabled(true);
            mUndoManager.addUndoabilityChangeListener((UndoabilityChangeListener)new UML());
        }

        public void setEnabled(boolean bl) {
            this.lExternalEnablingFlag = bl;
            super.setEnabled(this.lExternalEnablingFlag && this.lManager.canRedo());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.lManager.redo();
        }

        private class UML
        implements UndoabilityChangeListener {
            private UML() {
            }

            public void undoabilityChanged(boolean bl) {
            }

            public void redoabilityChanged(boolean bl) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        ManagedRedoAction.this.setEnabled(ManagedRedoAction.this.lExternalEnablingFlag);
                    }
                };
                MJUtilities.runOnEventDispatchThread((Runnable)runnable);
            }
        }
    }

    private static class UnmanagedUndoAction
    extends AbstractUndoAction {
        UnmanagedUndoAction() {
            super.setEnabled(false);
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    private static class ManagedUndoAction
    extends AbstractUndoAction {
        private MUndoManager lManager;
        private boolean lExternalEnablingFlag;

        ManagedUndoAction(MUndoManager mUndoManager) {
            this.lManager = mUndoManager;
            this.setEnabled(true);
            mUndoManager.addUndoabilityChangeListener((UndoabilityChangeListener)new UML());
        }

        public void setEnabled(boolean bl) {
            this.lExternalEnablingFlag = bl;
            super.setEnabled(this.lExternalEnablingFlag && this.lManager.canUndo());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.lManager.undo();
        }

        private class UML
        implements UndoabilityChangeListener {
            private UML() {
            }

            public void dirtyStateChanged(boolean bl) {
            }

            public void undoabilityChanged(boolean bl) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        ManagedUndoAction.this.setEnabled(ManagedUndoAction.this.lExternalEnablingFlag);
                    }
                };
                MJUtilities.runOnEventDispatchThread((Runnable)runnable);
            }

            public void redoabilityChanged(boolean bl) {
            }
        }
    }
}

