/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.recordlist;

import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.border.DashedBorder;
import com.mathworks.mwswing.table.ListColorUtils;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.recordlist.IRecordIconProvider;
import com.mathworks.widgets.recordlist.IRecordSecondaryIconProvider;
import com.mathworks.widgets.recordlist.RecordlistTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

class FullRLTCellRenderer
implements TableCellRenderer {
    private int fAlignment;
    private IRecordIconProvider fPrimaryRIP;
    private IRecordSecondaryIconProvider fSecondaryRIP;

    FullRLTCellRenderer(int n, IRecordIconProvider iRecordIconProvider, IRecordSecondaryIconProvider iRecordSecondaryIconProvider) {
        this.fAlignment = n;
        this.fPrimaryRIP = iRecordIconProvider;
        this.fSecondaryRIP = iRecordSecondaryIconProvider;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Object object2;
        boolean bl3 = true;
        if (jTable instanceof RecordlistTable) {
            bl3 = ((RecordlistTable)((Object)jTable)).hasAppearanceFocus();
        }
        int n3 = -1;
        boolean bl4 = false;
        int n4 = n;
        if (jTable instanceof RecordlistTable) {
            int n5 = ((RecordlistTable)((Object)jTable)).getPrimaryFieldIndex();
            n3 = jTable.convertColumnIndexToView(n5);
            bl4 = ((RecordlistTable)((Object)jTable)).getFullCellSelection();
            n4 = ((RecordlistTable)((Object)jTable)).convertRowIndexToUnderlyingModel(n);
        }
        Icon icon = null;
        Icon icon2 = null;
        if (this.fPrimaryRIP != null && n2 == n3) {
            icon = this.fPrimaryRIP.getRecordIcon(n4);
            if (this.fSecondaryRIP != null && this.fSecondaryRIP.hasRecordSecondaryIcons()) {
                icon2 = this.fSecondaryRIP.getRecordSecondaryIcon(n4);
            }
        }
        boolean bl5 = (PlatformInfo.isMacintosh() || bl4) && jTable.getSelectionModel().isSelectedIndex(n);
        Color color = FullRLTCellRenderer.getTableBackgroundColor(jTable, n, bl5, bl3);
        Color color2 = FullRLTCellRenderer.getTableForegroundColor(jTable, bl5, bl3);
        MJPanel mJPanel = new MJPanel();
        mJPanel.setLayout((LayoutManager)new BorderLayout());
        mJPanel.setBackground(color);
        MJPanel mJPanel2 = new MJPanel();
        mJPanel2.setBackground(color);
        mJPanel2.setLayout((LayoutManager)new BorderLayout());
        IconPanel iconPanel = new IconPanel();
        iconPanel.setBackground(color);
        iconPanel.setLayout(new BorderLayout());
        MJLabel mJLabel = new MJLabel();
        mJLabel.setName("PrimaryIconLabel");
        mJLabel.setBackground(color);
        MJLabel mJLabel2 = null;
        if (icon2 != null) {
            mJLabel2 = new MJLabel();
            mJLabel2.setName("SecondaryIconLabel");
            mJLabel2.setBackground(color);
        }
        MJLabel mJLabel3 = new MJLabel(object == null ? "" : object.toString(), false);
        mJLabel3.setName("RealIconLabel");
        mJLabel3.setBackground(color);
        mJLabel3.setForeground(color2);
        mJLabel3.setFont(jTable.getFont());
        mJLabel3.setHorizontalAlignment(this.fAlignment);
        mJLabel3.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 6));
        mJLabel3.setOpaque(true);
        if (!PlatformInfo.isMacintosh() && !bl4) {
            if (bl) {
                icon = RecordlistTable.createSelectedIcon(icon);
                icon2 = RecordlistTable.createSelectedIcon(icon2);
                mJLabel3.setBackground(jTable.getSelectionBackground());
                mJLabel3.setForeground(jTable.getSelectionForeground());
                if (bl2) {
                    object2 = BorderFactory.createCompoundBorder((Border)new DashedBorder(jTable.getSelectionBackground(), new Color(247, 219, 148)), BorderFactory.createEmptyBorder(0, 1, 0, 5));
                    mJLabel3.setBorder((Border)object2);
                }
            } else if (bl2) {
                mJLabel3.setBorder((Border)BorderFactory.createCompoundBorder((Border)new DashedBorder((Color)SystemColor.textText, color), BorderFactory.createEmptyBorder(0, 1, 0, 5)));
            }
        }
        if (!PlatformInfo.isMacintosh() && bl4 && bl3 && jTable.getSelectionModel().isSelectedIndex(n)) {
            mJLabel3.setForeground(jTable.getSelectionForeground());
        }
        mJLabel.setIcon(icon);
        if (mJLabel2 != null) {
            mJLabel2.setIcon(icon2);
        }
        object2 = new MJPanel();
        object2.setLayout((LayoutManager)new BorderLayout());
        object2.setBackground(color);
        mJPanel2.add((Component)mJLabel, (Object)"West");
        if (mJLabel2 != null) {
            mJPanel2.add((Component)mJLabel2, (Object)"Center");
        }
        object2.add((Component)mJLabel3, (Object)(this.fAlignment == 2 ? "West" : "East"));
        mJPanel.add(Box.createHorizontalStrut(1), (Object)"West");
        mJPanel.add((Component)object2, (Object)"Center");
        iconPanel.add((Component)mJPanel2, "West");
        iconPanel.add((Component)mJPanel, "Center");
        int n6 = 0;
        if (icon != null) {
            n6 = icon.getIconWidth();
        }
        int n7 = 0;
        if (icon2 != null) {
            n7 = icon2.getIconWidth();
        }
        Dimension dimension = mJLabel3.getPreferredSize();
        mJLabel3.setPreferredSize(new Dimension(Math.min(jTable.getColumnModel().getColumn(n2).getWidth() - (n6 + n7), dimension.width + 3), dimension.height));
        FullRLTCellRenderer.handleAccessibleText(jTable, n3, iconPanel, mJLabel3, n, n2);
        return iconPanel;
    }

    private static Color getTableBackgroundColor(JTable jTable, int n, boolean bl, boolean bl2) {
        return ListColorUtils.getListBackgroundColor((JTable)jTable, (int)n, (boolean)bl, (boolean)bl2);
    }

    private static Color getTableForegroundColor(JTable jTable, boolean bl, boolean bl2) {
        return ListColorUtils.getListForegroundColor((JTable)jTable, (boolean)bl, (boolean)bl2);
    }

    private static void handleAccessibleText(JTable jTable, int n, IconPanel iconPanel, MJLabel mJLabel, int n2, int n3) {
        iconPanel.setAccessibleContextSource((Component)mJLabel);
        if (n3 == n) {
            StringBuilder stringBuilder = new StringBuilder(mJLabel.getText());
            for (int i = 0; i < jTable.getModel().getColumnCount(); ++i) {
                String string;
                Object object;
                int n4;
                if (i == n || (n4 = jTable.convertColumnIndexToView(i)) == -1 || (object = jTable.getValueAt(n2, n4)) == null || (string = object.toString()).length() <= 0) continue;
                stringBuilder.append(", ").append(jTable.getColumnModel().getColumn(n4).getHeaderValue()).append(' ').append(jTable.getValueAt(n2, n4));
            }
            mJLabel.getAccessibleContext().setAccessibleName(stringBuilder.toString());
        }
    }

    private static class IconPanel
    extends MJPanel {
        private Component fComp;

        private IconPanel() {
        }

        void setAccessibleContextSource(Component component) {
            this.fComp = component;
        }

        public AccessibleContext getAccessibleContext() {
            if (this.fComp == null) {
                return super.getAccessibleContext();
            }
            return this.fComp.getAccessibleContext();
        }
    }
}

