/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.prefs;

import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJMultilineLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.widgets.HyperlinkLabel;
import com.mathworks.widgets.prefs.PrefsContainer;
import com.mathworks.widgets.prefs.PrefsModel;
import com.mathworks.widgets.prefs.PrefsModelEvent;
import com.mathworks.widgets.prefs.PrefsModelListener;
import com.mathworks.widgets.prefs.PrefsNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.concurrent.Semaphore;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class DefaultPrefsContainer
implements PrefsContainer {
    private static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.widgets.prefs.resources.RES_Prefs");
    private final MJPanel fPanel;
    private final MJPanel fContentPanel;
    private final MJLabel fTitleLabel;
    private final MJPanel fTitleBox;
    private final MJMultilineLabel fDescriptionLabel;
    private final Dimension fMinimumSize;
    private final Dimension fMaximumSize;
    private final PrefsModel fModel;
    private final String fTitleSuffix;
    private final Semaphore fChangeLock = new Semaphore(1);
    private final PrefsModelListener fModelListener;
    private PrefsNode fSelectedNode;

    public DefaultPrefsContainer(PrefsModel prefsModel, Dimension dimension, Dimension dimension2, String string) {
        PrefsNode prefsNode;
        this.fPanel = new MJPanel();
        this.fMinimumSize = (Dimension)dimension.clone();
        this.fMaximumSize = (Dimension)dimension2.clone();
        this.fTitleSuffix = string == null ? "" : string;
        this.fModel = prefsModel;
        this.fContentPanel = new MJPanel((LayoutManager)new BorderLayout());
        this.fPanel.add((Component)this.fContentPanel, (Object)"Center");
        this.fTitleLabel = new MJLabel(" ");
        this.fTitleLabel.setFont(this.fTitleLabel.getFont().deriveFont(1));
        this.fDescriptionLabel = new MJMultilineLabel(" ", true);
        this.fDescriptionLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.fTitleBox = new MJPanel((LayoutManager)new FlowLayout(0));
        this.fTitleBox.add((Component)this.fTitleLabel);
        this.fTitleBox.setOpaque(true);
        this.fTitleBox.setBackground(ColorUtils.getDarkenedHeadingBackground((JComponent)this.fTitleBox));
        this.fTitleBox.setForeground(ColorUtils.getDarkenedHeadingForeground((JComponent)this.fTitleBox));
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        mJPanel.add((Component)this.fTitleBox, (Object)"North");
        mJPanel.add((Component)this.fDescriptionLabel, (Object)"Center");
        this.fPanel.setLayout((LayoutManager)new BorderLayout(5, 10));
        this.fPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
        MJScrollPane mJScrollPane = new MJScrollPane((Component)this.fContentPanel);
        mJScrollPane.setBorder(BorderFactory.createEmptyBorder());
        mJScrollPane.setHorizontalScrollBarPolicy(30);
        mJScrollPane.setVerticalScrollBarPolicy(20);
        mJScrollPane.setViewportBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.fPanel.add((Component)mJScrollPane, (Object)"Center");
        this.fPanel.add((Component)mJPanel, (Object)"North");
        this.fPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        if (prefsModel.getRoot() != null && prefsModel.getRoot().getChildCount() > 0 && (prefsNode = prefsModel.getRoot().getChildren().iterator().next()).isEditable()) {
            this.display(prefsNode);
        }
        this.fModelListener = new PrefsModelListener(){

            @Override
            public void nodeTurnedOn(PrefsModelEvent prefsModelEvent) {
                this.update(prefsModelEvent.getNode());
            }

            @Override
            public void nodeTurnedOff(PrefsModelEvent prefsModelEvent) {
                this.update(prefsModelEvent.getNode());
            }

            private void update(PrefsNode prefsNode) {
                if (prefsNode == DefaultPrefsContainer.this.fSelectedNode) {
                    DefaultPrefsContainer.this.display(DefaultPrefsContainer.this.fSelectedNode);
                    DefaultPrefsContainer.this.fPanel.invalidate();
                    DefaultPrefsContainer.this.fPanel.repaint();
                }
            }
        };
        prefsModel.addPrefsModelListener(this.fModelListener);
    }

    @Override
    public void dispose() {
        this.fModel.removePrefsModelListener(this.fModelListener);
    }

    @Override
    public Dimension getClientSize() {
        return this.fContentPanel.getSize();
    }

    @Override
    public JComponent getComponent() {
        return this.fPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void display(final PrefsNode prefsNode) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DefaultPrefsContainer.this.display(prefsNode);
                }
            });
        } else if (this.fChangeLock.tryAcquire()) {
            try {
                if (prefsNode != this.fSelectedNode && prefsNode.isEditable()) {
                    String string;
                    this.fContentPanel.removeAll();
                    JComponent jComponent = null;
                    if (!prefsNode.canBeToggled() || prefsNode.isOn()) {
                        jComponent = prefsNode.getEditorPanel().getComponent(prefsNode);
                    } else {
                        jComponent = new MJPanel((LayoutManager)new FlowLayout(0));
                        string = MessageFormat.format(sRes.getString("toggle.text"), prefsNode.getName());
                        HyperlinkLabel hyperlinkLabel = new HyperlinkLabel(string, new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                DefaultPrefsContainer.this.fSelectedNode.turnOn();
                                DefaultPrefsContainer.this.display(DefaultPrefsContainer.this.fSelectedNode);
                            }
                        }, "toggleLink", string);
                        jComponent.add((Component)((Object)hyperlinkLabel));
                    }
                    this.fContentPanel.add((Component)jComponent, (Object)"Center");
                    this.fContentPanel.validate();
                    this.fContentPanel.setPreferredSize(jComponent.getPreferredSize());
                    this.fContentPanel.repaint();
                    this.fTitleLabel.setText(prefsNode.getLongName() + " " + this.fTitleSuffix);
                    string = prefsNode.getDescription();
                    if (string == null) {
                        this.fDescriptionLabel.setVisible(false);
                    } else {
                        this.fDescriptionLabel.setText(prefsNode.getDescription());
                        this.fDescriptionLabel.setVisible(true);
                    }
                    this.fSelectedNode = prefsNode;
                }
            }
            finally {
                this.fChangeLock.release();
            }
        }
    }
}

