/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.grouptable.transfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

public final class TransferUtils {
    private static final DataFlavor sTypeFlavor;

    private TransferUtils() {
    }

    public static Transferable wrapObjectList(final List list) {
        return new Transferable(){
            private final DataFlavor fFlavor;
            {
                try {
                    this.fFlavor = new DataFlavor("application/x-java-jvm-local-objectref;class=java.util.List");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new IllegalStateException(classNotFoundException);
                }
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{this.fFlavor};
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                return dataFlavor.equals(this.fFlavor);
            }

            @Override
            public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
                return list;
            }
        };
    }

    public static <C> List<C> unwrapObjectList(Class<C> clazz, Transferable transferable) {
        for (DataFlavor dataFlavor : transferable.getTransferDataFlavors()) {
            if (dataFlavor.getMimeType() == null || !dataFlavor.getMimeType().startsWith("application/x-java-jvm-local-objectref") || dataFlavor.getMimeType().indexOf("java.util.List") <= 0) continue;
            try {
                return (List)transferable.getTransferData(dataFlavor);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return null;
    }

    public static Transferable combineFlavors(final Transferable ... transferableArray) {
        return new Transferable(){

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                Vector<DataFlavor> vector = new Vector<DataFlavor>();
                for (Transferable transferable : transferableArray) {
                    vector.addAll(Arrays.asList(transferable.getTransferDataFlavors()));
                }
                return vector.toArray(new DataFlavor[vector.size()]);
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                for (Transferable transferable : transferableArray) {
                    if (!transferable.isDataFlavorSupported(dataFlavor)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
                for (Transferable transferable : transferableArray) {
                    if (!transferable.isDataFlavorSupported(dataFlavor)) continue;
                    return transferable.getTransferData(dataFlavor);
                }
                return null;
            }
        };
    }

    public static <C> Transferable createObjectTransferable(final C ... CArray) {
        return new Transferable(){
            private final DataFlavor fFlavor;
            {
                try {
                    this.fFlavor = new DataFlavor("application/x-java-jvm-local-objectref;class=java.util.List");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new IllegalStateException(classNotFoundException);
                }
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{this.fFlavor};
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                return dataFlavor.equals(this.fFlavor);
            }

            @Override
            public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
                return Arrays.asList(CArray);
            }
        };
    }

    public static Transferable addTransferType(final int n, final Transferable transferable) {
        return new Transferable(){

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
                DataFlavor[] dataFlavorArray2 = new DataFlavor[dataFlavorArray.length + 1];
                System.arraycopy(dataFlavorArray, 0, dataFlavorArray2, 0, dataFlavorArray.length);
                dataFlavorArray2[dataFlavorArray2.length - 1] = sTypeFlavor;
                return dataFlavorArray2;
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                return dataFlavor == sTypeFlavor || transferable.isDataFlavorSupported(dataFlavor);
            }

            @Override
            public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
                if (dataFlavor == sTypeFlavor) {
                    return n;
                }
                return transferable.getTransferData(dataFlavor);
            }
        };
    }

    public static int getTransferType(Transferable transferable) {
        if (transferable.isDataFlavorSupported(sTypeFlavor)) {
            try {
                return (Integer)transferable.getTransferData(sTypeFlavor);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1;
    }

    static {
        try {
            sTypeFlavor = new DataFlavor("application/x-java-jvm-local-objectref;class=java.lang.Integer");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException(classNotFoundException);
        }
    }
}

