/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.matchers.Matcher;
import com.mathworks.util.Converter;
import com.mathworks.widgets.glazedlists.DisposableList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class MappedEventList<K, V> {
    private final EventList<V> fList;
    private final Converter<V, K> fKeyAccessor;
    private final Map<K, DisposableList<V>> fMap;
    private static final int EMPTY_LIMIT = 100;

    public MappedEventList(EventList<V> eventList, Converter<V, K> converter) {
        this.fList = eventList;
        this.fKeyAccessor = converter;
        this.fMap = new HashMap<K, DisposableList<V>>();
    }

    public DisposableList<V> get(final K k) {
        DisposableList disposableList = this.fMap.get(k);
        if (disposableList == null) {
            Matcher matcher = new Matcher<V>(){

                public boolean matches(V v) {
                    return MappedEventList.this.fKeyAccessor.convert(v).equals(k);
                }
            };
            disposableList = new DisposableList<V>((TransformedList)new FilterList(this.fList, matcher), new TransformedList[0]){

                @Override
                public void dispose() {
                    if (this.isEmpty()) {
                        int n;
                        Iterator iterator = MappedEventList.this.fMap.values().iterator();
                        for (n = 0; iterator.hasNext() && n < 100; n += ((DisposableList)((Object)iterator.next())).isEmpty() ? 1 : 0) {
                        }
                        if (n >= 100) {
                            MappedEventList.this.fMap.remove(k);
                            super.dispose();
                        }
                    }
                }
            };
            this.fMap.put(k, disposableList);
        }
        return disposableList;
    }
}

