/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.editor.breakpoints;

import com.mathworks.matlab.api.debug.BreakpointStyle;
import com.mathworks.widgets.text.STPInterface;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class BreakpointRenderUtils {
    private BreakpointRenderUtils() {
    }

    public static void paintExecutableMark(Graphics2D graphics2D, Color color, int n, Rectangle rectangle) {
        int n2 = rectangle.y + rectangle.height / 2;
        int n3 = n - 4;
        int n4 = rectangle.width / 2 - n3 / 2;
        graphics2D.setColor(color);
        graphics2D.drawLine(n4, n2, n4 + n3, n2);
    }

    public static void paintBreakpoint(Graphics2D graphics2D, Color color, int n, Rectangle rectangle, boolean bl, BreakpointStyle breakpointStyle) {
        BreakpointRenderUtils.paintBreakpoint(graphics2D, color, n, n, rectangle, breakpointStyle);
        if (bl) {
            int n2 = rectangle.width / 2 - n / 2;
            int n3 = rectangle.y + rectangle.height / 2 - n / 2;
            graphics2D.drawLine(n2, n3 + n, n2 + n, n3);
            graphics2D.drawLine(n2, n3, n2 + n, n3 + n);
        }
    }

    public static void paintIntermediateBreakpoint(Graphics2D graphics2D, Color color, int n, Rectangle rectangle, BreakpointStyle breakpointStyle) {
        BreakpointRenderUtils.paintBreakpoint(graphics2D, color, n, n / 2, rectangle, breakpointStyle);
    }

    private static void paintBreakpoint(Graphics2D graphics2D, Color color, int n, int n2, Rectangle rectangle, BreakpointStyle breakpointStyle) {
        int n3 = rectangle.width / 2 - n / 2;
        int n4 = rectangle.y + rectangle.height / 2 - n2 / 2;
        graphics2D.setColor(breakpointStyle.getBackgroundColor());
        graphics2D.fillOval(n3, n4, n, n2);
        graphics2D.setColor(color);
        graphics2D.drawOval(n3, n4, n, n2);
    }

    public static int getBreakpointWidth(STPInterface sTPInterface) {
        int n = sTPInterface.getLineHeight() / 2;
        n = n % 2 == 0 ? n : n + 1;
        return Math.max(5, n);
    }
}

