/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.ComponentMover;
import com.mathworks.mwswing.MJWindow;
import com.mathworks.mwswing.MouseInputLatch;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.mwswing.binding.KeyStrokeUtils;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.desk.DTClient;
import com.mathworks.widgets.desk.DTComponentResizer;
import com.mathworks.widgets.desk.DTContainer;
import com.mathworks.widgets.desk.DTFloatingLocation;
import com.mathworks.widgets.desk.DTFrame;
import com.mathworks.widgets.desk.DTInternalFrame;
import com.mathworks.widgets.desk.DTKeyControlledMover;
import com.mathworks.widgets.desk.DTKeyControlledResizer;
import com.mathworks.widgets.desk.DTLocation;
import com.mathworks.widgets.desk.DTMultipleClientFrame;
import com.mathworks.widgets.desk.DTOccupant;
import com.mathworks.widgets.desk.DTRootPane;
import com.mathworks.widgets.desk.DTSelectable;
import com.mathworks.widgets.desk.DTTitleBar;
import com.mathworks.widgets.desk.Desktop;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputListener;

public class DTOnTopWindow
extends MJWindow
implements DTContainer {
    private Desktop fDesktop;
    private DTFrame fFrame;
    private DTOccupant fOccupant;
    private Dimension fMinimumSize;
    private MouseInputListener fTitleBarListener;
    private MouseInputListener fBorderListener;
    static KeyDispatcher sKeyDispatcher;

    public DTOnTopWindow(Desktop desktop, DTFrame dTFrame, DTOccupant dTOccupant, DTLocation dTLocation) {
        super((Frame)((Object)dTFrame));
        this.fDesktop = desktop;
        this.fFrame = dTFrame;
        this.fOccupant = dTOccupant;
        this.setFocusableWindowState(true);
        this.setName(dTOccupant.getName() + "Window");
        dTOccupant.prepareToShow();
        DTInternalFrame dTInternalFrame = dTOccupant.getInternalFrame();
        this.getContentPane().add((Component)((Object)dTInternalFrame), "Center");
        dTInternalFrame.setTitleBarVisible(true);
        dTInternalFrame.setBorderVisible(true);
        dTInternalFrame.setTitleBarMaximizeAllowed(false);
        dTInternalFrame.setFocusable(true);
        if (dTOccupant.isDockable()) {
            dTInternalFrame.getTitleBar().setDockListener((ActionListener)dTOccupant.getDockAction(), false);
        }
        this.fTitleBarListener = new MouseInputLatch((MouseInputListener)new ComponentMover((Component)((Object)this)));
        dTInternalFrame.getTitleBar().addMouseListener(this.fTitleBarListener);
        dTInternalFrame.getTitleBar().addMouseMotionListener(this.fTitleBarListener);
        dTInternalFrame.setTitleBarMinimizeAllowed(false);
        this.fBorderListener = new MouseInputLatch((MouseInputListener)new Resizer());
        dTInternalFrame.addMouseListener(this.fBorderListener);
        dTInternalFrame.addMouseMotionListener(this.fBorderListener);
        DTFloatingLocation dTFloatingLocation = this.refineFloatingLocation(dTLocation);
        dTFloatingLocation.setFrame(dTFrame);
        dTFloatingLocation.setContainer(this);
        this.setBounds(dTFloatingLocation.getFrameBounds());
        dTOccupant.setLocation(dTFloatingLocation);
        ((DTMultipleClientFrame)this.fFrame).beginTracking(dTOccupant);
        if (!this.fDesktop.isRestoringLayout()) {
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent windowEvent) {
                    if (DTOnTopWindow.this.fOccupant != null) {
                        DTOnTopWindow.this.fOccupant.requestFocus();
                    }
                    DTOnTopWindow.this.removeWindowListener(this);
                }
            });
        }
        this.addComponentListener(new LocalComponentListener());
        if (sKeyDispatcher == null) {
            sKeyDispatcher = new KeyDispatcher();
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            keyboardFocusManager.addKeyEventDispatcher(sKeyDispatcher);
            keyboardFocusManager.addKeyEventPostProcessor(sKeyDispatcher);
        }
    }

    private DTFloatingLocation refineFloatingLocation(DTLocation dTLocation) {
        Serializable serializable;
        Rectangle rectangle = WindowUtils.getScreenBounds();
        DTFloatingLocation dTFloatingLocation = dTLocation instanceof DTFloatingLocation ? (DTFloatingLocation)dTLocation : null;
        boolean bl = this.fOccupant.getLastLocation() != null && this.fOccupant.getLastLocation().isDocked();
        Rectangle rectangle2 = null;
        if (bl) {
            if (dTFloatingLocation == this.fOccupant.getLastUndockedLocation()) {
                dTFloatingLocation = null;
            }
            if (this.fOccupant.getLastLocation().isLocationInitialized() && this.fOccupant.getLastLocation().isSizeInitialized()) {
                rectangle2 = this.fOccupant.getLastLocation().getFrameBounds();
            }
        }
        if (dTFloatingLocation == null || !dTFloatingLocation.isSizeInitialized()) {
            if (dTFloatingLocation == null) {
                dTFloatingLocation = new DTFloatingLocation(true);
            }
            if (dTFloatingLocation.hasNormalizedSize()) {
                dTFloatingLocation.initializeSize(rectangle.getSize());
            } else if (rectangle2 != null) {
                dTFloatingLocation.setFrameSize(rectangle2.width, rectangle2.height);
            } else if (this.fOccupant instanceof DTClient) {
                dTFloatingLocation.setFrameSize(3 * rectangle.width / 8, 3 * rectangle.height / 8);
            } else {
                dTFloatingLocation.setFrameSize(9 * rectangle.width / 16, 5 * rectangle.height / 8);
            }
        }
        if (!dTFloatingLocation.isLocationInitialized()) {
            if (dTFloatingLocation.hasNormalizedLocation()) {
                dTFloatingLocation.initializeLocation(rectangle);
            } else if (rectangle2 != null) {
                dTFloatingLocation.setFrameLocation(Math.max(rectangle2.x - 20, 0), Math.max(rectangle2.y - 20, 0));
            } else {
                serializable = null;
                if (this.fOccupant instanceof DTClient && ((DTClient)this.fOccupant).getGroup() != null) {
                    serializable = ((DTClient)this.fOccupant).getGroup().getContainingFrame();
                }
                if (serializable == null) {
                    serializable = this.fDesktop.getMainFrame();
                }
                if (serializable == null) {
                    dTFloatingLocation.setFrameLocation(0, 0);
                } else {
                    dTFloatingLocation.setFrameLocation(Math.max(serializable.getX() - 20, 0), Math.max(serializable.getY() - 20, 0));
                }
            }
        }
        serializable = dTFloatingLocation.getFrameSize();
        Dimension dimension = this.getMinimumClientSize();
        if (serializable.width < dimension.width) {
            serializable.width = dimension.width;
        }
        if (serializable.height < dimension.height) {
            serializable.height = dimension.height;
        }
        dTFloatingLocation.setFrameSize((Dimension)serializable);
        dTFloatingLocation.ensureVisible(WindowUtils.getVirtualScreenBounds());
        if (dTFloatingLocation.getFrameX() < 0 && PlatformInfo.isLinux()) {
            dTFloatingLocation.setFrameLocation(0, dTFloatingLocation.getFrameY());
        }
        return dTFloatingLocation;
    }

    DTOccupant getOccupant() {
        return this.fOccupant;
    }

    public void dispose() {
        if (this.fOccupant != null) {
            DTInternalFrame dTInternalFrame = this.fOccupant.getInternalFrame();
            ((DTMultipleClientFrame)this.fFrame).endTracking(this.fOccupant);
            if (this.fOccupant.getLocation() != null) {
                this.fOccupant.getLocation().setContainer(null);
                this.fOccupant.setLocation(null);
            }
            if (this.fOccupant.isSelected() && this.fOccupant.isClosing()) {
                this.fDesktop.getSelectionManager().clearSelection();
            }
            dTInternalFrame.getTitleBar().removeMouseListener(this.fTitleBarListener);
            dTInternalFrame.getTitleBar().removeMouseMotionListener(this.fTitleBarListener);
            dTInternalFrame.setTitleBarMinimizeAllowed(true);
            dTInternalFrame.setTitleBarMaximizeAllowed(true);
            this.getContentPane().remove((Component)((Object)dTInternalFrame));
            dTInternalFrame.removeMouseListener(this.fBorderListener);
            dTInternalFrame.removeMouseMotionListener(this.fBorderListener);
            dTInternalFrame.setFocusable(false);
            dTInternalFrame.getTitleBar().setDockListener((ActionListener)(this.fOccupant.permitUserUndock() ? this.fOccupant.getUndockAction() : null), true);
            this.fOccupant = null;
            this.fFrame = null;
        }
        super.dispose();
    }

    boolean hasBeenDisposed() {
        return this.fOccupant == null;
    }

    protected Dimension getMinimumClientSize() {
        if (this.fMinimumSize == null) {
            if (this.fOccupant == null) {
                this.fMinimumSize = new Dimension(100, 20);
            } else {
                Insets insets = this.fOccupant.getInternalFrame().getInsets();
                DTTitleBar dTTitleBar = this.fOccupant.getInternalFrame().getTitleBar();
                this.fMinimumSize = dTTitleBar.getPreferredSize();
                this.fMinimumSize.height += insets.top + insets.bottom;
                this.fMinimumSize.width = 100;
            }
        }
        return this.fMinimumSize;
    }

    @Override
    public void add(DTOccupant dTOccupant, DTLocation dTLocation) {
    }

    @Override
    public void remove(DTOccupant dTOccupant) {
    }

    @Override
    public DTSelectable getNext(DTSelectable dTSelectable, boolean bl) {
        return null;
    }

    @Override
    public DTSelectable getPrevious(DTSelectable dTSelectable, boolean bl) {
        return null;
    }

    @Override
    public void replaceChild(Component component, Component component2) {
    }

    @Override
    public void toFront(DTOccupant dTOccupant, DTContainer.Scope scope) {
    }

    @Override
    public boolean canMoveWithKeys(DTOccupant dTOccupant) {
        return true;
    }

    @Override
    public boolean canResizeWithKeys(DTOccupant dTOccupant) {
        return true;
    }

    @Override
    public void startKeyMove(DTOccupant dTOccupant) {
        new DTKeyControlledMover().activate(dTOccupant);
    }

    @Override
    public void startKeyResize(DTOccupant dTOccupant) {
        new DTKeyControlledResizer().activate(dTOccupant, null);
    }

    static void repaintMnemonicsInWindow(Window window) {
        Window[] windowArray;
        if (window == null || !window.isShowing()) {
            return;
        }
        for (Window window2 : windowArray = window.getOwnedWindows()) {
            DTOnTopWindow.repaintMnemonicsInWindow(window2);
        }
        DTOnTopWindow.repaintMnemonicsInContainer(window);
    }

    static void repaintMnemonicsInContainer(Container container) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (component == null || !component.isVisible()) continue;
            if (component instanceof AbstractButton && ((AbstractButton)component).getMnemonic() != 0) {
                component.repaint();
                continue;
            }
            if (component instanceof JLabel && ((JLabel)component).getDisplayedMnemonic() != 0) {
                component.repaint();
                continue;
            }
            if (!(component instanceof Container)) continue;
            DTOnTopWindow.repaintMnemonicsInContainer((Container)component);
        }
    }

    static class KeyDispatcher
    implements KeyEventDispatcher,
    KeyEventPostProcessor {
        KeyDispatcher() {
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent keyEvent) {
            return keyEvent.getKeyCode() == 18 && PlatformInfo.isWindows() && this.processAlt(keyEvent);
        }

        @Override
        public boolean postProcessKeyEvent(KeyEvent keyEvent) {
            DTOnTopWindow dTOnTopWindow;
            if (keyEvent.getKeyCode() == 18) {
                return PlatformInfo.isWindows() && this.processAlt(keyEvent);
            }
            if (keyEvent.getID() == 401 && (keyEvent.isActionKey() || keyEvent.isAltDown() || (keyEvent.getModifiers() & KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK) != 0) && (dTOnTopWindow = this.getOnTopWindow(keyEvent)) != null) {
                DTFrame dTFrame = dTOnTopWindow.fFrame;
                JRootPane jRootPane = dTFrame.getRootPane();
                if (jRootPane instanceof DTRootPane) {
                    MenuSelectionManager menuSelectionManager;
                    Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                    ((DTRootPane)jRootPane).processKeyEvent(keyEvent);
                    if (keyEvent.isConsumed() && (menuSelectionManager = MenuSelectionManager.defaultManager()).getSelectedPath().length > 0) {
                        this.restoreFocusUponMenuClose(component);
                    }
                }
                return true;
            }
            return false;
        }

        private DTOnTopWindow getOnTopWindow(KeyEvent keyEvent) {
            JRootPane jRootPane = SwingUtilities.getRootPane(keyEvent.getComponent());
            Window window = jRootPane == null ? null : SwingUtilities.getWindowAncestor(jRootPane);
            return window instanceof DTOnTopWindow ? (DTOnTopWindow)((Object)window) : null;
        }

        private void restoreFocusUponMenuClose(final Component component) {
            final MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (menuSelectionManager.getSelectedPath().length == 0) {
                        component.requestFocus();
                        menuSelectionManager.removeChangeListener(this);
                    }
                }
            });
        }

        private boolean processAlt(KeyEvent keyEvent) {
            DTOnTopWindow dTOnTopWindow = this.getOnTopWindow(keyEvent);
            if (dTOnTopWindow != null) {
                DTFrame dTFrame = dTOnTopWindow.fFrame;
                if (keyEvent.getID() == 401) {
                    if (UIManager.getLookAndFeel().getClass().getName().equals("com.sun.java.swing.plaf.windows.WindowsLookAndFeel")) {
                        MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
                        if (menuElementArray.length == 0) {
                            WindowsLookAndFeel.setMnemonicHidden((boolean)false);
                            DTOnTopWindow.repaintMnemonicsInWindow((Window)((Object)dTFrame));
                        }
                        keyEvent.consume();
                    }
                } else if (keyEvent.getID() == 402) {
                    JMenu jMenu;
                    JMenuBar jMenuBar = dTFrame.getJMenuBar();
                    JMenu jMenu2 = jMenu = jMenuBar == null ? null : jMenuBar.getMenu(0);
                    if (jMenu != null) {
                        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                        MenuElement[] menuElementArray = new MenuElement[]{jMenuBar, jMenu};
                        MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
                        this.restoreFocusUponMenuClose(component);
                    }
                    return true;
                }
            }
            return false;
        }
    }

    private class Resizer
    extends DTComponentResizer {
        Resizer() {
            super((Component)((Object)DTOnTopWindow.this));
        }

        @Override
        protected Insets getResizeInsets() {
            return DTOnTopWindow.this.fOccupant != null ? DTOnTopWindow.this.fOccupant.getInternalFrame().getInsets() : new Insets(0, 0, 0, 0);
        }

        @Override
        protected Dimension getMinimumSize() {
            return DTOnTopWindow.this.getMinimumClientSize();
        }
    }

    private class LocalComponentListener
    extends ComponentAdapter {
        private LocalComponentListener() {
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            if (DTOnTopWindow.this.fOccupant != null && DTOnTopWindow.this.fOccupant.getLocation() != null) {
                DTOnTopWindow.this.fOccupant.getLocation().setFrameLocation(DTOnTopWindow.this.getX(), DTOnTopWindow.this.getY());
            }
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            if (DTOnTopWindow.this.fOccupant != null && DTOnTopWindow.this.fOccupant.getLocation() != null) {
                DTOnTopWindow.this.fOccupant.getLocation().setFrameSize(DTOnTopWindow.this.getWidth(), DTOnTopWindow.this.getHeight());
            }
        }
    }
}

