/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.widgets.desk.DTFrame;
import com.mathworks.widgets.desk.DTMenuMergeTag;
import com.mathworks.widgets.desk.DTPlaceHolderAction;
import com.mathworks.widgets.desk.DTToolBarConfiguration;
import com.mathworks.widgets.desk.DTToolBarFactory;
import com.mathworks.widgets.desk.DTToolBarInfo;
import com.mathworks.widgets.desk.DTToolBarRegistry;
import com.mathworks.widgets.desk.DTToolBarUtilities;
import com.mathworks.widgets.desk.DTToolSet;
import com.mathworks.widgets.desk.Desktop;
import java.awt.Component;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;

public class DTMainToolBarSupplier {
    protected Desktop fDesktop;
    private HashMap<String, HashMap<String, Action>> fRestoreMap;
    protected static final String CUT = "Cut";
    protected static final String COPY = "Copy";
    protected static final String PASTE = "Paste";
    protected static final String UNDO = "Undo";
    protected static final String REDO = "Redo";
    protected static HashMap<String, DTMenuMergeTag[]> sDefaultMergeMap = new HashMap();

    public DTMainToolBarSupplier(Desktop desktop) {
        this.fDesktop = desktop;
    }

    protected DTToolBarInfo[] getToolBarInfo() {
        Action[] actionArray = new Action[]{DTPlaceHolderAction.getCutPlaceHolder(this.fDesktop), DTPlaceHolderAction.getCopyPlaceHolder(this.fDesktop), DTPlaceHolderAction.getPastePlaceHolder(this.fDesktop), DTPlaceHolderAction.getUndoPlaceHolder(this.fDesktop), DTPlaceHolderAction.getRedoPlaceHolder(this.fDesktop)};
        String[] stringArray = new String[]{CUT, COPY, PASTE, UNDO, REDO};
        DTToolSet dTToolSet = new DTToolSet();
        for (int i = 0; i < actionArray.length; ++i) {
            dTToolSet.add(stringArray[i], actionArray[i]);
        }
        DTToolBarConfiguration dTToolBarConfiguration = new DTToolBarConfiguration(Arrays.asList(stringArray));
        DTToolBarInfo[] dTToolBarInfoArray = new DTToolBarInfo[]{new DTToolBarInfo("TestToolBar", "Test", dTToolSet, dTToolBarConfiguration)};
        return dTToolBarInfoArray;
    }

    protected JToolBar[] createToolBars() {
        DTToolBarInfo[] dTToolBarInfoArray = this.getToolBarInfo();
        JToolBar[] jToolBarArray = new JToolBar[dTToolBarInfoArray.length];
        for (int i = 0; i < dTToolBarInfoArray.length; ++i) {
            DTToolBarConfiguration dTToolBarConfiguration = DTToolBarUtilities.recallConfiguration(this.fDesktop, dTToolBarInfoArray[i]);
            ToolBarRegistrant toolBarRegistrant = new ToolBarRegistrant(dTToolBarInfoArray[i], dTToolBarConfiguration);
            this.fDesktop.getToolBarRegistry().register(dTToolBarInfoArray[i].getKey(), toolBarRegistrant, i);
            jToolBarArray[i] = DTToolBarFactory.createToolBar(dTToolBarInfoArray[i], toolBarRegistrant.getToolBarConfiguration(dTToolBarInfoArray[i].getKey()), this);
        }
        return jToolBarArray;
    }

    protected HashMap<String, DTMenuMergeTag[]> getMergeMap(String string) {
        return sDefaultMergeMap;
    }

    protected void merge(JMenuBar jMenuBar) {
        DTFrame dTFrame;
        if (jMenuBar != null) {
            if (this.fRestoreMap == null) {
                this.fRestoreMap = new HashMap();
            }
        } else if (this.fRestoreMap == null) {
            return;
        }
        if ((dTFrame = this.fDesktop.getMainFrame()) != null) {
            List<JComponent> list = dTFrame.getToolBarContainer().getToolBars();
            for (JComponent jComponent : list) {
                JToolBar jToolBar;
                String string;
                if (!(jComponent instanceof JToolBar) || (string = (String)(jToolBar = (JToolBar)jComponent).getClientProperty("ToolBarKey")) == null) continue;
                HashMap<String, DTMenuMergeTag[]> hashMap = null;
                HashMap<String, Action> hashMap2 = this.fRestoreMap.get(string);
                if (jMenuBar != null) {
                    hashMap = this.getMergeMap(string);
                    if (hashMap2 == null) {
                        hashMap2 = new HashMap();
                        this.fRestoreMap.put(string, hashMap2);
                    }
                }
                if (hashMap == null && hashMap2 == null) continue;
                for (int i = 0; i < jToolBar.getComponentCount(); ++i) {
                    Object object;
                    AbstractButton abstractButton;
                    String string2;
                    Component component = jToolBar.getComponent(i);
                    if (!(component instanceof AbstractButton) || (string2 = (String)(abstractButton = (AbstractButton)component).getClientProperty("ToolBarItemPropertyKey")) == null) continue;
                    if (hashMap != null) {
                        JMenuItem jMenuItem;
                        object = hashMap.get(string2);
                        if (object == null || (jMenuItem = this.getItem(jMenuBar, (DTMenuMergeTag[])object)) == null) continue;
                        hashMap2.put(string2, abstractButton.getAction());
                        abstractButton.setAction(jMenuItem.getAction());
                        continue;
                    }
                    object = hashMap2.get(string2);
                    if (object == null) continue;
                    abstractButton.setAction((Action)object);
                }
            }
        }
        if (jMenuBar == null) {
            this.fRestoreMap.clear();
        }
    }

    private JMenuItem getItem(JMenuBar jMenuBar, DTMenuMergeTag[] dTMenuMergeTagArray) {
        for (int i = 0; i < jMenuBar.getMenuCount(); ++i) {
            JMenu jMenu = jMenuBar.getMenu(i);
            if (dTMenuMergeTagArray[0] != DTMenuMergeTag.getTag(jMenu)) continue;
            return this.getItem(jMenu, dTMenuMergeTagArray, 1);
        }
        return null;
    }

    private JMenuItem getItem(JMenu jMenu, DTMenuMergeTag[] dTMenuMergeTagArray, int n) {
        for (int i = 0; i < jMenu.getMenuComponentCount(); ++i) {
            Component component = jMenu.getMenuComponent(i);
            if (!(component instanceof JMenuItem) || dTMenuMergeTagArray[n] != DTMenuMergeTag.getTag((JMenuItem)component)) continue;
            if (component instanceof JMenu && dTMenuMergeTagArray.length > n + 1) {
                return this.getItem((JMenu)component, dTMenuMergeTagArray, n + 1);
            }
            return (JMenuItem)component;
        }
        return null;
    }

    private JToolBar getToolBar(String string) {
        DTFrame dTFrame = this.fDesktop.getMainFrame();
        if (dTFrame != null) {
            List<JComponent> list = dTFrame.getToolBarContainer().getToolBars();
            for (JComponent jComponent : list) {
                if (!(jComponent instanceof JToolBar) || !string.equals(((JToolBar)jComponent).getClientProperty("ToolBarKey"))) continue;
                return (JToolBar)jComponent;
            }
        }
        return null;
    }

    static {
        sDefaultMergeMap.put(CUT, new DTMenuMergeTag[]{DTMenuMergeTag.EDIT, DTMenuMergeTag.CUT});
        sDefaultMergeMap.put(COPY, new DTMenuMergeTag[]{DTMenuMergeTag.EDIT, DTMenuMergeTag.COPY});
        sDefaultMergeMap.put(PASTE, new DTMenuMergeTag[]{DTMenuMergeTag.EDIT, DTMenuMergeTag.PASTE});
        sDefaultMergeMap.put(UNDO, new DTMenuMergeTag[]{DTMenuMergeTag.EDIT, DTMenuMergeTag.UNDO});
        sDefaultMergeMap.put(REDO, new DTMenuMergeTag[]{DTMenuMergeTag.EDIT, DTMenuMergeTag.REDO});
    }

    private class ToolBarRegistrant
    implements DTToolBarRegistry.Registrant {
        private DTToolBarInfo iInfo;
        private DTToolBarConfiguration iConfig;

        ToolBarRegistrant(DTToolBarInfo dTToolBarInfo, DTToolBarConfiguration dTToolBarConfiguration) {
            this.iInfo = dTToolBarInfo;
            this.iConfig = dTToolBarConfiguration;
        }

        @Override
        public String getToolBarLabel(String string) {
            return this.iInfo.getLabel();
        }

        @Override
        public DTToolBarInfo getToolBarInfo(String string) {
            return this.iInfo;
        }

        @Override
        public DTToolBarConfiguration getToolBarConfiguration(String string) {
            return this.iConfig;
        }

        @Override
        public void updateToolBars(String string, DTToolBarConfiguration dTToolBarConfiguration) {
            if (dTToolBarConfiguration.getVisibleItemKeys().size() == 0) {
                DTFrame dTFrame = DTMainToolBarSupplier.this.fDesktop.getMainFrame();
                if (dTFrame != null) {
                    dTFrame.getToolBarContainer().setToolBarVisible(string, null, false);
                }
            } else {
                this.iConfig = dTToolBarConfiguration;
                JToolBar jToolBar = DTMainToolBarSupplier.this.getToolBar(this.iInfo.getKey());
                if (jToolBar != null) {
                    DTToolBarFactory.udpateToolBar(jToolBar, this.iInfo.getToolSet(), dTToolBarConfiguration, DTMainToolBarSupplier.this);
                    jToolBar.revalidate();
                    jToolBar.repaint();
                }
                DTToolBarUtilities.saveConfiguration(DTMainToolBarSupplier.this.fDesktop, this.iInfo, dTToolBarConfiguration);
            }
        }
    }
}

