/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.widgets.desk.DTFrame;
import com.mathworks.widgets.desk.DTOccupant;
import com.mathworks.widgets.desk.Desktop;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;

class DTGlobalActionManager {
    private Desktop fDesktop;
    private List<Action> fActions = new ArrayList<Action>();
    private List<Action> fNonNavigationActions = new ArrayList<Action>();

    DTGlobalActionManager(Desktop desktop) {
        this.fDesktop = desktop;
    }

    void addAction(Action action) {
        if (this.fActions.contains(action)) {
            return;
        }
        this.fActions.add(action);
        if (!(action instanceof DTOccupant.SelectAction) && !this.fNonNavigationActions.contains(action)) {
            this.fNonNavigationActions.add(action);
        }
        List<DTFrame> list = this.fDesktop.getFrames();
        for (DTFrame dTFrame : list) {
            dTFrame.getRootPane().putClientProperty("GLOBAL_FRAME_ACTIONS", dTFrame.supportDesktopNavigationBindings() ? this.fActions : this.fNonNavigationActions);
        }
    }

    void removeAction(Action action) {
        if (this.fActions.contains(action)) {
            this.fActions.remove(action);
        }
        if (!(action instanceof DTOccupant.SelectAction) && this.fNonNavigationActions.contains(action)) {
            this.fNonNavigationActions.add(action);
        }
    }

    void addActionsToFrame(DTFrame dTFrame) {
        dTFrame.getRootPane().putClientProperty("GLOBAL_FRAME_ACTIONS", dTFrame.supportDesktopNavigationBindings() ? this.fActions : this.fNonNavigationActions);
    }

    void removeActionsFromFrame(DTFrame dTFrame) {
        dTFrame.getRootPane().putClientProperty("GLOBAL_FRAME_ACTIONS", null);
    }
}

