/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets;

import com.mathworks.matlab.api.debug.ViewProviderKey;
import com.mathworks.matlab.api.editor.EditorLanguage;
import com.mathworks.matlab.api.editor.EditorSyntaxHighlighting;
import com.mathworks.matlab.api.editor.SyntaxHighlightingColor;
import com.mathworks.mwswing.ChildAction;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJStatusBar;
import com.mathworks.mwswing.datatransfer.AutoScroller;
import com.mathworks.mwswing.datatransfer.MJClipboard;
import com.mathworks.mwswing.text.DocumentReader;
import com.mathworks.util.FileUtils;
import com.mathworks.util.Log;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.STPPrefsManager;
import com.mathworks.widgets.SyntaxTextPaneUtilities;
import com.mathworks.widgets.TextPrintPanel;
import com.mathworks.widgets.incSearch.IncSearch;
import com.mathworks.widgets.text.EditorLanguageUtils;
import com.mathworks.widgets.text.EditorPrefsAccessor;
import com.mathworks.widgets.text.MWCaret;
import com.mathworks.widgets.text.MWDrawLayerFactory;
import com.mathworks.widgets.text.MWEditorUI;
import com.mathworks.widgets.text.MWKit;
import com.mathworks.widgets.text.MWStatusBar;
import com.mathworks.widgets.text.MethodStyle;
import com.mathworks.widgets.text.STPBaseInterface;
import com.mathworks.widgets.text.STPIncSearch;
import com.mathworks.widgets.text.STPViewModificationInterface;
import com.mathworks.widgets.text.ViewHierarchyChangeEvent;
import com.mathworks.widgets.text.ViewHierarchyChangeListener;
import com.mathworks.widgets.text.ViewHierarchyModificationComponent;
import com.mathworks.widgets.text.mcode.MLanguage;
import com.mathworks.widgets.text.print.PrintSettings;
import com.mathworks.widgets.text.print.TextPrintable;
import com.mathworks.widgets.text.xml.XMLLanguage;
import com.mathworks.xml.XMLUtils;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.Autoscroll;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodHighlight;
import java.awt.im.InputMethodRequests;
import java.awt.print.PrinterAbortException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observer;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.SimpleDoc;
import javax.print.attribute.HashDocAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.apache.commons.io.IOUtils;
import org.netbeans.editor.AnnotationTypes;
import org.netbeans.editor.BaseCaret;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseDocumentEvent;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.JumpList;
import org.netbeans.editor.SettingsAdapter;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.StatusBar;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.editor.ext.ExtUtilities;
import org.netbeans.editor.ext.ToolTipSupport;

class SyntaxTextPaneBase
extends JEditorPane
implements Autoscroll,
STPBaseInterface,
ViewProviderKey,
STPViewModificationInterface {
    public static final String M_MIME_TYPE = MLanguage.INSTANCE.getMimeType();
    private KitStore fKitStore = null;
    private boolean fDragAndDropEnabled = false;
    private AutoScroller fAutoscroller;
    private IncSearch fIncSearch;
    private STPIncSearch fIncSearchImpl;
    private Observer fIncSearchObserver = null;
    private boolean fIsIncSearch = false;
    protected MJPopupMenu fContextMenu;
    private String fEncoding = null;
    private final List<ViewHierarchyChangeListener> fRegViewHierarchyChangeListeners = new ArrayList<ViewHierarchyChangeListener>();
    private final List<ViewHierarchyModificationComponent> fExtViewChangingComponents = new ArrayList<ViewHierarchyModificationComponent>();
    protected MJAbstractAction fCollapseAllFoldsAction;
    protected MJAbstractAction fCollapseFoldAction;
    protected MJAbstractAction fExpandFoldAction;
    protected MJAbstractAction fExpandAllFoldsAction;
    private MJAbstractAction fCodeFoldingMenuAction;
    private ViewHierarchyChangeListener fViewHierarchyChangeListener;
    private transient InputMethodRequests inputMethodRequestsHandler;
    private AttributedString composedText;
    private String composedTextContent;
    private Position composedTextStart;
    private Position latestCommittedTextStart;
    private int latestCommittedTextLength;
    private ComposedTextCaret composedTextCaret;
    private transient Caret originalCaret;
    private boolean checkedInputOverride;
    private boolean needToSendKeyTypedEvent;

    protected SyntaxTextPaneBase() {
        this.fKitStore = new KitStore();
        this.setupDefaultKits();
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("editorKit") && SyntaxTextPaneBase.this.getEditorKit() instanceof MWKit) {
                    SyntaxTextPaneBase.this.setTextDragAndDropEnabled(SyntaxTextPaneBase.this.fDragAndDropEnabled);
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if ((mouseEvent.getModifiers() & 8) != 0 && PlatformInfo.isXWindows()) {
                    try {
                        SyntaxTextPaneBase.this.setCaretPosition(SyntaxTextPaneBase.this.getPosFromPoint(mouseEvent.getPoint()));
                        Transferable transferable = MJClipboard.getMJClipboard().getXSelectionContents((Object)this);
                        if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                            String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                            SyntaxTextPaneBase.this.replaceSelection(string);
                        }
                    }
                    catch (Exception exception) {
                        Log.logException((Exception)exception);
                    }
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){
            private Cursor fNonSelectedCursor;

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                SyntaxTextPaneBase syntaxTextPaneBase;
                if (mouseEvent.getSource() instanceof SyntaxTextPaneBase && (syntaxTextPaneBase = (SyntaxTextPaneBase)mouseEvent.getSource()).getCaret() instanceof MWCaret) {
                    Cursor cursor = syntaxTextPaneBase.getCursor();
                    if (cursor.equals(Cursor.getPredefinedCursor(3))) {
                        return;
                    }
                    if (MWCaret.isClickInSelection(mouseEvent)) {
                        if (!cursor.equals(Cursor.getDefaultCursor())) {
                            this.fNonSelectedCursor = cursor;
                            syntaxTextPaneBase.setCursor(Cursor.getDefaultCursor());
                        }
                    } else if (cursor != this.fNonSelectedCursor) {
                        if (this.fNonSelectedCursor != null) {
                            syntaxTextPaneBase.setCursor(this.fNonSelectedCursor);
                        } else if (!cursor.equals(Cursor.getPredefinedCursor(2))) {
                            syntaxTextPaneBase.setCursor(Cursor.getPredefinedCursor(2));
                        }
                    }
                }
            }
        });
        this.fDragAndDropEnabled = true;
        this.fAutoscroller = new AutoScroller(this){

            public int getAutoscrollRowHeight() {
                int n = SyntaxTextPaneBase.this.getFontMetrics(SyntaxTextPaneBase.this.getFont()).getHeight();
                if (n < 15) {
                    n = 15;
                }
                return n;
            }

            public int getAutoscrollColumnWidth() {
                int n = SyntaxTextPaneBase.this.getFontMetrics(SyntaxTextPaneBase.this.getFont()).charWidth('W');
                if (n < 15) {
                    n = 15;
                }
                return n;
            }
        };
    }

    @Override
    public void registerViewHierarchyModificationComponent(ViewHierarchyModificationComponent viewHierarchyModificationComponent) {
        if (viewHierarchyModificationComponent != null) {
            this.fExtViewChangingComponents.add(viewHierarchyModificationComponent);
            if (this.fViewHierarchyChangeListener == null) {
                this.fViewHierarchyChangeListener = new ViewHierarchyChangeListenerImpl(this);
            }
            viewHierarchyModificationComponent.addViewHierarchyChangeListener(this.fViewHierarchyChangeListener);
        }
    }

    @Override
    public void addViewHierarchyChangeListener(ViewHierarchyChangeListener viewHierarchyChangeListener) {
        if (viewHierarchyChangeListener != null && this.fRegViewHierarchyChangeListeners != null) {
            this.fRegViewHierarchyChangeListeners.add(viewHierarchyChangeListener);
        }
    }

    @Override
    public void removeViewHierarchyChangeListener(ViewHierarchyChangeListener viewHierarchyChangeListener) {
        if (viewHierarchyChangeListener != null && this.fRegViewHierarchyChangeListeners != null) {
            this.fRegViewHierarchyChangeListeners.remove(viewHierarchyChangeListener);
        }
    }

    @Override
    public MJAbstractAction getCollapseAllFoldsAction() {
        return this.fCollapseAllFoldsAction;
    }

    @Override
    public MJAbstractAction getCollapseFoldAction() {
        return this.fCollapseFoldAction;
    }

    @Override
    public MJAbstractAction getExpandFoldAction() {
        return this.fExpandFoldAction;
    }

    @Override
    public MJAbstractAction getExpandAllFoldsAction() {
        return this.fExpandAllFoldsAction;
    }

    @Override
    public MJAbstractAction getCodeFoldingMenuAction() {
        if (this.fCodeFoldingMenuAction == null) {
            this.fCodeFoldingMenuAction = new MJAbstractAction(SyntaxTextPaneUtilities.intlString("codefolding-menu")){

                public void actionPerformed(ActionEvent actionEvent) {
                }
            };
            if (this.getEditorKit() instanceof MWKit) {
                this.fCodeFoldingMenuAction.setEnabled(((ExtKit)this.getEditorKit()).isCodeFoldingEnabled());
            } else {
                this.fCodeFoldingMenuAction.setEnabled(false);
            }
        }
        return this.fCodeFoldingMenuAction;
    }

    @Override
    public void validateCodeFoldActions() {
        MWEditorUI mWEditorUI;
        if (this.getEditorUI() != null && this.getEditorUI() instanceof MWEditorUI && (mWEditorUI = (MWEditorUI)this.getEditorUI()).getFoldSideBar() != null) {
            mWEditorUI.getFoldSideBar().validateColdFoldActions();
        }
    }

    private void cleanUpViewHierarchyModificationComponents() {
        if (!this.fExtViewChangingComponents.isEmpty()) {
            Iterator<ViewHierarchyModificationComponent> iterator = this.fExtViewChangingComponents.iterator();
            while (iterator.hasNext()) {
                ViewHierarchyModificationComponent viewHierarchyModificationComponent = iterator.next();
                viewHierarchyModificationComponent.cleanup();
                iterator.remove();
            }
        }
    }

    protected void setupDefaultKits() {
    }

    @Override
    public EditorKit getEditorKitForContentType(String string) {
        EditorKit editorKit;
        if (this.fKitStore.hasKit(string)) {
            editorKit = super.getEditorKitForContentType(string);
            assert (editorKit.getClass().equals(this.fKitStore.getKit(string).getKitClass()));
        } else {
            for (EditorLanguage editorLanguage : EditorLanguageUtils.getLanguages()) {
                if (!editorLanguage.getMimeType().equals(string)) continue;
                this.setEditorKitForContentType(string, editorLanguage.createDefaultKit());
                break;
            }
            editorKit = super.getEditorKitForContentType(string);
        }
        return editorKit;
    }

    @Override
    public void selectAll() {
        if (this.getSelectionMark() != 0 || this.getSelectionDot() != this.getLength()) {
            super.selectAll();
        }
    }

    public synchronized void setValue(boolean bl, String string, Object object) {
        EditorKit editorKit = null;
        if (!bl) {
            editorKit = this.getEditorKit();
        }
        this.setValue(editorKit, string, object);
    }

    public synchronized void setValue(EditorKit editorKit, String string, Object object) {
        if (editorKit == null) {
            Collection collection = this.fKitStore.getElements();
            for (EditorKitInfo editorKitInfo : collection) {
                SettingsAdapter.setValue((Object)this, (Class)editorKitInfo.getKitClass(), (String)string, (Object)object);
            }
        } else {
            if (!this.fKitStore.registeredKit(editorKit.getClass())) {
                throw new IllegalArgumentException("Invalid EditorKit");
            }
            SettingsAdapter.setValue((Object)this, editorKit.getClass(), (String)string, (Object)object);
        }
    }

    @Override
    public void setToolTipText(String string) {
        ToolTipSupport toolTipSupport;
        super.setToolTipText(string);
        if (Utilities.getEditorUI((JTextComponent)this) instanceof ExtEditorUI && (toolTipSupport = ExtUtilities.getExtEditorUI((JTextComponent)this).getToolTipSupport()) != null) {
            ToolTipManager.sharedInstance().unregisterComponent(this);
        }
    }

    public synchronized void setColoring(boolean bl, String string, Coloring coloring) {
        EditorKit editorKit = null;
        if (!bl) {
            editorKit = this.getEditorKit();
        }
        this.setColoring(editorKit, string, coloring);
    }

    public synchronized void setColoring(EditorKit editorKit, String string, Coloring coloring) {
        if (editorKit == null) {
            Collection collection = this.fKitStore.getElements();
            for (EditorKitInfo editorKitInfo : collection) {
                SettingsAdapter.setColoring((Object)this, (Class)editorKitInfo.getKitClass(), (String)string, (Object)coloring);
            }
        } else {
            if (!this.fKitStore.registeredKit(editorKit.getClass())) {
                throw new IllegalArgumentException("Invalid EditorKit");
            }
            SettingsAdapter.setColoring((Object)this, editorKit.getClass(), (String)string, (Object)coloring);
        }
    }

    public void registerEditorKit(String string, EditorKit editorKit) {
        if (editorKit instanceof MWKit && !((MWKit)((Object)editorKit)).isModifiable()) {
            throw new IllegalArgumentException("Cannot call registerEditorKit with a kit whose isModifiable() method returns false; use a custom kit subclass instead");
        }
        this.fKitStore.addKit(string, editorKit.getClass());
        this.setEditorKitForContentType(string, editorKit);
    }

    public void setTextDragAndDropEnabled(boolean bl) {
        this.fDragAndDropEnabled = bl;
        if (this.getCaret() instanceof MWCaret) {
            ((MWCaret)((Object)this.getCaret())).setTextDragAndDropEnabled(bl);
        } else {
            this.fDragAndDropEnabled = false;
        }
    }

    @Override
    public MJPopupMenu getContextMenu() {
        return this.fContextMenu;
    }

    @Override
    public Insets getAutoscrollInsets() {
        return this.fAutoscroller.getAutoscrollInsets();
    }

    @Override
    public void autoscroll(Point point) {
        this.fAutoscroller.autoscroll(point);
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        switch (n) {
            case 1: {
                return this.getLineHeight();
            }
            case 0: {
                return this.getLineHeight();
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + n);
    }

    @Override
    public void read(InputStream inputStream, Object object, String string) throws IOException {
        this.read(inputStream, object, string, null);
    }

    @Override
    public void read(InputStream inputStream, Object object, String string, String string2) throws IOException {
        this.setContentType(string);
        boolean bl = false;
        if (string2 != null) {
            try {
                this.read(new InputStreamReader(inputStream, string2), object);
                this.fEncoding = string2;
                bl = true;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                SyntaxTextPaneBase.handleUnsupportedEncodingException(string2);
            }
        }
        if (!bl) {
            this.fEncoding = null;
            this.read(inputStream, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(File file) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            this.read(fileInputStream, file.getName(), EditorLanguageUtils.getMimeTypeFromFilename(file.getName()), SyntaxTextPaneUtilities.getDefaultFileEncoding(file).name());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)fileInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(File file) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            this.write(fileOutputStream);
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {
                Log.logException((Exception)iOException);
            }
        }
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        try {
            String string;
            Document document = this.getDocument();
            boolean bl = false;
            if (XMLLanguage.INSTANCE.getMimeType().equals(this.getContentType()) && (string = XMLUtils.getEncoding((Reader)new DocumentReader(document))) != null) {
                try {
                    this.getUI().getEditorKit(this).write(new OutputStreamWriter(outputStream, string), document, 0, document.getLength());
                    bl = true;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    SyntaxTextPaneBase.handleUnsupportedEncodingException(string);
                }
            }
            if (!bl) {
                if (this.getEncoding() != null) {
                    this.getUI().getEditorKit(this).write(new OutputStreamWriter(outputStream, this.getEncoding()), document, 0, document.getLength());
                } else {
                    this.getUI().getEditorKit(this).write(outputStream, document, 0, document.getLength());
                }
            }
        }
        catch (BadLocationException badLocationException) {
            throw new IOException(badLocationException.getMessage());
        }
    }

    private String getEncoding() {
        return this.fEncoding;
    }

    private static void handleUnsupportedEncodingException(String string) {
        System.err.println(MessageFormat.format(SyntaxTextPaneUtilities.intlString("error.UnsupportedEncoding"), "'" + string + "'"));
    }

    public static JComponent getDisplayComponent(SyntaxTextPaneBase syntaxTextPaneBase) {
        return syntaxTextPaneBase.getUI() instanceof BaseTextUI ? Utilities.getEditorUI((JTextComponent)syntaxTextPaneBase).getExtComponent() : new JScrollPane(syntaxTextPaneBase);
    }

    public void setSpacesPerIndent(int n, boolean bl) {
        this.setValue(bl, "indent-shift-width", (Object)n);
    }

    public void setSpacesPerTab(int n, boolean bl) {
        this.setValue(bl, "tab-size", (Object)n);
        this.setValue(bl, "spaces-per-tab", (Object)n);
    }

    public void setTabUsingSpaces(boolean bl, boolean bl2) {
        this.setValue(bl2, "expand-tabs", (Object)bl);
    }

    @Override
    public char getCharAt(int n) throws BadLocationException {
        BaseDocument baseDocument = (BaseDocument)this.getDocument();
        return baseDocument.getChars(n, 1)[0];
    }

    @Override
    public char[] getChars(int n, int n2) throws BadLocationException {
        BaseDocument baseDocument = (BaseDocument)this.getDocument();
        return baseDocument.getChars(n, n2);
    }

    @Override
    public void delete(int n, int n2) throws BadLocationException {
        this.getDocument().remove(n, n2 - n);
    }

    @Override
    public void startBlockEdit() {
        BaseDocument baseDocument = (BaseDocument)this.getDocument();
        baseDocument.atomicLock();
    }

    @Override
    public void endBlockEdit() {
        BaseDocument baseDocument = (BaseDocument)this.getDocument();
        baseDocument.atomicUnlock();
    }

    @Override
    public int getTotalWidthInChars(int n, int n2) throws BadLocationException {
        if (this.getLineFromPos(n) != this.getLineFromPos(n2)) {
            throw new IllegalArgumentException("Arguments to getTotalWidthInChars must be on the same line.");
        }
        return this.getColFromPos(n2) - this.getColFromPos(n);
    }

    @Override
    public int getLineEnd(int n) throws BadLocationException {
        if (n < this.getNumLines() - 1) {
            return this.getLineStart(n + 1);
        }
        return this.getLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLineEndNoEOL(int n) throws BadLocationException {
        BaseDocument baseDocument = (BaseDocument)this.getDocument();
        baseDocument.readLock();
        try {
            int n2 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)this.getLineStart(n));
            return n2;
        }
        finally {
            baseDocument.readUnlock();
        }
    }

    @Override
    public int getLineLength(int n) throws BadLocationException {
        return this.getLineEnd(n) - this.getLineStart(n);
    }

    @Override
    public int getLineLengthNoEOL(int n) throws BadLocationException {
        return this.getLineEndNoEOL(n) - this.getLineStart(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLineStart(int n) throws BadLocationException {
        int n2;
        BaseDocument baseDocument = (BaseDocument)this.getDocument();
        baseDocument.readLock();
        try {
            n2 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)n);
        }
        finally {
            baseDocument.readUnlock();
        }
        if (n2 == -1) {
            throw new BadLocationException("Invalid line number", n);
        }
        return n2;
    }

    @Override
    public int getFirstNonWhitespace(int n) throws BadLocationException {
        return Utilities.getFirstNonWhiteFwd((BaseDocument)((BaseDocument)this.getDocument()), (int)this.getLineStart(n), (int)this.getLineEnd(n));
    }

    @Override
    public String getLineText(int n) throws BadLocationException {
        return this.getDocument().getText(this.getLineStart(n), this.getLineLength(n));
    }

    @Override
    public String getLineTextNoEOL(int n) throws BadLocationException {
        return this.getDocument().getText(this.getLineStart(n), this.getLineLengthNoEOL(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumLines() {
        BaseDocument baseDocument = (BaseDocument)this.getDocument();
        baseDocument.readLock();
        try {
            int n = Utilities.getRowCount((BaseDocument)baseDocument);
            return n;
        }
        finally {
            baseDocument.readUnlock();
        }
    }

    @Override
    public String getTextStartEnd(int n, int n2) throws BadLocationException {
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        return this.getDocument().getText(n3, n4 - n3);
    }

    @Override
    public int[] getTokenLocations(int n, int n2, TokenID[] tokenIDArray) throws BadLocationException {
        return ((BaseDocument)this.getDocument()).getSyntaxSupport().getTokenBlocks(n, n2, tokenIDArray);
    }

    @Override
    public void insert(int n, String string) throws BadLocationException {
        this.getDocument().insertString(n, string, null);
    }

    @Override
    public void insert(int n, char c) throws BadLocationException {
        this.insert(n, String.valueOf(c));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replace(int n, int n2, String string) throws BadLocationException {
        this.startBlockEdit();
        try {
            this.delete(n, n2);
            this.insert(n, string);
        }
        finally {
            this.endBlockEdit();
        }
    }

    @Override
    public int getLength() {
        return this.getDocument().getLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLineFromPos(int n) throws BadLocationException {
        BaseDocument baseDocument = (BaseDocument)this.getDocument();
        baseDocument.readLock();
        try {
            int n2 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n);
            return n2;
        }
        finally {
            baseDocument.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getColFromPos(int n) throws BadLocationException {
        BaseDocument baseDocument = (BaseDocument)this.getDocument();
        baseDocument.readLock();
        try {
            int n2 = Utilities.getVisualColumn((BaseDocument)baseDocument, (int)n);
            return n2;
        }
        finally {
            baseDocument.readUnlock();
        }
    }

    @Override
    public int getLineFromY(int n) throws BadLocationException {
        int n2 = ((BaseTextUI)this.getUI()).getPosFromY(n);
        return this.getLineFromPos(n2);
    }

    @Override
    public int getPosFromPoint(Point point) throws BadLocationException {
        return this.getUI().viewToModel(this, point);
    }

    @Override
    public Point getPointFromPos(int n) throws BadLocationException {
        return this.getUI().modelToView(this, n).getLocation();
    }

    @Override
    public int getWordStartFromPos(int n) throws BadLocationException {
        return Utilities.getWordStart((JTextComponent)this, (int)n);
    }

    @Override
    public int getWordEndFromPos(int n) throws BadLocationException {
        return Utilities.getWordEnd((JTextComponent)this, (int)n);
    }

    @Override
    public int getLineHeight() {
        return Utilities.getEditorUI((JTextComponent)this).getLineHeight();
    }

    @Override
    public int getLineAscent() {
        return Utilities.getEditorUI((JTextComponent)this).getLineAscent();
    }

    @Override
    public int getSelectionMark() {
        return this.getCaret().getMark();
    }

    @Override
    public int getSelectionDot() {
        return this.getCaret().getDot();
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.getSelectionMark() == this.getSelectionDot();
    }

    public void setLeftPanel(JPanel jPanel) {
        ((MWEditorUI)Utilities.getEditorUI((JTextComponent)this)).setLeftPanel(jPanel);
    }

    @Override
    public Color getLineNumberBackgroundColor() {
        Coloring coloring = (Coloring)Utilities.getEditorUI((JTextComponent)this).getColoringMap().get("line-number");
        Coloring coloring2 = Utilities.getEditorUI((JTextComponent)this).getDefaultColoring();
        if (coloring.getBackColor() != null) {
            return coloring.getBackColor();
        }
        return coloring2.getBackColor();
    }

    @Override
    public Color getLineNumberForeColor() {
        Coloring coloring = (Coloring)Utilities.getEditorUI((JTextComponent)this).getColoringMap().get("line-number");
        Coloring coloring2 = Utilities.getEditorUI((JTextComponent)this).getDefaultColoring();
        if (coloring.getForeColor() != null) {
            return coloring.getForeColor();
        }
        return coloring2.getForeColor();
    }

    public int getTerminatorLength(int n) throws BadLocationException {
        return this.getLineLength(n) - this.getLineLengthNoEOL(n);
    }

    @Override
    public String getTerminator() {
        return "\n";
    }

    public void cleanup() {
        Document document;
        if (this.fContextMenu != null) {
            this.fContextMenu.dispose();
            this.fContextMenu.removeAll();
        }
        this.fContextMenu = null;
        this.getActionMap().clear();
        EditorUI editorUI = Utilities.getEditorUI((JTextComponent)this);
        if (editorUI != null && editorUI instanceof MWEditorUI) {
            ((MWEditorUI)editorUI).cleanup();
        }
        if ((document = this.getDocument()) != null && this.inputMethodRequestsHandler != null) {
            document.removeDocumentListener((DocumentListener)((Object)this.inputMethodRequestsHandler));
        }
        JumpList.removeEntries((JTextComponent)this);
        this.cleanUpViewHierarchyModificationComponents();
        SyntaxTextPaneBase.clearParentAction(this.fCollapseAllFoldsAction);
        SyntaxTextPaneBase.clearParentAction(this.fCollapseFoldAction);
        SyntaxTextPaneBase.clearParentAction(this.fExpandFoldAction);
        SyntaxTextPaneBase.clearParentAction(this.fExpandAllFoldsAction);
    }

    private static void clearParentAction(MJAbstractAction mJAbstractAction) {
        if (mJAbstractAction != null && mJAbstractAction instanceof ChildAction) {
            ((ChildAction)mJAbstractAction).setParent(null);
        }
    }

    @Override
    public void endIncSearch() {
        this.fIsIncSearch = false;
        this.removeKeyListener(this.fIncSearch);
        this.removeFocusListener(this.fIncSearch);
        this.removeMouseListener(this.fIncSearch);
    }

    @Override
    public void startIncSearch(boolean bl) {
        if (this.fIncSearchObserver != null) {
            this.fIsIncSearch = true;
            if (this.fIncSearch == null) {
                this.fIncSearchImpl = new STPIncSearch(this);
                this.fIncSearch = new IncSearch(this.fIncSearchImpl, true);
            }
            this.fIncSearchImpl.startingIncSearch();
            this.fIncSearch.initIncSearch(bl);
            this.addKeyListener(this.fIncSearch);
            this.addFocusListener(this.fIncSearch);
            this.addMouseListener(this.fIncSearch);
        }
    }

    @Override
    public void addIncSearchObserver(Observer observer) {
        this.fIncSearchObserver = observer;
        if (this.fIncSearch == null) {
            this.fIncSearchImpl = new STPIncSearch(this);
            this.fIncSearch = new IncSearch(this.fIncSearchImpl, true);
        }
        this.fIncSearch.addObserver(this.fIncSearchObserver);
    }

    @Override
    public void removeIncSearchObserver(Observer observer) {
        if (this.fIncSearch != null && this.fIncSearchObserver == observer) {
            this.fIncSearch.removeObserver(observer);
            if (this.fIsIncSearch) {
                this.fIncSearch.searchDone(false);
            }
            this.fIncSearchObserver = null;
            this.fIncSearch = null;
        }
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        EventListener[] eventListenerArray;
        for (EventListener eventListener : eventListenerArray = this.getListeners(KeyListener.class)) {
            if (!(eventListener instanceof IncSearch) || (keyEvent.getID() != 401 || keyEvent.isAltGraphDown()) && (keyEvent.getID() != 400 || !keyEvent.isAltGraphDown())) continue;
            ((KeyListener)eventListener).keyPressed(keyEvent);
        }
        if (!this.fIsIncSearch) {
            super.processKeyEvent(keyEvent);
            for (EventListener eventListener : eventListenerArray) {
                if (!(eventListener instanceof PostKeyListener)) continue;
                if (keyEvent.getID() == 400) {
                    ((PostKeyListener)eventListener).postKeyTyped(keyEvent);
                    continue;
                }
                if (keyEvent.getID() != 401) continue;
                ((PostKeyListener)eventListener).postKeyPressed(keyEvent);
            }
        }
    }

    @Override
    public int getMinLineFromDocEvent(DocumentEvent documentEvent) {
        return ((BaseDocumentEvent)documentEvent).getLine();
    }

    @Override
    public int getMaxLineFromDocEvent(DocumentEvent documentEvent) {
        return this.getMinLineFromDocEvent(documentEvent) + ((BaseDocumentEvent)documentEvent).getLFCount();
    }

    public void setShowLineNumbers(boolean bl, boolean bl2) {
        this.setValue(bl2, "line-number-visible", (Object)bl);
        AnnotationTypes.getTypes().setShowGlyphGutter(Boolean.valueOf(bl));
    }

    public void setShowRightMargin(boolean bl, boolean bl2) {
        this.setValue(bl2, "text-limit-line-visible", (Object)bl);
    }

    public void setRightMarginColor(Color color, boolean bl) {
        this.setValue(bl, "text-limit-line-color", (Object)color);
    }

    public void setRightMarginWidth(int n, boolean bl) {
        this.setValue(bl, "text-limit-width", (Object)n);
    }

    public void setHighlightCaretRow(boolean bl, boolean bl2) {
        this.setValue(bl2, "highlight-caret-row", (Object)bl);
    }

    @Override
    public boolean isInsertMode() {
        Boolean bl = (Boolean)Utilities.getEditorUI((JTextComponent)this).getProperty((Object)"overwriteMode");
        return bl == null || bl == false;
    }

    @Override
    public void addOverwriteListener(PropertyChangeListener propertyChangeListener) {
        Utilities.getEditorUI((JTextComponent)this).addPropertyChangeListener("overwriteMode", propertyChangeListener);
    }

    @Override
    public void removeOverwriteListener(PropertyChangeListener propertyChangeListener) {
        Utilities.getEditorUI((JTextComponent)this).removePropertyChangeListener("overwriteMode", propertyChangeListener);
    }

    @Override
    public void setClientStatusBar(MJStatusBar mJStatusBar) {
        StatusBar statusBar = Utilities.getEditorUI((JTextComponent)this).getStatusBar();
        ((MWStatusBar)statusBar).setClientStatusBar(mJStatusBar);
    }

    @Override
    public void setCursorPercentFromTop(int n) {
        Utilities.getEditorUI((JTextComponent)this).adjustWindow(n);
    }

    public int getCursorPercentFromTop() {
        try {
            Rectangle rectangle = Utilities.getEditorUI((JTextComponent)this).getExtentBounds();
            return 100 * (int)(this.getPointFromPos(this.getSelectionDot()).getY() - (double)rectangle.y) / rectangle.height;
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    @Override
    public void selectAndCenterIfNotVisible(int n, int n2) {
        if (this.getCaret() instanceof BaseCaret) {
            Object object;
            final int n3 = n;
            final int n4 = n2;
            boolean bl = true;
            try {
                Rectangle rectangle = this.modelToView(n4);
                if (rectangle != null && (object = this.getExtentBounds()) != null && ((Rectangle)object).contains(rectangle)) {
                    bl = false;
                }
            }
            catch (BadLocationException badLocationException) {
                Log.logException((Exception)badLocationException);
            }
            this.getCaret().setDot(n3);
            this.getCaret().moveDot(n4);
            final boolean bl2 = bl;
            object = new Runnable(){

                @Override
                public void run() {
                    JTextComponent jTextComponent = SyntaxTextPaneBase.this.getActiveTextComponent();
                    if (jTextComponent != null) {
                        Rectangle rectangle;
                        Caret caret = SyntaxTextPaneBase.this.getCaret();
                        if (caret != null && caret instanceof BaseCaret && caret.getDot() != n3) {
                            caret.setDot(n3);
                            caret.moveDot(n4);
                        }
                        if ((rectangle = jTextComponent.getBounds()) != null && rectangle.width > 0 && rectangle.height > 0 && bl2) {
                            Utilities.getEditorUI((JTextComponent)jTextComponent).adjustWindow(50);
                        }
                    }
                }
            };
            SwingUtilities.invokeLater((Runnable)object);
        } else {
            this.getCaret().setDot(n);
            this.getCaret().moveDot(n2);
        }
        JumpList.checkAddEntry((JTextComponent)this);
    }

    @Override
    public void select(int n, int n2) {
        super.select(n, n2);
        JumpList.checkAddEntry((JTextComponent)this);
    }

    public void blockScroll(boolean bl, final int n) {
        if (!bl) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (SyntaxTextPaneBase.this.getCursorPercentFromTop() <= n) {
                        SyntaxTextPaneBase.this.setCursorPercentFromTop(100 - n);
                    }
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (SyntaxTextPaneBase.this.getCursorPercentFromTop() >= 100 - n) {
                        SyntaxTextPaneBase.this.setCursorPercentFromTop(n);
                    }
                }
            });
        }
    }

    @Override
    public Rectangle getExtentBounds() {
        return Utilities.getEditorUI((JTextComponent)this).getExtentBounds();
    }

    @Override
    public Rectangle getExtentBounds(Rectangle rectangle) {
        return Utilities.getEditorUI((JTextComponent)this).getExtentBounds(rectangle);
    }

    public void enableDelimiterMatchForTyping(boolean bl, boolean bl2) {
        this.setValue(bl2, "mw-highlight-match-brace", (Object)bl);
    }

    public void enableDelimiterMatchForArrows(boolean bl, boolean bl2) {
        this.setValue(bl2, "mw-highlight-match-brace-on-arrow", (Object)bl);
    }

    public void setDelimiterMatchOptionsForTyping(int n, int n2, boolean bl) {
        if (n != 3 && n != 1 && n != 2) {
            throw new IllegalArgumentException("Unsupported matchType argument specified to setDelimiterMatchingTypingOptions.");
        }
        if (n2 != 4 && n2 != 5 && n2 != 6) {
            throw new IllegalArgumentException("Unsupported mismatchType argument specified to setDelimiterMatchingTypingOptions.");
        }
        this.setValue(bl, "mw-bracematch-key", (Object)n);
        this.setValue(bl, "mw-bracemismatch-key", (Object)n2);
    }

    public void setDelimiterMatchOptionsForArrows(int n, int n2, boolean bl) {
        if (n != 2 && n != 1) {
            throw new IllegalArgumentException("Unsupported matchType argument specified to setDelimiterMatchingArrowsOptions.");
        }
        if (n2 != 4 && n2 != 5 && n2 != 6) {
            throw new IllegalArgumentException("Unsupported mismatchType argument specified to setDelimiterMatchingArrowsOptions.");
        }
        this.setValue(bl, "mw-bracematch-arrow", (Object)n);
        this.setValue(bl, "mw-bracemismatch-arrow", (Object)n2);
    }

    public void setEmacsStyleTabEnabled(boolean bl, boolean bl2) {
        this.setValue(bl2, "emacs-smart-tab", (Object)bl);
    }

    @Override
    public final void setFont(Font font) {
        super.setFont(font);
    }

    public void setFont(Font font, boolean bl) {
        Coloring coloring = SettingsUtil.getColoring(this.getEditorKit().getClass(), (String)"default", (boolean)false);
        if (coloring == null) {
            coloring = EditorPrefsAccessor.getTextColoring();
        }
        Coloring coloring2 = Coloring.changeFont((Coloring)coloring, (Font)font);
        this.setColoring(bl, "default", coloring2);
    }

    public void setSyntaxColor(EditorSyntaxHighlighting editorSyntaxHighlighting, SyntaxHighlightingColor syntaxHighlightingColor, Color color) {
        if (!this.fKitStore.registeredKit(this.getEditorKit().getClass())) {
            throw new IllegalArgumentException("Unregistered EditorKit: " + this.getEditorKit().getClass() + "; must call registerEditorKit() to modify settings");
        }
        STPPrefsManager.getInstance().setSyntaxColor(syntaxHighlightingColor, color, this.getEditorKit().getClass(), true, editorSyntaxHighlighting.getTokenContext());
    }

    public void setJavaMethodType(MethodStyle methodStyle) {
        if (methodStyle == null) {
            throw new IllegalArgumentException("'style' cannot be null");
        }
        if (!this.fKitStore.registeredKit(this.getEditorKit().getClass())) {
            throw new IllegalArgumentException("Invalid EditorKit");
        }
        STPPrefsManager.getInstance().setJavaMethodType(methodStyle, this.getEditorKit().getClass());
    }

    public Coloring getJavaMethodStyle() {
        return STPPrefsManager.getInstance().getJavaMethodStyle(this.getEditorKit().getClass());
    }

    @Override
    public final void setBackground(Color color) {
        super.setBackground(color);
    }

    @Override
    public final void setForeground(Color color) {
        super.setForeground(color);
    }

    public void setTextColor(Color color, boolean bl) {
        Coloring coloring = SettingsUtil.getColoring(this.getEditorKit().getClass(), (String)"default", (boolean)false);
        coloring = Coloring.changeForeColor((Coloring)coloring, (Color)color);
        this.setColoring(bl, "default", coloring);
        this.setValue(bl, "caret-color-overwrite-mode", (Object)coloring.getForeColor());
        this.setValue(bl, "caret-color-insert-mode", (Object)coloring.getForeColor());
    }

    public void setBackgroundColor(Color color, boolean bl) {
        Coloring coloring = SettingsUtil.getColoring(this.getEditorKit().getClass(), (String)"default", (boolean)false);
        coloring = Coloring.changeBackColor((Coloring)coloring, (Color)color);
        this.setColoring(bl, "default", coloring);
    }

    public void setSyntaxHighlightingEnabled(EditorLanguage editorLanguage, boolean bl) {
        if (!this.fKitStore.registeredKit(this.getEditorKit().getClass())) {
            throw new IllegalArgumentException("Invalid EditorKit");
        }
        STPPrefsManager.getInstance().setSyntaxHighlightingEnabled(editorLanguage, this.getEditorKit().getClass(), bl);
    }

    public void setContextMenuEnabled(boolean bl, boolean bl2) {
        this.setValue(bl2, "popup-menu-enabled", (Object)bl);
    }

    private TextPrintable getTextPrintable(int n, int n2, MJFrame mJFrame, DocPrintJob docPrintJob) {
        SettingsAdapter.setValue((Object)this, MWKit.class, (String)"print-line-number-visible", (Object)EditorPrefsAccessor.isPrintLineNumbers());
        try {
            if (n != 0) {
                n = this.getLineStart(this.getLineFromPos(n));
            }
            if (n2 != this.getLength()) {
                n2 = this.getLineEndNoEOL(this.getLineFromPos(n2));
            }
        }
        catch (BadLocationException badLocationException) {
            n = 0;
            n2 = this.getLength();
        }
        int n3 = n;
        int n4 = n2;
        if (docPrintJob == null) {
            return new TextPrintable(this.getDocument(), n3, n4, (Frame)mJFrame);
        }
        return new TextPrintable(this.getDocument(), n3, n4, (Frame)mJFrame, docPrintJob);
    }

    @Override
    public void printDocument(String string, int n, int n2) {
        this.getDocument().putProperty("title", string);
        PrintSettings printSettings = PrintSettings.getInstance();
        printSettings.setPrintOptions(EditorPrefsAccessor.getPrintOptions());
        printSettings.setWrap(EditorPrefsAccessor.isPrintWrapLines());
        printSettings.setHeaderFont(EditorPrefsAccessor.getPrintingHeaderFont());
        DocFlavor.SERVICE_FORMATTED sERVICE_FORMATTED = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
        HashDocAttributeSet hashDocAttributeSet = new HashDocAttributeSet();
        final PrintRequestAttributeSet printRequestAttributeSet = printSettings.getLastPrintRequestAttributes(FileUtils.truncatePathname((String)((String)this.getDocument().getProperty("title")), (int)25));
        Chromaticity chromaticity = TextPrintPanel.addChromaticityToPrintAttributeSet(EditorPrefsAccessor.getPrintOptions(), printRequestAttributeSet);
        final DocPrintJob docPrintJob = printSettings.showPrintDialog(sERVICE_FORMATTED, MJFrame.getFrame((Component)this), printRequestAttributeSet);
        Chromaticity chromaticity2 = (Chromaticity)printRequestAttributeSet.get(Chromaticity.class);
        TextPrintPanel.updateColorPrintOptionPrefIfNeccessary("EditorPrintOptions", chromaticity, chromaticity2, EditorPrefsAccessor.getPrintOptions());
        if (docPrintJob != null) {
            final SimpleDoc simpleDoc = new SimpleDoc(this.getTextPrintable(n, n2, MJFrame.getFrame((Component)this), docPrintJob), sERVICE_FORMATTED, hashDocAttributeSet);
            this.setEditable(false);
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        docPrintJob.print(simpleDoc, printRequestAttributeSet);
                    }
                    catch (PrintException printException) {
                        block4: {
                            try {
                                if (printException.getCause() instanceof PrinterAbortException) break block4;
                                MJOptionPane.showMessageDialog((Component)MJFrame.getFrame((Component)SyntaxTextPaneBase.this), (Object)(SyntaxTextPaneUtilities.intlString("errorPrinting") + "\n\n" + printException.getLocalizedMessage()), (String)SyntaxTextPaneUtilities.intlString("errorPrintingTitle"), (int)0);
                            }
                            catch (Throwable throwable) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        SyntaxTextPaneBase.this.setEditable(true);
                                    }
                                });
                                throw throwable;
                            }
                        }
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            }).start();
        }
    }

    private static int getCurrentEventModifiers() {
        int n = 0;
        AWTEvent aWTEvent = EventQueue.getCurrentEvent();
        if (aWTEvent instanceof InputEvent) {
            n = ((InputEvent)aWTEvent).getModifiers();
        } else if (aWTEvent instanceof ActionEvent) {
            n = ((ActionEvent)aWTEvent).getModifiers();
        }
        return n;
    }

    @Override
    protected void processInputMethodEvent(InputMethodEvent inputMethodEvent) {
        if (!inputMethodEvent.isConsumed()) {
            if (!this.isEditable()) {
                return;
            }
            switch (inputMethodEvent.getID()) {
                case 1100: {
                    this.replaceInputMethodText(inputMethodEvent);
                }
                case 1101: {
                    this.setInputMethodCaretPosition(inputMethodEvent);
                }
            }
            inputMethodEvent.consume();
        }
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        if (this.inputMethodRequestsHandler == null) {
            this.inputMethodRequestsHandler = new InputMethodRequestsHandler();
            Document document = this.getDocument();
            if (document != null) {
                document.addDocumentListener((DocumentListener)((Object)this.inputMethodRequestsHandler));
            }
        }
        return this.inputMethodRequestsHandler;
    }

    @Override
    public void addInputMethodListener(InputMethodListener inputMethodListener) {
        super.addInputMethodListener(inputMethodListener);
        if (inputMethodListener != null) {
            this.needToSendKeyTypedEvent = false;
            this.checkedInputOverride = true;
        }
    }

    private void replaceInputMethodText(InputMethodEvent inputMethodEvent) {
        int n;
        int n2 = inputMethodEvent.getCommittedCharacterCount();
        AttributedCharacterIterator attributedCharacterIterator = inputMethodEvent.getText();
        Document document = this.getDocument();
        if (this.composedTextExists()) {
            try {
                n = this.composedTextStart.getOffset();
                document.remove(n, this.composedTextContent.length());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            this.composedTextStart = null;
            this.composedText = null;
            this.composedTextContent = null;
        }
        if (attributedCharacterIterator != null) {
            int n3;
            attributedCharacterIterator.first();
            n = 0;
            int n4 = 0;
            if (n2 > 0) {
                n = this.getCaret().getDot();
                if (this.shouldSynthensizeKeyEvents()) {
                    char c = attributedCharacterIterator.current();
                    while (n2 > 0) {
                        KeyEvent keyEvent = new KeyEvent(this, 400, EventQueue.getMostRecentEventTime(), 0, 0, c);
                        this.processKeyEvent(keyEvent);
                        c = attributedCharacterIterator.next();
                        --n2;
                    }
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    char c = attributedCharacterIterator.current();
                    while (n2 > 0) {
                        stringBuffer.append(c);
                        c = attributedCharacterIterator.next();
                        --n2;
                    }
                    this.mapCommittedTextToAction(new String(stringBuffer));
                }
                n4 = this.getCaret().getDot();
            }
            if ((n3 = attributedCharacterIterator.getIndex()) < attributedCharacterIterator.getEndIndex()) {
                this.createComposedString(n3, attributedCharacterIterator);
                SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                simpleAttributeSet.addAttribute(StyleConstants.ComposedTextAttribute, this.composedText);
                try {
                    if (!((BaseDocument)this.getDocument()).isAtomicLock()) {
                        this.startBlockEdit();
                    }
                    this.replaceSelection(null);
                    document.insertString(this.getCaret().getDot(), this.composedTextContent, simpleAttributeSet);
                    this.composedTextStart = document.createPosition(this.getCaret().getDot() - this.composedTextContent.length());
                }
                catch (BadLocationException badLocationException) {
                    this.composedTextStart = null;
                    this.composedText = null;
                    this.composedTextContent = null;
                }
            }
            if (n != n4) {
                try {
                    this.latestCommittedTextStart = document.createPosition(n);
                    this.latestCommittedTextLength = n4 - n;
                }
                catch (BadLocationException badLocationException) {
                    this.latestCommittedTextStart = null;
                    this.latestCommittedTextLength = 0;
                }
            } else {
                this.latestCommittedTextStart = null;
                this.latestCommittedTextLength = 0;
            }
        }
    }

    private void createComposedString(int n, AttributedCharacterIterator attributedCharacterIterator) {
        StringBuffer stringBuffer = new StringBuffer();
        char c = attributedCharacterIterator.setIndex(n);
        while (c != '\uffff') {
            stringBuffer.append(c);
            c = attributedCharacterIterator.next();
        }
        this.composedTextContent = new String(stringBuffer);
        this.composedText = new AttributedString(attributedCharacterIterator, n, attributedCharacterIterator.getEndIndex());
    }

    private void mapCommittedTextToAction(String string) {
        Keymap keymap = this.getKeymap();
        if (keymap != null) {
            Serializable serializable;
            Action action = null;
            if (string.length() == 1) {
                serializable = KeyStroke.getKeyStroke(string.charAt(0));
                action = keymap.getAction((KeyStroke)serializable);
            }
            if (action == null) {
                action = keymap.getDefaultAction();
            }
            if (action != null) {
                serializable = new ActionEvent(this, 1001, string, EventQueue.getMostRecentEventTime(), SyntaxTextPaneBase.getCurrentEventModifiers());
                action.actionPerformed((ActionEvent)serializable);
            }
        }
    }

    private void setInputMethodCaretPosition(InputMethodEvent inputMethodEvent) {
        MWDrawLayerFactory.InputModeLayer inputModeLayer = this.getInputModeLayer();
        if (this.composedTextExists()) {
            InputMethodHighlight inputMethodHighlight;
            TextHitInfo textHitInfo;
            int n = this.composedTextStart.getOffset();
            if (!(this.getCaret() instanceof ComposedTextCaret)) {
                if (this.composedTextCaret == null) {
                    this.composedTextCaret = new ComposedTextCaret();
                }
                this.originalCaret = this.getCaret();
                this.exchangeCaret(this.originalCaret, (Caret)((Object)this.composedTextCaret));
            }
            if ((textHitInfo = inputMethodEvent.getCaret()) != null) {
                int n2 = textHitInfo.getInsertionIndex();
                n += n2;
                if (n2 == 0) {
                    try {
                        Rectangle rectangle = this.modelToView(n);
                        Rectangle rectangle2 = this.modelToView(this.composedTextStart.getOffset() + this.composedTextContent.length());
                        Rectangle rectangle3 = this.getBounds();
                        rectangle.x += Math.min(rectangle2.x - rectangle.x, rectangle3.width);
                        this.scrollRectToVisible(rectangle);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                inputMethodEvent.getText().setIndex(textHitInfo.getInsertionIndex());
            }
            if ((inputMethodHighlight = (InputMethodHighlight)inputMethodEvent.getText().getAttribute(TextAttribute.INPUT_METHOD_HIGHLIGHT)) != null && inputMethodHighlight.isSelected()) {
                int n3 = inputMethodEvent.getText().getRunLimit(TextAttribute.INPUT_METHOD_HIGHLIGHT) + this.composedTextStart.getOffset();
                if (n3 > n && n3 <= this.composedTextStart.getOffset() + this.composedTextContent.length()) {
                    this.getCaret().setDot(n3);
                    this.getCaret().moveDot(n);
                } else {
                    this.getCaret().setDot(n);
                }
            } else {
                this.getCaret().setDot(n);
            }
            inputModeLayer.setArea(this.composedTextStart.getOffset(), this.composedTextContent.length());
            if (!inputModeLayer.isEnabled()) {
                inputModeLayer.setEnabled(true);
            }
            try {
                Utilities.getEditorUI((JTextComponent)this).repaintOffset(inputModeLayer.getOffset());
            }
            catch (BadLocationException badLocationException) {}
        } else if (this.getCaret() instanceof ComposedTextCaret) {
            int n = this.getCaret().getDot();
            this.exchangeCaret(this.getCaret(), this.originalCaret);
            inputModeLayer.setEnabled(false);
            this.getCaret().setDot(n);
            this.endBlockEdit();
            try {
                Utilities.getEditorUI((JTextComponent)this).repaintOffset(inputModeLayer.getOffset());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    private void exchangeCaret(Caret caret, Caret caret2) {
        int n = caret.getBlinkRate();
        this.setCaret(caret2);
        this.getCaret().setBlinkRate(n);
        this.getCaret().setVisible(this.hasFocus());
    }

    private boolean shouldSynthensizeKeyEvents() {
        if (!this.checkedInputOverride) {
            this.checkedInputOverride = true;
            this.needToSendKeyTypedEvent = true;
        }
        return this.needToSendKeyTypedEvent;
    }

    boolean composedTextExists() {
        return this.composedTextStart != null;
    }

    @Override
    public boolean isComposing() {
        return this.getCaret() instanceof ComposedTextCaret;
    }

    @Override
    public JTextComponent getActiveTextComponent() {
        return this;
    }

    private Position getComposedTextStart() {
        return this.composedTextStart;
    }

    private MWDrawLayerFactory.InputModeLayer getInputModeLayer() {
        return (MWDrawLayerFactory.InputModeLayer)Utilities.getEditorUI((JTextComponent)this).findLayer("input-mode-layer");
    }

    @Override
    public Component getComponentForDialog() {
        return this;
    }

    @Override
    public int getLineEndFromPos(int n) throws BadLocationException {
        return Utilities.getRowEnd((BaseDocument)((BaseDocument)this.getDocument()), (int)n);
    }

    @Override
    public EditorUI getEditorUI() {
        return Utilities.getEditorUI((JTextComponent)this);
    }

    @Override
    public void setSelFocusOverride(boolean bl) {
        ((MWCaret)((Object)this.getCaret())).setSelFocusOverride(bl);
    }

    private class ViewHierarchyChangeListenerImpl
    implements ViewHierarchyChangeListener {
        private STPBaseInterface iBaseSyntaxPane;

        private ViewHierarchyChangeListenerImpl(STPBaseInterface sTPBaseInterface) {
            this.iBaseSyntaxPane = sTPBaseInterface;
        }

        @Override
        public void viewHierarchyChanged(ViewHierarchyChangeEvent viewHierarchyChangeEvent) {
            if (SyntaxTextPaneBase.this.fRegViewHierarchyChangeListeners != null && !SyntaxTextPaneBase.this.fRegViewHierarchyChangeListeners.isEmpty()) {
                for (ViewHierarchyChangeListener viewHierarchyChangeListener : SyntaxTextPaneBase.this.fRegViewHierarchyChangeListeners) {
                    viewHierarchyChangeListener.viewHierarchyChanged(new ViewHierarchyChangeEvent(this.iBaseSyntaxPane, viewHierarchyChangeEvent.getChangeHint(), viewHierarchyChangeEvent.getExtSource()));
                }
            }
        }
    }

    private class DoSetCaretPosition
    implements Runnable {
        JTextComponent host;
        Position newPos;

        DoSetCaretPosition(JTextComponent jTextComponent, Position position) {
            this.host = jTextComponent;
            this.newPos = position;
        }

        @Override
        public void run() {
            this.host.setCaretPosition(this.newPos.getOffset());
        }
    }

    private class ComposedTextCaret
    extends MWCaret {
        private ComposedTextCaret() {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.positionCaret(mouseEvent)) {
                super.mouseReleased(mouseEvent);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (this.positionCaret(mouseEvent)) {
                super.mousePressed(mouseEvent);
            }
        }

        protected boolean positionCaret(MouseEvent mouseEvent) {
            int n;
            SyntaxTextPaneBase syntaxTextPaneBase = (SyntaxTextPaneBase)this.component;
            Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
            int n2 = syntaxTextPaneBase.viewToModel(point);
            if (n2 < (n = syntaxTextPaneBase.getComposedTextStart().getOffset()) || n2 > n + SyntaxTextPaneBase.this.composedTextContent.length()) {
                try {
                    Position position = syntaxTextPaneBase.getDocument().createPosition(n2);
                    syntaxTextPaneBase.getInputContext().endComposition();
                    EventQueue.invokeLater(new DoSetCaretPosition(syntaxTextPaneBase, position));
                    mouseEvent.consume();
                    return false;
                }
                catch (BadLocationException badLocationException) {
                    System.out.println(badLocationException);
                }
            }
            return true;
        }
    }

    private class InputMethodRequestsHandler
    implements InputMethodRequests,
    DocumentListener {
        private InputMethodRequestsHandler() {
        }

        @Override
        public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributeArray) {
            Document document = SyntaxTextPaneBase.this.getDocument();
            if (document != null && SyntaxTextPaneBase.this.latestCommittedTextStart != null && SyntaxTextPaneBase.this.latestCommittedTextLength != 0) {
                try {
                    int n = SyntaxTextPaneBase.this.latestCommittedTextStart.getOffset();
                    String string = document.getText(n, SyntaxTextPaneBase.this.latestCommittedTextLength);
                    document.remove(n, SyntaxTextPaneBase.this.latestCommittedTextLength);
                    return new AttributedString(string).getIterator();
                }
                catch (BadLocationException badLocationException) {
                    Log.logException((Exception)badLocationException);
                }
            }
            return null;
        }

        @Override
        public AttributedCharacterIterator getCommittedText(int n, int n2, AttributedCharacterIterator.Attribute[] attributeArray) {
            String string;
            int n3 = 0;
            int n4 = 0;
            if (SyntaxTextPaneBase.this.composedTextExists()) {
                n3 = SyntaxTextPaneBase.this.composedTextStart.getOffset();
                n4 = n3 + SyntaxTextPaneBase.this.composedTextContent.length();
            }
            try {
                if (n < n3) {
                    if (n2 <= n3) {
                        string = SyntaxTextPaneBase.this.getText(n, n2 - n);
                    } else {
                        int n5 = n3 - n;
                        string = SyntaxTextPaneBase.this.getText(n, n5) + SyntaxTextPaneBase.this.getText(n4, n2 - n - n5);
                    }
                } else {
                    string = SyntaxTextPaneBase.this.getText(n + (n4 - n3), n2 - n);
                }
            }
            catch (BadLocationException badLocationException) {
                throw new IllegalArgumentException("Invalid range");
            }
            return new AttributedString(string).getIterator();
        }

        @Override
        public int getCommittedTextLength() {
            Document document = SyntaxTextPaneBase.this.getDocument();
            int n = 0;
            if (document != null) {
                n = document.getLength();
                if (SyntaxTextPaneBase.this.composedTextContent != null) {
                    n -= SyntaxTextPaneBase.this.composedTextContent.length();
                }
            }
            return n;
        }

        @Override
        public int getInsertPositionOffset() {
            int n;
            int n2 = 0;
            int n3 = 0;
            if (SyntaxTextPaneBase.this.composedTextExists()) {
                n2 = SyntaxTextPaneBase.this.composedTextStart.getOffset();
                n3 = n2 + SyntaxTextPaneBase.this.composedTextContent.length();
            }
            if ((n = SyntaxTextPaneBase.this.getCaretPosition()) < n2) {
                return n;
            }
            if (n < n3) {
                return n2;
            }
            return n - (n3 - n2);
        }

        @Override
        public TextHitInfo getLocationOffset(int n, int n2) {
            int n3;
            if (SyntaxTextPaneBase.this.composedText == null) {
                return null;
            }
            Point point = SyntaxTextPaneBase.this.getLocationOnScreen();
            point.x = n - point.x;
            point.y = n2 - point.y;
            int n4 = SyntaxTextPaneBase.this.viewToModel(point);
            if (n4 >= (n3 = SyntaxTextPaneBase.this.composedTextStart.getOffset()) && n4 <= n3 + SyntaxTextPaneBase.this.composedTextContent.length()) {
                return TextHitInfo.leading(n4 - SyntaxTextPaneBase.this.composedTextStart.getOffset());
            }
            return null;
        }

        @Override
        public Rectangle getTextLocation(TextHitInfo textHitInfo) {
            Rectangle rectangle;
            try {
                rectangle = SyntaxTextPaneBase.this.modelToView(SyntaxTextPaneBase.this.getCaretPosition());
                if (rectangle != null) {
                    Point point = SyntaxTextPaneBase.this.getLocationOnScreen();
                    rectangle.translate(point.x, point.y);
                }
            }
            catch (BadLocationException badLocationException) {
                rectangle = null;
            }
            if (rectangle == null) {
                rectangle = new Rectangle();
            }
            return rectangle;
        }

        @Override
        public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributeArray) {
            String string = SyntaxTextPaneBase.this.getSelectedText();
            if (string != null) {
                return new AttributedString(string).getIterator();
            }
            return null;
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            SyntaxTextPaneBase.this.latestCommittedTextStart = null;
            SyntaxTextPaneBase.this.latestCommittedTextLength = 0;
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            SyntaxTextPaneBase.this.latestCommittedTextStart = null;
            SyntaxTextPaneBase.this.latestCommittedTextLength = 0;
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            SyntaxTextPaneBase.this.latestCommittedTextStart = null;
            SyntaxTextPaneBase.this.latestCommittedTextLength = 0;
        }
    }

    private static class EditorKitInfo {
        private Object fKey = null;
        private Class fKitClass = null;

        private EditorKitInfo(Object object, Class clazz) {
            this.fKey = object;
            this.fKitClass = clazz;
        }

        public Object getType() {
            return this.fKey;
        }

        public Class getKitClass() {
            return this.fKitClass;
        }

        public String getClassname() {
            return this.fKitClass.getName();
        }

        public ClassLoader getClassloader() {
            return this.fKitClass.getClassLoader();
        }
    }

    private static class KitStore {
        private Map<String, EditorKitInfo> fEditorKitTable = new Hashtable<String, EditorKitInfo>();

        private KitStore() {
        }

        private boolean hasKit(String string) {
            return this.fEditorKitTable.containsKey(string);
        }

        private EditorKitInfo getKit(String string) {
            return this.fEditorKitTable.get(string);
        }

        private boolean registeredKit(Class clazz) {
            for (EditorKitInfo editorKitInfo : this.getElements()) {
                if (clazz != editorKitInfo.getKitClass()) continue;
                return true;
            }
            return false;
        }

        private void addKit(String string, Class clazz) {
            this.fEditorKitTable.put(string, new EditorKitInfo(string, clazz));
            STPPrefsManager.getInstance().registerCodeFoldExtKitClass(string, clazz);
        }

        private Collection<EditorKitInfo> getElements() {
            return this.fEditorKitTable.values();
        }
    }

    public static interface PostKeyListener
    extends KeyListener {
        public void postKeyTyped(KeyEvent var1);

        public void postKeyPressed(KeyEvent var1);
    }
}

