/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets;

import com.mathworks.mwswing.ChildAction;
import com.mathworks.mwswing.ClipboardListener;
import com.mathworks.mwswing.ClipboardMonitor;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.WrapperAction;
import com.mathworks.mwswing.api.ExtendedUndoManager;
import com.mathworks.mwswing.api.UndoabilityChangeListener;
import com.mathworks.mwswing.datatransfer.MJClipboard;
import com.mathworks.mwswing.undo.MUndoManager;
import com.mathworks.mwswing.undo.UndoManagerListener;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.SyntaxTextPaneBase;
import com.mathworks.widgets.text.MWEditorUI;
import com.mathworks.widgets.text.MWKit;
import com.mathworks.widgets.text.PrintableDocument;
import com.mathworks.widgets.text.STPInterface;
import com.mathworks.widgets.text.STPViewInterface;
import com.mathworks.widgets.text.plain.PlainLanguage;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.Validate;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Utilities;

public class SyntaxTextPane
extends SyntaxTextPaneBase
implements STPInterface {
    private ActionManager fActionManager = new ActionManager();
    private MUndoManager fUndoManager = new MUndoManager();
    private List<SyntaxTextPaneBase> fClonedViews = new LinkedList<SyntaxTextPaneBase>();
    private CaretListener fSharedCaretListener = new SharedCaretListener();
    private FocusListener fSharedFocusListener = new SharedFocusListener();
    private UniqueKeyProvider fUniqueKeyProvider = new EmptyUniqueKeyProvider();
    private String fCachedUniqueKey;

    public SyntaxTextPane() {
        this.fContextMenu = this.createContextMenu();
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                block7: {
                    block6: {
                        if (!propertyChangeEvent.getPropertyName().equals("editorKit")) break block6;
                        if (SyntaxTextPane.this.getEditorKit() instanceof MWKit) {
                            MWKit mWKit = (MWKit)((Object)SyntaxTextPane.this.getEditorKit());
                            SyntaxTextPane.this.updateContextMenuEntry(SyntaxTextPane.this.getCutAction());
                            SyntaxTextPane.this.updateContextMenuEntry(SyntaxTextPane.this.getCopyAction());
                            SyntaxTextPane.this.updateContextMenuEntry(SyntaxTextPane.this.getPasteAction());
                            SyntaxTextPane.this.updateContextMenuEntry(SyntaxTextPane.this.getUndoAction());
                            SyntaxTextPane.this.updateContextMenuEntry(SyntaxTextPane.this.getRedoAction());
                            SyntaxTextPane.this.updateContextMenuEntry(SyntaxTextPane.this.getCommentAction());
                            SyntaxTextPane.this.updateContextMenuEntry(SyntaxTextPane.this.getUncommentAction());
                            SyntaxTextPane.this.updateContextMenuEntry(SyntaxTextPane.this.getWrapCommentsAction());
                            SyntaxTextPane.this.updateContextMenuEntry(SyntaxTextPane.this.getSmartIndentAction());
                            SyntaxTextPane.this.updateContextMenuEntry(SyntaxTextPane.this.getUnindentAction());
                            SyntaxTextPane.this.updateContextMenuEntry(SyntaxTextPane.this.getIndentAction());
                            SyntaxTextPane.this.getSmartIndentAction().setEnabled(mWKit.supportSmartIndent());
                            SyntaxTextPane.this.getUndoAction().setEnabled(SyntaxTextPane.this.fUndoManager.canUndo());
                            SyntaxTextPane.this.getRedoAction().setEnabled(SyntaxTextPane.this.fUndoManager.canUndo());
                            boolean bl = !SyntaxTextPane.this.isSelectionEmpty();
                            SyntaxTextPane.this.getCopyAction().setEnabled(bl);
                            SyntaxTextPane.this.getCutAction().setEnabled(bl);
                            SyntaxTextPane.this.getToUpperCaseAction().setEnabled(bl);
                            SyntaxTextPane.this.getToLowerCaseAction().setEnabled(bl);
                        }
                        for (SyntaxTextPaneBase syntaxTextPaneBase : SyntaxTextPane.this.fClonedViews) {
                            syntaxTextPaneBase.setEditorKit((EditorKit)propertyChangeEvent.getNewValue());
                            syntaxTextPaneBase.fContextMenu = SyntaxTextPane.this.fContextMenu;
                        }
                        break block7;
                    }
                    if (!propertyChangeEvent.getPropertyName().equals("document")) break block7;
                    Document document = (Document)propertyChangeEvent.getOldValue();
                    Document document2 = (Document)propertyChangeEvent.getNewValue();
                    if (document != null) {
                        document.removeUndoableEditListener((UndoableEditListener)SyntaxTextPane.this.fUndoManager);
                        SyntaxTextPane.this.fUndoManager.discardAllEdits();
                    }
                    if (document2 != null) {
                        document2.putProperty("undo-manager", SyntaxTextPane.this.fUndoManager);
                        document2.addUndoableEditListener((UndoableEditListener)SyntaxTextPane.this.fUndoManager);
                        SyntaxTextPane.this.getUndoAction().setEnabled(SyntaxTextPane.this.fUndoManager.canUndo());
                        SyntaxTextPane.this.getRedoAction().setEnabled(SyntaxTextPane.this.fUndoManager.canUndo());
                        if (document instanceof PrintableDocument && document2 instanceof PrintableDocument) {
                            ((PrintableDocument)document2).setFilename(((PrintableDocument)document).getFilename());
                        }
                    }
                    for (SyntaxTextPaneBase syntaxTextPaneBase : SyntaxTextPane.this.fClonedViews) {
                        syntaxTextPaneBase.setDocument(document2);
                    }
                }
            }
        });
        this.addCaretListener(this.fSharedCaretListener);
        this.addFocusListener(this.fSharedFocusListener);
        this.fUndoManager.addUndoabilityChangeListener(new UndoabilityChangeListener(){

            public void undoabilityChanged(final boolean bl) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SyntaxTextPane.this.getUndoAction().setEnabled(bl);
                    }
                });
            }

            public void redoabilityChanged(final boolean bl) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SyntaxTextPane.this.getRedoAction().setEnabled(bl);
                    }
                });
            }
        });
        this.setEditorKit(this.createDefaultEditorKit());
    }

    @Override
    protected EditorKit createDefaultEditorKit() {
        return new PlainLanguage().createDefaultKit();
    }

    private MJPopupMenu createContextMenu() {
        MJPopupMenu mJPopupMenu = new MJPopupMenu();
        mJPopupMenu.add((Action)this.getCutAction());
        mJPopupMenu.add((Action)this.getCopyAction());
        mJPopupMenu.add((Action)this.getPasteAction());
        mJPopupMenu.addSeparator();
        mJPopupMenu.add((Action)this.getUndoAction());
        mJPopupMenu.add((Action)this.getRedoAction());
        mJPopupMenu.addSeparator();
        mJPopupMenu.add((Action)this.getWrapCommentsAction());
        mJPopupMenu.add((Action)this.getCommentAction());
        mJPopupMenu.add((Action)this.getUncommentAction());
        mJPopupMenu.addSeparator();
        mJPopupMenu.add((Action)this.getSmartIndentAction());
        mJPopupMenu.add((Action)this.getUnindentAction());
        mJPopupMenu.add((Action)this.getIndentAction());
        return mJPopupMenu;
    }

    private void updateContextMenuEntry(MJAbstractAction mJAbstractAction) {
        Component[] componentArray = this.fContextMenu.getComponents();
        for (int i = 0; i != componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JMenuItem) || !((AbstractButton)componentArray[i]).getActionCommand().equals(mJAbstractAction.getValue("ActionCommandKey"))) continue;
            if (mJAbstractAction.equals(((AbstractButton)componentArray[i]).getAction())) break;
            this.fContextMenu.remove(componentArray[i]);
            this.fContextMenu.insert((Action)mJAbstractAction, i);
            break;
        }
    }

    @Override
    public void cleanup() {
        if (this.fUniqueKeyProvider == null) {
            throw new IllegalStateException("This SyntaxtTextPane has already been disposed of.");
        }
        this.fActionManager.cleanup();
        this.fCachedUniqueKey = this.fUniqueKeyProvider.provideUniqueKey();
        this.fUniqueKeyProvider = null;
        this.removeCaretListener(this.fSharedCaretListener);
        this.removeFocusListener(this.fSharedFocusListener);
        super.cleanup();
        Iterator<SyntaxTextPaneBase> iterator = this.fClonedViews.iterator();
        while (iterator.hasNext()) {
            SyntaxTextPaneBase syntaxTextPaneBase = iterator.next();
            this.cleanupClone(syntaxTextPaneBase);
            iterator.remove();
        }
    }

    @Override
    public MJAbstractAction getCutAction() {
        return this.fActionManager.getCutAction((BaseKit)this.getEditorKit());
    }

    @Override
    public MJAbstractAction getCopyAction() {
        return this.fActionManager.getCopyAction((BaseKit)this.getEditorKit());
    }

    @Override
    public MJAbstractAction getPasteAction() {
        return this.fActionManager.getPasteAction((BaseKit)this.getEditorKit());
    }

    @Override
    public MJAbstractAction getUndoAction() {
        return this.fActionManager.getUndoAction((BaseKit)this.getEditorKit());
    }

    @Override
    public MJAbstractAction getRedoAction() {
        return this.fActionManager.getRedoAction((BaseKit)this.getEditorKit());
    }

    @Override
    public MJAbstractAction getIndentAction() {
        return this.fActionManager.getIndentAction((BaseKit)this.getEditorKit());
    }

    @Override
    public MJAbstractAction getUnindentAction() {
        return this.fActionManager.getUnindentAction((BaseKit)this.getEditorKit());
    }

    @Override
    public MJAbstractAction getSmartIndentAction() {
        return this.fActionManager.getSmartIndentAction((BaseKit)this.getEditorKit());
    }

    @Override
    public MJAbstractAction getSelectAllAction() {
        return this.fActionManager.getSelectAllAction((BaseKit)this.getEditorKit());
    }

    @Override
    public MJAbstractAction getDeleteAction() {
        return this.fActionManager.getDeleteAction((BaseKit)this.getEditorKit());
    }

    @Override
    public MJAbstractAction getCommentAction() {
        return this.fActionManager.getCommentAction((BaseKit)this.getEditorKit());
    }

    @Override
    public MJAbstractAction getUncommentAction() {
        return this.fActionManager.getUncommentAction((BaseKit)this.getEditorKit());
    }

    @Override
    public MJAbstractAction getWrapCommentsAction() {
        return this.fActionManager.getWrapCommentsAction((BaseKit)this.getEditorKit());
    }

    @Override
    public MJAbstractAction getToUpperCaseAction() {
        return this.fActionManager.getToUpperCaseAction((BaseKit)this.getEditorKit());
    }

    @Override
    public MJAbstractAction getToLowerCaseAction() {
        return this.fActionManager.getToLowerCaseAction((BaseKit)this.getEditorKit());
    }

    @Override
    public MJAbstractAction getNextJumpAction() {
        return this.fActionManager.getNextJumpAction((BaseKit)this.getEditorKit());
    }

    @Override
    public MJAbstractAction getPrevJumpAction() {
        return this.fActionManager.getPrevJumpAction((BaseKit)this.getEditorKit());
    }

    @Override
    public MJAbstractAction getCollapseAllFoldsAction() {
        return this.fActionManager.getCollapseAllFoldsAction((BaseKit)this.getEditorKit());
    }

    @Override
    public MJAbstractAction getExpandAllFoldsAction() {
        return this.fActionManager.getExpandAllFoldsAction((BaseKit)this.getEditorKit());
    }

    @Override
    public MJAbstractAction getExpandFoldAction() {
        return this.fActionManager.getExpandFoldAction((BaseKit)this.getEditorKit());
    }

    @Override
    public MJAbstractAction getCollapseFoldAction() {
        return this.fActionManager.getCollapseFoldAction((BaseKit)this.getEditorKit());
    }

    @Override
    public void addUndoManagerListener(UndoManagerListener undoManagerListener) {
        this.fUndoManager.addUndoManagerListener(undoManagerListener);
    }

    @Override
    public void removeUndoManagerListener(UndoManagerListener undoManagerListener) {
        this.fUndoManager.removeUndoManagerListener(undoManagerListener);
    }

    @Override
    public boolean isDirty() {
        return !this.fUndoManager.isClean();
    }

    @Override
    public void setUndoCleanMarker() {
        this.fUndoManager.setCleanMarker();
    }

    @Override
    public void setUndoDirtyMarker() {
        this.fUndoManager.setDirtyMarker();
    }

    @Override
    public void discardAllUndoEdits() {
        this.fUndoManager.discardAllEdits();
    }

    @Override
    public void setUndoManagerLimit(int n) {
        this.fUndoManager.setLimit(n);
    }

    @Override
    public void setEditable(boolean bl) {
        super.setEditable(bl);
        if (this.fActionManager != null) {
            this.fActionManager.editableStatusChanged(bl);
        }
        if (this.fClonedViews != null) {
            for (SyntaxTextPaneBase syntaxTextPaneBase : this.fClonedViews) {
                syntaxTextPaneBase.setEditable(bl);
            }
        }
    }

    @Override
    public void setHighlightedLines(int[] nArray) {
        if (this.getDocument() instanceof PrintableDocument) {
            ((PrintableDocument)this.getDocument()).setHighlightedLines(nArray);
        }
    }

    @Override
    public void setBoldLines(int[] nArray) {
        if (this.getDocument() instanceof PrintableDocument) {
            ((PrintableDocument)this.getDocument()).setBoldLines(nArray);
        }
    }

    @Override
    public void setDrawAboveLines(int[] nArray) {
        if (this.getDocument() instanceof PrintableDocument) {
            ((PrintableDocument)this.getDocument()).setDrawAboveLines(nArray);
        }
    }

    @Override
    public void setFilename(String string) {
        if (this.getDocument() instanceof PrintableDocument) {
            ((PrintableDocument)this.getDocument()).setFilename(string);
        }
    }

    @Override
    public String getFilename() {
        String string = null;
        if (this.getDocument() instanceof PrintableDocument) {
            string = ((PrintableDocument)this.getDocument()).getFilename();
        }
        return string;
    }

    SyntaxTextPaneBase getClonedView() {
        SyntaxTextPaneBase syntaxTextPaneBase = new SyntaxTextPaneBase();
        syntaxTextPaneBase.setEditorKit(this.getEditorKit());
        BaseDocument baseDocument = (BaseDocument)this.getDocument();
        ((MWKit)((Object)this.getEditorKit())).prepareClone(baseDocument);
        syntaxTextPaneBase.setDocument((Document)baseDocument);
        syntaxTextPaneBase.addCaretListener(this.fSharedCaretListener);
        syntaxTextPaneBase.addFocusListener(this.fSharedFocusListener);
        syntaxTextPaneBase.setEditable(this.isEditable());
        syntaxTextPaneBase.fContextMenu = this.fContextMenu;
        BaseKit baseKit = (BaseKit)this.getEditorKit();
        syntaxTextPaneBase.fCollapseAllFoldsAction = this.fActionManager.getCollapseAllFoldsAction(baseKit);
        syntaxTextPaneBase.fCollapseFoldAction = this.fActionManager.getCollapseFoldAction(baseKit);
        syntaxTextPaneBase.fExpandAllFoldsAction = this.fActionManager.getExpandAllFoldsAction(baseKit);
        syntaxTextPaneBase.fExpandFoldAction = this.fActionManager.getExpandFoldAction(baseKit);
        this.fClonedViews.add(syntaxTextPaneBase);
        syntaxTextPaneBase.setName("SyntaxTextPaneClone" + this.fClonedViews.size());
        return syntaxTextPaneBase;
    }

    void removeClonedView(SyntaxTextPaneBase syntaxTextPaneBase) {
        this.fClonedViews.remove(syntaxTextPaneBase);
        this.cleanupClone(syntaxTextPaneBase);
    }

    private void cleanupClone(SyntaxTextPaneBase syntaxTextPaneBase) {
        syntaxTextPaneBase.removeCaretListener(this.fSharedCaretListener);
        syntaxTextPaneBase.removeFocusListener(this.fSharedFocusListener);
        syntaxTextPaneBase.cleanup();
    }

    @Override
    public Component getDisplayComponent() {
        return SyntaxTextPaneBase.getDisplayComponent(this);
    }

    @Override
    public ExtendedUndoManager getUndoManager() {
        return this.fUndoManager;
    }

    @Override
    public String getUniqueKey() {
        return this.fUniqueKeyProvider == null ? this.fCachedUniqueKey : this.fUniqueKeyProvider.provideUniqueKey();
    }

    public void setUniqueKeyProvider(UniqueKeyProvider uniqueKeyProvider) {
        Validate.notNull((Object)uniqueKeyProvider, (String)"The given UniqueKeyProvider cannot be null.");
        this.fUniqueKeyProvider = uniqueKeyProvider;
    }

    private static class EmptyUniqueKeyProvider
    implements UniqueKeyProvider {
        private EmptyUniqueKeyProvider() {
        }

        @Override
        public String provideUniqueKey() {
            return null;
        }
    }

    public static interface UniqueKeyProvider {
        public String provideUniqueKey();
    }

    private static class ActionManager {
        private WrapperAction fCutAction;
        private ChildAction fCopyAction;
        private WrapperAction fPasteAction;
        private WrapperAction fIndentAction;
        private WrapperAction fUnindentAction;
        private WrapperAction fSmartIndentAction;
        private ChildAction fSelectAllAction;
        private WrapperAction fUndoAction;
        private WrapperAction fRedoAction;
        private WrapperAction fDeleteAction;
        private WrapperAction fCommentAction;
        private WrapperAction fUncommentAction;
        private WrapperAction fWrapCommentsAction;
        private WrapperAction fToUpperCaseAction;
        private WrapperAction fToLowerCaseAction;
        private WrapperAction fNextJumpAction;
        private WrapperAction fPrevJumpAction;
        private WrapperAction fCollapseAllFoldsAction;
        private WrapperAction fExpandAllFoldsAction;
        private WrapperAction fExpandFoldAction;
        private WrapperAction fCollapseFoldAction;

        private ActionManager() {
        }

        public void editableStatusChanged(boolean bl) {
            ActionManager.setAlwaysDisable(this.fCutAction, bl);
            ActionManager.setAlwaysDisable(this.fPasteAction, bl);
            ActionManager.setAlwaysDisable(this.fIndentAction, bl);
            ActionManager.setAlwaysDisable(this.fUnindentAction, bl);
            ActionManager.setAlwaysDisable(this.fSmartIndentAction, bl);
            ActionManager.setAlwaysDisable(this.fUndoAction, bl);
            ActionManager.setAlwaysDisable(this.fRedoAction, bl);
            ActionManager.setAlwaysDisable(this.fDeleteAction, bl);
            ActionManager.setAlwaysDisable(this.fCommentAction, bl);
            ActionManager.setAlwaysDisable(this.fUncommentAction, bl);
            ActionManager.setAlwaysDisable(this.fWrapCommentsAction, bl);
            ActionManager.setAlwaysDisable(this.fToUpperCaseAction, bl);
            ActionManager.setAlwaysDisable(this.fToLowerCaseAction, bl);
            ActionManager.setAlwaysDisable(this.fCollapseAllFoldsAction, bl);
            ActionManager.setAlwaysDisable(this.fExpandAllFoldsAction, bl);
            ActionManager.setAlwaysDisable(this.fCollapseFoldAction, bl);
            ActionManager.setAlwaysDisable(this.fExpandFoldAction, bl);
        }

        private static void setAlwaysDisable(WrapperAction wrapperAction, boolean bl) {
            if (wrapperAction != null) {
                wrapperAction.setWrapperDisable(!bl);
            }
        }

        public WrapperAction getCutAction(BaseKit baseKit) {
            Action action = baseKit.getActionByName("cut-to-clipboard");
            if (ActionManager.createNewChildAction(this.fCutAction, action)) {
                this.fCutAction = new WrapperAction(new ChildAction(action, false));
                ActionManager.setNameCommandKey((MJAbstractAction)this.fCutAction, "cut-to-clipboard");
            }
            return this.fCutAction;
        }

        public ChildAction getCopyAction(BaseKit baseKit) {
            Action action = baseKit.getActionByName("copy-to-clipboard");
            if (ActionManager.createNewChildAction(this.fCopyAction, action)) {
                this.fCopyAction = new ChildAction(action, false);
                ActionManager.setNameCommandKey((MJAbstractAction)this.fCopyAction, "copy-to-clipboard");
            }
            return this.fCopyAction;
        }

        public WrapperAction getPasteAction(BaseKit baseKit) {
            Action action = baseKit.getActionByName("paste-from-clipboard");
            if (ActionManager.createNewChildAction(this.fPasteAction, action)) {
                this.fPasteAction = new WrapperAction((ChildAction)new PasteAction(action));
                ActionManager.setNameCommandKey((MJAbstractAction)this.fPasteAction, "paste-from-clipboard");
            }
            return this.fPasteAction;
        }

        public WrapperAction getUnindentAction(BaseKit baseKit) {
            Action action = baseKit.getActionByName("shift-line-left");
            if (ActionManager.createNewChildAction(this.fUnindentAction, action)) {
                this.fUnindentAction = new WrapperAction(new ChildAction(action));
                ActionManager.setNameCommandKey((MJAbstractAction)this.fUnindentAction, "shift-line-left");
            }
            return this.fUnindentAction;
        }

        public WrapperAction getIndentAction(BaseKit baseKit) {
            Action action = baseKit.getActionByName("shift-line-right");
            if (ActionManager.createNewChildAction(this.fIndentAction, action)) {
                this.fIndentAction = new WrapperAction(new ChildAction(action));
                ActionManager.setNameCommandKey((MJAbstractAction)this.fIndentAction, "shift-line-right");
            }
            return this.fIndentAction;
        }

        public WrapperAction getSmartIndentAction(BaseKit baseKit) {
            Action action = baseKit.getActionByName("format");
            if (ActionManager.createNewChildAction(this.fSmartIndentAction, action)) {
                this.fSmartIndentAction = new WrapperAction(new ChildAction(action, false));
                ActionManager.setNameCommandKey((MJAbstractAction)this.fSmartIndentAction, "format");
            }
            return this.fSmartIndentAction;
        }

        public ChildAction getSelectAllAction(BaseKit baseKit) {
            Action action = baseKit.getActionByName("select-all");
            if (ActionManager.createNewChildAction(this.fSelectAllAction, action)) {
                this.fSelectAllAction = new ChildAction(action);
                ActionManager.setNameCommandKey((MJAbstractAction)this.fSelectAllAction, "select-all");
            }
            return this.fSelectAllAction;
        }

        public WrapperAction getUndoAction(BaseKit baseKit) {
            Action action = baseKit.getActionByName("undo");
            if (ActionManager.createNewChildAction(this.fUndoAction, action)) {
                this.fUndoAction = new WrapperAction(new ChildAction(action, false));
                ActionManager.setNameCommandKey((MJAbstractAction)this.fUndoAction, "undo");
            }
            return this.fUndoAction;
        }

        public WrapperAction getRedoAction(BaseKit baseKit) {
            Action action = baseKit.getActionByName("redo");
            if (ActionManager.createNewChildAction(this.fRedoAction, action)) {
                this.fRedoAction = new WrapperAction(new ChildAction(action, false));
                ActionManager.setNameCommandKey((MJAbstractAction)this.fRedoAction, "redo");
            }
            return this.fRedoAction;
        }

        public WrapperAction getDeleteAction(BaseKit baseKit) {
            Action action = baseKit.getActionByName("delete-next");
            if (ActionManager.createNewChildAction(this.fDeleteAction, action)) {
                this.fDeleteAction = new WrapperAction(new ChildAction(action));
                ActionManager.setNameCommandKey((MJAbstractAction)this.fDeleteAction, "delete-next");
            }
            return this.fDeleteAction;
        }

        public WrapperAction getCommentAction(BaseKit baseKit) {
            Action action = baseKit.getActionByName("comment");
            if (ActionManager.createNewChildAction(this.fCommentAction, action)) {
                this.fCommentAction = new WrapperAction(new ChildAction(action));
                ActionManager.setNameCommandKey((MJAbstractAction)this.fCommentAction, "comment");
            }
            return this.fCommentAction;
        }

        public WrapperAction getUncommentAction(BaseKit baseKit) {
            Action action = baseKit.getActionByName("uncomment");
            if (ActionManager.createNewChildAction(this.fUncommentAction, action)) {
                this.fUncommentAction = new WrapperAction(new ChildAction(action));
                ActionManager.setNameCommandKey((MJAbstractAction)this.fUncommentAction, "uncomment");
            }
            return this.fUncommentAction;
        }

        public WrapperAction getWrapCommentsAction(BaseKit baseKit) {
            Action action = baseKit.getActionByName("merge-comments");
            if (ActionManager.createNewChildAction(this.fWrapCommentsAction, action)) {
                this.fWrapCommentsAction = new WrapperAction(new ChildAction(action));
                ActionManager.setNameCommandKey((MJAbstractAction)this.fWrapCommentsAction, "merge-comments");
            }
            return this.fWrapCommentsAction;
        }

        public WrapperAction getToUpperCaseAction(BaseKit baseKit) {
            Action action = baseKit.getActionByName("to-upper-case");
            if (ActionManager.createNewChildAction(this.fToUpperCaseAction, action)) {
                this.fToUpperCaseAction = new WrapperAction(new ChildAction(action, false));
                ActionManager.setNameCommandKey((MJAbstractAction)this.fToUpperCaseAction, "to-upper-case");
            }
            return this.fToUpperCaseAction;
        }

        public WrapperAction getToLowerCaseAction(BaseKit baseKit) {
            Action action = baseKit.getActionByName("to-lower-case");
            if (ActionManager.createNewChildAction(this.fToLowerCaseAction, action)) {
                this.fToLowerCaseAction = new WrapperAction(new ChildAction(action, false));
                ActionManager.setNameCommandKey((MJAbstractAction)this.fToLowerCaseAction, "to-lower-case");
            }
            return this.fToLowerCaseAction;
        }

        public WrapperAction getNextJumpAction(BaseKit baseKit) {
            Action action = baseKit.getActionByName("jump-list-next");
            if (ActionManager.createNewChildAction(this.fNextJumpAction, action)) {
                this.fNextJumpAction = new WrapperAction(new ChildAction(action, true));
                ActionManager.setNameCommandKey((MJAbstractAction)this.fNextJumpAction, "jump-list-next");
            }
            return this.fNextJumpAction;
        }

        public WrapperAction getPrevJumpAction(BaseKit baseKit) {
            Action action = baseKit.getActionByName("jump-list-prev");
            if (ActionManager.createNewChildAction(this.fPrevJumpAction, action)) {
                this.fPrevJumpAction = new WrapperAction(new ChildAction(action, true));
                ActionManager.setNameCommandKey((MJAbstractAction)this.fPrevJumpAction, "jump-list-prev");
            }
            return this.fPrevJumpAction;
        }

        public WrapperAction getCollapseAllFoldsAction(BaseKit baseKit) {
            Action action = baseKit.getActionByName("collapse-all-folds");
            if (ActionManager.createNewChildAction(this.fCollapseAllFoldsAction, action)) {
                this.fCollapseAllFoldsAction = new WrapperAction(new ChildAction(action, false));
                ActionManager.setNameCommandKey((MJAbstractAction)this.fCollapseAllFoldsAction, "collapse-all-folds");
            }
            return this.fCollapseAllFoldsAction;
        }

        public WrapperAction getExpandAllFoldsAction(BaseKit baseKit) {
            Action action = baseKit.getActionByName("expand-all-folds");
            if (ActionManager.createNewChildAction(this.fExpandAllFoldsAction, action)) {
                this.fExpandAllFoldsAction = new WrapperAction(new ChildAction(action, false));
                ActionManager.setNameCommandKey((MJAbstractAction)this.fExpandAllFoldsAction, "expand-all-folds");
            }
            return this.fExpandAllFoldsAction;
        }

        public WrapperAction getExpandFoldAction(BaseKit baseKit) {
            Action action = baseKit.getActionByName("expand-fold");
            if (ActionManager.createNewChildAction(this.fExpandFoldAction, action)) {
                this.fExpandFoldAction = new WrapperAction(new ChildAction(action, false));
                ActionManager.setNameCommandKey((MJAbstractAction)this.fExpandFoldAction, "expand-fold");
            }
            return this.fExpandFoldAction;
        }

        public WrapperAction getCollapseFoldAction(BaseKit baseKit) {
            Action action = baseKit.getActionByName("collapse-fold");
            if (ActionManager.createNewChildAction(this.fCollapseFoldAction, action)) {
                this.fCollapseFoldAction = new WrapperAction(new ChildAction(action, false));
                ActionManager.setNameCommandKey((MJAbstractAction)this.fCollapseFoldAction, "collapse-fold");
            }
            return this.fCollapseFoldAction;
        }

        private static void setNameCommandKey(MJAbstractAction mJAbstractAction, String string) {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("MATLABEditor", string, (ExtendedAction)mJAbstractAction);
        }

        private void cleanup() {
            ActionManager.clearParent((ChildAction)this.fCutAction);
            ActionManager.clearParent(this.fCopyAction);
            ActionManager.clearParent((ChildAction)this.fPasteAction);
            ActionManager.clearParent((ChildAction)this.fIndentAction);
            ActionManager.clearParent((ChildAction)this.fUnindentAction);
            ActionManager.clearParent((ChildAction)this.fSmartIndentAction);
            ActionManager.clearParent(this.fSelectAllAction);
            ActionManager.clearParent((ChildAction)this.fUndoAction);
            ActionManager.clearParent((ChildAction)this.fRedoAction);
            ActionManager.clearParent((ChildAction)this.fDeleteAction);
            ActionManager.clearParent((ChildAction)this.fCommentAction);
            ActionManager.clearParent((ChildAction)this.fUncommentAction);
            ActionManager.clearParent((ChildAction)this.fToUpperCaseAction);
            ActionManager.clearParent((ChildAction)this.fToLowerCaseAction);
            ActionManager.clearParent((ChildAction)this.fNextJumpAction);
            ActionManager.clearParent((ChildAction)this.fPrevJumpAction);
            ActionManager.clearParent((ChildAction)this.fCollapseAllFoldsAction);
            ActionManager.clearParent((ChildAction)this.fExpandAllFoldsAction);
            ActionManager.clearParent((ChildAction)this.fExpandFoldAction);
            ActionManager.clearParent((ChildAction)this.fCollapseFoldAction);
            ActionManager.clearParent((ChildAction)this.fWrapCommentsAction);
        }

        private static void clearParent(ChildAction childAction) {
            if (childAction != null) {
                if (childAction.getParent() instanceof ChildAction) {
                    ActionManager.clearParent((ChildAction)childAction.getParent());
                }
                childAction.setParent(null);
                if (childAction instanceof ClipboardListener) {
                    ClipboardMonitor.removeListener((ClipboardListener)((ClipboardListener)childAction));
                }
            }
        }

        private static boolean createNewChildAction(WrapperAction wrapperAction, Action action) {
            if (wrapperAction == null || wrapperAction.getParent() == null) {
                return true;
            }
            boolean bl = ActionManager.createNewChildAction((ChildAction)wrapperAction.getParent(), action);
            if (bl) {
                ActionManager.clearParent((ChildAction)wrapperAction);
            }
            return bl;
        }

        private static boolean createNewChildAction(ChildAction childAction, Action action) {
            assert (action != null) : "parent cannot be null";
            if (childAction == null) {
                return true;
            }
            assert (childAction.getParent() != null) : "currentChild's parent is null";
            if (!childAction.getParent().getClass().equals(action.getClass()) || action instanceof MWKit.InstancesNotEqual && (!(childAction.getParent() instanceof MWKit.InstancesNotEqual) || !((MWKit.InstancesNotEqual)((Object)action)).areIdentical((MWKit.InstancesNotEqual)((Object)childAction.getParent())))) {
                ActionManager.clearParent(childAction);
                return true;
            }
            return false;
        }

        private static class PasteAction
        extends ChildAction
        implements ClipboardListener {
            private static DataFlavor[] sFlavors = new DataFlavor[]{DataFlavor.stringFlavor};

            private PasteAction(Action action) {
                super(action);
                if (!PlatformInfo.isUnix()) {
                    ClipboardMonitor.addListener((ClipboardListener)this);
                    this.clipboardContentTypeChanged(ClipboardMonitor.getFlavors());
                }
            }

            public void clipboardContentTypeChanged(DataFlavor[] dataFlavorArray) {
                if (sFlavors == null) {
                    return;
                }
                boolean bl = false;
                for (int i = 0; !bl && dataFlavorArray != null && i < sFlavors.length; ++i) {
                    for (int j = 0; !bl && j < dataFlavorArray.length; ++j) {
                        bl = sFlavors[i].equals(dataFlavorArray[j]);
                    }
                }
                this.setEnabled(bl);
            }
        }
    }

    private static class FocusCaretEvent
    extends CaretEvent {
        private FocusCaretEvent(SyntaxTextPaneBase syntaxTextPaneBase) {
            super(syntaxTextPaneBase);
        }

        @Override
        public int getDot() {
            return ((JTextComponent)this.getSource()).getCaret().getDot();
        }

        @Override
        public int getMark() {
            return ((JTextComponent)this.getSource()).getCaret().getMark();
        }
    }

    private class SharedFocusListener
    implements FocusListener {
        private SharedFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (focusEvent.getSource() instanceof SyntaxTextPaneBase && !SyntaxTextPane.this.fClonedViews.isEmpty()) {
                final SyntaxTextPaneBase syntaxTextPaneBase = (SyntaxTextPaneBase)focusEvent.getSource();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SyntaxTextPane.this.fireCaretUpdate(new FocusCaretEvent(syntaxTextPaneBase));
                        EditorUI editorUI = Utilities.getEditorUI((JTextComponent)syntaxTextPaneBase);
                        if (editorUI instanceof MWEditorUI) {
                            Boolean bl = !syntaxTextPaneBase.isInsertMode();
                            ((MWEditorUI)editorUI).fireFakePropertyChange("overwriteMode", bl);
                        }
                    }
                });
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }
    }

    private class SharedCaretListener
    implements CaretListener {
        private SharedCaretListener() {
        }

        @Override
        public void caretUpdate(CaretEvent caretEvent) {
            if (SyntaxTextPane.this.fClonedViews.isEmpty() || ((Component)caretEvent.getSource()).hasFocus()) {
                boolean bl = !((STPViewInterface)caretEvent.getSource()).isSelectionEmpty();
                SyntaxTextPane.this.getCopyAction().setEnabled(bl);
                SyntaxTextPane.this.getCutAction().setEnabled(bl);
                SyntaxTextPane.this.getToUpperCaseAction().setEnabled(bl);
                SyntaxTextPane.this.getToLowerCaseAction().setEnabled(bl);
                if (bl && PlatformInfo.isXWindows()) {
                    MJClipboard.getMJClipboard().setXSelectionContents(SyntaxTextPane.this.getSelectedText());
                }
            }
            MWKit.KillLineAction killLineAction = (MWKit.KillLineAction)((Object)((BaseKit)SyntaxTextPane.this.getEditorKit()).getActionByName("kill-line"));
            killLineAction.resetClipboardAccumulation();
        }
    }
}

