/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets;

import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.Painter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;

public class MacLightTexturedButtonPainter
implements Painter<AbstractButton> {
    private static final int DEFAULT_FOCUS_BORDER_RADIUS = 3;
    private static final int TOP_MARGIN = 3;
    private static final int BOTTOM_MARGIN = 3;
    private static final int LEFT_MARGIN = 3;
    private static final int RIGHT_MARGIN = 3;
    private static final int ARC_DIAMETER = 6;
    private static final int PAD_PX = 5;
    private static final int HIGHLIGHT_HEIGHT = 1;
    private static final Color PRESSED_TOP_COLOR = new Color(0xB0B0B0);
    private static final Color PRESSED_BOTTOM_COLOR = new Color(0x888888);
    private static final Color AT_REST_BOTTOM_COLOR = new Color(0xC2C2C2);
    private static final Color AT_REST_TOP_COLOR = Color.WHITE;
    private static final Color BORDER_COLOR = new Color(0x666666);
    private static final Color HIGHLIGHT_COLOR = new Color(255, 255, 255, 140);

    public static void make(MJButton mJButton) {
        mJButton.putClientProperty((Object)"visualMargin", (Object)new Insets(3, 3, 3, 3));
        mJButton.setBackgroundPainter((Painter)new MacLightTexturedButtonPainter());
        mJButton.setBorder(BorderFactory.createEmptyBorder(8, 8, 9, 8));
        mJButton.setOpaque(false);
    }

    public void paint(AbstractButton abstractButton, Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n5 = n3 - 3 - 3 - 1;
        int n6 = n4 - 3 - 3 - 1;
        int n7 = n6 - 1;
        boolean bl = abstractButton.getModel().isPressed();
        graphics2D.setColor(HIGHLIGHT_COLOR);
        int n8 = 3;
        int n9 = 3;
        graphics2D.drawRoundRect(n8, n9, n5, n6, 6, 6);
        Paint paint = MacLightTexturedButtonPainter.createPaint(bl, n8, n9, n7);
        graphics2D.setPaint(paint);
        graphics2D.fillRoundRect(n8, n9, n5, n7, 6, 6);
        graphics2D.setColor(BORDER_COLOR);
        graphics2D.drawRoundRect(n8, n9, n5, n7, 6, 6);
        if (bl) {
            MacLightTexturedButtonPainter.paintInnerShadow(graphics2D, n8, n9, n5, n7, n6);
        }
    }

    private static Paint createPaint(boolean bl, int n, int n2, int n3) {
        return bl ? new GradientPaint(n, n2, PRESSED_TOP_COLOR, n, n3, PRESSED_BOTTOM_COLOR) : new GradientPaint(n, n2, AT_REST_TOP_COLOR, n, n3, AT_REST_BOTTOM_COLOR);
    }

    private static void paintInnerShadow(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5) {
        RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(n, n2, n3, n4, 6.0f, 6.0f);
        graphics2D.setClip(float_);
        for (int i = 1; i < 6; ++i) {
            float f = 7.0f - (float)i;
            graphics2D.setStroke(new BasicStroke(f));
            int n6 = i * 10;
            graphics2D.setColor(new Color(0, 0, 0, n6));
            graphics2D.drawRoundRect(n, n2, n3, n5, 6, 6);
        }
    }
}

