/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.proxy;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import net.jini.io.MarshalledInstance;
import net.jini.io.ObjectStreamContext;
import net.jini.io.context.IntegrityEnforcement;

public class MarshalledWrapper
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final MarshalledInstance instance;
    private transient boolean integrity = false;

    public static boolean integrityEnforced(ObjectInputStream objectInputStream) {
        if (objectInputStream instanceof ObjectStreamContext) {
            Collection collection = ((ObjectStreamContext)((Object)objectInputStream)).getObjectStreamContext();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof IntegrityEnforcement)) continue;
                return ((IntegrityEnforcement)e).integrityEnforced();
            }
        }
        return false;
    }

    public MarshalledWrapper(Object object) throws IOException {
        this.instance = new MarshalledInstance(object);
    }

    public MarshalledWrapper(MarshalledInstance marshalledInstance) {
        if (marshalledInstance == null) {
            throw new NullPointerException();
        }
        this.instance = marshalledInstance;
    }

    public Object get() throws IOException, ClassNotFoundException {
        return this.instance.get(this.integrity);
    }

    public MarshalledInstance getMarshalledInstance() {
        return this.instance;
    }

    public boolean getIntegrity() {
        return this.integrity;
    }

    public int hashCode() {
        return MarshalledWrapper.class.hashCode() ^ this.instance.hashCode();
    }

    public boolean equals(Object object) {
        return object == this || object != null && object.getClass() == this.getClass() && this.instance.equals(((MarshalledWrapper)object).instance);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.instance == null) {
            throw new InvalidObjectException("null instance");
        }
        this.integrity = MarshalledWrapper.integrityEnforced(objectInputStream);
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw new InvalidObjectException("no data");
    }
}

