/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.workflowui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.common.icons.CommonIcon;
import com.mathworks.common.icons.DebuggingIcon;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJHelpButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.project.api.DeploymentProcess;
import com.mathworks.project.api.DeploymentProcessMonitor;
import com.mathworks.project.api.InvalidProjectException;
import com.mathworks.project.api.ProjectComponent;
import com.mathworks.project.api.ReadableConfiguration;
import com.mathworks.project.api.SubProcessType;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.ProjectGUI;
import com.mathworks.project.impl.engine.DeploymentEngine;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.ParamSet;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.model.ProjectManager;
import com.mathworks.project.impl.model.WorkflowStep;
import com.mathworks.project.impl.model.WorkflowStepResult;
import com.mathworks.project.impl.plugin.PluginManager;
import com.mathworks.project.impl.settingsui.ParamSetPanel;
import com.mathworks.project.impl.settingsui.TabbedParamSetPanel;
import com.mathworks.project.impl.workflowui.OutputArea;
import com.mathworks.project.impl.workflowui.OutputAreaModel;
import com.mathworks.project.impl.workflowui.OutputTabDefinition;
import com.mathworks.project.impl.workflowui.WorkflowSplitPane;
import com.mathworks.project.impl.workflowui.WorkflowTree;
import com.mathworks.util.Converter;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.tree.TreeUtils;
import com.mathworks.widgets.BusyAffordance;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public final class WorkflowDialog {
    private final MJFrame fDialog;
    private final MJPanel fOptionsContainer;
    private final Project fProject;
    private final Configuration fConfiguration;
    private final PropertyChangeListener fPropertyChangeListener;
    private final MJButton fRunButton;
    private final Component fHelpComponent;
    private final MJCheckBox fSkipCheckBox;
    private final Map<String, ProjectComponent> fOptionPanels;
    private final WorkflowTree fTree;
    private final BusyAffordance fBusyAffordance;
    private final Map<String, OutputAreaModel> fOutputModelByStepKey;
    private final OutputArea fOutputArea;
    private final WorkflowSplitPane fSplitPane;
    private WorkflowStep fSelectedStep;
    private DeploymentProcess fProcess;
    private boolean fIgnoreItemChange = false;
    private static WorkflowDialog sInstance;
    private ActionListener fActionListener;
    private ItemListener fItemListener;
    private WindowAdapter fWindowAdapter;
    private MJLabel fStepDescription;
    static final Icon RUN_STEP_ICON;
    static final Icon RUN_MULTI_STEP_ICON;

    public static WorkflowDialog getInstance() {
        return sInstance;
    }

    public MJFrame getDialog() {
        return this.fDialog;
    }

    public WorkflowStep getSelectedStep() {
        return this.fSelectedStep;
    }

    public Configuration getConfiguration() {
        return this.fConfiguration;
    }

    public static void invoke(final Project project) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (sInstance != null && !sInstance.fProject.equals(project)) {
                    WorkflowDialog.close();
                }
                if (sInstance == null) {
                    sInstance = new WorkflowDialog(project);
                }
                sInstance.setVisible(true);
            }
        });
    }

    public static void close() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (sInstance != null) {
                    sInstance.dispose();
                    sInstance = null;
                }
            }
        });
    }

    private WorkflowDialog(Project project) {
        Object object;
        MJToolBar mJToolBar;
        this.fProject = project;
        this.fConfiguration = project.getConfiguration();
        this.fOutputModelByStepKey = new HashMap<String, OutputAreaModel>();
        MJPanel mJPanel = new MJPanel((LayoutManager)new FlowLayout(2, 3, 0));
        this.fOutputArea = new OutputArea((Component)mJPanel);
        this.fDialog = new MJFrame(this.fConfiguration.getTarget().getName());
        this.fDialog.setLayout((LayoutManager)new FormLayout("3dlu, fill:p, 3dlu, fill:d:grow, 3dlu", "3dlu, fill:d, 3dlu, fill:d:grow"));
        CellConstraints cellConstraints = new CellConstraints();
        this.fOptionsContainer = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        this.fOptionPanels = new HashMap<String, ProjectComponent>();
        this.fRunButton = new MJButton(BuiltInResources.getString("button.run"), (Icon)DebuggingIcon.PLAY.getIcon());
        this.fRunButton.setName("RunButton");
        this.fActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WorkflowDialog.this.runCurrentStep();
            }
        };
        this.fRunButton.addActionListener(this.fActionListener);
        if (PlatformInfo.isMacintosh()) {
            this.fHelpComponent = new MJHelpButton();
            this.fHelpComponent.setName("step.help");
        } else {
            mJToolBar = new MJToolBar();
            mJToolBar.setFloatable(false);
            object = new MJAbstractAction(BuiltInResources.getString("button.help"), CommonIcon.HELP.getIcon()){

                public void actionPerformed(ActionEvent actionEvent) {
                    WorkflowDialog.this.showStepHelp();
                }
            };
            object.setComponentName("step.help");
            mJToolBar.add((Action)object);
            this.fHelpComponent = mJToolBar;
        }
        this.fSkipCheckBox = new MJCheckBox(BuiltInResources.getString("checkbox.skip"));
        this.fSkipCheckBox.setName("SkipStepCheckBox");
        this.fItemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (!WorkflowDialog.this.fIgnoreItemChange) {
                    boolean bl = WorkflowDialog.this.fSkipCheckBox.isSelected();
                    WorkflowDialog.this.fConfiguration.setWorkflowStepSkipped(WorkflowDialog.this.fSelectedStep, bl);
                    WorkflowDialog.this.fTree.updateSteps();
                }
            }
        };
        this.fSkipCheckBox.addItemListener(this.fItemListener);
        this.fBusyAffordance = new BusyAffordance(BusyAffordance.AffordanceSize.SIZE_16x16);
        mJPanel.add((Component)this.fSkipCheckBox);
        mJPanel.add((Component)this.fBusyAffordance.getComponent());
        mJToolBar = new MJPanel((LayoutManager)new FormLayout("3dlu:grow, fill:d, 3dlu, fill:d", "fill:d"));
        mJToolBar.add(this.fHelpComponent, cellConstraints.xy(2, 1));
        mJToolBar.add((Component)this.fRunButton, cellConstraints.xy(4, 1));
        mJPanel.add((Component)mJToolBar);
        this.fWindowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
            }
        };
        this.fDialog.addWindowListener((WindowListener)this.fWindowAdapter);
        this.fPropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (Configuration.isWorkflowStepEvent(propertyChangeEvent)) {
                            WorkflowDialog.this.fTree.getComponent().revalidate();
                            WorkflowDialog.this.fTree.getComponent().repaint();
                            if (WorkflowDialog.this.fSelectedStep != null && Configuration.isWorkflowStepEvent(WorkflowDialog.this.fSelectedStep, propertyChangeEvent)) {
                                WorkflowDialog.this.fRunButton.setEnabled(WorkflowDialog.this.fProcess == null && WorkflowDialog.this.fConfiguration.isStepAccessible(WorkflowDialog.this.fSelectedStep) && (WorkflowDialog.this.fSelectedStep.getScript() != null || !WorkflowDialog.this.fSelectedStep.getSubSteps().isEmpty()));
                                WorkflowStepResult workflowStepResult = WorkflowDialog.this.fConfiguration.getWorkflowStepResult(WorkflowDialog.this.fSelectedStep);
                                if (workflowStepResult != WorkflowStepResult.COMPLETED && workflowStepResult != WorkflowStepResult.ERROR) {
                                    int n;
                                    List<WorkflowStep> list = WorkflowDialog.this.fConfiguration.getTarget().getWorkflow().getFlattenedSteps();
                                    for (int i = n = list.indexOf(WorkflowDialog.this.fSelectedStep); i < list.size(); ++i) {
                                        WorkflowDialog.this.getOutputModelForStep(list.get(i)).getLogSource().clear();
                                    }
                                }
                            }
                        }
                    }
                });
            }
        };
        this.fStepDescription = new MJLabel(""){

            public Dimension getMinimumSize() {
                return new Dimension(0, (int)super.getMinimumSize().getHeight());
            }
        };
        this.fStepDescription.setBackground(this.fDialog.getBackground());
        this.fStepDescription.setBorder((Border)new EmptyBorder(0, 3, 0, 0));
        object = this.fStepDescription.getFont();
        this.fStepDescription.setFont(((Font)object).deriveFont(1));
        this.fSplitPane = new WorkflowSplitPane((Component)this.fOptionsContainer, this.fOutputArea.getComponent());
        this.fTree = new WorkflowTree(this.fConfiguration, this.createSelector(), this.createRunner());
        MJScrollPane mJScrollPane = new MJScrollPane((Component)this.fTree.getComponent());
        mJScrollPane.setHorizontalScrollBarPolicy(31);
        this.fDialog.add((Component)mJScrollPane, (Object)cellConstraints.xywh(2, 2, 1, 3));
        this.fDialog.add((Component)this.fStepDescription, (Object)cellConstraints.xy(4, 2));
        this.fDialog.add((Component)this.fSplitPane.getComponent(), (Object)cellConstraints.xy(4, 4));
        this.fConfiguration.addPropertyChangeListener(this.fPropertyChangeListener);
        Dimension dimension = this.instantiateOptionPanels(this.fConfiguration.getTarget().getWorkflow().getSteps());
        this.fDialog.setSize(dimension.width + this.fTree.getComponent().getPreferredSize().width + 100, dimension.height + 200);
        this.fDialog.setMinimumSize(new Dimension(dimension.width + this.fTree.getComponent().getPreferredSize().width + 30, dimension.height + 30));
        WindowUtils.centerWindowOnScreen((Window)this.fDialog);
        this.fConfiguration.regenerateDefaults();
        this.fTree.updateSteps();
    }

    public DeploymentProcess getCurrentProcess() {
        return this.fProcess;
    }

    private void showStepHelp() {
        if (this.fSelectedStep != null) {
            String string = PluginManager.resolveHelpMapPath(this.fConfiguration.getTarget().getHelpMapPath());
            MLHelpServices.cshDisplayTopic((Object)this.fDialog, (String)string, (String)this.fSelectedStep.getHelpKey());
        }
    }

    private ParameterRunnable<WorkflowStep> createSelector() {
        return new ParameterRunnable<WorkflowStep>(){

            public void run(WorkflowStep workflowStep) {
                WorkflowDialog.this.selectStep(workflowStep);
            }
        };
    }

    private Converter<WorkflowStep, DeploymentProcess> createRunner() {
        return new Converter<WorkflowStep, DeploymentProcess>(){

            public DeploymentProcess convert(WorkflowStep workflowStep) {
                return WorkflowDialog.this.createProcess(workflowStep);
            }
        };
    }

    private void dispose() {
        this.fConfiguration.removePropertyChangeListener(this.fPropertyChangeListener);
        this.fRunButton.removeActionListener(this.fActionListener);
        this.fSkipCheckBox.removeItemListener(this.fItemListener);
        for (ProjectComponent object : this.fOptionPanels.values()) {
            object.dispose();
        }
        this.fDialog.removeWindowListener((WindowListener)this.fWindowAdapter);
        this.fDialog.dispose();
        this.fOutputModelByStepKey.clear();
        this.fOutputArea.dispose();
        this.fOptionsContainer.removeAll();
        this.fTree.dispose();
        this.fOptionPanels.clear();
        for (OutputAreaModel outputAreaModel : this.fOutputModelByStepKey.values()) {
            outputAreaModel.dispose();
        }
        this.fOutputModelByStepKey.clear();
    }

    private void setVisible(boolean bl) {
        if (bl) {
            this.fDialog.show();
        } else {
            this.fDialog.setVisible(bl);
        }
    }

    private void selectStep(WorkflowStep workflowStep) {
        Object object;
        if (this.fSelectedStep != null) {
            this.getOutputModelForStep(this.fSelectedStep).getLogSource().unbind();
        }
        this.fSelectedStep = workflowStep;
        this.fOptionsContainer.removeAll();
        Component component = this.getOptionPanel(workflowStep);
        if (component != null) {
            if (TreeUtils.findComponent((Component)component, JTabbedPane.class) == null && TreeUtils.findComponent((Component)component, JScrollPane.class) == null) {
                object = new MJScrollPane(component);
                object.setBorder(null);
                object.getViewport().setBorder(null);
                this.fOptionsContainer.add((Component)object);
            } else {
                this.fOptionsContainer.add(component);
            }
        }
        this.fSkipCheckBox.setVisible(this.fSelectedStep.isSkippable());
        this.fIgnoreItemChange = true;
        this.fSkipCheckBox.setSelected(this.fConfiguration.isWorkflowStepSkipped(this.fSelectedStep));
        this.fIgnoreItemChange = false;
        this.fOptionsContainer.revalidate();
        this.fOptionsContainer.repaint();
        this.fRunButton.setEnabled(this.fProcess == null && this.fConfiguration.isStepAccessible(this.fSelectedStep) && (this.fSelectedStep.getScript() != null || !this.fSelectedStep.getSubSteps().isEmpty()));
        this.fRunButton.setVisible(this.fSelectedStep.getScript() != null || !this.fSelectedStep.getSubSteps().isEmpty());
        this.fRunButton.setIcon(workflowStep.getScript() != null ? RUN_STEP_ICON : RUN_MULTI_STEP_ICON);
        this.fHelpComponent.setVisible(this.fSelectedStep.getHelpKey() != null);
        object = this.fSelectedStep.getDescription();
        if (object == null) {
            object = "";
        }
        this.fStepDescription.setText("<html>" + (String)object + "</html>");
        this.fOutputArea.setModel(this.getOutputModelForStep(workflowStep));
    }

    private void runCurrentStep() {
        this.fTree.runToStep(this.fSelectedStep, this.fSelectedStep);
    }

    private DeploymentProcess createProcess(final WorkflowStep workflowStep) {
        try {
            DeploymentProcess deploymentProcess;
            if (ProjectGUI.getInstance().getCurrentProject() != this.fProject) {
                return null;
            }
            this.fProcess = deploymentProcess = DeploymentEngine.createWorkflowStepProcess(this.fProject, workflowStep);
            this.fConfiguration.setWorkflowStepResult(workflowStep, null);
            this.fProcess.addMonitor(new DeploymentProcessMonitor(){

                public void subProcessStarted(SubProcessType subProcessType) {
                }

                public void commandStarted(String string) {
                }

                public void commandOutput(String string) {
                }

                public void commandError(String string) {
                }

                public void finished() {
                    this.finish(WorkflowStepResult.COMPLETED);
                }

                public void failed() {
                    this.finish(WorkflowStepResult.ERROR);
                }

                public void canceled() {
                    this.finish(null);
                }

                private void finish(WorkflowStepResult workflowStepResult) {
                    WorkflowDialog.this.fConfiguration.setWorkflowStepResult(workflowStep, workflowStepResult);
                    WorkflowDialog.this.fTree.updateSteps();
                    MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            WorkflowDialog.this.fTree.notifyStopped();
                            WorkflowDialog.this.fRunButton.setEnabled(WorkflowDialog.this.fConfiguration.isStepAccessible(WorkflowDialog.this.fSelectedStep) && (WorkflowDialog.this.fSelectedStep.getScript() != null || !WorkflowDialog.this.fSelectedStep.getSubSteps().isEmpty()));
                            WorkflowDialog.this.fBusyAffordance.stop();
                            WorkflowDialog.this.fProcess = null;
                        }
                    });
                }
            });
            this.fRunButton.setEnabled(false);
            this.fBusyAffordance.start();
            this.fTree.notifyStepRunning(workflowStep);
            ProjectManager.waitForSave(this.fProject);
            ProjectGUI.getInstance().getCurrentClient().disableChangeActionsWhileRunning(deploymentProcess);
            this.getOutputModelForStep(workflowStep).getLogSource().setProcess(deploymentProcess);
            return deploymentProcess;
        }
        catch (InvalidProjectException invalidProjectException) {
            MJOptionPane.showMessageDialog((Component)this.fDialog, (Object)invalidProjectException.getMessage(), (String)BuiltInResources.getString("validation.error.title"), (int)0);
            return null;
        }
    }

    public OutputAreaModel getOutputModelForStep(WorkflowStep workflowStep) {
        OutputAreaModel outputAreaModel = this.fOutputModelByStepKey.get(workflowStep.getKey());
        if (outputAreaModel == null) {
            outputAreaModel = new OutputAreaModel(this.fProject, workflowStep.getScript() != null);
            for (OutputTabDefinition outputTabDefinition : workflowStep.getOutputTabs()) {
                outputAreaModel.addExtraTab(outputTabDefinition);
            }
            this.fOutputModelByStepKey.put(workflowStep.getKey(), outputAreaModel);
        }
        return outputAreaModel;
    }

    private Dimension instantiateOptionPanels(List<WorkflowStep> list) {
        Dimension dimension = new Dimension(0, 0);
        for (WorkflowStep workflowStep : list) {
            Component component = this.getOptionPanel(workflowStep);
            Dimension dimension2 = component.getPreferredSize();
            dimension.width = Math.max(dimension.width, dimension2.width);
            dimension.height = Math.max(dimension.height, dimension2.height);
            Dimension dimension3 = this.instantiateOptionPanels(workflowStep.getSubSteps());
            dimension.width = Math.max(dimension.width, dimension3.width);
            dimension.height = Math.max(dimension.height, dimension3.height);
        }
        return dimension;
    }

    private Component getOptionPanel(WorkflowStep workflowStep) {
        ProjectComponent projectComponent = this.fOptionPanels.get(workflowStep.getKey());
        if (projectComponent == null) {
            if (workflowStep.getOptionsWidgetClassName() != null) {
                try {
                    Class<?> clazz = Class.forName(workflowStep.getOptionsWidgetClassName());
                    Constructor<?> constructor = clazz.getConstructor(ReadableConfiguration.class);
                    projectComponent = (ProjectComponent)constructor.newInstance(this.fConfiguration);
                }
                catch (Exception exception) {
                    throw new IllegalStateException(exception);
                }
            } else if (workflowStep.getParamSets().isEmpty()) {
                projectComponent = new ParamSetPanel(this.fProject, new ParamSet("paramset_" + workflowStep.getKey()), false, true, new ArrayList<String>(0));
            } else if (workflowStep.getParamSets().size() == 1) {
                projectComponent = new ParamSetPanel(this.fProject, workflowStep.getParamSets().get(0), false, true, new ArrayList<String>(0));
            } else if (workflowStep.getParamSets().size() > 1) {
                projectComponent = new TabbedParamSetPanel(this.fProject, workflowStep.getParamSets());
            }
            this.fOptionPanels.put(workflowStep.getKey(), projectComponent);
        }
        return projectComponent == null ? null : projectComponent.getComponent();
    }

    static {
        RUN_STEP_ICON = BuiltInResources.getIcon("play_12x12.png");
        RUN_MULTI_STEP_ICON = BuiltInResources.getIcon("run_multi_step.png");
    }
}

