/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui;

import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.project.impl.settingsui.AbstractParamWidget;
import com.mathworks.util.Log;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;

public class VersionWidget
extends AbstractParamWidget<String> {
    private final MJPanel fComponent = new MJPanel((LayoutManager)new FlowLayout(0));
    private final MJComboBox fMinorVersion;
    private final MJComboBox fMajorVersion;
    private static final int MIN_MAJOR_VERSION = 1;
    private static final int MAX_MAJOR_VERSION = 9;
    private static final int MIN_MINOR_VERSION = 0;
    private static final int MAX_MINOR_VERSION = 9;

    public VersionWidget(String string, String string2) {
        this.fComponent.setOpaque(false);
        this.fMajorVersion = new MJComboBox();
        this.fMinorVersion = new MJComboBox();
        int n = Math.min(1, 0);
        int n2 = Math.max(9, 9);
        for (int i = n; i <= n2; ++i) {
            if (i >= 1 && i <= 9) {
                this.fMajorVersion.addItem((Object)i);
            }
            if (i < 0 || i > 9) continue;
            this.fMinorVersion.addItem((Object)i);
        }
        this.fMinorVersion.addItemListener(this.createItemListener());
        this.fMajorVersion.addItemListener(this.createItemListener());
        this.fMajorVersion.setName(string + ".major.combo");
        this.fMinorVersion.setName(string + ".minor.combo");
        this.fMajorVersion.setOpaque(false);
        this.fMinorVersion.setOpaque(false);
        MJLabel mJLabel = new MJLabel(".");
        mJLabel.setName(string + ".pointlabel");
        mJLabel.setOpaque(false);
        this.fComponent.add((Component)this.fMajorVersion);
        this.fComponent.add((Component)mJLabel);
        this.fComponent.add((Component)this.fMinorVersion);
        if (string2 != null) {
            this.fMajorVersion.setToolTipText(string2);
            this.fMinorVersion.setToolTipText(string2);
            mJLabel.setToolTipText(string2);
        }
    }

    public void setData(String string) {
        int n = 1;
        int n2 = 0;
        int n3 = string.indexOf(46);
        try {
            n = Integer.parseInt(string.substring(0, n3));
            n2 = Integer.parseInt(string.substring(n3 + 1));
        }
        catch (RuntimeException runtimeException) {
            Log.logException((Exception)runtimeException);
        }
        if (n < 1 || n > 9) {
            Log.logException((Exception)new IllegalArgumentException("Version number out of display range: " + string));
            n = 1;
        }
        if (n2 < 0 || n2 > 9) {
            Log.logException((Exception)new IllegalArgumentException("Version number out of display range: " + string));
            n2 = 0;
        }
        this.fMajorVersion.setSelectedItem((Object)n);
        this.fMinorVersion.setSelectedItem((Object)n2);
    }

    public String getData() {
        return this.fMajorVersion.getSelectedItem() + "." + this.fMinorVersion.getSelectedItem();
    }

    public void setEnabled(boolean bl) {
        this.fMajorVersion.setEnabled(bl);
        this.fMinorVersion.setEnabled(bl);
    }

    public Component getComponent() {
        return this.fComponent;
    }

    public void dispose() {
    }
}

