/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.project.impl.settingsui.SettingComponentDefinition;
import com.mathworks.project.impl.settingsui.SettingsPanelBuilder;
import com.mathworks.util.tree.TreeUtils;
import com.mathworks.widgets.SyntaxTextPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JScrollPane;

final class MacSettingsPanelBuilder
implements SettingsPanelBuilder {
    private final GridBagConstraints fConstraints;
    private MJPanel fComponent = new MJPanel((LayoutManager)new GridBagLayout());
    private String fCurrentCategoryName;
    private String fPendingLabel;
    private boolean fSuppressPadding;
    private Component fLastLargeNonGrowingComponent;
    private int fComponentCount;
    private boolean fFinished;

    MacSettingsPanelBuilder() {
        this.fComponent.setOpaque(false);
        this.fConstraints = new GridBagConstraints();
        this.fConstraints.gridx = 0;
        this.fConstraints.gridy = 0;
        this.fConstraints.weightx = 1.0;
    }

    @Override
    public void startCategory(String string) {
        this.fPendingLabel = string;
        this.fCurrentCategoryName = string;
        if (this.fConstraints.gridy > 0) {
            this.addCategoryPadding();
        }
    }

    private void addCategoryPadding() {
        MJPanel mJPanel = new MJPanel(){

            public Dimension getPreferredSize() {
                return new Dimension(4, 4);
            }
        };
        mJPanel.setOpaque(false);
        this.fConstraints.gridwidth = 2;
        this.fConstraints.gridx = 0;
        this.fConstraints.fill = 2;
        this.fConstraints.weighty = 0.0;
        this.fConstraints.fill = 0;
        this.fComponent.add((Component)mJPanel, (Object)this.fConstraints);
        this.fConstraints.gridwidth = 1;
        ++this.fConstraints.gridy;
    }

    @Override
    public String getCurrentCategoryName() {
        return this.fCurrentCategoryName;
    }

    @Override
    public void endCategory() {
        this.fCurrentCategoryName = null;
        this.addCategoryPadding();
    }

    private void addPendingLabel(Component component) {
        if (this.fPendingLabel != null) {
            this.prepareForLabel(component);
            this.fComponent.add((Component)new MJLabel(this.fPendingLabel), (Object)this.fConstraints);
            this.fPendingLabel = null;
        }
    }

    @Override
    public void addComponent(SettingComponentDefinition settingComponentDefinition) {
        if (settingComponentDefinition.getLabel() == null) {
            this.addComponent(settingComponentDefinition.getComponent(), false);
            return;
        }
        this.addPendingLabel(settingComponentDefinition.getComponent());
        MJLabel mJLabel = new MJLabel(settingComponentDefinition.getLabel());
        if (this.fCurrentCategoryName == null) {
            this.prepareForLabel(settingComponentDefinition.getComponent());
            this.fComponent.add((Component)mJLabel, (Object)this.fConstraints);
            this.prepareForComponent(settingComponentDefinition.getComponent());
            this.fComponent.add(settingComponentDefinition.getComponent(), (Object)this.fConstraints);
        } else {
            boolean bl = MacSettingsPanelBuilder.isLarge(settingComponentDefinition.getComponent());
            MJPanel mJPanel = new MJPanel((LayoutManager)new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            mJPanel.setOpaque(false);
            gridBagConstraints.insets = new Insets(0, 0, 0, 3);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            int n = gridBagConstraints.anchor = bl ? 12 : 13;
            if (bl) {
                gridBagConstraints.insets.top = 8;
            }
            mJPanel.add((Component)mJLabel, (Object)gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 3, 0, 0);
            if (bl) {
                gridBagConstraints.insets.top = 6;
            }
            gridBagConstraints.fill = 2;
            mJPanel.add(settingComponentDefinition.getComponent(), (Object)gridBagConstraints);
            this.prepareForComponent(settingComponentDefinition.getComponent());
            this.fComponent.add((Component)mJPanel, (Object)this.fConstraints);
        }
        ++this.fConstraints.gridy;
    }

    @Override
    public void addComponent(Component component, boolean bl) {
        this.addPendingLabel(component);
        this.prepareForComponent(component);
        if (bl) {
            this.fConstraints.gridwidth = 2;
            this.fConstraints.gridx = 0;
            this.fConstraints.anchor = 10;
        }
        this.fComponent.add(component, (Object)this.fConstraints);
        ++this.fConstraints.gridy;
        this.fConstraints.gridwidth = 1;
    }

    @Override
    public void addPadding() {
        if (this.fSuppressPadding) {
            this.fConstraints.gridwidth = 2;
            this.fConstraints.gridx = 0;
            MJPanel mJPanel = new MJPanel();
            mJPanel.setOpaque(false);
            this.fConstraints.insets = new Insets(16, 3, 3, 3);
            this.fComponent.add((Component)mJPanel, (Object)this.fConstraints);
        } else {
            this.fConstraints.gridx = 0;
            this.fConstraints.gridwidth = 2;
            this.fConstraints.fill = 1;
            this.fConstraints.weightx = 1.0;
            this.fConstraints.weighty = 1.0;
            MJPanel mJPanel = new MJPanel();
            mJPanel.setOpaque(false);
            this.fComponent.add((Component)mJPanel, (Object)this.fConstraints);
            MJPanel mJPanel2 = this.fComponent;
            this.fComponent = new MJPanel((LayoutManager)new FormLayout("0dlu:grow, fill:d, 0dlu:grow", "fill:d:grow"));
            this.fComponent.setOpaque(false);
            CellConstraints cellConstraints = new CellConstraints();
            this.fComponent.add((Component)mJPanel2, (Object)cellConstraints.xy(2, 1));
        }
    }

    @Override
    public JComponent getComponent() {
        if (!this.fFinished) {
            if (this.fLastLargeNonGrowingComponent != null && this.fComponentCount == 1) {
                this.fComponent.remove(this.fLastLargeNonGrowingComponent);
                this.fComponent = new MJPanel((LayoutManager)new FormLayout("fill:d:grow", "fill:d:grow"));
                this.fComponent.add(this.fLastLargeNonGrowingComponent, (Object)new CellConstraints(1, 1));
            }
            this.fFinished = true;
        }
        return this.fComponent;
    }

    private static boolean isLarge(Component component) {
        return component != null && (TreeUtils.findComponent((Component)component, JScrollPane.class) != null || component.getPreferredSize().getHeight() > 32.0);
    }

    private void prepareForLabel(Component component) {
        boolean bl = MacSettingsPanelBuilder.isLarge(component);
        if (this.fConstraints.gridy == 0) {
            this.fConstraints.insets = new Insets(16, 3, 3, 3);
            if (bl) {
                this.fConstraints.insets.top += 4;
            }
        } else {
            this.fConstraints.insets = new Insets(3, 3, 3, 3);
            if (bl) {
                this.fConstraints.insets.top += 7;
            }
        }
        this.fConstraints.anchor = bl ? 12 : 13;
        this.fConstraints.fill = 0;
        this.fConstraints.gridx = 0;
        this.fConstraints.gridwidth = 1;
        this.fConstraints.weighty = 0.0;
    }

    private void prepareForComponent(Component component) {
        boolean bl = TreeUtils.findComponent((Component)component, JScrollPane.class) != null;
        boolean bl2 = TreeUtils.findComponent((Component)component, SyntaxTextPane.class) != null;
        this.fConstraints.insets = this.fConstraints.gridy == 0 ? new Insets(16, 8, 3, 16) : new Insets(3, 8, 3, 16);
        if (bl && !bl2) {
            this.fConstraints.insets.bottom = 16;
        }
        if (bl2) {
            this.fConstraints.fill = 1;
            this.fConstraints.weightx = 1.0;
            this.fConstraints.gridx = 1;
            this.fConstraints.weighty = 1.0;
            this.fSuppressPadding = true;
        } else {
            this.fLastLargeNonGrowingComponent = component;
            this.fConstraints.anchor = 17;
            this.fConstraints.fill = 0;
            this.fConstraints.gridx = 1;
            this.fConstraints.gridwidth = 1;
            this.fConstraints.weightx = 0.0;
        }
        ++this.fComponentCount;
    }
}

