/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.model;

import com.mathworks.project.api.ConfigurationValidator;
import com.mathworks.project.api.ReadableConfiguration;
import com.mathworks.project.api.Severity;
import com.mathworks.project.api.ValidationMessage;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.DynamicFileSubset;
import com.mathworks.project.impl.model.DynamicTargetAttribute;
import com.mathworks.project.impl.model.DynamicTargetScript;
import com.mathworks.project.impl.model.FileSetDefinition;
import com.mathworks.project.impl.model.LicensedObject;
import com.mathworks.project.impl.model.MatlabExpression;
import com.mathworks.project.impl.model.PackageType;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.model.ParamSet;
import com.mathworks.project.impl.model.Plugin;
import com.mathworks.project.impl.model.Profile;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.model.ProjectTabDefinition;
import com.mathworks.project.impl.model.ProjectType;
import com.mathworks.project.impl.model.ResourceStringProvider;
import com.mathworks.project.impl.model.Workflow;
import com.mathworks.project.impl.model.WorkflowStep;
import com.mathworks.project.impl.model.XslInput;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.Icon;

public final class Target
implements LicensedObject {
    private final String fKey;
    private final String fName;
    private final String fDescription;
    private final String fProductName;
    private final String fClientClassName;
    private final String fDetailedTooltipProviderClassName;
    private final Set<String> fLicenseNames;
    private final List<Profile> fProfiles;
    private final String fHelpMapPath;
    private final String fHelpTopicKey;
    private final Plugin fPlugin;
    private final DynamicTargetScript fBuildScript;
    private final DynamicTargetScript fPackageScript;
    private final DynamicTargetAttribute fPackageEnable;
    private final DynamicTargetAttribute fEnable;
    private final DynamicTargetAttribute fProjectWindowTitle;
    private final DynamicTargetAttribute fNewWindowTitle;
    private final DynamicTargetAttribute fSettingsDialogWidth;
    private final DynamicTargetAttribute fSettingsDialogHeight;
    private final List<PackageType> fPackageTypes;
    private final List<ProjectType> fProjectTypes;
    private final Icon fIcon;
    private final List<ParamSet> fParameters;
    private final List<ParamSet> fNonWorkflowParameters;
    private final List<FileSetDefinition> fFileSets;
    private final List<ProjectTabDefinition> fProjectTabs;
    private final Map<String, String> fExtraAttributes;
    private final ConfigurationValidator fValidator;
    private final ResourceStringProvider fResources;
    private final String fProjectXslOut;
    private final String fProjectXslIn;
    private final DynamicFileSubset fBuildDeliverables;
    private final MatlabExpression fProjectOpenCode;
    private final MatlabExpression fProjectCloseCode;
    private final MatlabExpression fWorkflowResetCode;
    private final boolean fRequiresMatlabPathInProjectFile;
    private final Workflow fWorkflow;
    private final String fSettingsHelpKeyGeneratorClass;

    public Target(String string, String string2, String string3, String string4, String string5, String string6, Set<String> set, List<Profile> list, String string7, String string8, Plugin plugin, Icon icon, DynamicTargetAttribute dynamicTargetAttribute, DynamicTargetAttribute dynamicTargetAttribute2, DynamicTargetAttribute dynamicTargetAttribute3, DynamicTargetAttribute dynamicTargetAttribute4, DynamicTargetAttribute dynamicTargetAttribute5, List<ParamSet> list2, List<FileSetDefinition> list3, List<ProjectTabDefinition> list4, Map<String, String> map, DynamicTargetScript dynamicTargetScript, List<PackageType> list5, DynamicTargetScript dynamicTargetScript2, DynamicTargetAttribute dynamicTargetAttribute6, ConfigurationValidator configurationValidator, ResourceStringProvider resourceStringProvider, String string9, String string10, DynamicFileSubset dynamicFileSubset, MatlabExpression matlabExpression, MatlabExpression matlabExpression2, MatlabExpression matlabExpression3, boolean bl, Workflow workflow, String string11) {
        this.fKey = string;
        this.fName = string2;
        this.fDescription = string3;
        this.fIcon = icon;
        this.fWorkflow = workflow;
        this.fLicenseNames = new HashSet<String>(set);
        this.fClientClassName = string5;
        this.fDetailedTooltipProviderClassName = string6;
        this.fProfiles = new ArrayList<Profile>(list);
        this.fHelpMapPath = string7;
        this.fHelpTopicKey = string8;
        this.fPlugin = plugin;
        this.fEnable = dynamicTargetAttribute;
        this.fProjectWindowTitle = dynamicTargetAttribute2;
        this.fNewWindowTitle = dynamicTargetAttribute3;
        this.fSettingsDialogWidth = dynamicTargetAttribute4;
        this.fSettingsDialogHeight = dynamicTargetAttribute5;
        this.fProductName = string4;
        this.fProjectXslOut = string9;
        this.fProjectXslIn = string10;
        this.fBuildScript = dynamicTargetScript;
        this.fProjectTabs = new ArrayList<ProjectTabDefinition>(list4);
        this.fNonWorkflowParameters = new ArrayList<ParamSet>(list2);
        this.fParameters = this.getAllParamSets();
        this.fFileSets = new ArrayList<FileSetDefinition>(list3);
        this.fExtraAttributes = new TreeMap<String, String>(map);
        this.fPackageTypes = new ArrayList<PackageType>(list5);
        this.fProjectTypes = new ArrayList<ProjectType>();
        this.fPackageScript = dynamicTargetScript2;
        this.fPackageEnable = dynamicTargetAttribute6;
        this.fValidator = configurationValidator;
        this.fResources = resourceStringProvider;
        this.fBuildDeliverables = dynamicFileSubset;
        this.fProjectOpenCode = matlabExpression;
        this.fProjectCloseCode = matlabExpression2;
        this.fWorkflowResetCode = matlabExpression3;
        this.fRequiresMatlabPathInProjectFile = bl;
        this.fSettingsHelpKeyGeneratorClass = string11;
    }

    public String getClientClassName() {
        return this.fClientClassName;
    }

    public String getDetailedToolTipProviderClassName() {
        return this.fDetailedTooltipProviderClassName;
    }

    public List<Profile> getProfiles() {
        return new ArrayList<Profile>(this.fProfiles);
    }

    public Profile getProfile(String string) {
        for (Profile profile : this.fProfiles) {
            if (!profile.getKey().equals(string)) continue;
            return profile;
        }
        return null;
    }

    public Profile getDefaultProfile() {
        for (Profile profile : this.fProfiles) {
            if (profile.getSelectedAttribute() != null) continue;
            return profile;
        }
        return null;
    }

    public MatlabExpression getProjectOpenCode() {
        return this.fProjectOpenCode;
    }

    public MatlabExpression getProjectCloseCode() {
        return this.fProjectCloseCode;
    }

    public MatlabExpression getWorflowResetCode() {
        return this.fWorkflowResetCode;
    }

    public boolean requiresMatlabPathInProjectFile() {
        return this.fRequiresMatlabPathInProjectFile;
    }

    public boolean supportsPackaging() {
        return this.fPackageScript != null;
    }

    public Plugin getPlugin() {
        return this.fPlugin;
    }

    public boolean isEnabled(XmlReader xmlReader) {
        return this.fEnable == null || this.fEnable.evaluateBoolean(new XslInput(xmlReader));
    }

    public DynamicTargetAttribute getProjectWindowTitle() {
        return this.fProjectWindowTitle;
    }

    public DynamicTargetAttribute getNewWindowTitle() {
        return this.fNewWindowTitle;
    }

    public DynamicTargetAttribute getSettingsDialogWidth() {
        return this.fSettingsDialogWidth;
    }

    public DynamicTargetAttribute getSettingsDialogHeight() {
        return this.fSettingsDialogHeight;
    }

    public String getProjectXslOut() {
        return this.fProjectXslOut;
    }

    public String getProjectXslIn() {
        return this.fProjectXslIn;
    }

    public Icon getIcon() {
        return this.fIcon;
    }

    public String getKey() {
        return this.fKey;
    }

    public String getName() {
        return this.fName;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public DynamicFileSubset getBuildDeliverables() {
        return this.fBuildDeliverables;
    }

    public Param getParam(String string) {
        for (ParamSet paramSet : this.getParamSets()) {
            for (Param param : paramSet.getParams()) {
                if (!param.getKey().equals(string)) continue;
                return param;
            }
        }
        return null;
    }

    public String getCategoryName(Param param) {
        for (ParamSet paramSet : this.getParamSets()) {
            String string = paramSet.getCategoryName(param);
            if (string == null) continue;
            return string;
        }
        return null;
    }

    public ParamSet getParamSet(String string) {
        for (ParamSet paramSet : this.getParamSets()) {
            if (!paramSet.getKey().equals(string)) continue;
            return paramSet;
        }
        return null;
    }

    public String getProductName() {
        return this.fProductName;
    }

    @Override
    public Set<String> getLicenseNames() {
        return new HashSet<String>(this.fLicenseNames);
    }

    public String getHelpMapPath() {
        return this.fHelpMapPath;
    }

    public String getHelpTopicKey() {
        return this.fHelpTopicKey;
    }

    public List<ParamSet> getParamSets() {
        return new Vector<ParamSet>(this.fParameters);
    }

    public List<ParamSet> getNonWorkflowParamSets() {
        return new ArrayList<ParamSet>(this.fNonWorkflowParameters);
    }

    private List<ParamSet> getAllParamSets() {
        LinkedHashSet<ParamSet> linkedHashSet = new LinkedHashSet<ParamSet>();
        linkedHashSet.addAll(this.fNonWorkflowParameters);
        if (this.fWorkflow != null) {
            Target.addParamSets(linkedHashSet, this.fWorkflow.getSteps());
        }
        return new ArrayList<ParamSet>(linkedHashSet);
    }

    private static void addParamSets(Set<ParamSet> set, List<WorkflowStep> list) {
        for (WorkflowStep workflowStep : list) {
            set.addAll(workflowStep.getParamSets());
            Target.addParamSets(set, workflowStep.getSubSteps());
        }
    }

    public List<FileSetDefinition> getFileSets() {
        return new Vector<FileSetDefinition>(this.fFileSets);
    }

    public FileSetDefinition getFileSet(String string) {
        for (FileSetDefinition fileSetDefinition : this.fFileSets) {
            if (!fileSetDefinition.getKey().equals(string)) continue;
            return fileSetDefinition;
        }
        return null;
    }

    public List<ProjectType> getProjectTypes() {
        return new ArrayList<ProjectType>(this.fProjectTypes);
    }

    public void setProjectTypes(List<ProjectType> list) {
        assert (this.fProjectTypes.isEmpty());
        this.fProjectTypes.addAll(list);
    }

    public DynamicTargetScript getBuildScript() {
        return this.fBuildScript;
    }

    public DynamicTargetScript getPackageScript() {
        return this.fPackageScript;
    }

    public DynamicTargetAttribute getPackageEnabledAttribute() {
        return this.fPackageEnable;
    }

    public Workflow getWorkflow() {
        return this.fWorkflow;
    }

    public List<PackageType> getSupportedPackageTypes(Project project) {
        ArrayList<PackageType> arrayList = new ArrayList<PackageType>();
        for (PackageType packageType : this.fPackageTypes) {
            if (!packageType.isEnabled(project)) continue;
            arrayList.add(packageType);
        }
        return arrayList;
    }

    public PackageType getPackageTypeByKey(Project project, String string) {
        for (PackageType packageType : this.getSupportedPackageTypes(project)) {
            if (!packageType.getKey().equals(string)) continue;
            return packageType;
        }
        return null;
    }

    public List<ValidationMessage> validate(Project project) {
        if (this.fValidator == null) {
            return new ArrayList<ValidationMessage>(0);
        }
        return this.fValidator.validate((ReadableConfiguration)project.getConfiguration());
    }

    public boolean isValid(Project project, Configuration configuration) {
        if (this.fValidator == null) {
            return true;
        }
        List list = this.fValidator.validate((ReadableConfiguration)configuration);
        if (list == null) {
            return true;
        }
        for (ValidationMessage validationMessage : list) {
            if (validationMessage.getSeverity() != Severity.ERROR) continue;
            return false;
        }
        return true;
    }

    public Map<String, String> getExtraAttributes() {
        return new TreeMap<String, String>(this.fExtraAttributes);
    }

    public String getResourceString(String string) {
        return this.fResources.getResource(string);
    }

    public List<ProjectTabDefinition> getProjectTabs() {
        return new ArrayList<ProjectTabDefinition>(this.fProjectTabs);
    }

    public String getSettingsHelpKeyGeneratorClassName() {
        return this.fSettingsHelpKeyGeneratorClass;
    }

    public String toString() {
        return this.getName();
    }
}

