/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.model;

import com.mathworks.common.icons.FileTypeIcon;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabPath;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.mlwidgets.explorer.model.realfs.RealFileSystem;
import com.mathworks.mlwidgets.explorer.util.FileSystemUtils;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.InvalidFormatException;
import com.mathworks.project.api.ProjectApi;
import com.mathworks.project.api.ReadableConfiguration;
import com.mathworks.project.api.ReadableEntityInstance;
import com.mathworks.project.api.UnavailableTargetException;
import com.mathworks.project.api.ValidationMessage;
import com.mathworks.project.api.XmlApi;
import com.mathworks.project.api.XmlLooper;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.api.XmlWriter;
import com.mathworks.project.impl.ProjectPrefs;
import com.mathworks.project.impl.model.AutoSaveHandler;
import com.mathworks.project.impl.model.BasicValidator;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.DynamicFileReference;
import com.mathworks.project.impl.model.DynamicFileSubset;
import com.mathworks.project.impl.model.EntityDefinition;
import com.mathworks.project.impl.model.EntityInstance;
import com.mathworks.project.impl.model.FileReferenceMode;
import com.mathworks.project.impl.model.FileSetDefinition;
import com.mathworks.project.impl.model.FileSetInstance;
import com.mathworks.project.impl.model.GeneratedReferenceSet;
import com.mathworks.project.impl.model.InvalidFileSetException;
import com.mathworks.project.impl.model.InvalidParameterValueException;
import com.mathworks.project.impl.model.MatlabExpression;
import com.mathworks.project.impl.model.PackageType;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.model.ParamSet;
import com.mathworks.project.impl.model.Plugin;
import com.mathworks.project.impl.model.PrefsWatcher;
import com.mathworks.project.impl.model.Profile;
import com.mathworks.project.impl.model.ProfileManager;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.model.ProjectApiImpl;
import com.mathworks.project.impl.model.ProjectType;
import com.mathworks.project.impl.model.ProjectVersionUtils;
import com.mathworks.project.impl.model.SaveErrorHandler;
import com.mathworks.project.impl.model.SpecialFile;
import com.mathworks.project.impl.model.Target;
import com.mathworks.project.impl.model.Workflow;
import com.mathworks.project.impl.model.WorkflowStep;
import com.mathworks.project.impl.model.XmlGenerationContext;
import com.mathworks.project.impl.model.XmlGenerationFlag;
import com.mathworks.project.impl.plugin.PluginManager;
import com.mathworks.services.Prefs;
import com.mathworks.util.Converter;
import com.mathworks.util.DeferrableRetriever;
import com.mathworks.util.Log;
import com.mathworks.util.MRUList;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.PlatformInfo;
import com.mathworks.xml.XMLUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class ProjectManager {
    private static SaveErrorHandler sSaveErrorHandler;
    private static final Map<Project, AutoSaveHandler> sAutoSaveHandlers;
    private static final Map<Project, PrefsWatcher> sPrefWatchers;
    private static final MRUList<File> sRecentProjectList;
    private static final List<ChangeListener> sRecentProjectListListeners;
    public static final String PROJECT_ROOT_TAG = "deployment-project";
    public static final String LEGACY_DEPLOYMENT_PROJECT_ROOT_TAG = "project";
    public static final String LEGACY_VERSION = "legacy";
    static final String TEMPLATE_KEY_ATTRIBUTE = "template-key";
    static final String TEMPLATE_NAME_ATTRIBUTE = "template-name";
    static final String TEMPLATE_FILE_ATTRIBUTE = "template-file";

    private ProjectManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        PluginManager.init();
        ProjectApi.setInstance((ProjectApi)new ProjectApiImpl());
        MRUList<File> mRUList = sRecentProjectList;
        synchronized (mRUList) {
            sRecentProjectList.clear();
            String[] stringArray = ProjectPrefs.RECENT_PROJECTS.get();
            for (int i = stringArray.length - 1; i >= 0; --i) {
                sRecentProjectList.add((Object)new File(stringArray[i]));
            }
        }
    }

    public static void waitForSave(Project project) {
        AutoSaveHandler autoSaveHandler = sAutoSaveHandlers.get(project);
        if (autoSaveHandler != null) {
            autoSaveHandler.waitForIdle();
        }
    }

    public static void forceSave(Project project) {
        AutoSaveHandler autoSaveHandler = sAutoSaveHandlers.get(project);
        autoSaveHandler.requestSave();
        autoSaveHandler.waitForIdle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRecentProjectListListener(ChangeListener changeListener) {
        MRUList<File> mRUList = sRecentProjectList;
        synchronized (mRUList) {
            sRecentProjectListListeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeRecentProjectListListener(ChangeListener changeListener) {
        MRUList<File> mRUList = sRecentProjectList;
        synchronized (mRUList) {
            sRecentProjectListListeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRecentProject(File file) {
        MRUList<File> mRUList = sRecentProjectList;
        synchronized (mRUList) {
            sRecentProjectList.add((Object)file);
            ProjectManager.saveRecentProjectList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeRecentProject(File file) {
        MRUList<File> mRUList = sRecentProjectList;
        synchronized (mRUList) {
            sRecentProjectList.remove((Object)file);
            ProjectManager.saveRecentProjectList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveRecentProjectList() {
        MRUList<File> mRUList = sRecentProjectList;
        synchronized (mRUList) {
            String[] stringArray = new String[sRecentProjectList.size()];
            Iterator iterator = sRecentProjectList.iterator();
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = ((File)iterator.next()).getAbsolutePath();
            }
            ProjectPrefs.RECENT_PROJECTS.set(stringArray);
            for (ChangeListener changeListener : sRecentProjectListListeners) {
                changeListener.stateChanged(new ChangeEvent(ProjectManager.class));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<File> getRecentProjects(int n) {
        MRUList<File> mRUList = sRecentProjectList;
        synchronized (mRUList) {
            int n2 = 0;
            ArrayList<File> arrayList = new ArrayList<File>();
            for (File file : sRecentProjectList) {
                if (!file.exists()) continue;
                arrayList.add(file);
                if (++n2 != n) continue;
                break;
            }
            return arrayList;
        }
    }

    public static void setSaveErrorHandler(SaveErrorHandler saveErrorHandler) {
        sSaveErrorHandler = saveErrorHandler;
    }

    public static SaveErrorHandler getSaveErrorHandler() {
        return sSaveErrorHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PrefsWatcher getPrefsWatcher(Project project) {
        Map<Project, PrefsWatcher> map = sPrefWatchers;
        synchronized (map) {
            return sPrefWatchers.get(project);
        }
    }

    public static String getConfigurationName(File file) {
        int n = file.getName().lastIndexOf(46);
        if (n >= 0) {
            return file.getName().substring(0, n);
        }
        return file.getName();
    }

    public static Project createTemporary(ProjectType projectType) {
        File file = new File(new File(System.getProperty("user.dir")), "___temp___.prj");
        return ProjectManager.create(file, projectType, true, false);
    }

    public static Project create(File file, ProjectType projectType) {
        return ProjectManager.create(file, projectType, true);
    }

    public static Project create(File file, ProjectType projectType, boolean bl) {
        return ProjectManager.create(file, projectType, bl, true);
    }

    public static Project create(File file, ProjectType projectType, boolean bl, boolean bl2) {
        Project project = new Project(file, null);
        Target target = projectType.getTarget();
        ProjectManager.installPrefsWatcher(project, target);
        Configuration configuration = new Configuration(ProjectManager.getConfigurationName(file), target, project);
        for (FileSetDefinition object : target.getFileSets()) {
            configuration.getFileSet(object.getKey()).normalize();
        }
        if (bl2) {
            try {
                ProjectManager.save(project);
            }
            catch (IOException iOException) {
                ProjectManager.getSaveErrorHandler().saveFailed(project, iOException);
                return null;
            }
        }
        if (projectType.getTemplate() != null) {
            Configuration configuration2 = projectType.getTemplate().getConfiguration();
            for (ParamSet paramSet : configuration2.getTarget().getParamSets()) {
                for (Param param : paramSet.getParams()) {
                    Object object = configuration2.getSetParameterValue(param.getKey());
                    if (object == null) continue;
                    configuration.setParamAsObject(param.getKey(), object);
                }
            }
        }
        configuration.loadingFinished();
        if (bl && target.getProjectOpenCode() != null) {
            target.getProjectOpenCode().evaluate(project, true);
        }
        if (bl2) {
            ProjectManager.installAutoSave(project);
            if (projectType.getTemplate() != null) {
                ProjectManager.forceSave(project);
            }
        }
        return project;
    }

    public static Project closeAndOpen(Project project, Runnable runnable, File file) throws InvalidFormatException, UnavailableTargetException {
        Target target;
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("This method is not safe to invoke on the EDT.");
        }
        Project project2 = ProjectManager.load(file, false, false);
        if (project != null) {
            ProjectManager.closeWithUiCallback(project, runnable);
        }
        if ((target = project2.getConfiguration().getTarget()).getProjectOpenCode() != null) {
            target.getProjectOpenCode().evaluate(project2, true);
        }
        return project2;
    }

    public static Project closeAndCreate(Project project, Runnable runnable, File file, ProjectType projectType) {
        Target target;
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("This method is not safe to invoke on the EDT.");
        }
        Project project2 = ProjectManager.create(file, projectType, false);
        if (project2 == null) {
            return project2;
        }
        if (project != null) {
            ProjectManager.closeWithUiCallback(project, runnable);
        }
        if ((target = project2.getConfiguration().getTarget()).getProjectOpenCode() != null) {
            target.getProjectOpenCode().evaluate(project2, true);
        }
        return project2;
    }

    private static void closeWithUiCallback(Project project, final Runnable runnable) {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                runnable.run();
                countDownLatch.countDown();
            }
        });
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException(interruptedException);
        }
        ProjectManager.close(project, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close(Project project, boolean bl) {
        Object object;
        Object object2 = sAutoSaveHandlers;
        synchronized (object2) {
            object = sAutoSaveHandlers.remove(project);
            if (object != null) {
                ((AutoSaveHandler)object).destroy();
            }
        }
        object2 = sPrefWatchers;
        synchronized (object2) {
            object = sPrefWatchers.remove(project);
            if (object != null) {
                ((PrefsWatcher)object).destroy();
            }
        }
        object2 = project.getConfiguration().getTarget().getProjectCloseCode();
        if (object2 != null) {
            ((MatlabExpression)object2).evaluate(project, bl);
        }
    }

    public static DeferrableRetriever<ProjectType> createTypeRetriever(final FileSystemEntry fileSystemEntry) {
        return new DeferrableRetriever<ProjectType>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(ParameterRunnable<ProjectType> parameterRunnable, Runnable runnable) {
                Map map;
                if (fileSystemEntry.isReal()) {
                    map = sAutoSaveHandlers;
                    synchronized (map) {
                        File file = fileSystemEntry.getLocation().toFile();
                        for (Project project : sAutoSaveHandlers.keySet()) {
                            if (!project.getFile().equals(file)) continue;
                            parameterRunnable.run((Object)project.getConfiguration().getProjectType());
                            return;
                        }
                    }
                }
                try {
                    map = ProjectManager.getStandardProjectXml(fileSystemEntry, false);
                    if (map != null) {
                        parameterRunnable.run((Object)ProjectManager.getTypeForStandardProject(fileSystemEntry.getLocation().toFile(), (XmlReader)map));
                    } else {
                        parameterRunnable.run(null);
                    }
                }
                catch (UnavailableTargetException unavailableTargetException) {
                    parameterRunnable.run(null);
                }
            }
        };
    }

    public static boolean isProject(File file) {
        try {
            XmlReader xmlReader = XmlApi.getInstance().read(file);
            return xmlReader.getCurrentElementName().equals(PROJECT_ROOT_TAG) || xmlReader.getCurrentElementName().equals(LEGACY_DEPLOYMENT_PROJECT_ROOT_TAG);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isUnsupportedProjectVersion(File file) throws IOException {
        String string;
        XmlReader xmlReader = XmlApi.getInstance().read(file);
        if (xmlReader.getCurrentElementName().equals(PROJECT_ROOT_TAG) && (string = xmlReader.getChild(new String[]{"configuration"}).readAttribute("target")) != null) {
            Target target = PluginManager.getTarget(string);
            return target != null && !ProjectVersionUtils.canConvertToVersion(xmlReader, target.getPlugin(), target.getPlugin().getVersion());
        }
        return false;
    }

    public static boolean isNonStandardProjectFormat(File file) throws IOException, InvalidFormatException, UnavailableTargetException {
        XmlReader xmlReader = XmlApi.getInstance().read(file);
        if (xmlReader.getCurrentElementName().equals(PROJECT_ROOT_TAG)) {
            return false;
        }
        for (Target target : PluginManager.getTargets()) {
            if (target.getProjectXslIn() == null) continue;
            try {
                XmlReader xmlReader2 = XmlApi.getInstance().read(XMLUtils.transform((String)xmlReader.getXML(), (String)target.getProjectXslIn()));
                if (!xmlReader2.getCurrentElementName().equals(PROJECT_ROOT_TAG)) continue;
                return true;
            }
            catch (Exception exception) {
                Log.logException((Exception)exception);
            }
        }
        if (xmlReader.getCurrentElementName().equals(LEGACY_DEPLOYMENT_PROJECT_ROOT_TAG)) {
            throw new UnavailableTargetException("This is a legacy deployment project and MATLAB Compiler is not installed");
        }
        throw new InvalidFormatException("Unrecognized format", file);
    }

    private static Target getTarget(XmlReader xmlReader, boolean bl) {
        if (xmlReader == null) {
            return null;
        }
        String string = xmlReader.getChild(new String[]{"configuration"}).readAttribute("target");
        if (string == null) {
            return null;
        }
        return bl ? PluginManager.getLicensedTarget(string) : PluginManager.getTarget(string);
    }

    public static Target getTarget(File file) {
        try {
            XmlReader xmlReader = ProjectManager.getStandardProjectXml(RealFileSystem.getInstance().getEntry(new FileLocation(file)), false);
            return ProjectManager.getTarget(xmlReader, false);
        }
        catch (UnavailableTargetException unavailableTargetException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static XmlReader getStandardProjectXml(FileSystemEntry fileSystemEntry, boolean bl) throws UnavailableTargetException {
        XmlReader xmlReader;
        try {
            xmlReader = XmlApi.getInstance().read(FileSystemUtils.readText((FileSystemEntry)fileSystemEntry, (String)"UTF8"));
        }
        catch (IOException iOException) {
            return null;
        }
        if (xmlReader.getCurrentElementName().equals(PROJECT_ROOT_TAG)) {
            return xmlReader;
        }
        for (Target target : bl ? PluginManager.getLicensedTargets() : PluginManager.getTargets()) {
            if (target.getProjectXslIn() == null) continue;
            try {
                XmlReader xmlReader2 = XmlApi.getInstance().read(XMLUtils.transform((String)xmlReader.getXML(), (String)target.getProjectXslIn()));
                if (!xmlReader2.getCurrentElementName().equals(PROJECT_ROOT_TAG)) continue;
                return xmlReader2;
            }
            catch (Exception exception) {
                Log.logException((Exception)exception);
            }
        }
        if (xmlReader.getCurrentElementName().equals(LEGACY_DEPLOYMENT_PROJECT_ROOT_TAG)) {
            throw new UnavailableTargetException("This is a legacy deployment project and MATLAB Compiler is not installed");
        }
        return null;
    }

    private static ProjectType getTypeForStandardProject(File file, XmlReader xmlReader) {
        final Target target = ProjectManager.getTarget(xmlReader, false);
        if (target == null) {
            return null;
        }
        List<ProjectType> list = target.getProjectTypes();
        if (list.size() == 1 && list.get(0).getTemplate() == null) {
            return list.get(0);
        }
        try {
            Project project = ProjectManager.loadStandardProject(file, xmlReader, true, false, FileTypeIcon.GENERIC.getIcon(), new Converter<String, Target>(){

                public Target convert(String string) {
                    return target;
                }
            });
            ProjectType projectType = project.getConfiguration().getProjectType();
            ProjectManager.close(project, false);
            return projectType;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Project load(File file, boolean bl, boolean bl2) throws InvalidFormatException, UnavailableTargetException {
        XmlReader xmlReader = null;
        try {
            xmlReader = ProjectManager.getStandardProjectXml(RealFileSystem.getInstance().getEntry(new FileLocation(file)), true);
        }
        catch (IOException iOException) {
            Log.logException((Exception)iOException);
            throw new InvalidFormatException("Could not read file: ", file);
        }
        if (xmlReader == null) {
            throw new InvalidFormatException("Could not read file: ", file);
        }
        return ProjectManager.loadStandardProject(file, xmlReader, bl, bl2, null, new Converter<String, Target>(){

            public Target convert(String string) {
                return PluginManager.getLicensedTarget(string);
            }
        });
    }

    public static Project loadStandardProject(File file, XmlReader xmlReader, boolean bl, boolean bl2, Icon icon, Converter<String, Target> converter) throws InvalidFormatException, UnavailableTargetException {
        Object object;
        Object object2;
        Object object3;
        FileSetDefinition fileSetDefinition22;
        if (!xmlReader.getCurrentElementName().equals(PROJECT_ROOT_TAG)) {
            throw new InvalidFormatException("Unrecognized root element: " + xmlReader.getCurrentElementName(), file);
        }
        XmlReader xmlReader2 = xmlReader.getChild(new String[]{"configuration"});
        if (!xmlReader2.isPresent()) {
            throw new InvalidFormatException("Missing configuration element", file);
        }
        String string = xmlReader2.readAttribute("target");
        if (string == null) {
            throw new InvalidFormatException("Missing target attribute on configuration", file);
        }
        Target target = (Target)converter.convert((Object)string);
        if (target == null) {
            throw new UnavailableTargetException(string);
        }
        try {
            xmlReader = ProjectVersionUtils.convertToVersion(xmlReader, target.getPlugin(), target.getPlugin().getVersion());
            xmlReader2 = xmlReader.getChild(new String[]{"configuration"});
            string = xmlReader2.readAttribute("target");
            if (string == null) {
                throw new InvalidFormatException("Missing target attribute on configuration", file);
            }
            target = (Target)converter.convert((Object)string);
            if (target == null) {
                throw new UnavailableTargetException(string);
            }
        }
        catch (IOException iOException) {
            throw new InvalidFormatException("Cannot read version translation files needed to load the project.", file);
        }
        Project project = new Project(file, icon);
        if (!bl) {
            ProjectManager.installPrefsWatcher(project, target);
        }
        Configuration configuration = new Configuration(ProjectManager.getConfigurationName(file), target, project);
        String string2 = xmlReader2.readAttribute("preferred-package-location");
        String string3 = xmlReader2.readAttribute("preferred-package-type");
        String string4 = xmlReader2.readAttribute("build-checksum");
        if (string2 != null && string2.trim().length() > 0) {
            configuration.setPreferredPackageLocation(new File(string2.trim()));
        }
        if (string3 != null && target.getPackageTypeByKey(project, string3) != null) {
            configuration.setPreferredPackageType(target.getPackageTypeByKey(project, string3));
        }
        if (string4 != null) {
            configuration.setBuildChecksum(string4);
        }
        for (FileSetDefinition fileSetDefinition22 : target.getFileSets()) {
            object3 = configuration.getFileSet(fileSetDefinition22.getKey());
            try {
                ProjectManager.deserializeFileSet(file, configuration, xmlReader2, fileSetDefinition22, (FileSetInstance)object3);
                ((FileSetInstance)object3).normalize();
            }
            catch (InvalidFileSetException invalidFileSetException) {
                throw new InvalidFormatException((Exception)invalidFileSetException, file);
            }
        }
        final TreeSet treeSet = new TreeSet();
        xmlReader2.getChild(new String[]{"unset"}).loop(new XmlLooper(){

            public void iterate(XmlReader xmlReader) {
                treeSet.add(xmlReader.getCurrentElementName());
            }
        }, new String[0]);
        fileSetDefinition22 = xmlReader2.getChild(new String[]{"profile"});
        object3 = configuration.getProfileManager();
        while (fileSetDefinition22.isPresent()) {
            String string5 = fileSetDefinition22.readAttribute("key");
            if (string5 != null) {
                Profile object4 = target.getProfile(string5);
                final HashSet hashSet = new HashSet();
                fileSetDefinition22.getChild(new String[]{"unset"}).loop(new XmlLooper(){

                    public void iterate(XmlReader xmlReader) {
                        hashSet.add(xmlReader.getCurrentElementName());
                    }
                }, new String[0]);
                if (object4 != null) {
                    Param param = fileSetDefinition22.getChild(new String[0]);
                    while (param.isPresent()) {
                        object2 = param.getCurrentElementName();
                        if (!((String)object2).equals("unset") && !hashSet.contains(object2) && (object = target.getParam((String)object2)) != null && ((ProfileManager)object3).hasProfileSupport(object4, (Param)object)) {
                            try {
                                Object object5 = ((Param)object).getType().deserialize(project, (Param)object, (XmlReader)param);
                                ((ProfileManager)object3).setProfileValue(object4, (Param)object, object5);
                            }
                            catch (InvalidParameterValueException invalidParameterValueException) {
                                // empty catch block
                            }
                        }
                        param = param.next();
                    }
                }
            }
            fileSetDefinition22 = fileSetDefinition22.next();
        }
        for (ParamSet paramSet : target.getParamSets()) {
            for (Param param : paramSet.getParams()) {
                if (treeSet.contains(param.getKey()) || !(object2 = xmlReader2.getChild(new String[]{param.getKey()})).isPresent()) continue;
                try {
                    object = param.getType().deserialize(project, param, (XmlReader)object2);
                    configuration.setParamAsObject(param.getKey(), object);
                }
                catch (InvalidParameterValueException invalidParameterValueException) {}
            }
        }
        ProjectManager.readWorkflowSection(target, xmlReader2, configuration);
        configuration.loadingFinished();
        if (bl2 && target.getProjectOpenCode() != null) {
            target.getProjectOpenCode().evaluate(project, true);
        }
        if (!bl) {
            ProjectManager.installAutoSave(project);
        }
        if (Matlab.isMatlabAvailable() && NativeMatlab.nativeIsMatlabThread() && project.getConfiguration().hasPendingMatlabDefaults()) {
            throw new IllegalStateException("Not all MATLAB loads have finished");
        }
        return project;
    }

    private static void readWorkflowSection(final Target target, XmlReader xmlReader, final Configuration configuration) {
        if (target.getWorkflow() != null) {
            XmlReader xmlReader2 = xmlReader.getChild(new String[]{"workflow"});
            xmlReader2.loop(new XmlLooper(){

                public void iterate(XmlReader xmlReader) {
                    WorkflowStep workflowStep;
                    String string = xmlReader.readAttribute("skipped");
                    String string2 = xmlReader.readAttribute("key");
                    if (string2 != null && string != null && (workflowStep = target.getWorkflow().getStepByKey(string2)) != null) {
                        configuration.setWorkflowStepSkipped(workflowStep, string.equals("true"));
                    }
                }
            }, new String[]{"step"});
        }
    }

    public static List<ValidationMessage> validate(Project project, boolean bl) {
        ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
        arrayList.addAll(new BasicValidator(bl).validate((ReadableConfiguration)project.getConfiguration()));
        arrayList.addAll(project.getConfiguration().getTarget().validate(project));
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void save(Project project) throws IOException {
        XmlWriter xmlWriter = XmlApi.getInstance().create(PROJECT_ROOT_TAG);
        Plugin plugin = project.getConfiguration().getTarget().getPlugin();
        xmlWriter.writeAttribute("plugin", (Object)plugin.getKey());
        xmlWriter.writeAttribute("plugin-version", (Object)plugin.getVersion());
        XmlWriter xmlWriter2 = xmlWriter.createElement("configuration");
        ProjectManager.configurationToXml(project, xmlWriter2, new XmlGenerationContext(XmlGenerationFlag.USE_FILE_ALIASES, XmlGenerationFlag.EXCLUDE_PREFS, XmlGenerationFlag.EXCLUDE_COMMAND_LINE_ADAPTERS));
        PrintWriter printWriter = null;
        try {
            String string = xmlWriter.getXML();
            String string2 = project.getConfiguration().getTarget().getProjectXslOut();
            string = string2 != null ? XMLUtils.transform((String)string, (String)string2) : ProjectVersionUtils.convertToVersion(string, plugin, plugin.getVersion(), plugin.getSaveVersion());
            printWriter = new PrintWriter(project.getFile(), "UTF-8");
            printWriter.print(string);
            printWriter.close();
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    static String configurationToXml(Project project) {
        return ProjectManager.configurationToXml(project, (PackageType)null, null);
    }

    public static String configurationToXml(Project project, PackageType packageType, File file) {
        return ProjectManager.configurationToXml(project, packageType, file, null);
    }

    public static String configurationToXml(Project project, PackageType packageType, File file, GeneratedReferenceSet generatedReferenceSet) {
        XmlWriter xmlWriter = XmlApi.getInstance().create("configuration");
        ProjectManager.configurationToXml(project, packageType, file, xmlWriter, new XmlGenerationContext(generatedReferenceSet));
        return xmlWriter.getXML();
    }

    public static XmlReader createStaticXslInput() {
        return ProjectManager.createStaticXslInput(null);
    }

    public static XmlReader createStaticXslInput(Target target) {
        PrefsWatcher prefsWatcher = null;
        if (target != null) {
            prefsWatcher = new PrefsWatcher(target);
        }
        XmlWriter xmlWriter = XmlApi.getInstance().create("configuration");
        ProjectManager.writeMatlabSection(null, xmlWriter, new XmlGenerationContext(new XmlGenerationFlag[0]));
        ProjectManager.writePrefsSection(prefsWatcher, xmlWriter);
        ProjectManager.writePlatformSection(xmlWriter);
        try {
            XmlReader xmlReader = XmlApi.getInstance().read(xmlWriter.getXML());
            return xmlReader;
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        finally {
            if (prefsWatcher != null) {
                prefsWatcher.destroy();
            }
        }
    }

    static XmlReader configurationToXslInput(Project project) {
        try {
            return XmlApi.getInstance().read(ProjectManager.configurationToXslInput(project, new XmlGenerationContext(new XmlGenerationFlag[0])));
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public static String configurationToXslInput(Project project, XmlGenerationContext xmlGenerationContext, Map<String, String> map) {
        if (xmlGenerationContext == null) {
            xmlGenerationContext = new XmlGenerationContext(new XmlGenerationFlag[0]);
        }
        XmlWriter xmlWriter = XmlApi.getInstance().create("configuration");
        ProjectManager.configurationToXml(project, xmlWriter, xmlGenerationContext);
        ProjectManager.writeMatlabSection(project, xmlWriter, xmlGenerationContext);
        XmlWriter xmlWriter2 = xmlWriter.createElement("function-params");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            xmlWriter2.writeText(entry.getKey(), new Object[]{entry.getValue()});
        }
        return xmlWriter.getXML();
    }

    static String configurationToXslInput(Project project, XmlGenerationContext xmlGenerationContext) {
        return ProjectManager.configurationToXslInput(project, xmlGenerationContext, new TreeMap<String, String>());
    }

    private static void configurationToXml(Project project, XmlWriter xmlWriter, XmlGenerationContext xmlGenerationContext) {
        ProjectManager.configurationToXml(project, null, null, xmlWriter, xmlGenerationContext);
    }

    static XmlWriter createXslInputRoot(Project project, XmlGenerationContext xmlGenerationContext) {
        XmlWriter xmlWriter = XmlApi.getInstance().create("configuration");
        ProjectManager.writeConfigurationHeader(xmlWriter, project, xmlGenerationContext);
        return xmlWriter;
    }

    private static void writeConfigurationHeader(XmlWriter xmlWriter, Project project, XmlGenerationContext xmlGenerationContext) {
        File file = project.getFile();
        String string = ProjectManager.getConfigurationName(file);
        Configuration configuration = project.getConfiguration();
        xmlWriter.writeAttribute("target", (Object)configuration.getTargetKey());
        xmlWriter.writeAttribute("target-name", (Object)configuration.getTargetName());
        if (!xmlGenerationContext.hasFlag(XmlGenerationFlag.EXCLUDE_TEMPLATE_INFO) && configuration.getProjectType().getTemplate() != null) {
            if (configuration.getProjectType().getKey() != null) {
                xmlWriter.writeAttribute(TEMPLATE_KEY_ATTRIBUTE, (Object)configuration.getProjectType().getKey());
            }
            xmlWriter.writeAttribute(TEMPLATE_NAME_ATTRIBUTE, (Object)configuration.getProjectType().getName());
            xmlWriter.writeAttribute(TEMPLATE_FILE_ATTRIBUTE, (Object)configuration.getProjectType().getTemplate().getFile().getName());
        }
        xmlWriter.writeAttribute("name", (Object)string);
        xmlWriter.writeAttribute("location", (Object)file.getParentFile());
        xmlWriter.writeAttribute("file", (Object)file.getAbsolutePath());
        Target target = project.getConfiguration().getTarget();
        for (Map.Entry<String, String> entry : target.getExtraAttributes().entrySet()) {
            xmlWriter.writeAttribute(entry.getKey(), (Object)entry.getValue());
        }
    }

    private static void configurationToXml(Project project, PackageType packageType, File file, XmlWriter xmlWriter, XmlGenerationContext xmlGenerationContext) {
        Object object;
        ProfileManager profileManager;
        Configuration configuration = project.getConfiguration();
        File file2 = project.getFile();
        if (xmlGenerationContext == null) {
            xmlGenerationContext = new XmlGenerationContext(new XmlGenerationFlag[0]);
        }
        ProjectManager.writeConfigurationHeader(xmlWriter, project, xmlGenerationContext);
        Target target = project.getConfiguration().getTarget();
        if (!xmlGenerationContext.hasFlag(XmlGenerationFlag.EXCLUDE_PACKAGE_PREFS) && packageType != null) {
            xmlWriter.writeAttribute("package-type", (Object)packageType.getKey());
        }
        if (!xmlGenerationContext.hasFlag(XmlGenerationFlag.EXCLUDE_PACKAGE_PREFS) && file != null) {
            xmlWriter.writeAttribute("package", (Object)file.getAbsolutePath());
        }
        if (!xmlGenerationContext.hasFlag(XmlGenerationFlag.EXCLUDE_PACKAGE_PREFS) && configuration.getPreferredPackageType() != null) {
            xmlWriter.writeAttribute("preferred-package-type", (Object)configuration.getPreferredPackageType().getKey());
        }
        if (!xmlGenerationContext.hasFlag(XmlGenerationFlag.EXCLUDE_CHECKSUMS) && configuration.getBuildchecksum() != null) {
            xmlWriter.writeAttribute("build-checksum", (Object)configuration.getBuildchecksum());
        }
        if (!xmlGenerationContext.hasFlag(XmlGenerationFlag.EXCLUDE_PACKAGE_PREFS) && configuration.getPreferredPackageLocation() != null) {
            xmlWriter.writeAttribute("preferred-package-location", (Object)configuration.getPreferredPackageLocation().getAbsolutePath());
        }
        if (xmlGenerationContext.hasFlag(XmlGenerationFlag.USE_FILE_ALIASES)) {
            profileManager = configuration.getProfileManager();
            for (Profile object2 : configuration.getTarget().getProfiles()) {
                object = xmlWriter.createElement("profile");
                object.writeAttribute("key", (Object)object2.getKey());
                ProjectManager.serializeParameters(configuration, object2, (XmlWriter)object, xmlGenerationContext);
                XmlWriter xmlWriter2 = object.createElement("unset");
                for (ParamSet paramSet : target.getParamSets()) {
                    for (Param param : paramSet.getParams()) {
                        if (!profileManager.hasProfileSupport(object2, param) || profileManager.hasProfileValue(object2, param)) continue;
                        xmlWriter2.createElement(param.getKey());
                    }
                }
            }
        }
        ProjectManager.serializeParameters(configuration, null, xmlWriter, xmlGenerationContext);
        profileManager = xmlWriter.createElement("unset");
        for (String string : configuration.getUnsetParamKeys()) {
            object = target.getParam(string);
            if (!((Param)object).shouldSaveUnsetValue() || xmlGenerationContext.hasFlag(XmlGenerationFlag.USE_FILE_ALIASES) && configuration.getProfileManager().hasAnyProfileSupport((Param)object)) continue;
            profileManager.createElement(string);
        }
        for (FileSetDefinition fileSetDefinition : target.getFileSets()) {
            if (fileSetDefinition.getKey().compareTo("fileset.package") == 0 && xmlGenerationContext.hasFlag(XmlGenerationFlag.EXCLUDE_FILESET_PACKAGE)) continue;
            ProjectManager.serializeFileSet(file2, configuration, xmlWriter, fileSetDefinition, configuration.getFileSet(fileSetDefinition.getKey()), xmlGenerationContext);
        }
        if (!xmlGenerationContext.hasFlag(XmlGenerationFlag.EXCLUDE_BUILD_DELIVERABLES)) {
            ProjectManager.writeBuildDeliverables(project, xmlWriter, xmlGenerationContext);
        }
        ProjectManager.writeWorkflowSection(project, xmlWriter);
        ProjectManager.writeMatlabSection(project, xmlWriter, xmlGenerationContext);
        ProjectManager.writePlatformSection(xmlWriter);
        if (!xmlGenerationContext.hasFlag(XmlGenerationFlag.EXCLUDE_PREFS)) {
            PrefsWatcher prefsWatcher = ProjectManager.getPrefsWatcher(project);
            ProjectManager.writePrefsSection(prefsWatcher, xmlWriter);
        }
    }

    static void serializeParameters(Configuration configuration, Profile profile, XmlWriter xmlWriter, XmlGenerationContext xmlGenerationContext) {
        ProfileManager profileManager = configuration.getProfileManager();
        Project project = configuration.getProject();
        for (ParamSet paramSet : configuration.getTarget().getParamSets()) {
            for (Param param : paramSet.getParams()) {
                XmlWriter xmlWriter2;
                Object object;
                if (profile != null && profileManager.hasProfileSupport(profile, param)) {
                    object = profileManager.hasProfileValue(profile, param) ? profileManager.getProfileValue(profile, param) : configuration.getParamDefaultValue(param.getKey());
                    xmlWriter2 = XmlApi.getInstance().create(param.getKey());
                    if (object != null) {
                        param.getType().serialize(project, param, object, xmlWriter2, true);
                    }
                    xmlWriter.writeXML(xmlWriter2.getXML());
                    continue;
                }
                if (profile != null || xmlGenerationContext.isParameterKeyExcluded(param.getKey()) || !param.shouldSaveUnsetValue() && configuration.getUnsetParamKeys().contains(param.getKey()) || xmlGenerationContext.hasFlag(XmlGenerationFlag.USE_FILE_ALIASES) && profileManager.hasAnyProfileSupport(param)) continue;
                object = xmlGenerationContext.getXML(param.getKey());
                if (object == null) {
                    xmlWriter2 = XmlApi.getInstance().create(param.getKey());
                    Object object2 = configuration.getParamAsObject(param.getKey(), xmlGenerationContext);
                    if (object2 != null) {
                        param.getType().serialize(project, param, object2, xmlWriter2, xmlGenerationContext.hasFlag(XmlGenerationFlag.USE_FILE_ALIASES));
                    }
                    object = xmlWriter2.getXML();
                    xmlGenerationContext.setXML(param.getKey(), (String)object);
                }
                xmlWriter.writeXML((String)object);
            }
        }
    }

    static void deserializeFileSet(File file, Configuration configuration, XmlReader xmlReader, FileSetDefinition fileSetDefinition, FileSetInstance fileSetInstance) throws InvalidFileSetException {
        XmlReader xmlReader2 = xmlReader.getChild(new String[]{fileSetDefinition.getKey()});
        if (fileSetDefinition.getHierarchyLevels() > 1) {
            XmlReader xmlReader3 = xmlReader2.getChild(new String[0]);
            while (xmlReader3.isPresent()) {
                ProjectManager.deserializeFileSetEntity(fileSetInstance, file, configuration, xmlReader3, null);
                xmlReader3 = xmlReader3.next();
            }
        } else {
            TreeSet<File> treeSet = new TreeSet<File>();
            XmlReader xmlReader4 = xmlReader2.getChild(new String[]{"file"});
            while (xmlReader4.isPresent()) {
                treeSet.add(ProjectManager.deserializeFile(file, configuration, xmlReader4, fileSetDefinition, fileSetInstance));
                xmlReader4 = xmlReader4.next();
            }
            String string = fileSetInstance.validateAdd(null, treeSet, false);
            if (string != null) {
                throw new InvalidFileSetException(fileSetDefinition.getKey(), string, xmlReader2);
            }
            fileSetInstance.add(treeSet);
        }
    }

    static File deserializeFile(File file, Configuration configuration, XmlReader xmlReader, FileSetDefinition fileSetDefinition, FileSetInstance fileSetInstance) {
        File file2;
        File file3;
        SpecialFile specialFile = ProjectManager.deserializeSpecialFile(xmlReader, fileSetDefinition);
        File file4 = file3 = specialFile == null ? null : configuration.getSpecialFileLocation(specialFile);
        if (file3 != null) {
            file2 = file3;
            FileReferenceMode fileReferenceMode = ProjectManager.deserializeFileReferenceMode(xmlReader, specialFile);
            fileSetInstance.setReferenceMode(file3, fileReferenceMode);
        } else if (fileSetDefinition.getCustomDataWidgetClassName() != null || xmlReader.readAttribute("value") != null) {
            String string;
            File file5;
            file2 = file5 = ProjectManager.relativeLocationToFile(file, xmlReader.readAttribute("value"));
            XmlReader xmlReader2 = xmlReader.getChild(new String[0]);
            if (xmlReader2.isPresent()) {
                fileSetInstance.setCustomData(file5, xmlReader2.getXML());
            }
            if ((string = xmlReader.readAttribute("custom-data-expanded")) != null && string.equalsIgnoreCase("true")) {
                fileSetInstance.setCustomDataExpanded(file5, true);
            }
        } else {
            file2 = ProjectManager.relativeLocationToFile(file, xmlReader.readText());
        }
        return file2;
    }

    static void deserializeFileSetEntity(FileSetInstance fileSetInstance, File file, Configuration configuration, XmlReader xmlReader, EntityInstance entityInstance) throws InvalidFileSetException {
        EntityDefinition entityDefinition;
        String string = xmlReader.getCurrentElementName();
        String string2 = xmlReader.readAttribute("name");
        EntityDefinition entityDefinition2 = entityDefinition = entityInstance != null ? entityInstance.getDefinition().getChild(string) : fileSetInstance.getDefinition().getRootLevelEntity(string);
        if (entityDefinition == null) {
            throw new InvalidFileSetException(fileSetInstance.getDefinition().getKey(), "Invalid entity key: " + string, xmlReader);
        }
        if (string2 == null) {
            throw new InvalidFileSetException(fileSetInstance.getDefinition().getKey(), "Entity has no name attribute", xmlReader);
        }
        EntityInstance entityInstance2 = new EntityInstance(entityDefinition);
        entityInstance2.setName(string2);
        if (entityInstance != null) {
            fileSetInstance.addChild(entityInstance, entityInstance2);
        } else {
            fileSetInstance.add(entityInstance2);
        }
        TreeSet<File> treeSet = new TreeSet<File>();
        XmlReader xmlReader2 = xmlReader.getChild(new String[0]);
        while (xmlReader2.isPresent()) {
            if (xmlReader2.getCurrentElementName().equals("file")) {
                treeSet.add(ProjectManager.deserializeFile(file, configuration, xmlReader2, fileSetInstance.getDefinition(), fileSetInstance));
            } else {
                ProjectManager.deserializeFileSetEntity(fileSetInstance, file, configuration, xmlReader2, entityInstance2);
            }
            xmlReader2 = xmlReader2.next();
        }
        if (!treeSet.isEmpty()) {
            String string3 = fileSetInstance.validateAdd((ReadableEntityInstance)entityInstance2, treeSet, false);
            if (string3 != null) {
                throw new InvalidFileSetException(fileSetInstance.getDefinition().getKey(), string3, xmlReader);
            }
            fileSetInstance.add((ReadableEntityInstance)entityInstance2, treeSet);
        }
    }

    static void serializeFileSet(File file, Configuration configuration, XmlWriter xmlWriter, FileSetDefinition fileSetDefinition, FileSetInstance fileSetInstance, XmlGenerationContext xmlGenerationContext) {
        XmlWriter xmlWriter2 = xmlWriter.createElement(fileSetDefinition.getKey());
        if (fileSetDefinition.getHierarchyLevels() > 1) {
            for (EntityInstance entityInstance : fileSetInstance.getRootEntities()) {
                ProjectManager.serializeFileSetEntity(file, xmlWriter2, fileSetInstance, entityInstance, xmlGenerationContext);
            }
        } else {
            Map<SpecialFile, File> map = ProjectManager.getSpecialFileLocations(fileSetDefinition, configuration);
            for (File file2 : fileSetInstance.getNonSubsetFiles()) {
                ProjectManager.serializeFile(file, fileSetDefinition, fileSetInstance, xmlWriter2, map, file2, xmlGenerationContext);
            }
        }
    }

    static void serializeFile(File file, FileSetDefinition fileSetDefinition, FileSetInstance fileSetInstance, XmlWriter xmlWriter, Map<SpecialFile, File> map, File file2, XmlGenerationContext xmlGenerationContext) {
        File file3 = file2;
        XmlWriter xmlWriter2 = xmlWriter.createElement("file");
        if (!xmlGenerationContext.hasFlag(XmlGenerationFlag.USE_FILE_ALIASES)) {
            file3 = xmlGenerationContext.getReferenceFile(fileSetDefinition, file2);
            if (file3.getParentFile() != null) {
                xmlWriter2.writeAttribute("location", (Object)file3.getParentFile().getAbsolutePath());
            } else {
                xmlWriter2.writeAttribute("location", (Object)"");
            }
            xmlWriter2.writeAttribute("name", (Object)file3.getName());
            xmlWriter2.writeAttribute("directory", (Object)file3.isDirectory());
        }
        ProjectManager.serializeSpecialFileLocation(xmlWriter2, map, file3, fileSetInstance.getReferenceMode(file2));
        String string = ProjectManager.fileToRelativeLocation(file, file3, xmlGenerationContext);
        if (fileSetInstance.getDefinition().getCustomDataWidgetClassName() != null || fileSetInstance.hasAnyCustomData() && xmlGenerationContext.hasFlag(XmlGenerationFlag.USE_FILE_ALIASES)) {
            xmlWriter2.writeAttribute("value", (Object)string);
            xmlWriter2.writeAttribute("custom-data-expanded", (Object)fileSetInstance.isCustomDataExpanded(file2));
            XmlReader xmlReader = fileSetInstance.getCustomData(file3);
            if (xmlReader != null) {
                xmlWriter2.writeXML(xmlReader.getXML());
            }
        } else {
            xmlWriter2.writeText((Object)string);
        }
    }

    static Map<SpecialFile, File> getSpecialFileLocations(FileSetDefinition fileSetDefinition, Configuration configuration) {
        HashMap<SpecialFile, File> hashMap = new HashMap<SpecialFile, File>();
        if (fileSetDefinition.getKey().equals("fileset.package")) {
            for (SpecialFile specialFile : fileSetDefinition.getSpecialFiles()) {
                hashMap.put(specialFile, configuration.getSpecialFileLocation(specialFile));
            }
        }
        return hashMap;
    }

    static SpecialFile deserializeSpecialFile(XmlReader xmlReader, FileSetDefinition fileSetDefinition) {
        String string = xmlReader.readAttribute("special-file");
        return string == null ? null : fileSetDefinition.getSpecialFile(string);
    }

    static FileReferenceMode deserializeFileReferenceMode(XmlReader xmlReader, SpecialFile specialFile) {
        String string = xmlReader.readAttribute("reference-mode");
        FileReferenceMode fileReferenceMode = FileReferenceMode.DIRECT;
        if (string != null) {
            try {
                fileReferenceMode = FileReferenceMode.valueOf(string.toUpperCase(Locale.ENGLISH).replace('-', '_'));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        fileReferenceMode = fileReferenceMode.getNearestPlatformCounterpart(specialFile.getSupportedReferenceModes());
        return fileReferenceMode;
    }

    static void serializeSpecialFileLocation(XmlWriter xmlWriter, Map<SpecialFile, File> map, File file, FileReferenceMode fileReferenceMode) {
        for (Map.Entry<SpecialFile, File> entry : map.entrySet()) {
            if (!entry.getValue().equals(file)) continue;
            xmlWriter.writeAttribute("special-file", (Object)entry.getKey().getKey());
            xmlWriter.writeAttribute("reference-mode", (Object)fileReferenceMode.toString().toLowerCase(Locale.ENGLISH).replace('_', '-'));
            break;
        }
    }

    static void serializeFileSetEntity(File file, XmlWriter xmlWriter, FileSetInstance fileSetInstance, EntityInstance entityInstance, XmlGenerationContext xmlGenerationContext) {
        XmlWriter xmlWriter2 = xmlWriter.createElement(entityInstance.getDefinition().getKey());
        xmlWriter2.writeAttribute("name", (Object)entityInstance.getName());
        for (EntityInstance object : fileSetInstance.getChildren((ReadableEntityInstance)entityInstance)) {
            ProjectManager.serializeFileSetEntity(file, xmlWriter2, fileSetInstance, object, xmlGenerationContext);
        }
        for (File file2 : fileSetInstance.getFilesForEntity((ReadableEntityInstance)entityInstance)) {
            ProjectManager.serializeFile(file, fileSetInstance.getDefinition(), fileSetInstance, xmlWriter2, new HashMap<SpecialFile, File>(), file2, xmlGenerationContext);
        }
    }

    static void writeBuildDeliverables(Project project, XmlWriter xmlWriter, XmlGenerationContext xmlGenerationContext) {
        XmlWriter xmlWriter2 = xmlWriter.createElement("build-deliverables");
        DynamicFileSubset dynamicFileSubset = project.getConfiguration().getTarget().getBuildDeliverables();
        if (dynamicFileSubset != null) {
            Set<DynamicFileReference> set = project.getConfiguration().evaluateDynamicFileSubset(dynamicFileSubset);
            for (DynamicFileReference dynamicFileReference : set) {
                File file = dynamicFileReference.getFile();
                if (file == null || file.getParentFile() == null) continue;
                XmlWriter xmlWriter3 = xmlWriter2.createElement("file");
                xmlWriter3.writeAttribute("name", (Object)file.getName());
                xmlWriter3.writeAttribute("location", (Object)ProjectManager.fileToRelativeLocation(project.getFile(), file.getParentFile(), xmlGenerationContext));
                xmlWriter3.writeAttribute("optional", (Object)dynamicFileReference.isOptional());
                xmlWriter3.writeText((Object)file.getAbsolutePath());
            }
        }
    }

    static void writePlatformSection(XmlWriter xmlWriter) {
        boolean bl = PlatformInfo.isWindows64() || PlatformInfo.isLinux64() || PlatformInfo.isIntelMac64() || PlatformInfo.isSolaris64();
        String string = "win32";
        if (PlatformInfo.isWindows64()) {
            string = "win64";
        }
        if (PlatformInfo.isSolaris()) {
            string = "sol64";
        }
        if (PlatformInfo.isLinux()) {
            string = "glnx86";
        }
        if (PlatformInfo.isLinux64()) {
            string = "glnxa64";
        }
        if (PlatformInfo.isMacintosh() && PlatformInfo.is64Bit()) {
            string = "maci64";
        }
        if (PlatformInfo.isMacintosh() && !PlatformInfo.is64Bit()) {
            string = "maci";
        }
        XmlWriter xmlWriter2 = xmlWriter.createElement("platform");
        xmlWriter2.writeText("unix", new Object[]{PlatformInfo.isUnix()});
        xmlWriter2.writeText("mac", new Object[]{PlatformInfo.isMacintosh()});
        xmlWriter2.writeText("windows", new Object[]{PlatformInfo.isWindows()});
        xmlWriter2.writeText("win2k", new Object[]{PlatformInfo.isWindows2000()});
        xmlWriter2.writeText("winxp", new Object[]{PlatformInfo.isWindowsXP()});
        xmlWriter2.writeText("vista", new Object[]{PlatformInfo.isWindowsVista()});
        xmlWriter2.writeText("linux", new Object[]{PlatformInfo.isLinux()});
        xmlWriter2.writeText("solaris", new Object[]{PlatformInfo.isSolaris()});
        xmlWriter2.writeText("osver", new Object[]{System.getProperty("os.version")});
        xmlWriter2.writeText("os32", new Object[]{!bl});
        xmlWriter2.writeText("os64", new Object[]{bl});
        xmlWriter2.writeText("arch", new Object[]{string});
        xmlWriter2.writeText("matlab", new Object[]{Matlab.isMatlabAvailable()});
    }

    static void writePrefsSection(PrefsWatcher prefsWatcher, XmlWriter xmlWriter) {
        if (prefsWatcher != null) {
            xmlWriter.writeXML(prefsWatcher.getPreferenceXml());
        } else {
            XmlWriter xmlWriter2 = xmlWriter.createElement("prefs");
            xmlWriter2.writeText("prefdir", new Object[]{Prefs.getPropertyDirectory()});
        }
    }

    static File getMatlabRoot() {
        return com.mathworks.project.impl.util.Matlab.matlabRoot();
    }

    static void writeWorkflowSection(Project project, XmlWriter xmlWriter) {
        Configuration configuration = project.getConfiguration();
        Workflow workflow = configuration.getTarget().getWorkflow();
        XmlWriter xmlWriter2 = xmlWriter.createElement("workflow");
        if (workflow != null) {
            for (WorkflowStep workflowStep : workflow.getFlattenedSteps()) {
                boolean bl = configuration.isWorkflowStepSkipped(workflowStep);
                XmlWriter xmlWriter3 = xmlWriter2.createElement("step");
                xmlWriter3.writeAttribute("key", (Object)workflowStep.getKey());
                xmlWriter3.writeAttribute("skipped", (Object)bl);
            }
        }
    }

    static void writeMatlabSection(Project project, XmlWriter xmlWriter, XmlGenerationContext xmlGenerationContext) {
        String string = xmlGenerationContext.getMatlabSection();
        if (string == null) {
            XmlWriter xmlWriter2 = XmlApi.getInstance().create("matlab");
            File file = ProjectManager.getMatlabRoot();
            xmlWriter2.writeText("root", new Object[]{file == null ? "" : file.getAbsolutePath()});
            if (!(xmlGenerationContext.hasFlag(XmlGenerationFlag.EXCLUDE_PATH) || xmlGenerationContext.hasFlag(XmlGenerationFlag.USE_FILE_ALIASES) && !project.getConfiguration().getTarget().requiresMatlabPathInProjectFile())) {
                XmlWriter xmlWriter3 = xmlWriter2.createElement("path");
                for (File file2 : MatlabPath.getPathFiles()) {
                    xmlWriter3.writeText("directory", new Object[]{ProjectManager.fileToRelativeLocation(project == null ? null : project.getFile(), file2, xmlGenerationContext)});
                }
            }
            string = xmlWriter2.getXML();
            xmlGenerationContext.setMatlabSection(string);
        }
        xmlWriter.writeXML(string);
    }

    static String fileToRelativeLocation(File file, File file2, XmlGenerationContext xmlGenerationContext) {
        if (file2 == null) {
            return null;
        }
        if (!xmlGenerationContext.hasFlag(XmlGenerationFlag.USE_FILE_ALIASES)) {
            return file2.getAbsolutePath();
        }
        HashMap<File, String> hashMap = new HashMap<File, String>();
        hashMap.put(file.getParentFile(), "${PROJECT_ROOT}");
        hashMap.put(ProjectManager.getMatlabRoot(), "${MATLAB_ROOT}");
        return ProjectManager.applyAliases(hashMap, file2);
    }

    public static String fileToRelativeLocation(File file) {
        HashMap<File, String> hashMap = new HashMap<File, String>();
        hashMap.put(ProjectManager.getMatlabRoot(), "${MATLAB_ROOT}");
        hashMap.put(new File(Prefs.getPropertyDirectory()), "${PREF_DIR}");
        return ProjectManager.applyAliases(hashMap, file);
    }

    public static File relativeLocationToFile(File file, String string) {
        HashMap<String, File> hashMap = new HashMap<String, File>();
        hashMap.put("${PROJECT_ROOT}", file.getParentFile());
        hashMap.put("${MATLAB_ROOT}", ProjectManager.getMatlabRoot());
        hashMap.put("$(PROJECTDIR)", file.getParentFile());
        hashMap.put("$(MATLABROOT)", ProjectManager.getMatlabRoot());
        return ProjectManager.undoAliases(hashMap, string);
    }

    public static File relativeLocationToFile(String string) {
        HashMap<String, File> hashMap = new HashMap<String, File>();
        hashMap.put("${MATLAB_ROOT}", new File(Matlab.matlabRoot()));
        hashMap.put("${PREF_DIR}", new File(Prefs.getPropertyDirectory()));
        return ProjectManager.undoAliases(hashMap, string);
    }

    private static String applyAliases(Map<File, String> map, File file) {
        Stack<String> stack = new Stack<String>();
        File file2 = file;
        while (file2.getParentFile() != null && file2.getName() != null) {
            stack.push(file2.getName());
            file2 = file2.getParentFile();
            for (Map.Entry<File, String> entry : map.entrySet()) {
                if (!file2.equals(entry.getKey()) && (!PlatformInfo.isWindows() || !entry.getKey().getAbsolutePath().equalsIgnoreCase(file2.getAbsolutePath()))) continue;
                StringBuilder stringBuilder = new StringBuilder(entry.getValue());
                stringBuilder.append(File.separator);
                while (!stack.empty()) {
                    stringBuilder.append((String)stack.pop());
                    if (stack.empty()) continue;
                    stringBuilder.append(File.separator);
                }
                return stringBuilder.toString();
            }
        }
        return file.getAbsolutePath();
    }

    private static File undoAliases(Map<String, File> map, String string) {
        for (Map.Entry<String, File> entry : map.entrySet()) {
            if (!string.startsWith(entry.getKey() + "/") && !string.startsWith(entry.getKey() + "\\")) continue;
            return new File(entry.getValue(), string.substring(entry.getKey().length() + 1).replace('/', File.separatorChar).replace('\\', File.separatorChar));
        }
        return new File(string);
    }

    public static boolean isProjectFile(File file) {
        return file.getName().toLowerCase(Locale.ENGLISH).endsWith(".prj".toLowerCase(Locale.ENGLISH)) && !file.isDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void installAutoSave(Project project) {
        Map<Project, AutoSaveHandler> map = sAutoSaveHandlers;
        synchronized (map) {
            sAutoSaveHandlers.put(project, new AutoSaveHandler(project));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void installPrefsWatcher(Project project, Target target) {
        Map<Project, PrefsWatcher> map = sPrefWatchers;
        synchronized (map) {
            sPrefWatchers.put(project, new PrefsWatcher(target));
        }
    }

    static {
        sAutoSaveHandlers = new HashMap<Project, AutoSaveHandler>();
        sPrefWatchers = new HashMap<Project, PrefsWatcher>();
        sRecentProjectList = new MRUList(100);
        sRecentProjectListListeners = new ArrayList<ChangeListener>();
        ProjectManager.init();
    }
}

