/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.engine;

import com.mathworks.jmi.Matlab;
import com.mathworks.mvm.context.MvmContext;
import com.mathworks.mvm.exec.FutureEvalResult;
import com.mathworks.mvm.exec.MatlabEvalRequest;
import com.mathworks.mvm.exec.MatlabExecutor;
import com.mathworks.mvm.exec.MvmException;
import com.mathworks.mvm.exec.MvmExecutionException;
import com.mathworks.project.api.Command;
import com.mathworks.project.api.CommandExecutionException;
import com.mathworks.project.api.CommandStatus;
import java.io.IOException;
import java.io.Writer;

public final class MatlabCommand
implements Command {
    private final String fCode;
    private static final Matlab sMatlab = new Matlab();
    private boolean fEcho;

    MatlabCommand(String string, boolean bl) {
        this.fCode = string.replaceAll("\\n", " ").replaceAll("\\r", " ").replaceAll("\\s+", " ");
        this.fEcho = bl;
    }

    public static Writer createOutputWriter(final CommandStatus commandStatus) {
        return new Writer(){

            @Override
            public void write(char[] cArray, int n, int n2) throws IOException {
                commandStatus.printOutputLine(String.copyValueOf(cArray, n, n2));
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        };
    }

    public static Writer createErrorWriter(final CommandStatus commandStatus) {
        return new Writer(){

            @Override
            public void write(char[] cArray, int n, int n2) throws IOException {
                commandStatus.printErrorLine(String.copyValueOf(cArray, n, n2));
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        };
    }

    public static void handleFailure(Command command, CommandStatus commandStatus, MvmExecutionException mvmExecutionException) {
        MvmException mvmException = mvmExecutionException.getMvmCause();
        StackTraceElement[] stackTraceElementArray = mvmException.getStackTrace();
        commandStatus.printErrorLine(mvmException.getLocalizedMessage());
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            commandStatus.printErrorLine("\nError in <a href=\"matlab: opentoline('" + stackTraceElement.getFileName() + "'," + stackTraceElement.getLineNumber() + ",0)\">" + (stackTraceElement.getClassName().isEmpty() ? "" : stackTraceElement.getClassName() + ">") + stackTraceElement.getMethodName() + " at " + stackTraceElement.getLineNumber() + "</a>");
        }
        commandStatus.failed(new CommandExecutionException(command, (Throwable)mvmExecutionException));
    }

    public void execute(CommandStatus commandStatus) {
        Writer writer = MatlabCommand.createOutputWriter(commandStatus);
        Writer writer2 = MatlabCommand.createErrorWriter(commandStatus);
        MatlabEvalRequest matlabEvalRequest = new MatlabEvalRequest(this.fCode, writer);
        MatlabExecutor matlabExecutor = MvmContext.get().getExecutor();
        FutureEvalResult futureEvalResult = matlabExecutor.submit(matlabEvalRequest);
        try {
            futureEvalResult.get();
            commandStatus.finished();
        }
        catch (MvmExecutionException mvmExecutionException) {
            MatlabCommand.handleFailure(this, commandStatus, mvmExecutionException);
        }
        catch (InterruptedException interruptedException) {
            commandStatus.failed(new CommandExecutionException((Command)this, (Throwable)interruptedException));
        }
    }

    public void cancel() {
    }

    public String toString() {
        if (!this.fEcho) {
            return "";
        }
        return this.fCode;
    }
}

