/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.desktop;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.plaf.PlafUtils;
import com.mathworks.project.api.DeploymentProcess;
import com.mathworks.project.api.InvalidProjectException;
import com.mathworks.project.api.ProjectComponent;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.ProjectGUI;
import com.mathworks.project.impl.SectionPanel;
import com.mathworks.project.impl.apps.DescriptionLabel;
import com.mathworks.project.impl.desktop.AppsProjectClient;
import com.mathworks.project.impl.desktop.BuildAction;
import com.mathworks.project.impl.engine.DeploymentEngine;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.model.ProjectManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class AppActionPanel
implements ProjectComponent {
    private MJPanel fPanel;
    private MJButton fBuildButton;
    private MJButton fInstallButton;
    private AppsProjectClient fClient;
    private MJPanel fOutputMessagePanel;
    private JComponent fOutputFileName;
    private MJLabel fOutputMessage;
    private MJPanel buttonsPanel;
    public static final String PARAM_OUTPUT = "param.output";
    public static boolean initialOutputPath = true;
    private Param fParamOutput;
    private Component fParamOutputComponent;

    AppActionPanel(AppsProjectClient appsProjectClient) {
        this.fClient = appsProjectClient;
        this.fPanel = new MJPanel(new BorderLayout()){

            public void setBackground(Color color) {
                super.setBackground(SectionPanel.APP_BACKGROUND);
            }

            public Dimension getMinimumSize() {
                return new Dimension(270, 0);
            }

            public Dimension getPreferredSize() {
                return this.getMinimumSize();
            }
        };
        this.fPanel.setBackground(SectionPanel.APP_BACKGROUND);
        this.fPanel.setOpaque(true);
    }

    private void initializeComponents(Configuration configuration) {
        this.fBuildButton = new MJButton(BuiltInResources.getString("build.button1"));
        this.fBuildButton.setName("sally.package.button");
        this.fBuildButton.addActionListener((ActionListener)((Object)new BuildAction(this.fClient)));
        this.fInstallButton = new MJButton(BuiltInResources.getString("build.button2"));
        this.fInstallButton.setName("sally.package.and.install.button");
        this.buttonsPanel = new MJPanel();
        this.buttonsPanel.setOpaque(true);
        this.buttonsPanel.setLayout((LayoutManager)new GridBagLayout());
        this.buttonsPanel.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        this.buttonsPanel.add((Component)this.fBuildButton, (Object)gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 20;
        this.buttonsPanel.add((Component)this.fInstallButton, (Object)gridBagConstraints);
        this.fInstallButton.setVisible(false);
        this.fInstallButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    final DeploymentProcess deploymentProcess = DeploymentEngine.createCustomPackageProcess(AppActionPanel.this.fClient.getProject());
                    MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (ProjectGUI.getInstance().getCurrentProcess() != null) {
                                return;
                            }
                            ProjectManager.waitForSave(AppActionPanel.this.fClient.getProject());
                            AppActionPanel.this.fClient.start(deploymentProcess);
                        }
                    });
                }
                catch (InvalidProjectException invalidProjectException) {
                    MJOptionPane.showMessageDialog((Component)((Object)AppActionPanel.this.fClient), (Object)invalidProjectException.getLocalizedMessage(), (String)BuiltInResources.getString("error.action.title"), (int)0);
                }
            }
        });
        this.fOutputMessagePanel = new MJPanel();
        this.fOutputMessagePanel.setForeground(new Color(93, 134, 178));
        this.fOutputMessagePanel.setPreferredSize(new Dimension(200, 80));
        this.fOutputMessagePanel.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1));
        this.fOutputMessagePanel.setLayout((LayoutManager)new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        this.fOutputFileName = new DescriptionLabel(BuiltInResources.getString("build.outputfile")).getComponent();
        this.fOutputFileName.setPreferredSize(new Dimension(100, 20));
        this.fOutputFileName.setBorder(BorderFactory.createCompoundBorder(this.fOutputFileName.getBorder(), BorderFactory.createEmptyBorder(1, 5, 1, 1)));
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.anchor = 23;
        gridBagConstraints2.ipady = 5;
        this.fOutputMessagePanel.add((Component)this.fOutputFileName, (Object)gridBagConstraints2);
        this.fParamOutput = configuration.getTarget().getParam(PARAM_OUTPUT);
        this.fParamOutputComponent = this.fClient.getWidgetBinder().createAndRegister(this.fParamOutput);
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.ipady = 0;
        gridBagConstraints2.anchor = 10;
        this.fOutputMessagePanel.add(this.fParamOutputComponent, (Object)gridBagConstraints2);
        this.fOutputMessagePanel.setOpaque(true);
        this.fOutputMessagePanel.setBackground(Color.WHITE);
        this.fOutputMessagePanel.revalidate();
        this.fOutputMessage = new MJLabel("");
        this.fOutputMessage.setFont(new Font("Arial", 1, 24));
        this.fOutputMessage.setVisible(false);
        this.fOutputMessage.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.fOutputMessage.setName("project.impl.desktop.AppActionPanel.fOutputMessage");
    }

    private void createPanel(MJPanel mJPanel) {
        FormLayout formLayout = new FormLayout("10dlu:none, 10dlu, 40dlu, 40dlu:grow, 10dlu:none, 10dlu:none", "10dlu:none, 80dlu:grow, 5dlu, top:d:grow, 5dlu, top:d:grow, 70dlu, top:d:grow, 5dlu:grow");
        mJPanel.setLayout((LayoutManager)formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        mJPanel.add((Component)this.buttonsPanel, (Object)cellConstraints.xywh(3, 2, 2, 2));
        mJPanel.add((Component)this.fOutputMessagePanel, (Object)cellConstraints.xyw(2, 4, 4));
    }

    public Component getComponent() {
        return this.fPanel;
    }

    public void dispose() {
        this.fPanel.setVisible(false);
    }

    public void setOutputMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AppActionPanel.this.fOutputMessage.setText(string);
                AppActionPanel.this.fOutputMessage.setVisible(true);
            }
        });
    }

    public void resetOutputMessage() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AppActionPanel.this.fOutputMessage.setVisible(false);
            }
        });
    }

    public void reportSuccess() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AppActionPanel.this.fOutputMessage.setText(MessageFormat.format(BuiltInResources.getString("appaction.package.success"), AppActionPanel.this.fOutputFileName));
                AppActionPanel.this.fOutputMessage.setVisible(true);
            }
        });
    }

    public void reportFailure() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AppActionPanel.this.fOutputMessage.setText(MessageFormat.format(BuiltInResources.getString("appaction.package.failure"), AppActionPanel.this.fOutputFileName));
                AppActionPanel.this.fOutputMessage.setVisible(true);
            }
        });
    }

    public void reportCancel() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AppActionPanel.this.fOutputMessage.setText(MessageFormat.format(BuiltInResources.getString("appaction.package.cancelled"), AppActionPanel.this.fOutputFileName));
                AppActionPanel.this.fOutputMessage.setVisible(true);
            }
        });
    }

    public String getParamOutput() {
        return this.fOutputMessage.getText();
    }

    public void setConfiguration(Project project) {
        PlafUtils.setLookAndFeel();
        MJPanel mJPanel = new MJPanel();
        MJScrollPane mJScrollPane = new MJScrollPane();
        this.initializeComponents(project.getConfiguration());
        this.createPanel(mJPanel);
        mJScrollPane.getViewport().add((Component)mJPanel);
        mJScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        mJScrollPane.setBackground(SectionPanel.APP_BACKGROUND);
        mJPanel.setBackground(SectionPanel.APP_BACKGROUND);
        this.fPanel.add((Component)mJScrollPane, (Object)"Center");
    }

    public void close() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AppActionPanel.this.fPanel.removeAll();
                AppActionPanel.this.fPanel.invalidate();
            }
        });
    }
}

