/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.apps;

import com.mathworks.project.api.ConfigurationValidator;
import com.mathworks.project.api.ReadableConfiguration;
import com.mathworks.project.api.Severity;
import com.mathworks.project.api.ValidationMessage;
import com.mathworks.project.impl.BuiltInResources;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class Validator
implements ConfigurationValidator {
    private static final String APP_NAME_KEY = "param.appname";
    private static final Pattern APP_NAME_PATTERN = Pattern.compile("[^<>\\/?*:|\"]");
    private static final String VERSION_KEY = "param.version";
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+\\.){1,3}+[\\d]*$");

    public List<ValidationMessage> validate(ReadableConfiguration readableConfiguration) {
        String string;
        ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
        String string2 = readableConfiguration.getParamAsString(APP_NAME_KEY);
        if (string2 == null || string2.length() == 0) {
            arrayList.add(new ValidationMessage(Severity.ERROR, BuiltInResources.getString("error.appname.blank")));
        }
        if (!VERSION_PATTERN.matcher(string = readableConfiguration.getParamAsString(VERSION_KEY)).matches()) {
            arrayList.add(new ValidationMessage(Severity.ERROR, BuiltInResources.getString("error.version.string"), VERSION_KEY));
        }
        return arrayList;
    }
}

