/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.apps;

import com.mathworks.appmanagement.AppManagementApi;
import com.mathworks.appmanagement.AppManagementApiBuilder;
import com.mathworks.mvm.MvmSwingWorker;
import com.mathworks.mvm.context.MvmContext;
import com.mathworks.mvm.exec.FutureFevalResult;
import com.mathworks.mvm.exec.FutureResult;
import com.mathworks.mvm.exec.MatlabExecutor;
import com.mathworks.mvm.exec.MatlabFevalRequest;
import com.mathworks.project.api.Command;
import com.mathworks.project.api.CommandExecutionException;
import com.mathworks.project.api.CommandStatus;
import com.mathworks.project.api.ReadableConfiguration;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.impl.BuiltInResources;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.concurrent.ExecutionException;

public class InstallCommand
implements Command {
    private ReadableConfiguration fConfig;
    private final AppManagementApi fInstallApi;

    public InstallCommand(File file, ReadableConfiguration readableConfiguration, XmlReader xmlReader) {
        this.fConfig = readableConfiguration;
        this.fInstallApi = AppManagementApiBuilder.getAppManagementApi();
    }

    public void execute(CommandStatus commandStatus) {
        this.installUsingJavaAPI(commandStatus);
        commandStatus.printOutputLine(MessageFormat.format(BuiltInResources.getString("install.finished"), this.fConfig.getParamAsString("param.output")));
        commandStatus.finished();
    }

    private void installUsingMatlab(final CommandStatus commandStatus) {
        Writer writer = new Writer(){

            @Override
            public void write(char[] cArray, int n, int n2) throws IOException {
                commandStatus.printOutputLine(String.copyValueOf(cArray, n, n2));
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        };
        PrintWriter printWriter = new PrintWriter(new Writer(){

            @Override
            public void write(char[] cArray, int n, int n2) throws IOException {
                commandStatus.printErrorLine(String.copyValueOf(cArray, n, n2));
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        });
        File file = new File(this.fConfig.getParamAsString("param.output"));
        String string = this.fConfig.getParamAsString("param.appname");
        if (!string.toLowerCase().endsWith(".mlappinstall")) {
            string = string + ".mlappinstall";
        }
        MatlabFevalRequest matlabFevalRequest = new MatlabFevalRequest("matlab.apputil.install", 0, writer, (Writer)printWriter, new Object[]{file.getAbsolutePath()});
        MatlabExecutor matlabExecutor = MvmContext.get().getExecutor();
        FutureFevalResult futureFevalResult = matlabExecutor.submit(matlabFevalRequest);
        MvmSwingWorker mvmSwingWorker = new MvmSwingWorker((FutureResult)futureFevalResult){

            protected void done() {
                try {
                    Object object = this.get();
                }
                catch (ExecutionException executionException) {
                    StackTraceElement[] stackTraceElementArray = executionException.getStackTrace();
                    commandStatus.printErrorLine(executionException.getLocalizedMessage());
                    for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                        commandStatus.printErrorLine("\nError in <a href=\"matlab: opentoline('" + stackTraceElement.getFileName() + "'," + stackTraceElement.getLineNumber() + ",0)\">" + (stackTraceElement.getClassName().isEmpty() ? "" : stackTraceElement.getClassName() + ">") + stackTraceElement.getMethodName() + " at " + stackTraceElement.getLineNumber() + "</a>");
                    }
                    commandStatus.failed(new CommandExecutionException((Command)InstallCommand.this, executionException.getCause()));
                }
                commandStatus.finished();
            }
        };
        mvmSwingWorker.runWhenReady();
    }

    private void installUsingJavaAPI(CommandStatus commandStatus) {
        this.fInstallApi.install(this.fConfig.getParamAsString("param.output"));
    }

    public void cancel() {
    }

    public String toString() {
        return BuiltInResources.getString("apps.install.started");
    }
}

