/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl;

import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.datatransfer.MJDataFlavor;
import com.mathworks.mwswing.datatransfer.MJDragCursorUtilities;
import com.mathworks.project.impl.DeployTool;
import com.mathworks.project.impl.filesetui.FileSetEditor;
import com.mathworks.project.impl.filesetui.FileSetEditorGroup;
import com.mathworks.project.impl.filesetui.FileSetTransferPackage;
import com.mathworks.project.impl.filesetui.FileSetTree;
import com.mathworks.project.impl.model.EntityInstance;
import com.mathworks.project.impl.model.ProjectManager;
import com.mathworks.util.CollectionMap;
import com.mathworks.util.Log;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.Predicate;
import com.mathworks.widgets.tooltip.BalloonToolTip;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

public final class DataTransferSupport {
    private static BalloonToolTip sTip;
    private static String sErrorText;
    private static final DataFlavor sFileSetEditorFlavor;
    private static final List<SupportContext> sContexts;

    private DataTransferSupport() {
    }

    public static void uninstall(final Component component) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Iterator iterator = sContexts.iterator();
                while (iterator.hasNext()) {
                    SupportContext supportContext = (SupportContext)iterator.next();
                    if (!supportContext.getComponent().equals(component)) continue;
                    supportContext.uninstall();
                    iterator.remove();
                }
            }
        });
    }

    public static void installDragSupport(final FileSetEditor fileSetEditor, final FileSetTree fileSetTree) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                DragSource dragSource = new DragSource();
                FileSetDragListener fileSetDragListener = new FileSetDragListener(fileSetEditor, fileSetTree);
                final DragGestureRecognizer dragGestureRecognizer = dragSource.createDefaultDragGestureRecognizer(fileSetTree.getComponent(), 3, fileSetDragListener);
                sContexts.add(new SupportContext(){

                    @Override
                    public Component getComponent() {
                        return fileSetTree.getComponent();
                    }

                    @Override
                    public void uninstall() {
                        dragGestureRecognizer.setComponent(null);
                    }

                    @Override
                    public Map<Predicate<Point>, List<FileSetEditor>> getTargets() {
                        return null;
                    }
                });
            }
        });
    }

    public static void installDropSupport(FileSetEditor fileSetEditor, Component component) {
        DataTransferSupport.installDropSupport(Arrays.asList(fileSetEditor), component, new Predicate<Point>(){

            public boolean accept(Point point) {
                return true;
            }
        });
    }

    public static void installDropSupport(FileSetEditor fileSetEditor, Component component, Predicate<Point> predicate) {
        DataTransferSupport.installDropSupport(Arrays.asList(fileSetEditor), component, predicate);
    }

    public static void installDropSupport(FileSetEditorGroup fileSetEditorGroup, Component component, Predicate<Point> predicate) {
        DataTransferSupport.installDropSupport(fileSetEditorGroup.getEditors(), component, predicate);
    }

    public static void installDropSupport(FileSetEditor fileSetEditor) {
        DataTransferSupport.installDropSupport(fileSetEditor, (Component)fileSetEditor.getComponent(), new Predicate<Point>(){

            public boolean accept(Point point) {
                return true;
            }
        });
    }

    public static void installDropToOpenSupport(Component component) {
        DataTransferSupport.installDropSupport(new ArrayList<FileSetEditor>(0), component, new Predicate<Point>(){

            public boolean accept(Point point) {
                return true;
            }
        });
    }

    private static void installDropSupport(final List<FileSetEditor> list, final Component component, final Predicate<Point> predicate) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Object object;
                final HashMap<Predicate<Point>, List<FileSetEditor>> hashMap = new HashMap<Predicate<Point>, List<FileSetEditor>>();
                hashMap.put(predicate, new ArrayList(list));
                Iterator iterator = sContexts.iterator();
                while (iterator.hasNext()) {
                    object = (SupportContext)iterator.next();
                    if (!object.getComponent().equals(component) || object.getTargets() == null) continue;
                    hashMap.putAll(object.getTargets());
                    object.uninstall();
                    iterator.remove();
                }
                object = new FileSetDropListener(hashMap);
                component.setDropTarget(new DropTarget(component, 1, (DropTargetListener)object, true));
                sContexts.add(new SupportContext(){

                    @Override
                    public Component getComponent() {
                        return component;
                    }

                    @Override
                    public void uninstall() {
                        component.setDropTarget(null);
                    }

                    @Override
                    public Map<Predicate<Point>, List<FileSetEditor>> getTargets() {
                        return hashMap;
                    }
                });
            }
        });
    }

    private static void showError(final FileSetEditor fileSetEditor, final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (sErrorText != null) {
                    if (string.equals(sErrorText)) {
                        return;
                    }
                    DataTransferSupport.hideError();
                }
                MJLabel mJLabel = new MJLabel(string);
                sErrorText = string;
                Rectangle rectangle = fileSetEditor.getComponent().getBounds();
                Frame frame = (Frame)SwingUtilities.windowForComponent(fileSetEditor.getComponent());
                rectangle = SwingUtilities.convertRectangle(fileSetEditor.getComponent().getParent(), rectangle, frame);
                rectangle.setLocation((int)(rectangle.getLocation().getX() + (double)frame.getX()), (int)(rectangle.getLocation().getY() + (double)frame.getY()));
                sTip = new BalloonToolTip(frame, (Component)mJLabel, BalloonToolTip.WEST_EAST, mJLabel.getPreferredSize(), rectangle);
                sTip.setFocusableWindowState(false);
                sTip.show();
            }
        });
    }

    private static void hideError() {
        if (sTip != null) {
            if (sTip.getDialog().isVisible()) {
                sTip.cleanup();
            }
            sTip = null;
            sErrorText = null;
        }
    }

    private static CollectionMap<FileSetEditor, File> validateDrop(List<FileSetEditor> list, File[] fileArray) {
        CollectionMap collectionMap = new CollectionMap(HashMap.class, HashSet.class);
        String string = null;
        FileSetEditor fileSetEditor = null;
        for (File file : fileArray) {
            String string2 = null;
            FileSetEditor fileSetEditor2 = null;
            for (FileSetEditor fileSetEditor3 : list) {
                if (fileSetEditor3.getFileSet().getFiles().contains(file)) continue;
                collectionMap.add((Object)fileSetEditor3, (Object)file);
                string2 = fileSetEditor3.getFileSet().validateAdd((Set)collectionMap.get((Object)fileSetEditor3));
                if (string2 != null) {
                    collectionMap.remove((Object)fileSetEditor3, (Object)file);
                    fileSetEditor2 = fileSetEditor3;
                    continue;
                }
                string2 = null;
                break;
            }
            if (string2 == null) continue;
            string = string2;
            fileSetEditor = fileSetEditor2;
        }
        if (string != null && collectionMap.size() == 0) {
            DataTransferSupport.showError(fileSetEditor, string);
        } else {
            DataTransferSupport.hideError();
        }
        return collectionMap;
    }

    private static Transferable combineFlavors(final Transferable ... transferableArray) {
        return new Transferable(){

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                ArrayList<DataFlavor> arrayList = new ArrayList<DataFlavor>();
                for (Transferable transferable : transferableArray) {
                    arrayList.addAll(Arrays.asList(transferable.getTransferDataFlavors()));
                }
                return arrayList.toArray(new DataFlavor[arrayList.size()]);
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                for (Transferable transferable : transferableArray) {
                    if (!transferable.isDataFlavorSupported(dataFlavor)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
                for (Transferable transferable : transferableArray) {
                    if (!transferable.isDataFlavorSupported(dataFlavor)) continue;
                    return transferable.getTransferData(dataFlavor);
                }
                return null;
            }
        };
    }

    public static Transferable wrapTransferPackage(final FileSetTransferPackage fileSetTransferPackage) {
        return new Transferable(){

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{sFileSetEditorFlavor};
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                return dataFlavor.equals(sFileSetEditorFlavor);
            }

            @Override
            public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
                return fileSetTransferPackage;
            }
        };
    }

    private static FileSetTransferPackage unwrapTransferPackage(Transferable transferable) {
        try {
            return (FileSetTransferPackage)transferable.getTransferData(sFileSetEditorFlavor);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    static {
        sContexts = new ArrayList<SupportContext>();
        try {
            sFileSetEditorFlavor = new DataFlavor("application/x-java-jvm-local-objectref;class=" + FileSetTransferPackage.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException(classNotFoundException);
        }
    }

    private static class FileSetDragListener
    extends DragSourceAdapter
    implements DragGestureListener {
        private final FileSetTree fTree;
        private final FileSetEditor fEditor;

        FileSetDragListener(FileSetEditor fileSetEditor, FileSetTree fileSetTree) {
            this.fTree = fileSetTree;
            this.fEditor = fileSetEditor;
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            TreePath[] treePathArray = this.fTree.getSelectionModel().getSelectionPaths();
            TreeSet<File> treeSet = new TreeSet<File>();
            if (treePathArray != null) {
                for (TreePath treePath : treePathArray) {
                    Object object = treePath.getLastPathComponent();
                    if (!(object instanceof File)) continue;
                    treeSet.add((File)object);
                }
            }
            if (!treeSet.isEmpty()) {
                Transferable transferable2 = MJDataFlavor.encodeJavaFileListFlavor((File[])treeSet.toArray(new File[treeSet.size()]));
                transferable2 = DataTransferSupport.combineFlavors(new Transferable[]{transferable2, DataTransferSupport.wrapTransferPackage(new FileSetTransferPackage(this.fEditor))});
                dragGestureEvent.startDrag(MJDragCursorUtilities.getCursor((int)2), MJDragCursorUtilities.getMacImageToDrag(), new Point(0, 0), transferable2, this);
            }
        }

        @Override
        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
            dragSourceDragEvent.getDragSourceContext().setCursor(MJDragCursorUtilities.getCursor((int)dragSourceDragEvent.getDropAction()));
        }

        @Override
        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
            dragSourceDragEvent.getDragSourceContext().setCursor(MJDragCursorUtilities.getCursor((int)dragSourceDragEvent.getDropAction()));
        }
    }

    private static class FileSetDropListener
    extends DropTargetAdapter {
        private final Map<Predicate<Point>, List<FileSetEditor>> fTargets;

        FileSetDropListener(Map<Predicate<Point>, List<FileSetEditor>> map) {
            this.fTargets = new HashMap<Predicate<Point>, List<FileSetEditor>>(map);
        }

        private boolean isPointInTarget(Point point) {
            for (Map.Entry<Predicate<Point>, List<FileSetEditor>> entry : this.fTargets.entrySet()) {
                if (!entry.getKey().accept((Object)point)) continue;
                return true;
            }
            return false;
        }

        private List<FileSetEditor> getTargetEditors(Point point) {
            for (Map.Entry<Predicate<Point>, List<FileSetEditor>> entry : this.fTargets.entrySet()) {
                if (!entry.getKey().accept((Object)point)) continue;
                return entry.getValue();
            }
            return null;
        }

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            this.dragOver(dropTargetDragEvent);
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            if (!this.isPointInTarget(dropTargetDragEvent.getLocation())) {
                dropTargetDragEvent.rejectDrag();
                return;
            }
            if (MJDataFlavor.isDecodableFileFlavor((DropTargetDragEvent)dropTargetDragEvent)) {
                boolean bl;
                Transferable transferable;
                block13: {
                    transferable = dropTargetDragEvent.getTransferable();
                    bl = false;
                    if (!PlatformInfo.isMacintosh() && transferable != null) {
                        try {
                            File[] fileArray = MJDataFlavor.decodeJavaFileListFlavor((Transferable)transferable);
                            if (fileArray == null || fileArray.length <= 0) break block13;
                            if (fileArray.length == 1 && ProjectManager.isProjectFile(fileArray[0])) {
                                bl = true;
                            } else {
                                List<FileSetEditor> list = this.getTargetEditors(dropTargetDragEvent.getLocation());
                                if (list != null && DataTransferSupport.validateDrop(list, fileArray).size() > 0) {
                                    bl = true;
                                }
                            }
                        }
                        catch (Exception exception) {}
                    } else {
                        bl = true;
                    }
                }
                if (bl) {
                    if (transferable != null && DataTransferSupport.unwrapTransferPackage(transferable) != null) {
                        dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
                    } else {
                        dropTargetDragEvent.acceptDrag(1);
                    }
                } else {
                    dropTargetDragEvent.rejectDrag();
                }
            }
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
            DataTransferSupport.hideError();
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            if (!this.isPointInTarget(dropTargetDropEvent.getLocation())) {
                return;
            }
            dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
            Transferable transferable = dropTargetDropEvent.getTransferable();
            if (transferable != null) {
                try {
                    File[] fileArray = MJDataFlavor.decodeJavaFileListFlavor((Transferable)transferable);
                    FileSetTransferPackage fileSetTransferPackage = DataTransferSupport.unwrapTransferPackage(transferable);
                    if (fileSetTransferPackage == null && fileArray.length == 1 && ProjectManager.isProjectFile(fileArray[0])) {
                        DeployTool.invoke(fileArray[0]);
                    } else {
                        List<FileSetEditor> list = this.getTargetEditors(dropTargetDropEvent.getLocation());
                        if (list != null && !list.isEmpty()) {
                            ArrayList arrayList = new ArrayList();
                            CollectionMap collectionMap = DataTransferSupport.validateDrop(list, fileArray);
                            int n = 0;
                            for (Map.Entry entry : collectionMap.entrySet()) {
                                FileSetEditor fileSetEditor = (FileSetEditor)entry.getKey();
                                File[] fileArray2 = ((Collection)entry.getValue()).toArray(new File[((Collection)entry.getValue()).size()]);
                                if (fileSetEditor.getFileSet().getDefinition().getHierarchyLevels() > 1) {
                                    EntityInstance entityInstance = fileSetEditor.getTargetEntity(dropTargetDropEvent.getLocation());
                                    if (entityInstance == null) {
                                        entityInstance = fileSetEditor.addNewEntity(false);
                                    }
                                    fileSetEditor.addAndSelect(entityInstance, fileArray2, n++ == 0);
                                } else {
                                    fileSetEditor.addAndSelect(fileArray2, n++ == 0);
                                }
                                arrayList.addAll((Collection)entry.getValue());
                            }
                            if (fileSetTransferPackage != null && dropTargetDropEvent.getDropAction() == 2) {
                                fileSetTransferPackage.getEditor().removePaths(fileSetTransferPackage.getPaths(arrayList));
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    Log.logException((Exception)exception);
                }
            }
        }
    }

    private static interface SupportContext {
        public Component getComponent();

        public void uninstall();

        public Map<Predicate<Point>, List<FileSetEditor>> getTargets();
    }
}

