/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.export.pagesetup;

import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.page.export.pagesetup.PageSetupDialog;
import com.mathworks.page.export.print.PagePrintSettings;
import com.mathworks.page.utils.VertFlowLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class PSTabAxis
extends MJPanel
implements ActionListener,
PropertyChangeListener {
    private PagePrintSettings fPrintSettings;
    MJRadioButton fRadBtnAxesRecompute;
    MJRadioButton fRadBtnAxesScreen;
    MJRadioButton fRadBtnBkWhite;
    MJRadioButton fRadBtnBkScreen;
    MJCheckBox fCheckboxPrintUI;
    MJComboBox fComboFigRenderer;

    public PSTabAxis(PagePrintSettings pagePrintSettings) {
        this.fPrintSettings = pagePrintSettings;
        this.fPrintSettings.addPropertyChangeListener(this);
        this.createUI();
    }

    private void createUI() {
        this.setLayout(new BorderLayout());
        MJPanel mJPanel = new MJPanel();
        this.add((Component)mJPanel, "Center");
        mJPanel.setLayout((LayoutManager)new GridBagLayout());
        MJPanel mJPanel2 = new MJPanel();
        mJPanel2.setBorder((Border)new TitledBorder(PageSetupDialog.sResHandle.getString("groupbox.axisGroup")));
        mJPanel2.setLayout((LayoutManager)new VertFlowLayout());
        mJPanel.add((Component)mJPanel2, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(18, 6, 3, 6), 0, 0));
        this.fRadBtnAxesRecompute = new MJRadioButton(PageSetupDialog.sResHandle.getString("checkbox.recalcAxesLimits"));
        this.fRadBtnAxesScreen = new MJRadioButton(PageSetupDialog.sResHandle.getString("checkbox.freezeAxesLimits"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)this.fRadBtnAxesRecompute);
        buttonGroup.add((AbstractButton)this.fRadBtnAxesScreen);
        mJPanel2.add((Component)this.fRadBtnAxesRecompute);
        mJPanel2.add((Component)this.fRadBtnAxesScreen);
        this.fRadBtnAxesRecompute.addActionListener((ActionListener)this);
        this.fRadBtnAxesScreen.addActionListener((ActionListener)this);
        MJPanel mJPanel3 = new MJPanel();
        mJPanel3.setBorder((Border)new TitledBorder(PageSetupDialog.sResHandle.getString("groupbox.figControls")));
        mJPanel3.setLayout((LayoutManager)new VertFlowLayout());
        mJPanel.add((Component)mJPanel3, (Object)new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(3, 6, 3, 6), 0, 0));
        this.fCheckboxPrintUI = new MJCheckBox(PageSetupDialog.sResHandle.getString("checkbox.fControls"));
        mJPanel3.add((Component)this.fCheckboxPrintUI);
        this.fCheckboxPrintUI.addActionListener((ActionListener)this);
        MJPanel mJPanel4 = new MJPanel();
        mJPanel4.setBorder((Border)new TitledBorder(PageSetupDialog.sResHandle.getString("groupbox.figBGGroup")));
        mJPanel4.setLayout((LayoutManager)new VertFlowLayout());
        mJPanel.add((Component)mJPanel4, (Object)new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(3, 6, 3, 6), 0, 0));
        this.fRadBtnBkWhite = new MJRadioButton(PageSetupDialog.sResHandle.getString("checkbox.fBGWhite"));
        this.fRadBtnBkScreen = new MJRadioButton(PageSetupDialog.sResHandle.getString("checkbox.fBGNormal"));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add((AbstractButton)this.fRadBtnBkWhite);
        buttonGroup2.add((AbstractButton)this.fRadBtnBkScreen);
        mJPanel4.add((Component)this.fRadBtnBkWhite);
        mJPanel4.add((Component)this.fRadBtnBkScreen);
        this.fRadBtnBkWhite.addActionListener((ActionListener)this);
        this.fRadBtnBkScreen.addActionListener((ActionListener)this);
        MJPanel mJPanel5 = new MJPanel();
        mJPanel5.setBorder((Border)new TitledBorder(PageSetupDialog.sResHandle.getString("groupbox.figRenderer")));
        mJPanel5.setLayout((LayoutManager)new VertFlowLayout());
        mJPanel.add((Component)mJPanel5, (Object)new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 18, 2, new Insets(3, 6, 3, 6), 0, 0));
        this.fComboFigRenderer = new MJComboBox();
        mJPanel5.add((Component)this.fComboFigRenderer);
        this.fComboFigRenderer.addItem((Object)PageSetupDialog.sResHandle.getString("renderer.default"));
        this.fComboFigRenderer.addItem((Object)PageSetupDialog.sResHandle.getString("renderer.painters"));
        this.fComboFigRenderer.addItem((Object)PageSetupDialog.sResHandle.getString("renderer.zbuffer"));
        this.fComboFigRenderer.addItem((Object)PageSetupDialog.sResHandle.getString("renderer.opengl"));
        this.fComboFigRenderer.addActionListener((ActionListener)this);
        MJPanel mJPanel6 = new MJPanel();
        mJPanel.add((Component)mJPanel6, (Object)new GridBagConstraints(0, 4, 3, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.fRadBtnAxesRecompute.setName("RadBtn_AxesRecompute");
        this.fRadBtnAxesScreen.setName("RadBtn_AxesFreeze");
        this.fRadBtnBkWhite.setName("RadBtn_ColorBW");
        this.fRadBtnBkScreen.setName("RadBtn_ColorScreen");
        this.fCheckboxPrintUI.setName("CheckBox_PrintUI");
        this.fComboFigRenderer.setName("Combo_Renderer");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.fRadBtnAxesRecompute) || object.equals(this.fRadBtnAxesScreen)) {
            this.onAxesLimsTicksChanged();
        } else if (object.equals(this.fCheckboxPrintUI)) {
            this.onPrintUIChanged();
        } else if (object.equals(this.fRadBtnBkWhite) || object.equals(this.fRadBtnBkScreen)) {
            this.onBackgroundChanged();
        } else if (object.equals(this.fComboFigRenderer)) {
            this.onRendererChanged();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getNewValue();
        if (propertyChangeEvent.getSource() != this.fPrintSettings) {
            return;
        }
        if (string.equals("AxesFreezeLimits")) {
            this.setAxesLimsTicks((Double)object);
        } else if (string.equals("PrintUI")) {
            this.setPrintUI((Double)object);
        } else if (string.equals("InvertHardCopy")) {
            this.setBackground((String)object);
        } else if (string.equals("Renderer")) {
            this.setRenderer((String)object);
        }
    }

    private void onAxesLimsTicksChanged() {
        boolean bl = this.fRadBtnAxesScreen.isSelected();
        Double d = bl ? new Double("1.0") : new Double("0.0");
        this.fPrintSettings.setAxesFreezeTicks(this, d);
        this.fPrintSettings.setAxesFreezeLims(this, d);
    }

    private void onPrintUIChanged() {
        boolean bl = this.fCheckboxPrintUI.isSelected();
        Double d = bl ? new Double("1.0") : new Double("0.0");
        this.fPrintSettings.setPrintUI(this, d);
    }

    private void onBackgroundChanged() {
        boolean bl = this.fRadBtnBkWhite.isSelected();
        String string = bl ? new String("on") : new String("off");
        this.fPrintSettings.setBackgroundColor(this, string);
    }

    private void onRendererChanged() {
        int n = this.fComboFigRenderer.getSelectedIndex();
        this.fPrintSettings.setRenderer(this, PagePrintSettings.RENDERER_CODE_ARRAY[n]);
    }

    private void setAxesLimsTicks(Double d) {
        boolean bl;
        boolean bl2 = bl = d > 0.5;
        if (bl) {
            this.fRadBtnAxesScreen.setSelected(true);
        } else {
            this.fRadBtnAxesRecompute.setSelected(true);
        }
    }

    private void setPrintUI(Double d) {
        boolean bl = d > 0.5;
        this.fCheckboxPrintUI.removeActionListener((ActionListener)this);
        this.fCheckboxPrintUI.setSelected(bl);
        this.fCheckboxPrintUI.addActionListener((ActionListener)this);
    }

    private void setBackground(String string) {
        if (string.equals("on")) {
            this.fRadBtnBkWhite.setSelected(true);
        } else {
            this.fRadBtnBkScreen.setSelected(true);
        }
    }

    private void setRenderer(String string) {
        int n;
        this.fComboFigRenderer.removeActionListener((ActionListener)this);
        for (n = 0; n < PagePrintSettings.RENDERER_CODE_ARRAY.length && !string.equals(PagePrintSettings.RENDERER_CODE_ARRAY[n]); ++n) {
        }
        this.fComboFigRenderer.setSelectedIndex(n);
        this.fComboFigRenderer.addActionListener((ActionListener)this);
    }
}

