/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index.doccenter;

import com.mathworks.helpsearch.index.DocumentationDocument;
import com.mathworks.helpsearch.index.LinkResolver;
import com.mathworks.helpsearch.index.XmlFragmentHandler;
import com.mathworks.helpsearch.index.XmlFragmentReader;
import com.mathworks.helpsearch.index.XmlTagInfo;
import com.mathworks.helpsearch.index.doccenter.DocCenterHtmlTagUtils;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class LinkFragmentHandler
implements XmlFragmentHandler,
XmlFragmentReader {
    private final String fRelPath;
    private final LinkResolver fResolver;
    private final List<String> fLinks = new LinkedList<String>();

    public LinkFragmentHandler(String relPath, LinkResolver resolver) {
        this.fRelPath = relPath;
        this.fResolver = resolver;
    }

    @Override
    public String[] getEnclosingTagNames() {
        return new String[]{"a"};
    }

    @Override
    public boolean useHandler(XmlTagInfo xmlTag) {
        return DocCenterHtmlTagUtils.isInContentContainer(xmlTag) && !DocCenterHtmlTagUtils.isInBreadCrumb(xmlTag);
    }

    @Override
    public boolean continueHandling() {
        return true;
    }

    @Override
    public XmlFragmentReader startFragment(XmlTagInfo location) {
        return this;
    }

    @Override
    public void startElement(XmlTagInfo location) {
        String href = location.getAttribute("href");
        if (href != null) {
            String link;
            if (href.contains("#")) {
                href = href.substring(0, href.indexOf(35));
            }
            if (href.trim().length() > 0 && href.endsWith(".html") && !href.startsWith("http:") && (link = this.fResolver.resolveLink(this.fRelPath, href)) != null && link.trim().length() > 0) {
                this.fLinks.add(link);
            }
        }
    }

    @Override
    public void characters(XmlTagInfo location, String chars) {
    }

    @Override
    public void endElement(XmlTagInfo location) {
    }

    @Override
    public void endFragment(XmlTagInfo location) {
    }

    @Override
    public void populateDocument(DocumentationDocument doc) {
        Collection<String> existing = doc.getOutgoingLinks();
        if (existing == null || existing.isEmpty()) {
            doc.addOutgoingLinks(this.fLinks);
        }
    }
}

