/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index;

import com.mathworks.helpsearch.index.IndexUtils;

public class DocumentBody {
    private final StringBuilder fBody = new StringBuilder();
    private String fFinalBody = null;

    public void append(String text) {
        this.fBody.append(text);
    }

    public void appendTagReplacement(String tagName) {
        if (IndexUtils.isSentenceBreakTag(tagName)) {
            this.fBody.append('\n');
        } else if (IndexUtils.isWordBreakTag(tagName)) {
            this.fBody.append(' ');
        }
    }

    public void append(DocumentBody body) {
        this.fBody.append((CharSequence)body.fBody);
    }

    public void cleanup() {
        String body = this.fBody.toString();
        body = body.replaceAll("\\xa0", " ");
        body = body.replaceAll("\\s*\\n\\s*", "\n");
        body = body.replaceAll("\\s{2,}", " ");
        body = body.replaceAll("(?<!\\.)\\. ", ".\n");
        this.fFinalBody = body.trim();
    }

    public synchronized String getBody() {
        if (this.fFinalBody == null) {
            this.cleanup();
        }
        return this.fFinalBody;
    }
}

