/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help.search;

import com.mathworks.mde.help.search.SearchResultCell;
import com.mathworks.mwswing.ColorUtils;
import java.awt.Color;

class SearchResultCellColors {
    private static final Color TITLE_TEXT_BASE_COLOR = new Color(200, 106, 2);
    private static final Color PROD_SECT_TEXT_BASE_COLOR = new Color(104, 143, 211);
    private static final Color HIGHLIGHTS_BACKGROUND_BASE_COLOR = new Color(191, 214, 255);
    private static Color sTitleTextColor = TITLE_TEXT_BASE_COLOR;
    private static Color sProdSectColor = PROD_SECT_TEXT_BASE_COLOR;
    private static Color sHighlightsForeground;
    private static Color sHighlightsBackground;

    private SearchResultCellColors() {
    }

    static void calculateColors(Color color, Color color2) {
        if (color == null || color2 == null) {
            return;
        }
        sTitleTextColor = ColorUtils.areContrasting((Color)TITLE_TEXT_BASE_COLOR, (Color)color2) ? TITLE_TEXT_BASE_COLOR : color;
        sProdSectColor = ColorUtils.areContrasting((Color)PROD_SECT_TEXT_BASE_COLOR, (Color)color2) ? PROD_SECT_TEXT_BASE_COLOR : color;
        Color color3 = color;
        if (ColorUtils.isDark((Color)color3)) {
            for (int i = 0; i < 10 && ColorUtils.areContrasting((Color)color3.brighter(), (Color)color2); ++i) {
                color3 = color3.brighter();
            }
        } else {
            for (int i = 0; i < 10 && ColorUtils.areContrasting((Color)color3.darker(), (Color)color2); ++i) {
                color3 = color3.brighter();
            }
        }
        sHighlightsForeground = color3;
        sHighlightsBackground = ColorUtils.areBackgroundsContrasting((Color)HIGHLIGHTS_BACKGROUND_BASE_COLOR, (Color)color2) ? HIGHLIGHTS_BACKGROUND_BASE_COLOR : ColorUtils.getBlackOrWhiteContrasting((Color)color2);
        SearchResultCell.updateColors();
    }

    static Color getTitleForeground() {
        return sTitleTextColor;
    }

    static Color getProdSectForeground() {
        return sProdSectColor;
    }

    static Color getHighlightsForeground() {
        return sHighlightsForeground;
    }

    static Color getHighlightsBackground() {
        return sHighlightsBackground;
    }

    static {
        sHighlightsBackground = HIGHLIGHTS_BACKGROUND_BASE_COLOR;
    }
}

