/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor.debug;

import com.mathworks.matlab.api.editor.actions.DebuggerActions;
import com.mathworks.mde.editor.breakpoints.DebugLoopEvent;
import com.mathworks.mde.editor.debug.DebuggerActionsProvider;
import com.mathworks.mvm.context.MvmContext;
import com.mathworks.mvm.eventmgr.MvmListener;
import com.mathworks.util.osgi.ClasspathOSGiManager;
import com.mathworks.widgets.debug.DebuggerManager;
import java.util.ArrayList;
import java.util.Collection;

public class DebuggerInstaller {
    private static boolean fHasInitialized = false;

    private DebuggerInstaller() {
    }

    public static void init() {
        if (fHasInitialized) {
            return;
        }
        Collection collection = ClasspathOSGiManager.getInstance().getImplementors(DebuggerActionsProvider.class);
        MvmContext.get().getEventMgr().addMvmListener(DebuggerInstaller.createMvmListener(collection), DebugLoopEvent.class);
        fHasInitialized = true;
    }

    private static MvmListener<DebugLoopEvent> createMvmListener(final Collection<DebuggerActionsProvider> collection) {
        return new MvmListener<DebugLoopEvent>(){

            public void mvmChanged(DebugLoopEvent debugLoopEvent) {
                ArrayList<DebuggerActionsProvider> arrayList = new ArrayList<DebuggerActionsProvider>();
                for (DebuggerActionsProvider debuggerActionsProvider : collection) {
                    if (!debuggerActionsProvider.isApplicable(debugLoopEvent)) continue;
                    arrayList.add(debuggerActionsProvider);
                }
                assert (arrayList.size() <= 1) : "There should be no more than 1 applicable DebuggerProvider";
                if (arrayList.size() == 1) {
                    if (DebugLoopEvent.LoopState.ENTERED.equals((Object)debugLoopEvent.getState())) {
                        DebuggerManager.addDebuggerToTop((DebuggerActions)((DebuggerActionsProvider)arrayList.get(0)).getActions());
                    } else {
                        DebuggerManager.removeTopDebugger(((DebuggerActionsProvider)arrayList.get(0)).getActions().getClass());
                    }
                }
            }
        };
    }
}

