/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.dataimport;

import com.mathworks.jmi.MatlabPath;
import com.mathworks.mde.dataimport.DataInterpretationPanel;
import com.mathworks.mde.dataimport.DataSourceSelectionPanel;
import com.mathworks.mde.dataimport.IVariableContentsOwner;
import com.mathworks.mde.dataimport.ImportProxy;
import com.mathworks.mde.dataimport.ImportUtils;
import com.mathworks.mde.dataimport.ValueSpecification;
import com.mathworks.mde.dataimport.VariableSourceSelectionPanel;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.services.ColorPrefs;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.widgets.wizard.AbstractSimpleWizardContents;
import com.mathworks.widgets.wizard.ICodeGenerator;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public class ImportWizardContents
extends AbstractSimpleWizardContents
implements PropertyChangeListener,
PrefListener,
ICodeGenerator {
    private volatile DataSourceSelectionPanel fPanel0;
    private volatile DataInterpretationPanel fPanel1;
    private volatile VariableSourceSelectionPanel fPanel2;
    private ImportProxy fImportProxy;
    private int fHeaderLines;
    private int fRememberedHeaderLines;
    private String fDelim;
    private String fRememberedDelim;
    private String fPreviewText;
    private String[] fVariableNames;
    private String[] fVariableSizes;
    private long[] fVariableByteses;
    private String[] fVariableClasses;
    private String[] fColHeadersClean;
    private String[] fRowHeadersClean;
    private final File fSuppliedFile;
    private final boolean fForceClipboard;
    private final boolean fIsText;
    private boolean fGenerateCode;
    private static boolean sStartOnFirstPanel;
    private final boolean fIsSynchronous;
    private final boolean fIsSpreadsheetFile;
    private String fCurrentWorksheetname = "";
    private List<String> fCurrentVariableNames;
    private int fCounter;
    static final String NAVIGATION_CHANGED = "NAVIGATION_CHANGED";

    public static void setStartOnFirstPanel(boolean bl) {
        sStartOnFirstPanel = bl;
    }

    public ImportWizardContents() {
        this(false, null, null, -1, null, null, null, null, null, null, null, false, false);
    }

    public ImportWizardContents(boolean bl, File file, String string, int n, String string2, String[] stringArray, String[] stringArray2, long[] lArray, String[] stringArray3, String[] stringArray4, String[] stringArray5, boolean bl2, boolean bl3) {
        boolean bl4;
        boolean bl5;
        boolean bl6 = file == null;
        boolean bl7 = bl5 = !bl6 && file.getName() != null && file.getName().length() != 0;
        assert (bl != bl5);
        boolean bl8 = bl4 = bl5 && file.length() == 0L;
        assert (!bl4);
        this.fForceClipboard = bl;
        this.fSuppliedFile = file;
        this.fDelim = string;
        this.fRememberedHeaderLines = this.fHeaderLines = n;
        this.fRememberedDelim = this.fDelim;
        this.fPreviewText = string2;
        this.fVariableNames = stringArray != null ? (String[])stringArray.clone() : null;
        this.fVariableSizes = stringArray2 != null ? (String[])stringArray2.clone() : null;
        this.fVariableByteses = lArray != null ? (long[])lArray.clone() : null;
        this.fVariableClasses = stringArray3 != null ? (String[])stringArray3.clone() : null;
        this.fColHeadersClean = stringArray4 != null ? (String[])stringArray4.clone() : null;
        this.fRowHeadersClean = stringArray5 != null ? (String[])stringArray5.clone() : null;
        this.fCounter = -1;
        this.fIsText = this.fHeaderLines != -1;
        this.fImportProxy = new ImportProxy(this);
        this.fIsSynchronous = bl2;
        this.fIsSpreadsheetFile = bl3;
        sStartOnFirstPanel = this.fVariableSizes == null && this.fVariableSizes == null && this.fVariableByteses == null && this.fVariableClasses == null && this.fVariableNames == null;
        ColorPrefs.addColorListener((String)"ColorsBackground", (PrefListener)this);
        ColorPrefs.addColorListener((String)"ColorsText", (PrefListener)this);
    }

    private JPanel getPanel(int n) {
        switch (n) {
            case 0: {
                this.fRememberedHeaderLines = this.fHeaderLines;
                this.fRememberedDelim = this.fDelim;
                if (this.fPanel0 == null) {
                    this.fPanel0 = new DataSourceSelectionPanel(this, this.fImportProxy, this.fSuppliedFile, this.fForceClipboard);
                    this.fPanel0.addPropertyChangeListener(NAVIGATION_CHANGED, this);
                }
                return this.fPanel0;
            }
            case 1: {
                File file;
                if (this.fForceClipboard) {
                    file = null;
                } else {
                    file = this.fSuppliedFile;
                    if (file == null) {
                        file = new File(MatlabPath.getCWD());
                    }
                }
                if (this.fPanel1 == null) {
                    this.fPanel1 = new DataInterpretationPanel(this.fImportProxy, file, this.fDelim, this.fHeaderLines, this.fPreviewText, this.fVariableNames);
                    this.fPanel1.addPropertyChangeListener(NAVIGATION_CHANGED, this);
                } else {
                    this.fPanel1.reinitialize(file, this.fRememberedDelim, this.fRememberedHeaderLines, this.fPreviewText, this.fVariableNames);
                }
                return this.fPanel1;
            }
            case 2: {
                File file;
                if (this.fForceClipboard) {
                    file = null;
                } else {
                    file = this.fSuppliedFile;
                    if (file == null) {
                        file = new File(MatlabPath.getCWD());
                    }
                }
                if (this.fPanel1 != null) {
                    this.fRememberedHeaderLines = this.fPanel1.getHeaderLines();
                    this.fRememberedDelim = this.fPanel1.getDelimiter();
                }
                if (this.fPanel2 == null) {
                    this.fPanel2 = new VariableSourceSelectionPanel(this.fImportProxy, this.getCurrentWorksheetname(), file, this.getCurrentVariableNamesAsArray(), this.fVariableSizes, this.fVariableByteses, this.fVariableClasses, this.fColHeadersClean, this.fRowHeadersClean, this.fGenerateCode, this.fIsSynchronous);
                    this.fPanel2.addPropertyChangeListener(NAVIGATION_CHANGED, this);
                } else {
                    this.fPanel2.reinitialize(file, this.getCurrentWorksheetname(), this.getCurrentVariableNamesAsArray(), this.fVariableSizes, this.fVariableByteses, this.fVariableClasses, this.fColHeadersClean, this.fRowHeadersClean);
                }
                return this.fPanel2;
            }
        }
        return null;
    }

    public JPanel getStartupPanel() {
        this.fCounter = this.fIsText ? 1 : (this.fIsSpreadsheetFile ? 0 : (sStartOnFirstPanel ? 0 : 2));
        return this.getPanel(this.fCounter);
    }

    public JPanel getNextPanel() {
        if (this.fCounter == 0 || this.fCounter == 1) {
            this.fCounter = 2;
        }
        return this.getPanel(this.fCounter);
    }

    public JPanel getPreviousPanel() {
        if (this.fCounter == 2) {
            this.fCounter = this.fIsText ? 1 : 0;
        }
        return this.getPanel(this.fCounter);
    }

    public ImportProxy getImportProxy() {
        return this.fImportProxy;
    }

    public boolean isNextAvailable() {
        switch (this.fCounter) {
            case 0: {
                return this.fPanel0.isNextAvailable();
            }
            case 1: {
                return this.fPanel1.isNextAvailable();
            }
        }
        return false;
    }

    public boolean isBackAvailable() {
        return this.fCounter == 2 && this.fPanel2.isBackAvailable();
    }

    public boolean isFinishAvailable() {
        switch (this.fCounter) {
            case 0: {
                return DataSourceSelectionPanel.isFinishAvailable();
            }
            case 1: {
                return false;
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    public boolean needsBothNextAndFinish() {
        return true;
    }

    public String getName() {
        return ImportUtils.getResource("dialog.title");
    }

    public boolean finish() {
        boolean bl = this.fPanel2.finish();
        if (bl) {
            this.cleanup();
        }
        return bl;
    }

    public void cancel() {
        this.fImportProxy.requestCancel();
        this.cleanup();
    }

    private void cleanup() {
        ColorPrefs.removeColorListener((String)"ColorsBackground", (PrefListener)this);
        ColorPrefs.removeColorListener((String)"ColorsText", (PrefListener)this);
        if (this.fPanel0 != null) {
            this.fPanel0.cleanup();
            this.fPanel0 = null;
        }
        if (this.fPanel1 != null) {
            this.fPanel1.cleanup();
            this.fPanel1 = null;
        }
        if (this.fPanel2 != null) {
            this.fPanel2.cleanup();
            this.fPanel2 = null;
        }
        this.fImportProxy.cleanup();
        this.fImportProxy = null;
    }

    public Dimension getPreferredSize() {
        return new Dimension(300, 200);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.notifyNavigationListeners();
    }

    void setPreviewTextContents(String string, int n, String string2, String[] stringArray) {
        this.fPreviewText = string;
        this.fHeaderLines = n;
        this.fDelim = string2;
        this.fPanel0.setPreviewTextContents(string, true, stringArray, this.fIsSpreadsheetFile);
    }

    void setPreviewTabList(int n, String[] stringArray, String[] stringArray2, long[] lArray, String[] stringArray3, String[] stringArray4, String[] stringArray5, String[] stringArray6, String[] stringArray7, String string) {
        this.fVariableNames = stringArray != null ? (String[])stringArray.clone() : null;
        this.fVariableSizes = stringArray2 != null ? (String[])stringArray2.clone() : null;
        this.fVariableByteses = lArray != null ? (long[])lArray.clone() : null;
        this.fVariableClasses = stringArray3 != null ? (String[])stringArray3.clone() : null;
        this.fColHeadersClean = stringArray6 != null ? (String[])stringArray6.clone() : null;
        this.fRowHeadersClean = stringArray7 != null ? (String[])stringArray7.clone() : null;
        this.fPanel0.setPreviewTabList(n, stringArray, stringArray4, stringArray5, lArray, string);
    }

    void setPreviewTabListDelimiter(String[] stringArray, String[] stringArray2, long[] lArray, String[] stringArray3, String[] stringArray4, String[] stringArray5, String[] stringArray6, String[] stringArray7) {
        this.fVariableNames = stringArray != null ? (String[])stringArray.clone() : null;
        this.fVariableSizes = stringArray2 != null ? (String[])stringArray2.clone() : null;
        this.fVariableByteses = lArray != null ? (long[])lArray.clone() : null;
        this.fVariableClasses = stringArray3 != null ? (String[])stringArray3.clone() : null;
        this.fColHeadersClean = stringArray6 != null ? (String[])stringArray6.clone() : null;
        this.fRowHeadersClean = stringArray7 != null ? (String[])stringArray7.clone() : null;
        this.fPanel1.setPreviewTabList(stringArray);
    }

    public boolean isHelpAvailable() {
        return true;
    }

    public void showHelp() {
        String string = MLHelpServices.getMapfileName((String)"matlab", (String)"import_export");
        MLHelpServices.displayTopic((String)string, (String)"matlab_env_import_wizard");
    }

    static void addVariablePreviewData(IVariableContentsOwner iVariableContentsOwner, ValueSpecification valueSpecification, String string) {
        iVariableContentsOwner.addVariablePreviewData(valueSpecification, string);
    }

    static void addVariablePreviewData(IVariableContentsOwner iVariableContentsOwner, ValueSpecification valueSpecification, double[][] dArray, double[][] dArray2) {
        iVariableContentsOwner.addVariablePreviewData(valueSpecification, dArray, dArray2);
    }

    static void addVariablePreviewData(IVariableContentsOwner iVariableContentsOwner, ValueSpecification valueSpecification, int[][] nArray, int[][] nArray2) {
        iVariableContentsOwner.addVariablePreviewData(valueSpecification, nArray, nArray2);
    }

    public void prefChanged(PrefEvent prefEvent) {
        String string = prefEvent.getPrefKey();
        if (string.equals("ColorsBackground") || string.equals("ColorsText")) {
            if (this.fPanel0 != null) {
                this.fPanel0.resetColors();
            }
            if (this.fPanel1 != null) {
                this.fPanel1.resetColors();
            }
            if (this.fPanel2 != null) {
                this.fPanel2.resetColors();
            }
        }
    }

    public void setGenerateCodeOnFinish(boolean bl) {
        this.fGenerateCode = bl;
        if (this.fPanel2 != null) {
            this.fPanel2.setCodeGenerationRequested(bl);
        }
    }

    public boolean getGenerateCodeOnFinish() {
        return this.fGenerateCode;
    }

    public void browse() {
        assert (this.fCounter == 0);
        this.fPanel0.browse();
    }

    public String getCurrentWorksheetname() {
        return this.fCurrentWorksheetname;
    }

    public void setCurrentWorksheetname(String string) {
        this.fCurrentWorksheetname = string;
    }

    public List<String> getCurrentVariableNames() {
        return this.fCurrentVariableNames;
    }

    public void clearCurrentVariableNames() {
        if (this.fCurrentVariableNames != null) {
            this.fCurrentVariableNames.clear();
        }
    }

    public void addVariableName(String string) {
        if (this.fCurrentVariableNames == null) {
            this.fCurrentVariableNames = new ArrayList<String>();
        }
        this.fCurrentVariableNames.add(string);
    }

    public boolean isSpreasheetFile() {
        return this.fIsSpreadsheetFile;
    }

    public String[] getCurrentVariableNamesAsArray() {
        if (this.fCurrentVariableNames == null) {
            return this.fVariableNames;
        }
        Object[] objectArray = this.fCurrentVariableNames.toArray();
        int n = objectArray.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        for (Object object : objectArray) {
            stringArray[n2++] = (String)object;
        }
        return stringArray;
    }
}

