/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.cmdwin;

import com.mathworks.mde.cmdhist.CmdHistory;
import com.mathworks.mde.cmdwin.CmdWinDocument;
import com.mathworks.mde.cmdwin.CmdWinDocumentUtilities;
import com.mathworks.mde.cmdwin.CmdWinMLIF;
import com.mathworks.mde.cmdwin.CmdWinPrefs;
import com.mathworks.mde.cmdwin.CmdWinTextUtilities;
import com.mathworks.mde.cmdwin.CmdWinUndoManager;
import com.mathworks.mde.cmdwin.Prompt;
import com.mathworks.mde.cmdwin.TabCompletionImpl;
import com.mathworks.mde.cmdwin.XCaret;
import com.mathworks.mde.cmdwin.XCmdWndView;
import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mde.find.FindFiles;
import com.mathworks.mde.functionbrowser.FunctionBrowser;
import com.mathworks.mde.functionhints.FunctionHints;
import com.mathworks.mlwidgets.help.HelpPopup;
import com.mathworks.mlwidgets.tabcompletion.TabCompletionAction;
import com.mathworks.mlwidgets.tabcompletion.TabCompletionInterface;
import com.mathworks.mwswing.ClipboardListener;
import com.mathworks.mwswing.ClipboardMonitor;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.binding.ActionData;
import com.mathworks.mwswing.binding.Context;
import com.mathworks.mwswing.binding.KeyBindingManager;
import com.mathworks.mwswing.binding.KeyStrokeList;
import com.mathworks.mwswing.text.MTextAction;
import com.mathworks.services.Prefs;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.util.Log;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.StringUtils;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.im.InputContext;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;
import javax.swing.text.TextAction;

public class CmdWinEditorKit
extends DefaultEditorKit
implements ClipboardListener {
    private static Hashtable<String, Action> sDefaultActionTable = new Hashtable();
    private static Hashtable<String, Action> sActionTable = new Hashtable();
    private static TabCompletionAction sCWTabAction = new CWTabCompletionAction();
    private static CmdWinUndoManager sCmdWinUndoMgr = null;
    public static final String insertBreakAction = "insert-break";
    public static final String selectWordAction = "select-word";
    public static final String insertTabAction = "insert-tab";
    public static final String deletePrevCharAction = "delete-previous";
    public static final String defaultKey = "default-typed";
    public static final String deleteNextCharAction = "delete-next";
    public static final String cwDownHistory = "next-history-item";
    public static final String cwUpHistory = "previous-history-item";
    public static final String beginLineAction = "caret-begin-line";
    public static final String endLineAction = "caret-end-line";
    public static final String undoAction = "undo";
    public static final String redoAction = "redo";
    public static final String escAction = "clear-text-at-prompt";
    public static final String killCutAction = "kill-line";
    public static final String cutAction = "cut-to-clipboard";
    public static final String copyAction = "copy-to-clipboard";
    public static final String pasteAction = "paste-from-clipboard";
    public static final String breakAction = "break-interrupt";
    public static final String selectionBeginLineAction = "selection-begin-line";
    public static final String selectionEndLineAction = "selection-end-line";
    public static final String evaluateSelection = "evaluate-selection";
    public static final String selectLineAction = "select-line";
    public static final String clearWindow = "clear-command-window";
    public static final String helpOnSelection = "help-on-selection";
    public static final String openSelection = "open-selection";
    public static final String print = "print";
    public static final String dropLine = "drop-line";
    public static final String pageSetup = "show-page-setup";
    public static final String printSelection = "print-selection";
    public static final String findString = "find-and-replace";
    public static final String findFilesString = "find-files";
    public static final String incForwardString = "inc-search-forward";
    public static final String incBackwardString = "inc-search-backward";
    public static final String pageUpAction = "page-up";
    public static final String pageDownAction = "page-down";
    public static final String endAction = "caret-end";
    public static final String beginAction = "caret-begin";
    public static final String ctrlReturnAction = "open-errored-file";
    public static final String nextWordAction = "caret-next-word";
    public static final String previousWordAction = "caret-previous-word";
    public static final String selNextWordAction = "selection-next-word";
    public static final String selPreviousWordAction = "selection-previous-word";
    public static final String overWrite = "toggle-typing-mode";
    public static final String forwardAction = "caret-forward";
    public static final String backwardAction = "caret-backward";
    public static final String upAction = "caret-up";
    public static final String downAction = "caret-down";
    public static final String scrollTop = "adjust-window-top";
    public static final String scrollBottom = "adjust-window-bottom";
    public static final String openFunctionBrowser = "function-browser-key";
    public static final String showFunctionBrowserButton = "show-funcbrowser-btn";
    public static final String openFunctionHints = "function-hints-key";
    private static final Action[] sCWActions = new Action[]{new CWDefaultKeyTypedAction(), new CWOverwrite(), new CWReturnAction(), sCWTabAction, new CWDeleteNextCharAction(), new CWDeletePrevCharAction(), new CWDownHistoryAction(), new CWUpHistoryAction(), new SelectWordAction(), new CWBeginLineAction("caret-begin-line", false), new CWBeginLineAction("selection-begin-line", true), new CWEndLineAction("caret-end-line", false), new CWEndLineAction("selection-end-line", true), new CWSelectLineAction(), new CWUndoAction(), new CWRedoAction(), new CWEscAction(), new CWKillCutAction(), new CWCutAction(), new CWCopyAction(), new CWPasteAction(), new CWNavigationAction("page-up"), new CWNavigationAction("page-down"), new CWNavigationAction("caret-end"), new CWNavigationAction("caret-begin"), new CWBreakAction(), new EvaluateAction(), new HelpAction(), new OpenSelAction(), new PrintAction(), new DropLineAction(), new PageSetupAction(), new PrintSelectionAction(), new FindAction(), new FindFilesAction(), new IncrementalSearchAction("inc-search-forward", true), new IncrementalSearchAction("inc-search-backward", false), new CWSelectAllAction(), new CtrlReturnAction(), new CWNextWordAction("caret-next-word", false), new CWPreviousWordAction("caret-previous-word", false), new CWNextWordAction("selection-next-word", true), new CWPreviousWordAction("selection-previous-word", true), new ClearCommandWindowAction(), new CWNextVisualPositionAction("caret-forward", 3), new CWNextVisualPositionAction("caret-backward", 7), new CWUpOrDownAction("caret-up"), new CWUpOrDownAction("caret-down"), new ScrollToTop(), new ScrollToBottom(), new FunctionBrowserAction(), new FunctionBrowserButtonShowAction(), new FunctionHintsAction()};
    private static final CmdWinDocument sCWDoc = CmdWinDocument.getInstance();
    private static StringCharacterIterator sHandyIterator = new StringCharacterIterator("h");
    private static String sLastHistoryCmd = "";
    private static String sLastCommandPrefixForHistory = null;
    private static Segment sSegmentForHistory = new Segment();
    private static final CmdWinEditorKit sCWKit = new CmdWinEditorKit();

    private CmdWinEditorKit() {
        CmdWinEditorKit.createDefaultActionTable(this);
        CmdWinEditorKit.createActionTable();
        if (!PlatformInfo.isUnix()) {
            ClipboardMonitor.addListener((ClipboardListener)this);
            this.clipboardContentTypeChanged(ClipboardMonitor.getFlavors());
        }
        sCmdWinUndoMgr = CmdWinUndoManager.getInstance(this, sCWDoc, XCmdWndView.getInstance());
    }

    public void clipboardContentTypeChanged(DataFlavor[] dataFlavorArray) {
        boolean bl = false;
        if (dataFlavorArray != null) {
            for (int i = 0; i < dataFlavorArray.length && !bl; ++i) {
                bl = dataFlavorArray[i].equals(DataFlavor.stringFlavor);
            }
        }
        CmdWinEditorKit.getActionByName(pasteAction).setEnabled(bl);
    }

    static boolean containsWhitespace(CharacterIterator characterIterator) {
        char c = characterIterator.first();
        while (c != '\uffff') {
            if (Character.isWhitespace(c)) {
                return true;
            }
            c = characterIterator.next();
        }
        return characterIterator.getEndIndex() == 0;
    }

    private static void createActionTable() {
        Action[] actionArray = sCWActions;
        for (int i = 0; i < actionArray.length; ++i) {
            Action action = actionArray[i];
            Object object = action.getValue("ActionCommandKey");
            if (object == null) {
                object = action.getValue("Name");
            }
            sActionTable.put((String)object, action);
        }
    }

    private static void createDefaultActionTable(CmdWinEditorKit cmdWinEditorKit) {
        Action[] actionArray = cmdWinEditorKit.getDefaultActions();
        for (int i = 0; i < actionArray.length; ++i) {
            Action action = actionArray[i];
            sDefaultActionTable.put((String)action.getValue("Name"), action);
        }
    }

    @Override
    public Document createDefaultDocument() {
        return CmdWinDocument.getInstance();
    }

    @Override
    public Action[] getActions() {
        return TextAction.augmentList(super.getActions(), sCWActions);
    }

    static Action getActionByName(String string) {
        return sActionTable.get(string);
    }

    static Action getDefaultActionByName(String string) {
        return sDefaultActionTable.get(string);
    }

    private Action[] getDefaultActions() {
        return super.getActions();
    }

    static CmdWinEditorKit getInstance() {
        return sCWKit;
    }

    static void insertCommandAndSend(String string) throws BadLocationException {
        sCWDoc.setUserInitialized();
        XCaret.combineCarets();
        try {
            sCWDoc.clearSuggestion();
            sCWDoc.insertAtPrompt(string);
        }
        catch (Exception exception) {
            Log.logException((Exception)exception);
        }
        int n = sCWDoc.getAfterThePrompt() + string.length();
        CmdWinEditorKit.sendCurrentCommand(n);
    }

    static void insertCommand(String string) throws BadLocationException {
        sCWDoc.setUserInitialized();
        XCaret.combineCarets();
        try {
            string = string + "\n";
            sCWDoc.insertAtPrompt(string);
        }
        catch (Exception exception) {
            Log.logException((Exception)exception);
        }
        int n = sCWDoc.getAfterThePrompt() + string.length();
        if (string != null) {
            sHandyIterator.setText(string);
            if (!CmdWinEditorKit.isWhitespace(sHandyIterator)) {
                CmdWinEditorKit.sendCommandToHistory(string);
                sCWDoc.setPrompt(Prompt.NULL_PROMPT);
            }
        }
        CmdHistory.getInstance().reset();
        try {
            sCWDoc.insertPrompt(n);
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
            return;
        }
    }

    static boolean isWhitespace(CharacterIterator characterIterator) {
        char c = characterIterator.first();
        while (c != '\uffff') {
            if (!Character.isWhitespace(c)) {
                return false;
            }
            c = characterIterator.next();
        }
        return true;
    }

    static void sendCurrentCommand(int n) {
        int n2;
        String string;
        assert (EventQueue.isDispatchThread());
        try {
            if (sCWDoc.getInUsePrompt() == Prompt.TYPEAHEAD_PROMPT) {
                sCWDoc.setPrompt(Prompt.NULL_PROMPT);
                sCWDoc.replacePrompt();
                n -= Prompt.TYPEAHEAD_PROMPT.length();
            }
            if ((string = sCWDoc.getText(n2 = sCWDoc.getAfterThePrompt(), n - n2)) == null || !string.endsWith("\n")) {
                sCWDoc.insertString(n, "\n", null);
                ++n;
            }
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
            return;
        }
        n2 = sCWDoc.getAfterThePrompt();
        string = null;
        try {
            string = sCWDoc.getText(n2, n - n2);
        }
        catch (Exception exception) {
            Log.logException((Exception)exception);
        }
        if (string != null) {
            sHandyIterator.setText(string);
            if (!CmdWinEditorKit.isWhitespace(sHandyIterator)) {
                CmdWinEditorKit.sendCommandToHistory(string);
                sCWDoc.setPrompt(Prompt.NULL_PROMPT);
            }
            CmdWinMLIF.doEval(string);
        }
        CmdHistory.getInstance().reset();
        try {
            sCWDoc.insertPrompt(n);
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
            return;
        }
        sCmdWinUndoMgr.reset();
    }

    private static void sendCommandToHistory(String string) {
        string = string.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r");
        String string2 = "";
        while (stringTokenizer.hasMoreElements()) {
            string2 = stringTokenizer.nextToken();
            sHandyIterator.setText(string2);
            if (CmdWinEditorKit.isWhitespace(sHandyIterator) || CmdWinMLIF.isInBangMode()) continue;
            CmdHistory.getInstance().add(string2.trim(), !stringTokenizer.hasMoreElements());
        }
    }

    private static void openFunctionHints(JTextComponent jTextComponent) {
        try {
            int n = jTextComponent.getCaretPosition() - sCWDoc.getAfterThePrompt();
            if (n > 0) {
                FunctionHints.openFunctionHintsSynchronously(jTextComponent, sCWDoc.getText(sCWDoc.getAfterThePrompt(), n));
            } else {
                FunctionHints.hidePopup();
            }
        }
        catch (BadLocationException badLocationException) {
            Log.log((String)badLocationException.toString());
        }
    }

    private static void maybeOpenFunctionHints(JTextComponent jTextComponent, ActionEvent actionEvent) {
        if (!Prefs.getBooleanPref((String)"CommandWindowFunctionHints", (boolean)true)) {
            return;
        }
        try {
            int n = jTextComponent.getCaretPosition() - sCWDoc.getAfterThePrompt();
            if (n > 0) {
                FunctionHints.openFunctionHints(jTextComponent, sCWDoc.getText(sCWDoc.getAfterThePrompt(), n), actionEvent);
            } else {
                FunctionHints.hidePopup();
            }
        }
        catch (BadLocationException badLocationException) {
            Log.log((String)actionEvent.toString());
        }
    }

    private static void closeFunctionHints() {
        FunctionHints.hidePopup();
    }

    private static boolean doesCopyActionUseKeyStroke(KeyStroke keyStroke) {
        if (keyStroke == null) {
            return false;
        }
        KeyBindingManager keyBindingManager = MatlabKeyBindings.getManager();
        Context context = keyBindingManager.getContext("CommandWindow");
        ActionData actionData = keyBindingManager.getActionData(copyAction);
        List list = keyBindingManager.getCurrentKeyBindingSet().getKeyBindings(context, actionData);
        return list.contains(new KeyStrokeList(new KeyStroke[]{keyStroke}));
    }

    private static void selectWord(ActionEvent actionEvent, JTextComponent jTextComponent) {
        if (jTextComponent != null) {
            try {
                int n = jTextComponent.getCaretPosition();
                int n2 = CmdWinTextUtilities.getWordStart(jTextComponent, n);
                int n3 = CmdWinTextUtilities.getWordEnd(jTextComponent, n);
                jTextComponent.setCaretPosition(n2);
                jTextComponent.moveCaretPosition(n3);
            }
            catch (BadLocationException badLocationException) {
                UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
            }
        }
    }

    private static void insertCommandFromHistory(boolean bl) {
        try {
            sCWDoc.clearSuggestion();
            sCWDoc.getCurrentPromptLine(sSegmentForHistory);
            String string = sSegmentForHistory.toString();
            if (sLastCommandPrefixForHistory == null) {
                sLastCommandPrefixForHistory = string;
            }
            if (string.equals(sLastHistoryCmd)) {
                string = sLastCommandPrefixForHistory;
            } else {
                CmdHistory.getInstance().reset();
            }
            String string2 = bl ? (String)CmdHistory.getInstance().next(string) : (String)CmdHistory.getInstance().previous(string);
            if (string2 == null || string2.equals("")) {
                Toolkit.getDefaultToolkit().beep();
                sCWDoc.removeCurrentPromptLine();
                sCWDoc.insertAtPrompt(sLastCommandPrefixForHistory);
                sLastCommandPrefixForHistory = null;
            } else {
                sLastHistoryCmd = string2;
                sLastCommandPrefixForHistory = string;
                sCWDoc.removeCurrentPromptLine();
                sCWDoc.insertAtPrompt(string2);
            }
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
            return;
        }
    }

    private static class CWTabCompletionAction
    extends TabCompletionAction {
        private CWTabCompletionAction() {
            super((TabCompletionInterface)new TabCompletionImpl());
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("CommandWindow", CmdWinEditorKit.insertTabAction, (ExtendedAction)this);
        }
    }

    public static class IncrementalSearchAction
    extends CWTextAction {
        private boolean fForward = true;

        IncrementalSearchAction(String string, boolean bl) {
            super(string);
            this.fForward = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XCmdWndView.getInstance().startIncSearch(this.fForward);
        }
    }

    public static class FindAction
    extends CWTextAction {
        FindAction() {
            super(CmdWinEditorKit.findString);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XCmdWndView.getInstance().invokeFindDialog();
        }
    }

    public static class FindFilesAction
    extends CWTextAction {
        FindFilesAction() {
            super(CmdWinEditorKit.findFilesString);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponentIfNull(actionEvent);
            FindFiles.invoke(jTextComponent.getSelectedText());
        }
    }

    private static class CWOverwrite
    extends CWTextAction {
        CWOverwrite() {
            super(CmdWinEditorKit.overWrite);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XCmdWndView cfr_ignored_0 = (XCmdWndView)this.getTextComponentIfNull(actionEvent);
            XCmdWndView.setOverwriteMode(!((XCmdWndView)this.getTextComponentIfNull(actionEvent)).isOverwriteMode());
        }
    }

    private static class CWSelectLineAction
    extends CWTextAction {
        private Action start = new CWBeginLineAction("caret-begin-line", false);

        CWSelectLineAction() {
            super(CmdWinEditorKit.selectLineAction, false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CmdWinEditorKit.closeFunctionHints();
            this.start.actionPerformed(actionEvent);
            JTextComponent jTextComponent = this.getTextComponentIfNull(actionEvent);
            int n = jTextComponent.getCaretPosition();
            int n2 = CmdWinDocumentUtilities.getLineEnd(sCWDoc, n);
            if (sCWDoc.isAfterThePrompt(n)) {
                n2 = sCWDoc.getPromptLineEndOffset(false);
            }
            if (n2 < sCWDoc.getLength()) {
                jTextComponent.moveCaretPosition(n2 + 1);
            } else {
                jTextComponent.moveCaretPosition(n2);
            }
        }
    }

    private static class CWSelectAllAction
    extends CWTextAction {
        CWSelectAllAction() {
            super("select-all");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Action action = CmdWinEditorKit.getDefaultActionByName("select-all");
            action.actionPerformed(actionEvent);
        }
    }

    private static class ScrollToBottom
    extends CWTextAction {
        ScrollToBottom() {
            super(CmdWinEditorKit.scrollBottom);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XCmdWndView.getInstance().scrollToOffset(sCWDoc.getLength() - 1);
        }
    }

    private static class ScrollToTop
    extends CWTextAction {
        ScrollToTop() {
            super(CmdWinEditorKit.scrollTop);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XCmdWndView.getInstance().scrollToOffset(0);
        }
    }

    private static class DropLineAction
    extends CWTextAction {
        DropLineAction() {
            super(CmdWinEditorKit.dropLine);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                JTextComponent jTextComponent = this.getTextComponentIfNull(actionEvent);
                if (!(jTextComponent.getCaret() instanceof XCaret)) {
                    InputContext inputContext = jTextComponent.getInputContext();
                    if (inputContext != null) {
                        inputContext.endComposition();
                    }
                    return;
                }
                XCaret xCaret = (XCaret)jTextComponent.getCaret();
                int n = xCaret.getDot();
                if (sCWDoc.isInOrBeforeThePrompt(n)) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                sCWDoc.insertString(n, "\n", null);
            }
            catch (BadLocationException badLocationException) {
                Log.logException((Exception)badLocationException);
            }
        }
    }

    public static class CWDefaultKeyTypedAction
    extends CWTextAction {
        public CWDefaultKeyTypedAction() {
            super(CmdWinEditorKit.defaultKey, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            char c;
            boolean bl;
            if (actionEvent.getModifiers() == 0) {
                sCWKit;
                sLastCommandPrefixForHistory = null;
            }
            sCWDoc.clearSuggestionFlag();
            JTextComponent jTextComponent = this.getTextComponentIfNull(actionEvent);
            Caret caret = jTextComponent.getCaret();
            int n = caret.getDot();
            if (!((XCmdWndView)jTextComponent).isOverwriteMode() || sCWDoc.isInOrBeforeThePrompt(n) || jTextComponent.getSelectedText() != null) {
                CmdWinEditorKit.getDefaultActionByName(CmdWinEditorKit.defaultKey).actionPerformed(actionEvent);
                CmdWinEditorKit.maybeOpenFunctionHints(jTextComponent, actionEvent);
                return;
            }
            int n2 = actionEvent.getModifiers();
            boolean bl2 = (n2 & 2) != 0;
            boolean bl3 = bl = (n2 & 8) != 0;
            if (bl && !bl2 || bl2 && !bl) {
                return;
            }
            if (jTextComponent != null && actionEvent != null && (c = (string = actionEvent.getActionCommand()).charAt(0)) >= ' ' && c != '\u007f') {
                XCaret.adjustSelection(caret);
                try {
                    if (n < sCWDoc.getLength() && sCWDoc.getText(n, 1).charAt(0) != '\n') {
                        sCWDoc.remove(n, 1);
                        sCWDoc.insertString(n, string, null);
                    } else {
                        jTextComponent.replaceSelection(string);
                    }
                    CmdWinEditorKit.maybeOpenFunctionHints(jTextComponent, actionEvent);
                }
                catch (BadLocationException badLocationException) {
                    Log.logException((Exception)badLocationException);
                }
            }
        }
    }

    static class SelectWordAction
    extends CWTextAction {
        SelectWordAction() {
            super(CmdWinEditorKit.selectWordAction, false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CmdWinEditorKit.selectWord(actionEvent, this.getTextComponentIfNull(actionEvent));
        }
    }

    private static class CWUpHistoryAction
    extends CWTextAction {
        CWUpHistoryAction() {
            super(CmdWinEditorKit.cwUpHistory);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (FunctionHints.isOpen()) {
                FunctionHints.hidePopup();
            }
            XCaret.combineCarets();
            CmdWinEditorKit.insertCommandFromHistory(false);
        }
    }

    static class CWNextWordAction
    extends CWTextAction {
        private boolean select;

        CWNextWordAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                int n = jTextComponent.getCaretPosition();
                boolean bl = false;
                int n2 = n;
                Element element = CmdWinTextUtilities.getParagraphElement(jTextComponent, n);
                try {
                    n = CmdWinTextUtilities.getNextWord(jTextComponent, n);
                    if (n >= element.getEndOffset() && n2 != element.getEndOffset() - 1) {
                        n = element.getEndOffset() - 1;
                    }
                }
                catch (BadLocationException badLocationException) {
                    int n3 = jTextComponent.getDocument().getLength();
                    if (n != n3) {
                        n = n2 != element.getEndOffset() - 1 ? element.getEndOffset() - 1 : n3;
                    }
                    bl = true;
                }
                if (!bl) {
                    if (this.select) {
                        jTextComponent.moveCaretPosition(n);
                    } else {
                        jTextComponent.setCaretPosition(n);
                    }
                    CmdWinEditorKit.maybeOpenFunctionHints(jTextComponent, actionEvent);
                } else {
                    UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
                }
            }
        }
    }

    private static class CWUpOrDownAction
    extends CWTextAction {
        CWUpOrDownAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Action action = CmdWinEditorKit.getDefaultActionByName(this.getActionID());
            assert (action != null) : "Could not find action for id: " + this.getActionID();
            action.actionPerformed(actionEvent);
        }
    }

    private static class CWNextVisualPositionAction
    extends CWTextAction {
        private int iDirection;
        private String iName;

        CWNextVisualPositionAction(String string, int n) {
            super(string);
            this.iDirection = n;
            this.iName = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent.getSelectionStart() == jTextComponent.getSelectionEnd()) {
                Action action = CmdWinEditorKit.getDefaultActionByName(this.iName);
                action.actionPerformed(actionEvent);
                CmdWinEditorKit.maybeOpenFunctionHints(jTextComponent, actionEvent);
                return;
            }
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                if (this.iDirection == 3) {
                    caret.setDot(jTextComponent.getSelectionEnd());
                    CmdWinEditorKit.maybeOpenFunctionHints(jTextComponent, actionEvent);
                    return;
                }
                if (this.iDirection == 7) {
                    caret.setDot(jTextComponent.getSelectionStart());
                    CmdWinEditorKit.maybeOpenFunctionHints(jTextComponent, actionEvent);
                    return;
                }
            }
        }
    }

    static class CWPreviousWordAction
    extends CWTextAction {
        private boolean select;

        CWPreviousWordAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                int n = jTextComponent.getCaretPosition();
                boolean bl = false;
                try {
                    Element element = CmdWinTextUtilities.getParagraphElement(jTextComponent, n);
                    n = CmdWinTextUtilities.getPreviousWord(jTextComponent, n);
                    if (n < element.getStartOffset()) {
                        n = CmdWinTextUtilities.getParagraphElement(jTextComponent, n).getEndOffset() - 1;
                    }
                }
                catch (BadLocationException badLocationException) {
                    if (n != 0) {
                        n = 0;
                    }
                    bl = true;
                }
                if (!bl) {
                    if (this.select) {
                        jTextComponent.moveCaretPosition(n);
                    } else {
                        jTextComponent.setCaretPosition(n);
                    }
                    CmdWinEditorKit.maybeOpenFunctionHints(jTextComponent, actionEvent);
                } else {
                    UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
                }
            }
        }
    }

    private static class CWDownHistoryAction
    extends CWTextAction {
        CWDownHistoryAction() {
            super(CmdWinEditorKit.cwDownHistory);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (FunctionHints.isOpen()) {
                FunctionHints.hidePopup();
            }
            XCaret.combineCarets();
            CmdWinEditorKit.insertCommandFromHistory(true);
        }
    }

    private static class CWPasteAction
    extends CWTextAction {
        CWPasteAction() {
            super(CmdWinEditorKit.pasteAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            sCmdWinUndoMgr.startEditGroup();
            this.getTextComponentIfNull(actionEvent).paste();
            sCmdWinUndoMgr.endEditGroup();
        }
    }

    private static class CWCutAction
    extends CWTextAction {
        CWCutAction() {
            super(CmdWinEditorKit.cutAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            sCmdWinUndoMgr.startEditGroup();
            Action action = CmdWinEditorKit.getDefaultActionByName(CmdWinEditorKit.cutAction);
            action.actionPerformed(actionEvent);
            sCmdWinUndoMgr.endEditGroup();
        }
    }

    private static class CWCopyAction
    extends CWTextAction {
        CWCopyAction() {
            super(CmdWinEditorKit.copyAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.getTextComponentIfNull(actionEvent).copy();
        }
    }

    private static class CWBreakAction
    extends CWTextAction {
        CWBreakAction() {
            super(CmdWinEditorKit.breakAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            KeyStroke keyStroke = XCmdWndView.getInstance().getLastKeyStrokePressed();
            Action action = CmdWinEditorKit.getActionByName(CmdWinEditorKit.copyAction);
            if (CmdWinEditorKit.doesCopyActionUseKeyStroke(keyStroke) && action.isEnabled()) {
                action.actionPerformed(actionEvent);
            } else {
                Caret caret = this.getTextComponentIfNull(actionEvent).getCaret();
                caret.setDot(sCWDoc.getLength());
                XCaret.combineCarets();
                CmdWinMLIF.sendInterruptMsg();
            }
        }
    }

    private static class CWEscAction
    extends CWTextAction {
        CWEscAction() {
            super(CmdWinEditorKit.escAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (FunctionHints.isOpen()) {
                FunctionHints.hidePopup();
                return;
            }
            try {
                Caret caret = this.getTextComponentIfNull(actionEvent).getCaret();
                if (sCWDoc.isInOrBeforeThePrompt(caret.getDot())) {
                    XCaret.combineCarets();
                }
                sCWDoc.removeCurrentPromptLine();
                sCWKit;
                sLastCommandPrefixForHistory = null;
            }
            catch (BadLocationException badLocationException) {
                Log.logException((Exception)badLocationException);
                return;
            }
        }
    }

    private static class FunctionHintsAction
    extends CWTextAction {
        FunctionHintsAction() {
            super(CmdWinEditorKit.openFunctionHints);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            CmdWinEditorKit.openFunctionHints(jTextComponent);
        }
    }

    private static class FunctionBrowserButtonShowAction
    extends CWTextAction {
        FunctionBrowserButtonShowAction() {
            super(CmdWinEditorKit.showFunctionBrowserButton);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CmdWinPrefs.setShowFunctionBrowser(true);
        }
    }

    private static class FunctionBrowserAction
    extends CWTextAction {
        FunctionBrowserAction() {
            super(CmdWinEditorKit.openFunctionBrowser);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponentIfNull(actionEvent);
            String string = Prompt.stripPrompts(jTextComponent.getSelectedText());
            FunctionBrowser.open(jTextComponent, string);
        }
    }

    static class PageSetupAction
    extends CWTextAction {
        PageSetupAction() {
            super(CmdWinEditorKit.pageSetup);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XCmdWndView.showPageSetupDialog();
        }
    }

    static class PrintSelectionAction
    extends CWTextAction {
        PrintSelectionAction() {
            super(CmdWinEditorKit.printSelection);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XCmdWndView.getInstance().print(true);
        }
    }

    static class PrintAction
    extends CWTextAction {
        PrintAction() {
            super(CmdWinEditorKit.print);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XCmdWndView.getInstance().print(false);
        }
    }

    private static class OpenSelAction
    extends CWTextAction {
        OpenSelAction() {
            super(CmdWinEditorKit.openSelection);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.getTextComponentIfNull(actionEvent).getSelectedText().trim();
            string = StringUtils.quoteSingleQuotes((String)string);
            CmdWinMLIF.doEval("try open('" + string + "'); catch edit('" + string + "'); end");
            XCaret.combineCarets();
        }
    }

    private static class HelpAction
    extends CWTextAction {
        HelpAction() {
            super(CmdWinEditorKit.helpOnSelection);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.getAcceleratorSequence() != null) {
                HelpPopup.showHelp((JTextComponent)this.getTextComponentIfNull(actionEvent), (KeyStrokeList)new KeyStrokeList(this.getAcceleratorSequence()));
            } else {
                HelpPopup.showHelp((JTextComponent)this.getTextComponentIfNull(actionEvent), (KeyStroke)this.getAccelerator());
            }
        }
    }

    private static class ClearCommandWindowAction
    extends CWTextAction {
        ClearCommandWindowAction() {
            super(CmdWinEditorKit.clearWindow);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MLDesktop.getInstance().getClearCommandAction().actionPerformed(actionEvent);
            CmdWinEditorKit.closeFunctionHints();
        }
    }

    private static class EvaluateAction
    extends CWTextAction {
        EvaluateAction() {
            super(CmdWinEditorKit.evaluateSelection);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = Prompt.stripPrompts(this.getTextComponentIfNull(actionEvent).getSelectedText());
            XCaret.combineCarets();
            CmdWinMLIF.doExecuteCommand(string);
        }
    }

    private static class CWKillCutAction
    extends CWTextAction {
        CWKillCutAction() {
            super(CmdWinEditorKit.killCutAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponentIfNull(actionEvent);
            if (!(jTextComponent.getCaret() instanceof XCaret)) {
                InputContext inputContext = jTextComponent.getInputContext();
                if (inputContext != null) {
                    inputContext.endComposition();
                }
                return;
            }
            XCaret xCaret = (XCaret)this.getTextComponentIfNull(actionEvent).getCaret();
            int n = xCaret.getDot();
            if (sCWDoc.isInOrBeforeThePrompt(n)) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            xCaret.removeSelection();
            Action action = CmdWinEditorKit.getActionByName(CmdWinEditorKit.selectionEndLineAction);
            action.actionPerformed(actionEvent);
            action = CmdWinEditorKit.getDefaultActionByName(CmdWinEditorKit.cutAction);
            action.actionPerformed(actionEvent);
        }
    }

    private static class CWRedoAction
    extends CWTextAction {
        CWRedoAction() {
            super(CmdWinEditorKit.redoAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (sCmdWinUndoMgr.canRedo()) {
                sCmdWinUndoMgr.redo();
            }
            CmdWinEditorKit.closeFunctionHints();
        }
    }

    private static class CWUndoAction
    extends CWTextAction {
        CWUndoAction() {
            super(CmdWinEditorKit.undoAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (sCmdWinUndoMgr.canUndo()) {
                sCmdWinUndoMgr.undo();
            }
            CmdWinEditorKit.closeFunctionHints();
        }
    }

    private static class CWReturnAction
    extends CWTextAction {
        public CWReturnAction() {
            super(CmdWinEditorKit.insertBreakAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CmdWinEditorKit.closeFunctionHints();
            if (CmdWinMLIF.isInBangMode() && PlatformInfo.isUnix()) {
                return;
            }
            JTextComponent jTextComponent = this.getTextComponentIfNull(actionEvent);
            String string = jTextComponent.getSelectedText();
            if (!(jTextComponent.getCaret() instanceof XCaret)) {
                InputContext inputContext = jTextComponent.getInputContext();
                if (inputContext != null) {
                    inputContext.endComposition();
                }
                return;
            }
            try {
                jTextComponent.setCaretPosition(sCWDoc.getPromptLineEndOffset(false));
            }
            catch (Exception exception) {
                assert (exception instanceof IllegalArgumentException);
                jTextComponent.setCaretPosition(sCWDoc.getLength());
            }
            if (string != null && string.length() > 0) {
                CmdWinMLIF.doExecuteCommand(string);
            } else {
                CmdWinEditorKit.sendCurrentCommand(sCWDoc.getPromptLineEndOffset(false));
            }
        }
    }

    private static class CtrlReturnAction
    extends CWTextAction {
        public CtrlReturnAction() {
            super(CmdWinEditorKit.ctrlReturnAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Point point = XCaret.getInstance().getLocation();
            if (sCWDoc.isClickInHyperLink(point)) {
                sCWDoc.goToHyperLink(point);
            }
        }
    }

    private static class CWNavigationAction
    extends CWTextAction {
        private String name = null;

        public CWNavigationAction(String string) {
            super(string);
            this.name = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (FunctionHints.isOpen()) {
                FunctionHints.dispatchKeyEventToScrollPane(actionEvent);
                return;
            }
            Action action = CmdWinEditorKit.getDefaultActionByName(this.name);
            action.actionPerformed(actionEvent);
        }
    }

    private static class CWDeletePrevCharAction
    extends CWTextAction {
        CWDeletePrevCharAction() {
            super(CmdWinEditorKit.deletePrevCharAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            Caret caret = this.getTextComponentIfNull(actionEvent).getCaret();
            JTextComponent jTextComponent = this.getTextComponentIfNull(actionEvent);
            int n2 = caret.getDot();
            boolean bl = n2 != (n = caret.getMark());
            boolean bl2 = sCWDoc.isInOrBeforeThePrompt(n2);
            boolean bl3 = sCWDoc.isInOrBeforeThePrompt(n);
            if (bl && (bl2 && bl3 || bl2 && sCWDoc.isInOrBeforeThePrompt(caret.getMark() - 1) || bl3 && sCWDoc.isInOrBeforeThePrompt(caret.getDot() - 1))) {
                XCaret.adjustSelection(caret);
                Toolkit.getDefaultToolkit().beep();
            } else if (!bl && sCWDoc.isInOrBeforeThePrompt(n2 - 1)) {
                XCaret.adjustSelection(caret);
                if (sCWDoc.isInOrBeforeThePrompt(caret.getDot() - 1)) {
                    Toolkit.getDefaultToolkit().beep();
                } else {
                    Action action = CmdWinEditorKit.getDefaultActionByName(CmdWinEditorKit.deletePrevCharAction);
                    action.actionPerformed(actionEvent);
                    CmdWinEditorKit.maybeOpenFunctionHints(jTextComponent, actionEvent);
                }
            } else {
                if (!(!bl || !bl2 && !bl3 || bl2 && bl3)) {
                    if (!bl2) {
                        jTextComponent.setCaretPosition(n2);
                        jTextComponent.moveCaretPosition(sCWDoc.getAfterThePrompt());
                    } else {
                        jTextComponent.setCaretPosition(sCWDoc.getAfterThePrompt());
                        jTextComponent.moveCaretPosition(n);
                    }
                }
                Action action = CmdWinEditorKit.getDefaultActionByName(CmdWinEditorKit.deletePrevCharAction);
                action.actionPerformed(actionEvent);
                CmdWinEditorKit.maybeOpenFunctionHints(jTextComponent, actionEvent);
            }
        }
    }

    private static class CWDeleteNextCharAction
    extends CWTextAction {
        CWDeleteNextCharAction() {
            super(CmdWinEditorKit.deleteNextCharAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (CmdWinMLIF.isInBangMode() && PlatformInfo.isUnix()) {
                return;
            }
            Caret caret = this.getTextComponentIfNull(actionEvent).getCaret();
            JTextComponent jTextComponent = this.getTextComponentIfNull(actionEvent);
            int n2 = caret.getDot();
            boolean bl = n2 != (n = caret.getMark());
            boolean bl2 = sCWDoc.isInOrBeforeThePrompt(n2);
            boolean bl3 = sCWDoc.isInOrBeforeThePrompt(n);
            if (bl && bl2 && bl3) {
                XCaret.adjustSelection(caret);
            } else {
                if (!bl && sCWDoc.isInOrBeforeThePrompt(n2 - 1)) {
                    XCaret.adjustSelection(caret);
                }
                if (!(!bl || !bl2 && !bl3 || bl2 && bl3)) {
                    if (!bl2) {
                        jTextComponent.setCaretPosition(n2);
                        jTextComponent.moveCaretPosition(sCWDoc.getAfterThePrompt());
                    } else {
                        jTextComponent.setCaretPosition(sCWDoc.getAfterThePrompt());
                        jTextComponent.moveCaretPosition(n);
                    }
                }
                Action action = CmdWinEditorKit.getDefaultActionByName(CmdWinEditorKit.deleteNextCharAction);
                action.actionPerformed(actionEvent);
                CmdWinEditorKit.maybeOpenFunctionHints(jTextComponent, actionEvent);
            }
        }
    }

    static class CWEndLineAction
    extends CWTextAction {
        private boolean fSelect;

        CWEndLineAction(String string, boolean bl) {
            super(string);
            this.fSelect = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponentIfNull(actionEvent);
            int n = jTextComponent.getCaretPosition();
            int n2 = CmdWinDocumentUtilities.getLineEnd(sCWDoc, n);
            if (sCWDoc.isAfterThePrompt(n)) {
                n2 = sCWDoc.getPromptLineEndOffset(false);
            }
            if (this.fSelect) {
                jTextComponent.moveCaretPosition(n2);
            } else {
                jTextComponent.setCaretPosition(n2);
            }
            CmdWinEditorKit.maybeOpenFunctionHints(jTextComponent, actionEvent);
        }
    }

    private static class CWBeginLineAction
    extends CWTextAction {
        private boolean fSelect;

        public CWBeginLineAction(String string, boolean bl) {
            super(string);
            this.fSelect = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Caret caret = this.getTextComponentIfNull(actionEvent).getCaret();
            if (sCWDoc.isInOrBeforeThePrompt(caret.getDot())) {
                Action action = null;
                action = CmdWinEditorKit.getDefaultActionByName(this.fSelect ? CmdWinEditorKit.selectionBeginLineAction : CmdWinEditorKit.beginLineAction);
                action.actionPerformed(actionEvent);
                CmdWinEditorKit.closeFunctionHints();
                return;
            }
            if (this.fSelect) {
                this.getTextComponentIfNull(actionEvent).moveCaretPosition(sCWDoc.getAfterThePrompt());
            } else {
                this.getTextComponentIfNull(actionEvent).setCaretPosition(sCWDoc.getAfterThePrompt());
            }
            CmdWinEditorKit.closeFunctionHints();
        }
    }

    private static abstract class CWTextAction
    extends MTextAction {
        public CWTextAction(String string, boolean bl) {
            super(string);
            if (bl) {
                this.addKeyBindingAndActionInfo(string);
            }
        }

        public CWTextAction(String string) {
            this(string, true);
        }

        public CWTextAction(String string, Icon icon) {
            super(string, icon);
            throw new IllegalStateException("This signature is not supported.");
        }

        public CWTextAction(String string, Icon icon, boolean bl) {
            super(string, icon, bl);
            throw new IllegalStateException("This signature is not supported.");
        }

        private void addKeyBindingAndActionInfo(String string) {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("CommandWindow", string, (ExtendedAction)this);
        }

        protected JTextComponent getTextComponentIfNull(ActionEvent actionEvent) {
            JTextComponent jTextComponent = null;
            if (actionEvent != null && actionEvent.getSource() instanceof JTextComponent) {
                jTextComponent = (JTextComponent)actionEvent.getSource();
            }
            if (jTextComponent == null) {
                jTextComponent = XCmdWndView.getInstance();
            }
            return jTextComponent;
        }
    }
}

