/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.cmdhist;

import com.mathworks.services.FontPrefs;
import com.mathworks.services.FontPrefsComponent;
import com.mathworks.services.Prefs;
import java.util.ResourceBundle;

public class CmdHistoryPrefs
implements FontPrefsComponent {
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.mde.cmdhist.resources.RES_CmdHist");
    public static final int NEVER_SAVE = -1;
    public static final int SAVE_QUIT = -2;
    static final int SAVE_ON_QUIT = 1;
    static final int SAVE_ON_NLINES = 2;
    static final int SAVE_ON_MASK = 3;
    static final int SAVE_DUPLICATES = 4;
    static final int SAVE_EXITQUIT = 8;
    static final int DEFAULT_OPTIONS = 2;
    static final String COMMAND_HISTORY = "CommandHistory";
    static final String HISTORY_OPTIONS = "HistoryOptionsR14";
    static final String SAVE_LINES = "SaveLinesR14";
    static final String SHOW_DELETE_CONFIRM = "DeleteConfirm";
    static final int DEFAULT_SAVENCMDS = 1;
    private static int sSaveNCmds = Prefs.getIntegerPref((String)"CommandHistorySaveLinesR14", (int)1);
    private static int sHistoryOptions = Prefs.getIntegerPref((String)"CommandHistoryHistoryOptionsR14", (int)2);

    public String getDisplayName() {
        return sRes.getString("title");
    }

    public String getFontPrefsTagName() {
        return COMMAND_HISTORY;
    }

    public FontPrefs.FontType getDefaultFont() {
        return FontPrefs.FontType.CODE;
    }

    public static int getNumCommandsToSave() {
        int n = -1;
        int n2 = CmdHistoryPrefs.getHistoryOptions();
        if ((n2 & 1) == 1) {
            n = -2;
        } else if ((n2 & 2) == 2) {
            n = sSaveNCmds;
        }
        return n;
    }

    public static boolean getSaveDuplicates() {
        int n = CmdHistoryPrefs.getHistoryOptions();
        return (n & 4) == 4;
    }

    public static boolean getSaveExitQuit() {
        int n = CmdHistoryPrefs.getHistoryOptions();
        return (n & 8) == 8;
    }

    static int getHistoryOptions() {
        return sHistoryOptions;
    }

    static void setHistoryOptions(int n) {
        if (n != sHistoryOptions) {
            Prefs.setIntegerPref((String)"CommandHistoryHistoryOptionsR14", (int)n);
            sHistoryOptions = n;
        }
    }

    static int getSaveNLines() {
        return sSaveNCmds;
    }

    static void setSaveNLines(int n) {
        if (n != sSaveNCmds) {
            Prefs.setIntegerPref((String)"CommandHistorySaveLinesR14", (int)n);
            sSaveNCmds = n;
        }
    }
}

