/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.services.lmgr;

import com.mathworks.instutil.InstutilResourceKeys;
import com.mathworks.services.lmgr.HBManager;
import com.mathworks.services.lmgr.HBManagerImpl;
import com.mathworks.services.lmgr.LmgrWebLicensing;
import com.mathworks.services.lmgr.MathWorksLicenseServerClientFactory;
import com.mathworks.services.lmgr.SessionHelperManager;
import com.mathworks.services.lmgr.SessionHelperManagerImpl;
import com.mathworks.services.lmgr.SessionStopper;
import com.mathworks.webservices.client.core.MathWorksClientException;
import com.mathworks.webservices.client.core.MathWorksServiceException;
import com.mathworks.webservices.mls.MathWorksLicenseServerClient;
import com.mathworks.webservices.mls.model.Feature;
import com.mathworks.webservices.mls.model.MachineAttributes;
import com.mathworks.webservices.mls.model.StartSessionRequest;
import com.mathworks.webservices.mls.model.StartSessionResponse;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class WebData {
    private final LmgrWebLicensing nativeMethodProvider;
    private final MathWorksLicenseServerClient webClientObj;
    private final ExecutorService theExecuter;
    private final HBManager hbManager;
    private final SessionHelperManager sessionhelperManager;
    public static final int MW_SUCCESS = 0;
    public static final int MW_CLIENT_EXCEPTION = 4401;
    public static final int UNEXPECTED_ERROR = 4402;
    public static final int UNEXPECTED_STARTSESSION_EXCEPTION = 4403;
    public static final int SESSIONHELPER_THREAD_FAILURE = 4404;
    public static final int INVALID_SEAT_COUNT = 4405;
    public static final int ERROR_PASSING_DATA = 4406;
    public static final int INVALID_FEATURE_DATA = 4407;

    private static native boolean nativeIsWebLicenseEnabled();

    private static native String nativeGetMachineIDHash();

    private static native String nativeGetLicenseNumberForEPWS();

    private static native String nativeGetUserCredentials();

    private static native void nativeSetWebLicenseData(String var0, String var1, String var2, String var3, int var4);

    private static native void nativeSetWebLicensingStatus(int var0, String var1);

    private static native int nativeGetProcessId();

    public WebData() {
        this(new NativeLmgrWebLicensing(), MathWorksLicenseServerClientFactory.createClient(), Executors.newSingleThreadExecutor(), HBManagerImpl.getInstance(), SessionHelperManagerImpl.getInstance());
    }

    public WebData(LmgrWebLicensing lmgrWebLicensing, ExecutorService executorService, HBManager hBManager, SessionHelperManager sessionHelperManager) {
        this.nativeMethodProvider = lmgrWebLicensing;
        this.webClientObj = MathWorksLicenseServerClientFactory.createClient();
        this.theExecuter = executorService;
        this.hbManager = hBManager;
        this.sessionhelperManager = sessionHelperManager;
    }

    public WebData(LmgrWebLicensing lmgrWebLicensing, MathWorksLicenseServerClient mathWorksLicenseServerClient, ExecutorService executorService, HBManager hBManager, SessionHelperManager sessionHelperManager) {
        this.nativeMethodProvider = lmgrWebLicensing;
        this.webClientObj = mathWorksLicenseServerClient;
        this.theExecuter = executorService;
        this.hbManager = hBManager;
        this.sessionhelperManager = sessionHelperManager;
    }

    public void configFeatureData(String string) {
        boolean bl = this.nativeMethodProvider.isWebLicenseEnabled();
        if (bl) {
            StartSessionRequest startSessionRequest = this.createStartSessionRequest();
            WebDataThread webDataThread = new WebDataThread(this.webClientObj, startSessionRequest, string);
            this.theExecuter.submit(webDataThread);
            this.theExecuter.shutdown();
        }
    }

    private StartSessionRequest createStartSessionRequest() {
        String string = this.nativeMethodProvider.getUserCredentials();
        String string2 = this.nativeMethodProvider.getLicenseNumberForEPWS();
        String string3 = InstutilResourceKeys.RELEASE.getBundleString();
        String string4 = this.nativeMethodProvider.getMachineIDHash();
        MachineAttributes machineAttributes = new MachineAttributes();
        machineAttributes.setHostId(string4);
        StartSessionRequest startSessionRequest = new StartSessionRequest();
        startSessionRequest.setEntitlementId(string2);
        startSessionRequest.setRelease(string3);
        startSessionRequest.setToken(string);
        startSessionRequest.setMachineAttributes(machineAttributes);
        return startSessionRequest;
    }

    private static class NativeLmgrWebLicensing
    implements LmgrWebLicensing {
        NativeLmgrWebLicensing() {
            try {
                System.loadLibrary("nativelmgr");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @Override
        public String getMachineIDHash() {
            String string;
            try {
                string = WebData.nativeGetMachineIDHash();
            }
            catch (Throwable throwable) {
                string = "";
            }
            return string;
        }

        @Override
        public String getLicenseNumberForEPWS() {
            String string;
            try {
                string = WebData.nativeGetLicenseNumberForEPWS();
            }
            catch (Throwable throwable) {
                string = "";
            }
            return string;
        }

        @Override
        public String getProcessId() {
            String string;
            try {
                string = String.valueOf(WebData.nativeGetProcessId());
            }
            catch (Throwable throwable) {
                string = "";
            }
            return string;
        }

        @Override
        public String getUserCredentials() {
            String string;
            try {
                string = WebData.nativeGetUserCredentials();
            }
            catch (Throwable throwable) {
                string = "";
            }
            return string;
        }

        @Override
        public boolean isWebLicenseEnabled() {
            boolean bl;
            try {
                bl = WebData.nativeIsWebLicenseEnabled();
            }
            catch (Throwable throwable) {
                bl = false;
            }
            return bl;
        }

        @Override
        public void setWebLicenseData(String string, String string2, String string3, String string4, int n) {
            WebData.nativeSetWebLicenseData(string, string2, string3, string4, n);
        }

        @Override
        public void setWebLicensingStatus(int n, String string) {
            try {
                WebData.nativeSetWebLicensingStatus(n, string);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static class CheckoutException
    extends Exception {
        private final int status;
        private final String message;

        CheckoutException(int n, String string) {
            this.status = n;
            this.message = string;
        }

        int getStatus() {
            return this.status;
        }

        String getFailureMessage() {
            return this.message;
        }
    }

    private final class WebDataThread
    implements Runnable {
        private final MathWorksLicenseServerClient clientObj;
        private final StartSessionRequest sessionReq;
        private final String matlabRoot;

        WebDataThread(MathWorksLicenseServerClient mathWorksLicenseServerClient, StartSessionRequest startSessionRequest, String string) {
            this.clientObj = mathWorksLicenseServerClient;
            this.sessionReq = startSessionRequest;
            this.matlabRoot = string;
        }

        @Override
        public void run() {
            this.getDataFromWeb();
        }

        private void getDataFromWeb() {
            int n;
            String string = "";
            StartSessionResponse startSessionResponse = null;
            try {
                startSessionResponse = this.callStartSession();
                List list = startSessionResponse.getFeatures();
                for (Feature feature : list) {
                    String string2 = this.validateStringData(feature.getName());
                    String string3 = this.validateStringData(feature.getExpirationDate());
                    String string4 = this.validateStringData(feature.getLicenseNumber());
                    String string5 = this.validateStringData(feature.getAttributes());
                    int n2 = this.getSeatCount(feature);
                    this.giveDataToMatlab(string2, string3, string4, string5, n2);
                }
                this.startSessionHelperThread(startSessionResponse);
                n = 0;
            }
            catch (CheckoutException checkoutException) {
                if (startSessionResponse != null) {
                    SessionStopper sessionStopper = new SessionStopper(WebData.this.webClientObj, startSessionResponse.getSessionId(), this.sessionReq.getToken());
                    sessionStopper.run();
                }
                string = checkoutException.getFailureMessage();
                n = checkoutException.getStatus();
            }
            catch (Throwable throwable) {
                n = 4402;
                string = "Unexpected error during license checkout: " + throwable.getMessage();
            }
            WebData.this.nativeMethodProvider.setWebLicensingStatus(n, string);
            if (n == 0 && startSessionResponse != null) {
                this.startHeartbeatThread(startSessionResponse);
            }
        }

        private StartSessionResponse callStartSession() throws CheckoutException {
            StartSessionResponse startSessionResponse;
            try {
                startSessionResponse = this.clientObj.startSession(this.sessionReq);
            }
            catch (MathWorksServiceException mathWorksServiceException) {
                throw new CheckoutException(mathWorksServiceException.getStatusCode(), mathWorksServiceException.getMessage());
            }
            catch (MathWorksClientException mathWorksClientException) {
                int n = 4401;
                String string = "Error occurred while MATLAB worker was connecting to the online license server.\nError code: " + mathWorksClientException.getErrorCode() + "\nRequest id: " + mathWorksClientException.getRequestId();
                throw new CheckoutException(n, string);
            }
            catch (Throwable throwable) {
                int n = 4403;
                String string = throwable.getMessage();
                throw new CheckoutException(n, string);
            }
            return startSessionResponse;
        }

        private String validateStringData(String string) throws CheckoutException {
            if (string == null) {
                int n = 4407;
                throw new CheckoutException(n, "Invalid feature data received from online license server.");
            }
            return string;
        }

        private int getSeatCount(Feature feature) throws CheckoutException {
            int n;
            try {
                String string = feature.getSeatCount();
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                int n2 = 4405;
                String string = numberFormatException.getMessage();
                throw new CheckoutException(n2, string);
            }
            return n;
        }

        private void giveDataToMatlab(String string, String string2, String string3, String string4, int n) throws CheckoutException {
            try {
                WebData.this.nativeMethodProvider.setWebLicenseData(string, string2, string3, string4, n);
            }
            catch (Throwable throwable) {
                int n2 = 4406;
                String string5 = throwable.getMessage();
                throw new CheckoutException(n2, string5);
            }
        }

        private void startSessionHelperThread(StartSessionResponse startSessionResponse) throws CheckoutException {
            try {
                SessionStopper sessionStopper = new SessionStopper(WebData.this.webClientObj, startSessionResponse.getSessionId(), this.sessionReq.getToken());
                WebData.this.sessionhelperManager.startSessionHelperMonitorThread(this.matlabRoot, WebData.this.nativeMethodProvider.getProcessId(), startSessionResponse.getSessionId(), this.sessionReq.getToken(), sessionStopper);
            }
            catch (IOException iOException) {
                int n = 4404;
                String string = iOException.getMessage();
                throw new CheckoutException(n, string);
            }
        }

        private void startHeartbeatThread(StartSessionResponse startSessionResponse) {
            WebData.this.hbManager.startHBThread(startSessionResponse.getSessionId(), startSessionResponse.getHeartBeatInterval());
        }
    }
}

