/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.services.binding;

import com.mathworks.mwswing.binding.DefaultKeyBindingSet;
import com.mathworks.mwswing.binding.KeyBindingManager;
import com.mathworks.mwswing.binding.KeyBindingSet;
import com.mathworks.mwswing.binding.ReadWriteException;
import com.mathworks.services.binding.KeyBindingPreferences;
import com.mathworks.services.binding.MatlabKeyBindingPreferenceUtils;
import com.mathworks.services.binding.MatlabKeyBindingPreferences;
import com.mathworks.services.binding.PreferenceState;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.osgi.ClasspathOSGiManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.osgi.framework.Bundle;

public class MatlabKeyBindings {
    public static final String EDITOR_CONTEXT_ID = "MATLABEditor";
    public static final String DESKTOP_CONTEXT_ID = "MATLABDesktop";
    public static final String COMMAND_WINDOW_CONTEXT_ID = "CommandWindow";
    public static final String COMMAND_HISTORY_CONTEXT_ID = "CommandHistory";
    public static final String WORKSPACE_CONTEXT_ID = "WorkspaceBrowser";
    public static final String VARIABLE_EDITOR_ID = "VariableEditor";
    public static final String EXPLORER_CONTEXT_ID = "Explorer";
    public static final String COPY_ID = "copy-to-clipboard";
    public static final String CUT_ID = "cut-to-clipboard";
    public static final String PASTE_ID = "paste-from-clipboard";
    public static final String PASTE_TO_WORKSPACE_ID = "paste-to-workspace";
    public static final String COPY_FULL_PATH_ID = "copy-full-path";
    public static final String IMPORT_DATA_ID = "import-data";
    public static final String UNDO_ID = "undo";
    public static final String REDO_ID = "redo";
    public static final String RENAME_ID = "rename";
    public static final String SELECT_ALL_ID = "select-all";
    public static final String KILL_LINE_ID = "kill-line";
    public static final String CLEAR_SELECTION_ID = "unselect";
    public static final String DELETE_PREVIOUS_ID = "delete-previous";
    public static final String DELETE_NEXT_ID = "delete-next";
    public static final String INC_SEARCH_FORWARD_ID = "inc-search-forward";
    public static final String INC_SEARCH_BACKWARD_ID = "inc-search-backward";
    public static final String INSERT_BREAK_ID = "insert-break";
    public static final String SHIFT_INSERT_BREAK_ID = "shift-insert-break";
    public static final String CARET_FORWARD_ID = "caret-forward";
    public static final String CARET_BACKWARD_ID = "caret-backward";
    public static final String CARET_DOWN_ID = "caret-down";
    public static final String CARET_UP_ID = "caret-up";
    public static final String SELECTION_FORWARD_ID = "selection-forward";
    public static final String SELECTION_BACKWARD_ID = "selection-backward";
    public static final String SELECTION_DOWN_ID = "selection-down";
    public static final String SELECTION_UP_ID = "selection-up";
    public static final String CARET_NEXT_WORD_ID = "caret-next-word";
    public static final String CARET_PREVIOUS_WORD_ID = "caret-previous-word";
    public static final String SELECTION_NEXT_WORD_ID = "selection-next-word";
    public static final String SELECTION_PREVIOUS_WORD_ID = "selection-previous-word";
    public static final String SCROLL_UP_ID = "scroll-up";
    public static final String SCROLL_DOWN_ID = "scroll-down";
    public static final String PAGE_UP_ID = "page-up";
    public static final String PAGE_DOWN_ID = "page-down";
    public static final String SELECTION_PAGE_UP_ID = "selection-page-up";
    public static final String SELECTION_PAGE_DOWN_ID = "selection-page-down";
    public static final String CARET_BEGIN_LINE_ID = "caret-begin-line";
    public static final String CARET_END_LINE_ID = "caret-end-line";
    public static final String CARET_BEGIN_ID = "caret-begin";
    public static final String CARET_END_ID = "caret-end";
    public static final String EXPAND_OR_SELECT_ID = "expand-or-select";
    public static final String EXPAND_ID = "expand";
    public static final String COLLAPSE_OR_SELECT_ID = "collapse-or-select";
    public static final String COLLAPSE_ID = "collapse";
    public static final String SELECTION_BEGIN_LINE_ID = "selection-begin-line";
    public static final String SELECTION_END_LINE_ID = "selection-end-line";
    public static final String SELECTION_BEGIN_ID = "selection-begin";
    public static final String SELECTION_END_ID = "selection-end";
    public static final String TOGGLE_TYPING_MODE_ID = "toggle-typing-mode";
    public static final String REMOVE_NEXT_WORD_ID = "remove-word-next";
    public static final String REMOVE_PREVIOUS_WORD_ID = "remove-word-previous";
    public static final String NEW_M_FILE_ID = "new-mfile";
    public static final String NEW_M_FUNCTION_ID = "new-mfunction";
    public static final String NEW_M_EXAMPLE_ID = "new-mexample";
    public static final String NEW_M_CLASS_ID = "new-mclass";
    public static final String NEW_M_ENUMERATION_ID = "new-menumeration";
    public static final String NEW_M_SYSTEM_ID = "new-msystem";
    public static final String NEW_FIGURE_ID = "new-figure";
    public static final String NEW_VARIABLE_ID = "new-variable";
    public static final String NEW_MODEL_ID = "new-model";
    public static final String NEW_GUI_ID = "new-gui";
    public static final String OPEN_NEW_ID = "open-new";
    public static final String OPEN_WITH_SYSTEM_FILE_BROWSER_ID = "open-with-system-browser";
    public static final String LAUNCH_SIMULINK_ID = "launch-simulink";
    public static final String LAUNCH_GUIDE_ID = "launch-guide";
    public static final String LAUNCH_PROFILER_ID = "launch-profiler";
    public static final String EXIT_MATLAB_ID = "exit-matlab";
    public static final String CLOSE_ITEM_ID = "close-item";
    public static final String SAVE_ID = "save";
    public static final String SAVE_AS_ID = "save-as";
    public static final String SAVE_ALL_ID = "save-all";
    public static final String SAVE_BACKUP_ID = "save-backup";
    public static final String SET_PATH_ID = "set-path";
    public static final String CHANGE_CURRENT_FOLDER_ID = "change-current-folder";
    public static final String SHOW_PREFERENCES_ID = "show-preferences";
    public static final String FIND_ID = "find-and-replace";
    public static final String FIND_NEXT_ID = "find-next";
    public static final String FIND_PREVIOUS_ID = "find-previous";
    public static final String FIND_SELECTION_ID = "find-selection";
    public static final String FIND_PREVIOUS_SELECTION__ID = "find-previous-selection";
    public static final String EVALUATE_SELECTION_ID = "evaluate-selection";
    public static final String PRINT_SELECTION_ID = "print-selection";
    public static final String OPEN_SELECTION_ID = "open-selection";
    public static final String HELP_ON_SELECTION_ID = "help-on-selection";
    public static final String PRODUCT_HELP_ID = "product-help";
    public static final String DEMOS_ID = "show-demos";
    public static final String SET_CLEAR_BKPT_ID = "set-clear-breakpoint";
    public static final String GO_UNTIL_CURSOR_ID = "go-until-cursor";
    public static final String PRINT_ID = "print";
    public static final String PAGE_SETUP_ID = "show-page-setup";
    public static final String DEBUG_CONTINUE_ID = "debug-continue";
    public static final String DEBUG_STEP_IN_ID = "debug-step-in";
    public static final String DEBUG_STEP_ID = "debug-step";
    public static final String DEBUG_STEP_OUT_ID = "debug-step-out";
    public static final String EXIT_DEBUG_ID = "exit-debug";
    public static final String CLEAR_ALL_BKPTS_ID = "clear-all-breakpoints";
    public static final String SHOW_STOP_IF_DIALOG_ID = "show-stop-if-dialog";
    public static final String TOGGLE_GRAPHICAL_DEBUGGING_ID = "toggle-graphical-debugging";
    public static final String ADJUST_WINDOW_TOP_ID = "adjust-window-top";
    public static final String ADJUST_WINDOW_BOTTOM_ID = "adjust-window-bottom";
    public static final String FIND_FILES_ID = "find-files";
    public static final String GOTO_LINE_ID = "goto-line";
    public static final String INSERT_TAB_ID = "insert-tab";
    public static final String SAVE_WORKSPACE_ID = "save-workspace";
    public static final String BEEP_ID = "beep";
    public static final String PREVIOUS_LOCATION_ID = "jump-list-prev";
    public static final String NEXT_LOCATION_ID = "jump-list-next";
    public static final String CLEAR_COMMAND_HISTORY_ID = "clear-command-history";
    public static final String CLEAR_COMMAND_WINDOW_ID = "clear-command-window";
    public static final String CLEAR_WORKSPACE_ID = "clear-workspace";
    public static final String CREATE_M_FILE_FROM_SELECTION_ID = "create-mfile-from-selection";
    public static final String CREATE_SHORTCUT_FROM_SELECTION_ID = "create-shortcut-from-selection";
    public static final String PROFILE_SELECTED_TEXT_ID = "profile-selected-code";
    public static final String REFRESH_ID = "refresh";
    public static final String OPEN_FUNCTION_BROWSER_ID = "function-browser-key";
    public static final String SHOW_FUNCBROWSER_BTN_ID = "show-funcbrowser-btn";
    public static final String OPEN_FUNCTION_HINTS_ID = "function-hints-key";
    public static final String SHOW_PLOT_CATALOG_ID = "show-plot-catalog";
    public static final String SHOW_PLOT_TOOLS_ID = "plot-tools";
    private static final KeyBindingManager sManager = new KeyBindingManager();
    private static final MatlabKeyBindingPreferences sPrefs;
    private static final StringBuffer sErrors;
    private static final String ACTION_MANIFEST_HEADER = "KeyBindingManager-ActionFiles";
    private static final String CONTEXT_MANIFEST_HEADER = "KeyBindingManager-ContextFiles";
    private static final String SECONDARY_CONTEXT_MANIFEST_HEADER = "KeyBindingManager-SecondaryContextFiles";
    private static final String HEADER_VALUE_SEPARATOR = ",";

    private static void readActionAndContextFilesFromOSGi() throws ReadWriteException, IOException {
        Collection collection = ClasspathOSGiManager.getInstance().getInstalledBundles();
        if (collection.size() == 0) {
            throw new IOException("OSGi returned no keybinding XML files. Verify that new files can be created in OSGI root cache directory.");
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        LinkedList<String> linkedList2 = new LinkedList<String>();
        LinkedList<String> linkedList3 = new LinkedList<String>();
        for (Bundle object : collection) {
            MatlabKeyBindings.addHeaderValuesToList(ACTION_MANIFEST_HEADER, linkedList, object);
            MatlabKeyBindings.addHeaderValuesToList(CONTEXT_MANIFEST_HEADER, linkedList2, object);
            MatlabKeyBindings.addHeaderValuesToList(SECONDARY_CONTEXT_MANIFEST_HEADER, linkedList3, object);
        }
        for (String string : linkedList) {
            MatlabKeyBindings.addActionFile(string);
        }
        for (String string : linkedList2) {
            MatlabKeyBindings.addContextFile(string);
        }
        for (String string : linkedList3) {
            MatlabKeyBindings.addContextFile(string);
        }
    }

    private static void addHeaderValuesToList(String string, List<String> list, Bundle bundle) {
        String string2 = (String)bundle.getHeaders().get(string);
        if (string2 != null) {
            for (String string3 : string2.split(HEADER_VALUE_SEPARATOR)) {
                list.add(string3.trim());
            }
        }
    }

    private static void addActionFile(String string) throws ReadWriteException {
        InputStream inputStream = MatlabKeyBindings.class.getResourceAsStream(string);
        if (inputStream == null) {
            sErrors.append("Unable to find action file '").append(string).append("'.\n");
        } else {
            sManager.parseAndRegisterActions(inputStream);
        }
        MatlabKeyBindings.verifyNoErrors();
    }

    private static void addContextFile(String string) throws ReadWriteException {
        InputStream inputStream = MatlabKeyBindings.class.getResourceAsStream(string);
        if (inputStream == null) {
            sErrors.append("Unable to find context file '").append(string).append("'.\n");
        } else {
            sManager.parseAndRegisterContexts(inputStream);
        }
        MatlabKeyBindings.verifyNoErrors();
    }

    private static void verifyNoErrors() {
        assert (MatlabKeyBindings.getErrors().length() == 0) : MatlabKeyBindings.getErrors().toString();
    }

    private MatlabKeyBindings() {
    }

    public static KeyBindingManager getManager() {
        return sManager;
    }

    public static String getErrors() {
        return sErrors.toString();
    }

    public static KeyBindingPreferences getKeyBindingPreferences() {
        return sPrefs;
    }

    private static void initializeFromPrefs() throws ReadWriteException, IOException {
        for (File file : sPrefs.resolveModifiedDefaultFilesFromPrefs()) {
            sManager.parseAndRegisterModifiedDefaultSet(file);
        }
        for (File file : sPrefs.resolveCustomFilesFromPrefs()) {
            try {
                sManager.parseAndRegisterCustomKeyBindingSet(file);
            }
            catch (Exception exception) {
                System.out.println(MessageFormat.format(MatlabKeyBindingPreferenceUtils.lookup("error.parsingCustomSet"), file.getPath()));
            }
        }
        sManager.setCurrentKeyBindingSet(sPrefs.resolveCurrentSetFromPrefs().getID());
    }

    public static void setCurrentSet(SetID setID) {
        sManager.setCurrentKeyBindingSet(setID.getSetID());
    }

    public static PreferenceState getCurrentPreferencesAndSetToDefaults() throws ReadWriteException, IOException {
        PreferenceState preferenceState = new PreferenceState(sPrefs.resolveModifiedDefaultFilesFromPrefs());
        MatlabKeyBindings.deleteExistingSettings();
        MatlabKeyBindings.initializeFromPrefs();
        return preferenceState;
    }

    public static void restorePreferences(PreferenceState preferenceState) throws ReadWriteException, IOException {
        MatlabKeyBindings.deleteExistingSettings();
        preferenceState.restore();
        MatlabKeyBindings.initializeFromPrefs();
    }

    private static void deleteExistingSettings() throws ReadWriteException, IOException {
        sPrefs.deletePrefEntries();
        for (KeyBindingSet keyBindingSet : sManager.getCustomKeyBindingSets()) {
            sManager.removeCustomKeyBindingSet(keyBindingSet.getID());
        }
    }

    static {
        sErrors = new StringBuffer();
        sPrefs = new MatlabKeyBindingPreferences(sManager);
        try {
            MatlabKeyBindings.readActionAndContextFilesFromOSGi();
            sManager.setDefaultKeyBindingSetsForPlatform(PlatformInfo.isMacintosh() ? Arrays.asList(DefaultKeyBindingSet.MAC) : Arrays.asList(DefaultKeyBindingSet.WINDOWS, DefaultKeyBindingSet.EMACS));
            MatlabKeyBindings.initializeFromPrefs();
        }
        catch (Exception exception) {
            String string = exception.getLocalizedMessage() + "\n";
            for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
                if (stackTraceElement.getClassName().equals(MatlabKeyBindings.class.getName())) break;
                string = string + stackTraceElement.toString() + "\n";
            }
            throw new Error(string);
        }
    }

    public static enum SetID {
        WINDOWS{

            @Override
            String getSetID() {
                return DefaultKeyBindingSet.WINDOWS.getID();
            }
        }
        ,
        EMACS{

            @Override
            String getSetID() {
                return DefaultKeyBindingSet.EMACS.getID();
            }
        }
        ,
        MAC{

            @Override
            String getSetID() {
                return DefaultKeyBindingSet.MAC.getID();
            }
        };


        abstract String getSetID();
    }
}

