/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser;

import com.mathworks.html.HtmlActions;
import com.mathworks.html.HtmlDataListener;
import com.mathworks.html.HtmlPanelContextMenuHandler;
import com.mathworks.html.jxbrowser.JxBrowserFocusManager;
import com.mathworks.html.jxbrowser.JxBrowserSwingComponent;
import com.mathworks.html.jxbrowser.SystemUtils;
import com.teamdev.jxbrowser.ContextMenuHandler;
import com.teamdev.jxbrowser.events.ContextMenuEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class MWContextMenuHandler
implements ContextMenuHandler {
    private final HtmlPanelContextMenuHandler<? extends HtmlActions> fMenuHandler;
    private final CloseContextMenuListener fCloseContextMenuListener;

    public MWContextMenuHandler(HtmlPanelContextMenuHandler<? extends HtmlActions> htmlPanelContextMenuHandler, JxBrowserSwingComponent jxBrowserSwingComponent) {
        this.fMenuHandler = htmlPanelContextMenuHandler;
        CloseContextMenuListener closeContextMenuListener = null;
        if (jxBrowserSwingComponent != null && SystemUtils.isLinux()) {
            closeContextMenuListener = new CloseContextMenuListener();
            jxBrowserSwingComponent.addMouseListener(closeContextMenuListener);
            JxBrowserFocusManager jxBrowserFocusManager = jxBrowserSwingComponent.getFocusManager();
            if (jxBrowserFocusManager != null) {
                jxBrowserFocusManager.addFocusChangeListener(closeContextMenuListener);
            }
        }
        this.fCloseContextMenuListener = closeContextMenuListener;
    }

    public void showContextMenu(final ContextMenuEvent contextMenuEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JPopupMenu jPopupMenu = MWContextMenuHandler.this.fMenuHandler.showContextMenu(contextMenuEvent.getLocation().x, contextMenuEvent.getLocation().y, contextMenuEvent.getTarget());
                if (MWContextMenuHandler.this.fCloseContextMenuListener != null) {
                    MWContextMenuHandler.this.fCloseContextMenuListener.setPopupMenu(jPopupMenu);
                }
            }
        });
    }

    private HtmlPanelContextMenuHandler<? extends HtmlActions> getMenuHandler() {
        return this.fMenuHandler;
    }

    public boolean equals(Object object) {
        if (object instanceof MWContextMenuHandler) {
            return this.fMenuHandler.equals(((MWContextMenuHandler)object).getMenuHandler());
        }
        return false;
    }

    private static class CloseContextMenuListener
    extends MouseAdapter
    implements HtmlDataListener<Boolean> {
        private JPopupMenu iMenu;
        private boolean iCloseMenuOnFocusLoss = false;

        private CloseContextMenuListener() {
        }

        private void setPopupMenu(JPopupMenu jPopupMenu) {
            if (jPopupMenu != null) {
                jPopupMenu.requestFocusInWindow();
            }
            if (this.iMenu != null) {
                this.iMenu.setVisible(false);
            }
            this.iCloseMenuOnFocusLoss = false;
            this.iMenu = jPopupMenu;
        }

        @Override
        public void dataRetrieved(Boolean bl) {
            if (!bl.booleanValue() && this.iCloseMenuOnFocusLoss) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (CloseContextMenuListener.this.iMenu != null && !CloseContextMenuListener.this.iMenu.hasFocus()) {
                            CloseContextMenuListener.this.setPopupMenu(null);
                        }
                    }
                };
                SwingUtilities.invokeLater(runnable);
            } else {
                this.iCloseMenuOnFocusLoss = bl != false && this.iMenu != null;
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.setPopupMenu(null);
        }
    }
}

