/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html;

import com.mathworks.html.EncodingUtils;
import com.mathworks.html.HtmlUtils;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UrlFormatter {
    private static final Pattern URL_ANCHOR_PATTERN = Pattern.compile("^(.*?)([#?].*)?$");
    private static final Pattern UNC_URL_PATTERN = Pattern.compile("file:/*(//\\w[^:].*)$");
    private final boolean fCheckFileExistence;

    public UrlFormatter() {
        this(true);
    }

    public UrlFormatter(boolean bl) {
        this.fCheckFileExistence = bl;
    }

    public String formatUrl(String string) {
        if (!HtmlUtils.isValidUrl(string) && this.fileExists(string)) {
            return UrlFormatter.convertToFileUrl(string);
        }
        String[] stringArray = UrlFormatter.splitUrl(string);
        String string2 = this.resolveBaseUrl(stringArray[0]);
        if (stringArray.length > 1) {
            return string2 + stringArray[1];
        }
        return string2;
    }

    private String resolveBaseUrl(String string) {
        String string2;
        String string3;
        Matcher matcher;
        if (!HtmlUtils.isValidUrl(string)) {
            String string4;
            String string5 = string4 = EncodingUtils.needsDecoding(string) ? EncodingUtils.decodeUrl(string) : string;
            if (this.fileExists(string4) || UrlFormatter.isFilePathWithDriveLetter(string4)) {
                return UrlFormatter.convertToFileUrl(string);
            }
        } else if (File.separator.equals("\\") && (matcher = UNC_URL_PATTERN.matcher(string3 = EncodingUtils.needsDecoding(string) ? EncodingUtils.decodeUrl(string) : string)).find() && this.fileExists(string2 = matcher.group(1))) {
            return UrlFormatter.convertToFileUrl(string2);
        }
        return string;
    }

    private static String convertToFileUrl(String string) {
        String string2 = "file:///" + string.replaceAll("\\\\", "/");
        if (EncodingUtils.needsEncoding(string2)) {
            string2 = EncodingUtils.encodeUrl(string2);
        }
        return string2.replaceAll("#", "%23");
    }

    private static String[] splitUrl(String string) {
        String[] stringArray;
        Matcher matcher = URL_ANCHOR_PATTERN.matcher(string);
        if (!matcher.find()) {
            return new String[]{string};
        }
        String string2 = matcher.group(1);
        String string3 = matcher.group(2);
        if (string3 == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string2;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = string2;
            stringArray = stringArray3;
            stringArray3[1] = string3;
        }
        return stringArray;
    }

    protected boolean fileExists(String string) {
        return !this.fCheckFileExistence || new File(string).exists();
    }

    private static boolean isFilePathWithDriveLetter(String string) {
        return string.matches("^[a-zA-Z]:.*$");
    }
}

