/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html;

import com.mathworks.html.FindInPageHandler;
import com.mathworks.html.HtmlActions;
import com.mathworks.html.HtmlComponent;
import com.mathworks.html.HtmlDataListener;
import com.mathworks.html.StandardHtmlActionId;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;

public final class BasicHtmlActions
implements HtmlActions {
    private final HtmlComponent fHtmlComponent;
    private final Map<StandardHtmlActionId, Action> fBasicActions = new LinkedHashMap<StandardHtmlActionId, Action>();
    private final BasicHtmlActionLabels fLabels;
    private FindInPageHandler fFindInPageHandler;
    private boolean fPopulated = false;

    public BasicHtmlActions(HtmlComponent htmlComponent, BasicHtmlActionLabels basicHtmlActionLabels) {
        this.fHtmlComponent = htmlComponent;
        this.fLabels = basicHtmlActionLabels;
    }

    public void setViewSourceHandler(ViewSourceHandler viewSourceHandler) {
        if (viewSourceHandler == null) {
            this.fBasicActions.remove((Object)StandardHtmlActionId.VIEW_SOURCE);
        } else {
            this.fBasicActions.put(StandardHtmlActionId.VIEW_SOURCE, new ViewSourceAction(viewSourceHandler));
        }
    }

    public void setFindInPageHandler(FindInPageHandler findInPageHandler) {
        this.fFindInPageHandler = findInPageHandler;
        if (findInPageHandler == null) {
            this.fBasicActions.remove((Object)StandardHtmlActionId.FIND);
        } else {
            this.fBasicActions.put(StandardHtmlActionId.FIND, new FindAction());
        }
    }

    public void setSaveFileSelector(SaveFileSelector saveFileSelector) {
        if (saveFileSelector == null) {
            this.fBasicActions.remove((Object)StandardHtmlActionId.SAVE_AS);
        } else {
            this.fBasicActions.put(StandardHtmlActionId.SAVE_AS, new SaveAction(saveFileSelector));
        }
    }

    public Map<StandardHtmlActionId, Action> getBasicActions() {
        Map<StandardHtmlActionId, Action> map = this.populateBasicActions();
        if (this.fHtmlComponent.getHomeUrl() != null) {
            HashMap<StandardHtmlActionId, Action> hashMap = new HashMap<StandardHtmlActionId, Action>(map);
            hashMap.put(StandardHtmlActionId.HOME, new HomeAction());
            return Collections.unmodifiableMap(hashMap);
        }
        return Collections.unmodifiableMap(map);
    }

    private synchronized Map<StandardHtmlActionId, Action> populateBasicActions() {
        if (!this.fPopulated) {
            this.fBasicActions.put(StandardHtmlActionId.GO_BACK, new GoBackAction());
            this.fBasicActions.put(StandardHtmlActionId.GO_FORWARD, new GoForwardAction());
            this.fBasicActions.put(StandardHtmlActionId.RELOAD, new ReloadAction());
            this.fBasicActions.put(StandardHtmlActionId.COPY, new CopyAction());
            if (this.fHtmlComponent.isPrintingSupported()) {
                this.fBasicActions.put(StandardHtmlActionId.PRINT, new PrintAction());
            }
            this.fPopulated = true;
        }
        return this.fBasicActions;
    }

    @Override
    public void removeNavigationActions() {
        this.fBasicActions.remove((Object)StandardHtmlActionId.GO_BACK);
        this.fBasicActions.remove((Object)StandardHtmlActionId.GO_FORWARD);
        this.fBasicActions.remove((Object)StandardHtmlActionId.RELOAD);
        this.fBasicActions.remove((Object)StandardHtmlActionId.HOME);
    }

    public Collection<Action> getCustomActions() {
        return Collections.emptyList();
    }

    @Override
    public void dispose() {
    }

    public static interface SaveFileSelector {
        public File selectFile();
    }

    public static interface ViewSourceHandler {
        public void doViewSource(String var1, String var2);
    }

    private class HomeAction
    extends AbstractAction {
        private HomeAction() {
            super(BasicHtmlActions.this.fLabels.getLabel(StandardHtmlActionId.HOME));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BasicHtmlActions.this.fHtmlComponent.setCurrentLocation(BasicHtmlActions.this.fHtmlComponent.getHomeUrl());
        }
    }

    private class SaveAction
    extends AbstractAction {
        private final SaveFileSelector iFileSelector;

        private SaveAction(SaveFileSelector saveFileSelector) {
            super(BasicHtmlActions.this.fLabels.getLabel(StandardHtmlActionId.SAVE_AS));
            this.iFileSelector = saveFileSelector;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            File file = this.iFileSelector.selectFile();
            if (file != null) {
                new Thread(new SaveRunnable(file)).start();
            }
        }

        private class SaveRunnable
        implements Runnable {
            private File iFile;

            private SaveRunnable(File file) {
                this.iFile = file;
            }

            @Override
            public void run() {
                BasicHtmlActions.this.fHtmlComponent.saveAs(this.iFile);
            }
        }
    }

    private class PrintAction
    extends AbstractAction {
        private PrintAction() {
            super(BasicHtmlActions.this.fLabels.getLabel(StandardHtmlActionId.PRINT));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BasicHtmlActions.this.fHtmlComponent.print();
        }
    }

    private class FindAction
    extends AbstractAction {
        private FindAction() {
            super(BasicHtmlActions.this.fLabels.getLabel(StandardHtmlActionId.FIND));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BasicHtmlActions.this.fFindInPageHandler.openFindInPage();
        }
    }

    private class ViewSourceAction
    extends AbstractAction {
        private final ViewSourceHandler iHandler;

        private ViewSourceAction(ViewSourceHandler viewSourceHandler) {
            super(BasicHtmlActions.this.fLabels.getLabel(StandardHtmlActionId.VIEW_SOURCE));
            this.iHandler = viewSourceHandler;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = BasicHtmlActions.this.fHtmlComponent.getCurrentLocation();
            String string2 = BasicHtmlActions.this.fHtmlComponent.getHtmlText();
            this.iHandler.doViewSource(string, string2);
        }
    }

    private static class CopyListener
    implements HtmlDataListener<String> {
        private CopyListener() {
        }

        @Override
        public void dataRetrieved(String string) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new StringSelection(string), null);
        }
    }

    private class CopyAction
    extends AbstractAction {
        private CopyAction() {
            super(BasicHtmlActions.this.fLabels.getLabel(StandardHtmlActionId.COPY));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BasicHtmlActions.this.fHtmlComponent.getSelectedText(new CopyListener());
        }
    }

    private class ReloadAction
    extends AbstractAction {
        private ReloadAction() {
            super(BasicHtmlActions.this.fLabels.getLabel(StandardHtmlActionId.RELOAD));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BasicHtmlActions.this.fHtmlComponent.reload();
        }
    }

    private class GoForwardAction
    extends AbstractAction {
        private GoForwardAction() {
            super(BasicHtmlActions.this.fLabels.getLabel(StandardHtmlActionId.GO_FORWARD));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BasicHtmlActions.this.fHtmlComponent.goForward();
        }
    }

    private class GoBackAction
    extends AbstractAction {
        private GoBackAction() {
            super(BasicHtmlActions.this.fLabels.getLabel(StandardHtmlActionId.GO_BACK));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BasicHtmlActions.this.fHtmlComponent.goBack();
        }
    }

    public static interface BasicHtmlActionLabels {
        public String getLabel(StandardHtmlActionId var1);
    }
}

