/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide.template;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jidesoft.hints.FileIntelliHints;
import com.mathworks.common.icons.ApplicationIcon;
import com.mathworks.jmi.AWTUtilities;
import com.mathworks.jmi.Callback;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabPath;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJList;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTabbedPane;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.services.Prefs;
import com.mathworks.toolbox.matlab.guide.GuidePreferenceEnum;
import com.mathworks.toolbox.matlab.guide.LayoutEditor;
import com.mathworks.toolbox.matlab.guide.LayoutLooper;
import com.mathworks.toolbox.matlab.guide.LayoutMRUFiles;
import com.mathworks.toolbox.matlab.guide.ResourceManager;
import com.mathworks.toolbox.matlab.guide.template.TemplateInfo;
import com.mathworks.toolbox.matlab.guide.template.TemplateParser;
import com.mathworks.util.FileUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.RootPaneContainer;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;

public class QuickStartPanel
extends MJPanel {
    private static final boolean USE_INTELLIHINTS = false;
    public static final String MODE_STARTUP = "STARTUP";
    public static final String MODE_NEW = "NEW";
    public static final String DIALOG_NAME = ResourceManager.getString("dialog.title");
    private MJTabbedPane fTabPane;
    private MJList fTemplatesList;
    private MJList fRecentList;
    private MJComboBox fTemplateGroups;
    private MJLabel fImagePreviewPane;
    private MJCheckBox fSaveOption;
    private MJTextField fFilenameText;
    private MJButton fSaveBrowseButton;
    private MJButton fOKButton;
    private static final String LABEL_OK = ResourceManager.getString("dialog.okbutton");
    private static final String LABEL_OPEN = ResourceManager.getString("dialog.openbutton");
    private static final String LABEL_BROWSE = ResourceManager.getString("dialog.browsebutton");
    private static String sTabPanelNew = ResourceManager.getString("dialog.tabnewlabel");
    private static String sTabPanelOpen = ResourceManager.getString("dialog.tabopenlabel");
    private static String sSaveTitle = ResourceManager.getString("dialog.savetitle");
    private static final String PATH_SEP = File.separator;
    private static final String TEMPLATE_INFO_PATH = FileUtils.fromJavaPath((String)(Matlab.matlabRoot() + "/toolbox/matlab/guide/"));
    private static boolean sSaveState = false;
    private static boolean sFirstTime = true;
    private TemplateParser fTemplateParser;
    private TemplateInfo[] fTemplates = null;
    private SelectionResult fResult = null;
    private boolean fActionFlag = false;
    private CallbackWithID fCallback = new CallbackWithID();
    private int fCallbackID = -1;

    private QuickStartPanel(String string) {
        this.doInit(string);
        if (sFirstTime) {
            sFirstTime = false;
            LayoutLooper.requestPreload(this.fTemplates[0].getFilename() + ".fig");
        }
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
    }

    public static QuickStartPanel create(final String string) throws Exception {
        Object object;
        AWTUtilities.InvocationRunnable invocationRunnable = new AWTUtilities.InvocationRunnable(){

            public Object runWithOutput() {
                Object object;
                try {
                    object = new QuickStartPanel(string);
                }
                catch (Exception exception) {
                    object = exception;
                }
                return object;
            }
        };
        try {
            object = AWTUtilities.invokeAndWait((AWTUtilities.InvocationRunnable)invocationRunnable);
        }
        catch (Throwable throwable) {
            object = new Exception(throwable);
        }
        if (object instanceof Exception) {
            throw (Exception)object;
        }
        return (QuickStartPanel)((Object)object);
    }

    public Callback getCallback() {
        return this.fCallback;
    }

    public void addNotify() {
        super.addNotify();
        this.getTopLevelAncestor().setMinimumSize(this.getTopLevelAncestor().getSize());
        ((RootPaneContainer)((Object)this.fOKButton.getTopLevelAncestor())).getRootPane().setDefaultButton((JButton)this.fOKButton);
        Container container = this.getTopLevelAncestor();
        if (container instanceof Window) {
            ((Window)container).addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    QuickStartPanel.this.saveTabPreference();
                }
            });
        }
    }

    public void setInitialFocus() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                QuickStartPanel.this.fTemplatesList.requestFocusInWindow();
            }
        });
    }

    private void doInit(String string) {
        this.setName(DIALOG_NAME);
        this.populateDialog(string);
        this.initSelection();
    }

    private void populateDialog(String string) {
        this.fTabPane = new MJTabbedPane(1);
        this.fTabPane.addChangeListener((ChangeListener)new TabPaneChangeListener());
        this.fTabPane.addTab(sTabPanelNew, (Component)this.buildTemplatePanel());
        if (MODE_STARTUP.equals(string.toUpperCase())) {
            this.fTabPane.addTab(sTabPanelOpen, (Component)this.buildHistoryPanel());
        }
        FormLayout formLayout = new FormLayout("fill:p:g(1.0)", "fill:p:g(1.0), 4dlu, p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, (JPanel)((Object)this));
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.fTabPane, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.buildButtonBar(), cellConstraints.xy(1, 3));
        panelBuilder.setDefaultDialogBorder();
    }

    public void initSelection() {
        int n = GuidePreferenceEnum.getIntegerPreference(GuidePreferenceEnum.QUICK_START_TAB);
        if (this.fTabPane.getTabCount() > 1) {
            this.fTabPane.setSelectedIndex(n);
        }
        if (this.fTemplatesList != null) {
            this.fTemplatesList.setSelectedIndex(0);
            if (this.fTemplates.length > 0) {
                this.fImagePreviewPane.setIcon((Icon)new ImageIcon(this.fTemplates[0].getPreview()));
                this.fImagePreviewPane.repaint();
            }
        }
        if (this.fRecentList != null) {
            this.fRecentList.setSelectedIndex(0);
        }
    }

    public void close() {
        this.saveTabPreference();
        this.fCallback.setID(2);
        this.fCallback.postCallback();
    }

    private void saveTabPreference() {
        if (this.fTabPane.getTabCount() > 1) {
            Prefs.setIntegerPref((String)GuidePreferenceEnum.QUICK_START_TAB.getKey(), (int)this.fTabPane.getSelectedIndex());
        }
    }

    private MJPanel buildTemplatePanel() {
        MJPanel mJPanel = new MJPanel();
        FormLayout formLayout = new FormLayout("p:g(0.5), 8dlu, p:g(0.5)", "fill:p:g(1.0), 4dlu, p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, (JPanel)mJPanel);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.buildTemplateListPanel(), cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.buildPreviewPanel(), cellConstraints.xy(3, 1));
        panelBuilder.add((Component)this.buildSaveOnStartPanel(), cellConstraints.xyw(1, 3, 3));
        mJPanel.setBorder(Borders.createEmptyBorder((String)"4dlu, 8dlu, 4dlu, 8dlu"));
        return mJPanel;
    }

    private JPanel buildTemplateListPanel() {
        this.fTemplateParser = QuickStartPanel.parseTemplate();
        this.fTemplates = this.fTemplateParser.getTemplates(this.fTemplateParser.getDefaultGroupIndex());
        Object[] objectArray = this.fTemplateParser.getTemplateGroupNames();
        this.fTemplatesList = new MJList((Object[])this.fTemplates);
        this.fTemplatesList.setCellRenderer((ListCellRenderer)new QSPListCellRenderer());
        TemplatesListListener templatesListListener = new TemplatesListListener();
        this.fTemplatesList.addMouseListener((MouseListener)templatesListListener);
        this.fTemplatesList.addListSelectionListener((ListSelectionListener)templatesListListener);
        this.fTemplatesList.setCellViewerEnabled(true);
        MJScrollPane mJScrollPane = new MJScrollPane((Component)this.fTemplatesList);
        this.fTemplateGroups = new MJComboBox();
        this.fTemplateGroups.setVisible(false);
        if (objectArray.length > 1) {
            this.fTemplateGroups = new MJComboBox(objectArray);
            this.fTemplateGroups.setVisible(true);
            this.fTemplateGroups.setEditable(false);
            this.fTemplateGroups.setSelectedIndex(this.fTemplateParser.getDefaultGroupIndex());
            this.fTemplateGroups.addActionListener((ActionListener)new TemplateGroupsListener());
        }
        FormLayout formLayout = new FormLayout("fill:p:g(1.0)", "p, 2dlu, fill:p:g(1.0)");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        if (objectArray.length > 1) {
            panelBuilder.add((Component)this.fTemplateGroups, cellConstraints.xy(1, 1));
        } else {
            Object object = objectArray[this.fTemplateParser.getDefaultGroupIndex()];
            panelBuilder.addLabel((String)object, cellConstraints.xy(1, 1));
        }
        panelBuilder.add((Component)mJScrollPane, cellConstraints.xy(1, 3));
        return panelBuilder.getPanel();
    }

    private JPanel buildPreviewPanel() {
        this.fImagePreviewPane = new MJLabel();
        this.fImagePreviewPane.setHorizontalAlignment(0);
        this.fImagePreviewPane.setVerticalAlignment(0);
        MJPanel mJPanel = new MJPanel();
        mJPanel.setLayout((LayoutManager)new BorderLayout());
        mJPanel.setBorder((Border)BorderFactory.createTitledBorder(ResourceManager.getString("dialog.previewlabel")));
        mJPanel.add((Component)this.fImagePreviewPane, (Object)"Center");
        return mJPanel;
    }

    private MJPanel buildSaveOnStartPanel() {
        this.fSaveOption = new MJCheckBox(ResourceManager.getString("dialog.savelabel"));
        this.fSaveOption.addItemListener((ItemListener)new SaveOnCreateListener());
        this.fFilenameText = new MJTextField();
        this.fFilenameText.setSelectAllOnFocus(true);
        this.fFilenameText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                QuickStartPanel.this.fFilenameText.setToolTipText(QuickStartPanel.this.fFilenameText.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                QuickStartPanel.this.fFilenameText.setToolTipText(QuickStartPanel.this.fFilenameText.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                QuickStartPanel.this.fFilenameText.setToolTipText(QuickStartPanel.this.fFilenameText.getText());
            }
        });
        this.fFilenameText.setText(QuickStartPanel.getSuggestedFileName(MatlabPath.getCWD()));
        this.fSaveBrowseButton = new MJButton(LABEL_BROWSE);
        this.fSaveBrowseButton.addActionListener((ActionListener)new BrowseSaveButtonListener());
        this.fSaveOption.setSelected(sSaveState);
        this.fFilenameText.setEnabled(sSaveState);
        this.fSaveBrowseButton.setEnabled(sSaveState);
        MJPanel mJPanel = new MJPanel();
        FormLayout formLayout = new FormLayout("p, 2dlu, fill:0dlu:g(1.0), 4dlu, p", "p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, (JPanel)mJPanel);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.fSaveOption, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.fFilenameText, cellConstraints.xy(3, 1));
        panelBuilder.add((Component)this.fSaveBrowseButton, cellConstraints.xy(5, 1));
        return mJPanel;
    }

    private JPanel buildHistoryPanel() {
        String string;
        this.fRecentList = new MJList();
        this.fRecentList.setCellRenderer((ListCellRenderer)new QSPListCellRenderer());
        this.fRecentList.addMouseListener((MouseListener)new RecentListMouseListener());
        Vector<String> vector = new Vector<String>();
        int n = LayoutMRUFiles.getMRUListSize();
        for (int i = 1; i <= n; ++i) {
            string = LayoutMRUFiles.getItem(i);
            if (!FileUtils.fileExists((String)string)) continue;
            vector.add(string);
        }
        this.fRecentList.putClientProperty((Object)"HasHistory", (Object)(!vector.isEmpty() ? 1 : 0));
        this.fRecentList.setListData(vector);
        this.fRecentList.setCellViewerEnabled(true);
        MJButton mJButton = new MJButton(LABEL_BROWSE);
        mJButton.addActionListener((ActionListener)new BrowseOpenButtonListener());
        string = new ButtonBarBuilder();
        string.addGlue();
        string.addFixed((JComponent)mJButton);
        MJLabel mJLabel = new MJLabel(ResourceManager.getString("dialog.recentlabel"));
        MJScrollPane mJScrollPane = new MJScrollPane((Component)this.fRecentList);
        mJScrollPane.setVerticalScrollBarPolicy(20);
        mJScrollPane.setHorizontalScrollBarPolicy(30);
        mJScrollPane.setMinimumSize(new Dimension(0, 0));
        FormLayout formLayout = new FormLayout("fill:0dlu:g(1.0)", "p, 2dlu, fill:p:g(1.0), 4dlu, p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)mJLabel, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)mJScrollPane, cellConstraints.xy(1, 3));
        panelBuilder.add((Component)string.getPanel(), cellConstraints.xy(1, 5));
        panelBuilder.setBorder(Borders.createEmptyBorder((String)"4dlu, 8dlu, 4dlu, 8dlu"));
        return panelBuilder.getPanel();
    }

    private JPanel buildButtonBar() {
        this.fOKButton = new MJButton(LABEL_OK);
        this.fOKButton.addActionListener((ActionListener)new OKButtonListener());
        MJButton mJButton = new MJButton(ResourceManager.getString("dialog.cancelbutton"));
        mJButton.addActionListener((ActionListener)new CancelButtonListener());
        MJButton mJButton2 = new MJButton(ResourceManager.getString("dialog.helpbutton"));
        mJButton2.addActionListener((ActionListener)new HelpButtonListener());
        return ButtonBarFactory.buildOKCancelHelpBar((JButton)this.fOKButton, (JButton)mJButton, (JButton)mJButton2);
    }

    private static TemplateParser parseTemplate() {
        try {
            TemplateParser templateParser = new TemplateParser();
            String string = FileUtils.getLocalizedFilename((String)(TEMPLATE_INFO_PATH + "templateinfo.xml"));
            templateParser.parseTemplateInfo(string);
            return templateParser;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getSuggestedFileName(String string) {
        String string2 = string;
        if (!string2.endsWith(PATH_SEP)) {
            string2 = string2 + PATH_SEP;
        }
        int n = 0;
        while (true) {
            String string3 = string2 + "untitled";
            if (n > 0) {
                string3 = string3 + n;
            }
            File file = new File(string3 + ".fig");
            File file2 = new File(string3 + ".m");
            if (!file.exists() && !file2.exists()) {
                return string3 + ".fig";
            }
            ++n;
        }
    }

    private void validateDestinationFile(String string, String string2, String string3, boolean bl) {
        File file;
        if (string3 == null || string3.length() == 0) {
            this.showWarningDialog(ResourceManager.getString("dialog.noentry"));
            this.fFilenameText.requestFocus();
            return;
        }
        File file2 = new File(string3);
        if (file2.isDirectory()) {
            this.showWarningDialog(ResourceManager.getString("dialog.nofilename"));
            this.fFilenameText.requestFocus();
            return;
        }
        String string4 = file2.getParent();
        String string5 = file2.getName();
        if (string4 == null) {
            string4 = MatlabPath.getCWD();
        }
        if (!string4.endsWith(PATH_SEP)) {
            string4 = string4 + PATH_SEP;
        }
        if (!(file = new File(string4)).exists()) {
            String string6 = ResourceManager.getString("dialog.nodirectory");
            this.showWarningDialog(MessageFormat.format(string6, file.getAbsolutePath()));
            this.fFilenameText.requestFocus();
            return;
        }
        File file3 = new File(string4 + "tempdir");
        if (!file3.mkdir()) {
            String string7 = ResourceManager.getString("dialog.cannotcreate");
            this.showWarningDialog(MessageFormat.format(string7, file.getAbsolutePath()));
            this.fFilenameText.requestFocus();
            return;
        }
        file3.delete();
        String string8 = string5;
        int n = string8.lastIndexOf(46);
        if (n != -1) {
            string8 = string8.substring(0, n);
        }
        String string9 = string4 + string8;
        File file4 = new File(string9 + ".fig");
        File file5 = new File(string9 + ".m");
        boolean bl2 = false;
        if (file4.exists() || file5.exists()) {
            String string10 = ResourceManager.getString("dialog.alreadyexists");
            int n2 = this.showConfirmDialog(MessageFormat.format(string10, string8));
            if (n2 == 0) {
                String string11 = ResourceManager.getString("dialog.alreadyopen");
                if (LayoutEditor.isGUIOpen(file4.getAbsolutePath())) {
                    this.showWarningDialog(MessageFormat.format(string11, string8));
                    this.fFilenameText.requestFocus();
                    return;
                }
                if (!file4.canWrite() || !file5.canWrite()) {
                    String string12 = ResourceManager.getString("dialog.cannotoverwrite");
                    int n3 = this.showConfirmDialog(MessageFormat.format(string12, string8));
                    if (n3 == 0) {
                        bl2 = true;
                    } else {
                        this.fFilenameText.requestFocus();
                    }
                } else {
                    bl2 = true;
                }
            } else {
                this.fFilenameText.requestFocus();
            }
        } else {
            bl2 = true;
        }
        if (bl2) {
            this.fResult = new SelectionResult(string, string2, file4.getAbsolutePath(), bl);
            this.close();
        }
    }

    protected void showWarningDialog(String string) {
        Frame frame = this.getParentFrame();
        MJOptionPane.showMessageDialog((Component)frame, (Object)string, (String)sSaveTitle, (int)2);
    }

    private int showConfirmDialog(String string) {
        Frame frame = this.getParentFrame();
        return MJOptionPane.showConfirmDialog((Component)frame, (Object)string, (String)sSaveTitle, (int)0);
    }

    private Frame getParentFrame() {
        Frame frame = MJOptionPane.getFrameForComponent((Component)((Object)this));
        if (frame == null) {
            frame = MJOptionPane.getRootFrame();
        }
        return frame;
    }

    public SelectionResult getResult() {
        return this.fResult;
    }

    public void setSelectionResult(String string) {
        if (null != this.fRecentList) {
            this.fRecentList.repaint();
        }
        if (null != string) {
            this.fResult = new SelectionResult(LABEL_BROWSE, null, string, false);
        }
    }

    public void setSaveDestination(String string) {
        if (null != this.fTemplatesList) {
            this.fTemplatesList.repaint();
        }
        if (null != string) {
            this.fFilenameText.setText(string);
            this.fOKButton.requestFocusInWindow();
        }
    }

    public int getCallbackID() {
        return this.fCallbackID;
    }

    public static void main(String[] stringArray) {
        QuickStartPanel quickStartPanel = new QuickStartPanel(MODE_STARTUP);
        quickStartPanel.setVisible(true);
    }

    public static QuickStartPanel getTestDialog() {
        QuickStartPanel quickStartPanel = new QuickStartPanel(MODE_STARTUP);
        quickStartPanel.setVisible(true);
        return quickStartPanel;
    }

    static /* synthetic */ TemplateInfo[] access$1602(QuickStartPanel quickStartPanel, TemplateInfo[] templateInfoArray) {
        quickStartPanel.fTemplates = templateInfoArray;
        return templateInfoArray;
    }

    private static class SaveIntelliHints
    extends FileIntelliHints {
        private SaveIntelliHints(JTextComponent jTextComponent) {
            super(jTextComponent);
        }

        public void acceptHint(Object object) {
            super.acceptHint(object);
            this.getTextComponent().setText(this.getTextComponent().getText() + File.separatorChar);
            this.showHintsPopup();
            if (this.isHintsPopupVisible()) {
                this.getList().setSelectedIndex(0);
            }
        }

        public boolean updateHints(Object object) {
            boolean bl = super.updateHints(object);
            if (bl) {
                ListModel listModel = this.getList().getModel();
                if (listModel.getSize() > 1) {
                    Vector<String> vector = new Vector<String>();
                    for (int i = 0; i < listModel.getSize(); ++i) {
                        vector.add((String)listModel.getElementAt(i));
                    }
                    Collections.sort(vector);
                    DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
                    for (String string : vector) {
                        defaultListModel.addElement(string);
                    }
                    this.getList().setModel(defaultListModel);
                }
                if (this.isHintsPopupVisible()) {
                    this.getList().setSelectedIndex(0);
                }
            }
            return bl;
        }
    }

    private static class QSPListCellRenderer
    extends DefaultListCellRenderer {
        private QSPListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            jLabel.setIcon(ApplicationIcon.MATLAB_14x14.getIcon());
            return jLabel;
        }
    }

    private static class CallbackWithID
    extends Callback {
        private int fID = -1;
        public static final int BROWSE_FOR_SAVE = 0;
        public static final int BROWSE_FOR_OPEN = 1;
        public static final int DIALOG_DISMISSED = 2;

        private CallbackWithID() {
        }

        public int getID() {
            return this.fID;
        }

        public void setID(int n) {
            this.fID = n;
        }
    }

    private class TemplateGroupsListener
    implements ActionListener {
        private TemplateGroupsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = QuickStartPanel.this.fTemplateGroups.getSelectedIndex();
            QuickStartPanel.access$1602(QuickStartPanel.this, QuickStartPanel.this.fTemplateParser.getTemplates(n));
            Vector<String> vector = new Vector<String>();
            for (TemplateInfo templateInfo : QuickStartPanel.this.fTemplates) {
                vector.add(templateInfo.getName());
            }
            QuickStartPanel.this.fTemplatesList.setListData(vector);
            QuickStartPanel.this.initSelection();
        }
    }

    private class SaveOnCreateListener
    implements ItemListener {
        private SaveOnCreateListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (QuickStartPanel.this.fSaveOption.isSelected()) {
                QuickStartPanel.this.fFilenameText.setEnabled(true);
                QuickStartPanel.this.fSaveBrowseButton.setEnabled(true);
                QuickStartPanel.this.fFilenameText.requestFocusInWindow();
            } else {
                QuickStartPanel.this.fFilenameText.setEnabled(false);
                QuickStartPanel.this.fSaveBrowseButton.setEnabled(false);
            }
        }
    }

    private class BrowseOpenButtonListener
    implements ActionListener {
        private BrowseOpenButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            QuickStartPanel.this.fCallback.setID(1);
            QuickStartPanel.this.fCallback.postCallback();
        }
    }

    private class BrowseSaveButtonListener
    implements ActionListener {
        private BrowseSaveButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            QuickStartPanel.this.fCallback.setID(0);
            QuickStartPanel.this.fCallback.postCallback();
        }
    }

    private class HelpButtonListener
    implements ActionListener {
        private HelpButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = MLHelpServices.getDocRoot() + "/techdoc/creating_guis/creating_guis.map";
            MLHelpServices.cshDisplayTopic((Object)((Object)QuickStartPanel.this), (String)string, (String)"guide_templates");
        }
    }

    private class CancelButtonListener
    implements ActionListener {
        private CancelButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            QuickStartPanel.this.close();
        }
    }

    private class OKButtonListener
    implements ActionListener {
        private OKButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            block9: {
                String string = ((AbstractButton)actionEvent.getSource()).getText();
                if (string.equals(LABEL_OK)) {
                    if (QuickStartPanel.this.fActionFlag) {
                        QuickStartPanel.this.fActionFlag = false;
                    } else {
                        try {
                            int n = QuickStartPanel.this.fTemplatesList.getSelectedIndex();
                            if (n == -1) break block9;
                            String string2 = QuickStartPanel.this.fTemplates[n].getFilename();
                            String string3 = QuickStartPanel.this.fFilenameText.getText();
                            sSaveState = QuickStartPanel.this.fSaveOption.isSelected();
                            if (sSaveState) {
                                QuickStartPanel.this.validateDestinationFile(string, string2, string3, sSaveState);
                                break block9;
                            }
                            QuickStartPanel.this.fResult = new SelectionResult(string, string2, "", sSaveState);
                            QuickStartPanel.this.close();
                        }
                        catch (Exception exception) {
                            LayoutEditor.newLayoutEditor();
                            QuickStartPanel.this.close();
                        }
                    }
                } else if (string.equals(LABEL_OPEN)) {
                    int n = QuickStartPanel.this.fRecentList.getSelectedIndex();
                    if (n != -1) {
                        String string4 = QuickStartPanel.this.fRecentList.getSelectedValue().toString();
                        QuickStartPanel.this.fResult = new SelectionResult(string, null, string4, false);
                    }
                    QuickStartPanel.this.close();
                }
            }
        }
    }

    private class TabPaneChangeListener
    implements ChangeListener {
        private TabPaneChangeListener() {
        }

        @Override
        public void stateChanged(final ChangeEvent changeEvent) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MJTabbedPane mJTabbedPane = (MJTabbedPane)changeEvent.getSource();
                    if (mJTabbedPane.getSelectedIndex() == 0) {
                        QuickStartPanel.this.fOKButton.setText(LABEL_OK);
                        QuickStartPanel.this.fOKButton.setEnabled(true);
                        if (QuickStartPanel.this.fTemplatesList != null) {
                            QuickStartPanel.this.fTemplatesList.requestFocus();
                        }
                    } else if (mJTabbedPane.getSelectedIndex() == 1) {
                        QuickStartPanel.this.fOKButton.setText(LABEL_OPEN);
                        boolean bl = (Boolean)QuickStartPanel.this.fRecentList.getClientProperty((Object)"HasHistory");
                        QuickStartPanel.this.fOKButton.setEnabled(bl);
                        if (bl) {
                            QuickStartPanel.this.fRecentList.requestFocus();
                        }
                    }
                }
            });
        }
    }

    private class RecentListMouseListener
    extends MouseAdapter {
        private RecentListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            if (mouseEvent.getClickCount() == 2 && (n = QuickStartPanel.this.fRecentList.locationToIndex(mouseEvent.getPoint())) != -1) {
                String string = QuickStartPanel.this.fRecentList.getSelectedValue().toString();
                QuickStartPanel.this.fResult = new SelectionResult(LABEL_OPEN, null, string, false);
                QuickStartPanel.this.close();
            }
        }
    }

    private class TemplatesListListener
    extends MouseAdapter
    implements ListSelectionListener {
        private TemplatesListListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            if (mouseEvent.getClickCount() == 2 && (n = QuickStartPanel.this.fTemplatesList.getSelectedIndex()) != -1) {
                String string = QuickStartPanel.this.fTemplates[n].getFilename();
                String string2 = QuickStartPanel.this.fFilenameText.getText();
                QuickStartPanel.this.fActionFlag = true;
                sSaveState = QuickStartPanel.this.fSaveOption.isSelected();
                if (sSaveState) {
                    QuickStartPanel.this.validateDestinationFile(LABEL_OK, string, string2, sSaveState);
                } else {
                    QuickStartPanel.this.fResult = new SelectionResult(LABEL_OK, string, "", sSaveState);
                    QuickStartPanel.this.close();
                }
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n;
            if (!listSelectionEvent.getValueIsAdjusting() && (n = QuickStartPanel.this.fTemplatesList.getSelectedIndex()) != -1) {
                QuickStartPanel.this.fImagePreviewPane.setIcon((Icon)new ImageIcon(QuickStartPanel.this.fTemplates[n].getPreview()));
                QuickStartPanel.this.fImagePreviewPane.repaint();
            }
        }
    }

    private static class SelectionResult {
        private String fBtnLabel;
        private String fTemplateFileName;
        private String fDestFileName;
        private boolean fSaveFlag;

        SelectionResult(String string, String string2, String string3, boolean bl) {
            this.fBtnLabel = string;
            this.fTemplateFileName = string2;
            this.fDestFileName = string3;
            this.fSaveFlag = bl;
        }

        public String getButtonLabel() {
            return this.fBtnLabel;
        }

        public String getTemplateFileName() {
            return this.fTemplateFileName;
        }

        public String getDestFileName() {
            return this.fDestFileName;
        }

        public boolean isSaveOn() {
            return this.fSaveFlag;
        }
    }
}

