/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide.palette;

import com.mathworks.common.icons.IconContainer;
import com.mathworks.toolbox.matlab.guide.ResourceManager;
import com.mathworks.toolbox.matlab.guide.icons.GuideIcon;
import com.mathworks.toolbox.matlab.guide.palette.ActiveXFactory;
import com.mathworks.toolbox.matlab.guide.palette.ActiveXProxy;
import com.mathworks.toolbox.matlab.guide.palette.ControlFactory;
import com.mathworks.toolbox.matlab.guide.palette.GObjectFactory;
import com.mathworks.toolbox.matlab.guide.palette.GObjectProxy;
import com.mathworks.toolbox.matlab.guide.palette.ObjectFactory;
import com.mathworks.util.IntHashtable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;

public class ToolRegistry {
    static final String STANDARD_NAME = "Standard";
    private static final int[] SPECIAL_ID_VALUES = new int[]{0};
    private static final String UICONTROL_NAME = "UIControl";
    private static IntHashtable sFactoryTable = new IntHashtable(32);
    private static int sNextID = 4096;
    private static Map<String, int[]> sUIControlTable;
    private Map<String, int[]> fToolTable;
    private String fName;

    private static synchronized void initToolRegistry() {
        int[] nArray = ToolRegistry.buildUIControlPage(GObjectProxy.CONTROL_STRINGARRAY, GObjectProxy.CONTROL_ICONS, GObjectProxy.CONTROL_STYLES, GObjectProxy.CONTROL_TESTNAMES);
        sUIControlTable = new HashMap<String, int[]>(1);
        sUIControlTable.put(UICONTROL_NAME.toLowerCase(), nArray);
        sFactoryTable.put(0, (Object)new ControlFactory(0, ResourceManager.getString("label.select"), ResourceManager.getUntranslatedString("palette.select"), GuideIcon.SELECT));
    }

    static int[] buildUIControlPage(String[] stringArray, IconContainer[] iconContainerArray, int[] nArray, String[] stringArray2) {
        int n;
        int n2 = stringArray.length;
        int n3 = ActiveXProxy.CONTROL_STYLE_NAMES.length;
        int[] nArray2 = new int[n2 + n3];
        for (n = 0; n < n2; ++n) {
            ++sNextID;
            sFactoryTable.put(nArray2[n], (Object)new GObjectFactory(nArray[n], stringArray[n], stringArray2[n], iconContainerArray[n]));
        }
        for (int i = n; i < n + n3; ++i) {
            ++sNextID;
            sFactoryTable.put(nArray2[i], (Object)new ActiveXFactory(ActiveXProxy.CONTROL_STYLES[i - n], ActiveXProxy.CONTROL_STRINGARRAY[i - n], ActiveXProxy.CONTROL_TESTNAMES[i - n], ActiveXProxy.CONTROL_ICONS[i - n]));
        }
        return nArray2;
    }

    static boolean isPaletteEntry(int n) {
        ObjectFactory objectFactory = (ObjectFactory)sFactoryTable.get(n);
        return objectFactory != null && objectFactory.isPaletteEntry();
    }

    public static ObjectFactory getObjectFactory(int n) {
        return (ObjectFactory)sFactoryTable.get(n);
    }

    public static Object buildObject(int n) {
        ObjectFactory objectFactory = (ObjectFactory)sFactoryTable.get(n);
        if (objectFactory != null) {
            return objectFactory.buildObject();
        }
        return null;
    }

    public static String getName(int n) {
        ObjectFactory objectFactory = (ObjectFactory)sFactoryTable.get(n);
        if (objectFactory != null) {
            return objectFactory.getName();
        }
        return "";
    }

    static ImageIcon getImageResource(int n) {
        ObjectFactory objectFactory = (ObjectFactory)sFactoryTable.get(n);
        if (objectFactory != null) {
            return objectFactory.getIcon();
        }
        return null;
    }

    public static int getType(int n) {
        ObjectFactory objectFactory = (ObjectFactory)sFactoryTable.get(n);
        if (objectFactory != null) {
            return objectFactory.getType();
        }
        return 0;
    }

    static int[] getSpecialPage() {
        return SPECIAL_ID_VALUES;
    }

    private ToolRegistry(Map<String, int[]> map, String string) {
        this.fToolTable = map;
        this.fName = string;
    }

    int[] getDefaultPage() {
        return this.getPage(this.fName);
    }

    synchronized int[] getPage(String string) {
        int[] nArray = this.fToolTable.get(string);
        if (nArray == null) {
            return null;
        }
        if (nArray instanceof int[]) {
            return nArray;
        }
        return null;
    }

    int getPageCount() {
        return this.fToolTable.size();
    }

    Set pages() {
        return this.fToolTable.keySet();
    }

    public static ToolRegistry getUIControlToolRegistry() {
        return new ToolRegistry(sUIControlTable, UICONTROL_NAME.toLowerCase());
    }

    static {
        ToolRegistry.initToolRegistry();
    }
}

