/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide.menueditor;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.services.ObjectRegistry;
import com.mathworks.toolbox.matlab.guide.menueditor.MenuEditor;
import com.mathworks.toolbox.matlab.guide.menueditor.MenuNode;
import com.mathworks.toolbox.matlab.guide.menueditor.MenuTreeNode;
import com.mathworks.toolbox.matlab.guide.utils.LayoutWorker;
import java.awt.EventQueue;

public class MenuEditorLooper {
    private static boolean sMatlabAvailable;

    static void doDelete(MenuNode menuNode) {
        if (sMatlabAvailable) {
            ObjectRegistry.getLayoutRegistry().unregister((Object)menuNode.getUDDNode());
            Object[] objectArray = new Object[]{menuNode.getHandle()};
            LayoutWorker.fevalConsoleOutput("delete", objectArray, 0, null);
        }
    }

    static void doNew(MenuEditor menuEditor, int n, double d, String string, boolean bl, int n2) {
        if (sMatlabAvailable) {
            Object[] objectArray = new Object[4];
            int n3 = 0;
            objectArray[n3++] = n == 2 ? "doNewContextMenu" : "doNewMenu";
            objectArray[n3++] = d;
            objectArray[n3++] = string;
            objectArray[n3] = menuEditor;
            LayoutWorker.fevalConsoleOutput("menueditfunc", objectArray, 3, new NewRequestHandler(menuEditor, bl, n2));
        }
    }

    static void doSetProperty(double d, String string, Object object, CompletionObserver completionObserver) {
        if (sMatlabAvailable) {
            Object[] objectArray = new Object[4];
            int n = 0;
            objectArray[n++] = "doSetProperty";
            objectArray[n++] = d;
            objectArray[n++] = string;
            objectArray[n] = object;
            LayoutWorker.fevalConsoleOutput("menueditfunc", objectArray, 0, completionObserver);
        }
    }

    static void doGetProperty(double d, CompletionObserver completionObserver) {
        if (sMatlabAvailable) {
            Object[] objectArray = new Object[2];
            int n = 0;
            objectArray[n++] = "doGetProperty";
            objectArray[n] = d;
            LayoutWorker.fevalConsoleOutput("menueditfunc", objectArray, 1, completionObserver);
        }
    }

    static void doMoveUp(MenuEditor menuEditor, double d, double d2, MenuTreeNode menuTreeNode, int n) {
        if (sMatlabAvailable) {
            Object[] objectArray = new Object[]{"doMoveUp", d, d2};
            LayoutWorker.fevalConsoleOutput("menueditfunc", objectArray, 1, new MoveUpHandler(menuEditor, menuTreeNode, n));
        }
    }

    static void doMoveDown(MenuEditor menuEditor, double d, double d2, MenuTreeNode menuTreeNode, int n) {
        if (sMatlabAvailable) {
            Object[] objectArray = new Object[]{"doMoveDown", d, d2};
            LayoutWorker.fevalConsoleOutput("menueditfunc", objectArray, 1, new MoveDownHandler(menuEditor, menuTreeNode, n));
        }
    }

    static void doMoveForward(MenuEditor menuEditor, double d, double d2, MenuTreeNode menuTreeNode, int n) {
        if (sMatlabAvailable) {
            Object[] objectArray = new Object[]{"doMoveForward", d, d2};
            LayoutWorker.fevalConsoleOutput("menueditfunc", objectArray, 1, new MoveForwardHandler(menuEditor, menuTreeNode, n));
        }
    }

    static void doMoveBackward(MenuEditor menuEditor, double d, double d2, MenuTreeNode menuTreeNode, int n) {
        if (sMatlabAvailable) {
            Object[] objectArray = new Object[]{"doMoveBackward", d, d2};
            LayoutWorker.fevalConsoleOutput("menueditfunc", objectArray, 1, new MoveBackwardHandler(menuEditor, menuTreeNode, n));
        }
    }

    static void viewCallback(Object object, Object[] objectArray, String string, CompletionObserver completionObserver) {
        if (sMatlabAvailable) {
            Object[] objectArray2 = new Object[4];
            int n = 0;
            objectArray2[n++] = "viewCallback";
            objectArray2[n++] = object;
            objectArray2[n++] = objectArray;
            objectArray2[n] = string;
            LayoutWorker.fevalConsoleOutput("menueditfunc", objectArray2, 0, completionObserver);
        }
    }

    static void updateTag(Object[] objectArray, String string, CompletionObserver completionObserver) {
        if (sMatlabAvailable) {
            Object[] objectArray2 = new Object[3];
            int n = 0;
            objectArray2[n++] = "updateTag";
            objectArray2[n++] = objectArray;
            objectArray2[n] = string;
            LayoutWorker.fevalConsoleOutput("menueditfunc", objectArray2, 0, completionObserver);
        }
    }

    static void invoke(MenuEditor menuEditor) {
        if (sMatlabAvailable) {
            Object[] objectArray = new Object[3];
            int n = 0;
            objectArray[n++] = "getMenuStructure";
            objectArray[n++] = menuEditor.getFigHandle();
            objectArray[n] = menuEditor;
            LayoutWorker.fevalConsoleOutput("menueditfunc", objectArray, 4, new InvokeRequestHandler(menuEditor));
        }
    }

    static {
        if (Matlab.isMatlabAvailable()) {
            sMatlabAvailable = true;
        }
    }

    private static class InvokeRequestHandler
    implements CompletionObserver {
        private MenuEditor fEditor;

        InvokeRequestHandler(MenuEditor menuEditor) {
            this.fEditor = menuEditor;
        }

        public void completed(int n, final Object object) {
            if (LayoutWorker.isRunOnMatlabThreadSuccessful(n)) {
                try {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Object[] objectArray = (Object[])object;
                            InvokeRequestHandler.this.fEditor.completeInvoke(objectArray[0], (MenuNode)objectArray[1], (MenuNode)objectArray[2], new Integer((String)objectArray[3]));
                        }
                    });
                }
                catch (Throwable throwable) {
                    System.out.println("InvokeRequestHandler error: " + throwable.getMessage());
                }
            } else {
                this.fEditor.closeWindow();
            }
        }
    }

    private static class MoveBackwardHandler
    implements CompletionObserver {
        private MenuEditor fEditor;
        private MenuTreeNode fSelectedNode;
        private int fWhichTree;

        MoveBackwardHandler(MenuEditor menuEditor, MenuTreeNode menuTreeNode, int n) {
            this.fEditor = menuEditor;
            this.fSelectedNode = menuTreeNode;
            this.fWhichTree = n;
        }

        public void completed(int n, Object object) {
            if (LayoutWorker.isRunOnMatlabThreadSuccessful(n)) {
                this.fEditor.completeMove(this.fSelectedNode, this.fWhichTree, MenuEditor.MenuMovement.MOVE_BACKWARD);
            }
        }
    }

    private static class MoveForwardHandler
    implements CompletionObserver {
        private MenuEditor fEditor;
        private MenuTreeNode fSelectedNode;
        private int fWhichTree;

        MoveForwardHandler(MenuEditor menuEditor, MenuTreeNode menuTreeNode, int n) {
            this.fEditor = menuEditor;
            this.fSelectedNode = menuTreeNode;
            this.fWhichTree = n;
        }

        public void completed(int n, Object object) {
            if (LayoutWorker.isRunOnMatlabThreadSuccessful(n)) {
                this.fEditor.completeMove(this.fSelectedNode, this.fWhichTree, MenuEditor.MenuMovement.MOVE_FORWARD);
            }
        }
    }

    private static class MoveDownHandler
    implements CompletionObserver {
        private MenuEditor fEditor;
        private MenuTreeNode fSelectedNode;
        private int fWhichTree;

        MoveDownHandler(MenuEditor menuEditor, MenuTreeNode menuTreeNode, int n) {
            this.fEditor = menuEditor;
            this.fSelectedNode = menuTreeNode;
            this.fWhichTree = n;
        }

        public void completed(int n, Object object) {
            if (LayoutWorker.isRunOnMatlabThreadSuccessful(n)) {
                this.fEditor.completeMove(this.fSelectedNode, this.fWhichTree, MenuEditor.MenuMovement.MOVE_DOWN);
            }
        }
    }

    private static class MoveUpHandler
    implements CompletionObserver {
        private MenuEditor fEditor;
        private MenuTreeNode fSelectedNode;
        private int fWhichTree;

        MoveUpHandler(MenuEditor menuEditor, MenuTreeNode menuTreeNode, int n) {
            this.fEditor = menuEditor;
            this.fSelectedNode = menuTreeNode;
            this.fWhichTree = n;
        }

        public void completed(int n, Object object) {
            if (LayoutWorker.isRunOnMatlabThreadSuccessful(n)) {
                this.fEditor.completeMove(this.fSelectedNode, this.fWhichTree, MenuEditor.MenuMovement.MOVE_UP);
            }
        }
    }

    private static class NewRequestHandler
    implements CompletionObserver {
        private MenuEditor fEditor;
        private boolean fIsTopLevel;
        private int fWhichTree;

        NewRequestHandler(MenuEditor menuEditor, boolean bl, int n) {
            this.fEditor = menuEditor;
            this.fIsTopLevel = bl;
            this.fWhichTree = n;
        }

        public void completed(int n, Object object) {
            if (LayoutWorker.isRunOnMatlabThreadSuccessful(n) && object != null && object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                this.fEditor.completeNew(this.fIsTopLevel, (MenuNode)objectArray[0], this.fWhichTree);
                ObjectRegistry.getLayoutRegistry().register(objectArray[1], objectArray[2], -1, this.fEditor.getLayoutOwner(), true);
            }
        }
    }
}

