/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide.dragdrop;

import com.mathworks.toolbox.matlab.guide.LayoutArea;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

class LayoutDragSupport {
    protected LayoutArea fLayoutArea;

    public LayoutDragSupport(LayoutArea layoutArea) {
        this.fLayoutArea = layoutArea;
    }

    protected Point getSnapRect(Rectangle rectangle) {
        Point point;
        Dimension dimension = this.fLayoutArea.getSize();
        Point point2 = new Point(0, 0);
        if (this.fLayoutArea.getGrid().getSnapToGrid()) {
            point = this.fLayoutArea.getGrid().getGridSnapRect(rectangle, dimension.width, dimension.height);
            point2.translate(point.x, point.y);
            rectangle.translate(point.x, point.y);
        }
        point = this.fLayoutArea.getGrid().getGuideSnapRect(rectangle, dimension.width, dimension.height);
        point2.translate(point.x, point.y);
        rectangle.translate(point.x, point.y);
        return point2;
    }

    protected void drawDropOutline(Graphics graphics) {
        Point point = this.fLayoutArea.getLocation();
        Dimension dimension = this.fLayoutArea.getSize();
        Dimension dimension2 = this.fLayoutArea.getParent().getSize();
        int n = Math.min(dimension.width, dimension2.width);
        int n2 = Math.min(dimension.height, dimension2.height);
        graphics.drawRect(-point.x, -point.y, n - 1, n2 - 1);
        graphics.drawRect(-point.x + 1, -point.y + 1, n - 3, n2 - 3);
    }

    protected final void constrainPoint(Point point) {
        if (point.x < 0) {
            point.x = 0;
        }
        if (point.y < 0) {
            point.y = 0;
        }
        Dimension dimension = this.fLayoutArea.getSize();
        if (point.x > dimension.width) {
            point.x = dimension.width;
        }
        if (point.y > dimension.height) {
            point.y = dimension.height;
        }
    }

    protected final void constrainBounds(Point point) {
        if (point.x < 0) {
            point.x = 0;
        }
        if (point.y < 0) {
            point.y = 0;
        }
        Dimension dimension = this.fLayoutArea.getSize();
        if (point.x >= dimension.width) {
            point.x = dimension.width - 1;
        }
        if (point.y >= dimension.height) {
            point.y = dimension.height - 1;
        }
    }

    protected Graphics getXORGraphics() {
        return this.getXORGraphics(this.fLayoutArea, false);
    }

    protected Graphics getXORGraphics(boolean bl) {
        return this.getXORGraphics(this.fLayoutArea, bl);
    }

    protected Graphics getXORGraphics(Component component) {
        return this.getXORGraphics(component, false);
    }

    protected Graphics getXORGraphics(Component component, boolean bl) {
        Graphics graphics = component.getGraphics();
        graphics.setColor(this.fLayoutArea.getBackground());
        Color color = Color.gray;
        if (bl) {
            color = LayoutArea.getCorrectedColor(this.fLayoutArea.getBackground(), color);
        }
        graphics.setXORMode(color);
        return graphics;
    }
}

