/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide;

import com.mathworks.mwswing.MJMenu;
import com.mathworks.services.Prefs;
import com.mathworks.toolbox.matlab.guide.ResourceManager;
import com.mathworks.toolbox.matlab.guide.action.OpenMRUAction;
import com.mathworks.util.FileUtils;
import com.mathworks.util.PlatformInfo;
import java.awt.Toolkit;
import java.io.File;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.KeyStroke;

public class LayoutMRUFiles {
    private static final int MAX_MRU = 9;
    private static Vector<String> sFileNames;
    private static LayoutMRUFiles sMe;
    private static final Object FILE_NAMES_MONITOR;
    private static int sMenuEntryNumber;
    private static String sPrefix;
    private static String sLastOpenFile;
    private static String sLastSaveFile;

    public LayoutMRUFiles() {
        if (sMe != null) {
            return;
        }
        sFileNames = new Vector(9);
        for (int i = 0; i < 9; ++i) {
            File file;
            Integer n = i + 1;
            String string = Prefs.getStringPref((String)(sPrefix + n.toString()), (String)"");
            if (string == null || string.equals("") || !(file = FileUtils.absoluteFile((File)new File(string))).exists()) continue;
            sFileNames.addElement(file.getAbsolutePath());
        }
    }

    public static int getMRUListSize() {
        return sFileNames.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addItem(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        string = FileUtils.absolutePathname((String)string);
        Object object = FILE_NAMES_MONITOR;
        synchronized (object) {
            int n;
            for (n = 0; n < sFileNames.size(); ++n) {
                String string2 = sFileNames.elementAt(n);
                boolean bl = PlatformInfo.getPlatform() != 2 ? string2.equalsIgnoreCase(string) : string2.equals(string);
                if (!bl) continue;
                sFileNames.removeElementAt(n);
            }
            sFileNames.insertElementAt(string, 0);
            if (sFileNames.size() > 9) {
                for (n = sFileNames.size() - 1; n >= 9; --n) {
                    sFileNames.removeElementAt(n);
                }
            }
            LayoutMRUFiles.serializeMRUList();
        }
    }

    private static String createMenuString(String string, int n) {
        String string2 = FileUtils.truncatePathname((String)string, (int)25);
        return "&" + Integer.toString(n) + " " + string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void serializeMRUList() {
        Object object = FILE_NAMES_MONITOR;
        synchronized (object) {
            Integer n;
            for (int i = 0; i < sFileNames.size(); ++i) {
                n = i + 1;
                Prefs.setStringPref((String)(sPrefix + n.toString()), (String)sFileNames.elementAt(i));
            }
            for (int i = i; i < 9; ++i) {
                n = i + 1;
                Prefs.setStringPref((String)(sPrefix + n.toString()), (String)"");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getItem(int n) {
        String string = null;
        Object object = FILE_NAMES_MONITOR;
        synchronized (object) {
            if (n >= 1 && n <= sFileNames.size()) {
                string = sFileNames.elementAt(n - 1);
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToMenu(MJMenu mJMenu) {
        if (sFileNames.size() > 0 && sMenuEntryNumber > 0) {
            int n = 5000;
            int n2 = sFileNames.size() > sMenuEntryNumber ? sMenuEntryNumber : sFileNames.size();
            Object object = FILE_NAMES_MONITOR;
            synchronized (object) {
                mJMenu.addSeparator();
                int n3 = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
                for (int i = 1; i <= n2; ++i) {
                    String string = LayoutMRUFiles.createMenuString(sFileNames.elementAt(i - 1), i);
                    OpenMRUAction openMRUAction = new OpenMRUAction(n, string);
                    if (i <= 9) {
                        openMRUAction.setAccelerator(KeyStroke.getKeyStroke(48 + i, n3));
                    }
                    mJMenu.add((Action)((Object)openMRUAction));
                    ++n;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getMRUMenuNames() {
        String[] stringArray = new String[]{};
        if (sFileNames.size() > 0 && sMenuEntryNumber > 0) {
            int n;
            int n2 = n = sFileNames.size() > sMenuEntryNumber ? sMenuEntryNumber : sFileNames.size();
            if (n > 0) {
                stringArray = new String[n];
                Object object = FILE_NAMES_MONITOR;
                synchronized (object) {
                    for (int i = 1; i <= n; ++i) {
                        stringArray[i - 1] = LayoutMRUFiles.createMenuString(sFileNames.elementAt(i - 1), i);
                    }
                }
            }
        }
        return stringArray;
    }

    public static String getLastOpenFile() {
        return sLastOpenFile;
    }

    public static void setLastOpenFile(String string) {
        sLastOpenFile = string;
    }

    public static String getLastSaveFile() {
        return sLastSaveFile;
    }

    public static void setLastSaveFile(String string) {
        sLastSaveFile = string;
    }

    static {
        FILE_NAMES_MONITOR = new Object();
        sMenuEntryNumber = Prefs.getIntegerPref((String)ResourceManager.getString("layoutmru.menuentrynumber"), (int)4);
        sPrefix = ResourceManager.getString("layoutmru.prefix");
        sMe = new LayoutMRUFiles();
    }
}

