/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.javabuilder.webfigures;

import com.mathworks.toolbox.javabuilder.MWException;
import com.mathworks.toolbox.javabuilder.services.ServiceException;
import com.mathworks.toolbox.javabuilder.services.ServiceResourceMismatchException;
import com.mathworks.toolbox.javabuilder.webfigures.WebFigureRenderParameters;
import com.mathworks.toolbox.javabuilder.webfigures.service.WebFigureBinder;
import com.mathworks.toolbox.javabuilder.webfigures.service.WebFigurePeer;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.rmi.RemoteException;

public class WebFigureRenderer {
    private final WebFigureBinder binder = new WebFigureBinder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] renderBytes(WebFigureRenderParameters webFigureRenderParameters) throws IOException, MWException, ServiceException {
        byte[] byArray;
        WebFigurePeer webFigurePeer = this.binder.bindResource(webFigureRenderParameters.getWebFigure());
        try {
            byArray = webFigurePeer.renderEncoded(webFigureRenderParameters.toMap());
        }
        catch (Throwable throwable) {
            try {
                webFigurePeer.dispose();
                throw throwable;
            }
            catch (ServiceResourceMismatchException serviceResourceMismatchException) {
                throw new AssertionError((Object)"WebFigureBinder should not throw resource mismatch error when handed a WebFigure!");
            }
        }
        webFigurePeer.dispose();
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage renderImage(WebFigureRenderParameters webFigureRenderParameters) throws MWException, ServiceException {
        BufferedImage bufferedImage;
        WebFigurePeer webFigurePeer = this.binder.bindResource(webFigureRenderParameters.getWebFigure());
        try {
            bufferedImage = webFigurePeer.renderImage(webFigureRenderParameters.toMap());
        }
        catch (Throwable throwable) {
            try {
                webFigurePeer.dispose();
                throw throwable;
            }
            catch (ServiceResourceMismatchException serviceResourceMismatchException) {
                throw new AssertionError((Object)"WebFigureBinder should not throw resource mismatch error when handed a WebFigure!");
            }
            catch (RemoteException remoteException) {
                throw new AssertionError((Object)"renderImage should not throw RemoteException!");
            }
        }
        webFigurePeer.dispose();
        return bufferedImage;
    }

    public void dispose() {
        this.binder.dispose();
    }
}

